
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYMUSER.H__   1.7.1.0.1.0   11 Nov 1996 12:58:40   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYMUSER.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:40   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:54   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:00   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:28   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:28   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:35:10   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:08:12   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:44   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:40   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:20   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:38   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:36   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:06   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:20   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:58   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:50   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:42   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:22   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:18   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:20   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:14   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:40   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:30   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:02   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:54   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:06   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:32:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:34:14   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:08   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:02   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:58   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:20   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:36   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:08   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:08   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:58   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:52   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:18   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:30   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMUSER.H
**
**  Description:
**      All user defined symbol API's have the prefix: SymUser
**      Major header file used by user defined symbol.
**
**  Status:  CODED
**
**    Rev 1.0   25 May 1995 12:00:00   Gates
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMUSER_H_
#define _SYMUSER_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/////////////////////////////////////////////////////////////////
// User defined symbol node frame
/////////////////////////////////////////////////////////////////
struct SymUserNode {        
    char *name; // symbol name
    U32 addr;   // symbol address
    U8 type;    // symbol type
    struct SymUserNode *next;   // pointer to next address ; sort by address
    struct SymUserNode *ptr;    // pointer to next name ; sort by name
public :
    SymUserNode() {
        name = 0;
        addr = 0;
        type = 0;
        next = 0;
        ptr = 0;
    };  
};
    
struct SymUserNodeIndex {
    int num;                         
    struct SymUserNode *node;       
    struct SymUserNodeIndex *next;  
public :
    SymUserNodeIndex() {
        num = 0;
        node = 0;
        next = 0;
    };  
};
  
/////////////////////////////////////////////////////////////////
// User defined symbol Server main frame
/////////////////////////////////////////////////////////////////
class SymUserTable {
private :
    U32 symno;
    struct SymUserNode *namePtr;
    struct SymUserNode *addrPtr;
    struct SymUserNodeIndex *nameIndexPtr;
    struct SymUserNodeIndex *addrIndexPtr;

    struct SymUserNode *matchPtr;
    struct SymUserNode *preMatchPtr;
public :
    SymUserTable() {
        symno = 0;
        namePtr = 0;
        addrPtr = 0;
        nameIndexPtr = 0;
        addrIndexPtr = 0;           
        
        matchPtr = 0;
        preMatchPtr = 0;
    };
    ~SymUserTable(); 
             
public :
    int SymUserCreate(char *str , U8 type , U32 addr);
    int SymUserDelete(char *str);
    void SymUserDeleteAll(void);
    int SymUserList( void );
    int SymUserQuery( char *str );
    int SymUserSSave( char *str );
    int SymUserSRecall( char *str );
    int Sym2Addr( char *str , U8* type , U32* addr );
    int Addr2Sym( U8 type , U32 addr , char *str );

private :   
    int SymUserAddNode( struct SymUserNode *node );
    
    void SymUserSearchNodeByName( char *str );
    void SymUserSearchNodeByAddr( U32 addr , U8 type );
             
    void SymUserRejustNameIndex(void);
    void SymUserRejustAddrIndex(void);
    void SymUserClearUpNode();
    void SymUserClearUpIndex();
};              

extern void ShowLine(char *);
extern void ShlReShowLine(char * , int);

#endif
/******************************** E O F ***********************************/
