	
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/SYNLIB.H__   1.7.1.0.1.0   11 Nov 1996 12:59:50   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/SYNLIB.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:50   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:19:26   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:56   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:00   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:48:00   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:36   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:27:16   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:55:54   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:36:48   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:01:24   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:40   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:30:00   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:54:54   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:33:58   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:48:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:44   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:30:16   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:51:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:18   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:14   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:42   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:40   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:48   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:30   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:44   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:38   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:34   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:20   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:52   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:08:14   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:45:42   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:50   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:29:06   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:50:22   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:22   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:24   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:26   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:56   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNLIB.H
//
//  Description: The header file for the class: CSyntaxLib.
//
//  Author: Chen Jun
//
//  Date: 04/03/95
//
//  Modification:
//      1. 04/03/95, Initial version of the class: CSyntaxLib.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SYNLIB_
#define _SYNLIB_

#include "syntest.h"

/////////////////////////////////////////////////////////////////////////////
// CSyntaxLib class.
class CSyntaxLib : public CSyntaxTest
{
// Construction & Destruction.
public:
    CSyntaxLib();
    ~CSyntaxLib();
    void Init(void);                                ////by chris, 4/16/1996    
    
// Member variables.
private:
    // Local macro definition.
    enum { MAX_FILL_SIZE = 32 };
    
    // Maximum of the memory type.
    unsigned long m_ulMaxTypeP;
    unsigned long m_ulMaxTypeX;
    unsigned long m_ulMaxTypeI;
    unsigned long m_ulMaxTypeR;
    unsigned long m_ulMaxTypeB;

protected:
    enum { NO_ERROR          = 0,
    	   NOT_SHOW_ERROR, 	
           NO_COMMAND, 
           NO_SUCH_COMMAND,
           SYNTAX_ERROR,           
    	   ADDR_OUT_OF_RANGE,
           LEN_OUT_OF_RANGE,
           LEN_ERROR,
           ADDR_ERROR,	
           ADDR_TYPE_ERROR,
           ADDR_MAP_ERROR,
           MAP_ATTR_ERROR,
           REG_ERROR,
           DATA_OUT_OF_RANGE,
           DATA_ERROR,                      
           FILE_NAME_ERROR,
           MODULE_NAME_ERROR,            
		   VARIABLE_NAME_ERROR,      
		   SYMBOL_NAME_ERROR, 
		   COUNT_ERROR,   
		   COUNT_OUT_OF_RANGE,  	           
		   PORT_ERROR,
	       ADDR_FORMATERROR,       
	       ADDR_NOSYMBOL,	                               	
	       ADDR_COMPERROR,     
	       ADDR_OVERFLOW,     
	       ADDR_EMPTY,     
		   STATUS_ERROR,			   
           MAX_ERROR         = 100
    };
                 
    int m_nErrorID;             
// Implementations.
public:                           
    void DisplayError(void) ;	
    unsigned long StrToVar(char* pszStr) ;
    void VarToStr(unsigned long ulVar, char* pszStr) ;

    //void SymbolToAddr(char* pszSymbol, char* pszAddr) ;
    //void SymbolToAddr(char* pszSymbol, char* pszAddr, char chType) ;

    // Syntax check lib routine.                              
    //Add by Annie, 3/18
    //BOOL ConvertAddress(char* pszArgv1, char* pszArgv2, int space=0) ;
    BOOL ConvertAddress(char* pszArgv1, char* pszArgv2, int &nRet, int space=0) ;
    void ConvertLen(char* pszArgv1, char* pszArgv2) ;                                            
    BOOL IsHexAddr(char* pszArgv) ;
    BOOL IsAddr(char* pszArgv) ;
    BOOL IsPAddr(char* pszArgv) ;
    BOOL IsPAddrDefault(char* pszArgv) ;
    BOOL IsXAddr(char* pszArgv) ;
    BOOL IsXAddrDefault(char* pszArgv) ;
    BOOL IsIAddr(char* pszArgv) ;
    BOOL IsIAddrDefault(char* pszArgv) ;
    BOOL IsRAddr(char* pszArgv) ;
    BOOL IsRAddrDefault(char* pszArgv) ;
    BOOL IsBAddr(char* pszArgv) ;
    BOOL IsBAddrDefault(char* pszArgv) ;
    
    BOOL IsAddrLen(char* pszArgv, int &nRet) ;
    BOOL IsKeywordLength(char* pszArgv) ;
    BOOL IsLengthRange(char* pszAddr, char* pszLen, int &nRet) ;
    BOOL IsLengthRange(char* pszAddr, char* pszLen, char* pszTarget, int &nRet) ;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2) ;
    BOOL IsAddrRange(char* pszAddr1, char* pszAddr2, char* pszAddr3) ;
    
    BOOL IsMapStartAddr(char* pszArgv) ;
    BOOL IsMapEndAddr(char* pszArgv) ;
    BOOL IsMapAddrLen(char* pszArgv) ;
    BOOL IsMapMemType(char* pszArgv) ;
    BOOL IsMapAttr(char chType, char* pszArgv) ;
    
    BOOL IsRegName(char* pszRegName) ;
    BOOL IsRegData(char* pszRegName, char* pszRegData) ;
    
    BOOL IsKeywordAll(char* pszArgv) ;
    
    BOOL IsFilename(char* pszArgv, int &nRet) ;
    //BOOL IsFilename(char* pszArgv) ;
    BOOL IsLoadOption(int nArgc, char* pszArgv[]) ;
    BOOL IsModuleName(char* pszArgv) ;
    
    BOOL IsArgument(char* pszArgv) ;
    BOOL IsBackLevel(char* pszArgv) ;
    BOOL IsVariableName(char* pszArgv) ;
    BOOL IsSymbolName(char* pszArgv) ;
	BOOL IsMacroVarName(char* pszArgv) ;
	    
    BOOL IsData(char* pszArgv) ;
    BOOL IsDataBit(char* pszArgv) ;
    BOOL IsDataWord(char* pszArgv) ;
    BOOL IsDataLong(char* pszArgv) ;
    BOOL IsString(char* pszArgv) ;
    //BOOL IsDataRange(int nArgc, char* pszArgv[]) ;
    BOOL IsDataRange(int nArgc, char* pszArgv[], int nDigit) ;
    //BOOL IsStringRange(int nArgc, char* pszArgv[]) ;
    
    BOOL IsKeywordInsensitive(char* pszArgv) ;
    BOOL IsCaseStringRange(int nArgc, char* pszArgv[]) ;
    
    BOOL IsKeywordRun(char* pszArgv) ;
    BOOL IsKeywordFrom(char* pszArgv) ;
    BOOL IsKeywordTill(char* pszArgv) ;
    
    BOOL IsKeywordOver(char* pszArgv) ;
    BOOL IsKeywordForever(char* pszArgv) ;
    BOOL IsKeywordRet(char* pszArgv) ;
    BOOL IsKeywordCall(char* pszArgv) ;
    BOOL IsStepCount(char* pszArgv) ;
    BOOL IsAddrData(char* pszArgv) ;
    
    BOOL IsKeywordInstruction(char* pszArgv) ;
    BOOL IsKeywordStatement(char* pszArgv) ;
    BOOL IsKeywordLines(char* pszArgv) ;
    
    BOOL IsKeywordWith(char* pszArgv) ;
    BOOL IsKeywordClear(char* pszArgv) ;
    
    BOOL IsEventID(char* pszArgv) ;
    BOOL IsKeywordHigh(char* pszArgv) ;
    BOOL IsKeywordLow(char* pszArgv) ;
    BOOL IsKeywordRange(char* pszArgv) ;
    BOOL IsWildcardAddr(char* pszArgv) ;
    BOOL IsWildcardData(char* pszArgv) ;
    BOOL IsEventData(char* pszArgv) ;
    
    BOOL IsListOption(char* pszArgv) ;
    BOOL IsListFrame(char* pszArgv) ;
    
    BOOL IsKeywordTrace(char* pszArgv) ;
    BOOL IsKeywordTimer(char* pszArgv) ;
    BOOL IsKeywordOn(char* pszArgv) ;
    BOOL IsKeywordOff(char* pszArgv) ;
    BOOL IsEventSequence(char* pszArgv) ;

    BOOL IsKeywordReset(char* pszArgv) ;
    BOOL IsKeywordEa(char* pszArgv) ;
    BOOL IsKeywordEnable(char* pszArgv) ;
    BOOL IsKeywordDisable(char* pszArgv) ;
    BOOL IsKeywordBit(char* pszArgv) ;
    BOOL IsKeywordByte(char* pszArgv) ;

    BOOL IsCpuModule(char* pszArgv) ;
    BOOL IsPort(char* pszArgv) ;
    BOOL IsBitNo(char* pszArgv) ;
    BOOL IsBitData(char* pszArgv) ;
    BOOL IsBitRange(char* pszAddr, char* pszData) ;
    BOOL IsByteData(char* pszArgv) ;
    
    BOOL IsKeywordGlobal(char* pszArgv) ;
    BOOL IsLineNo(char* pszArgv) ;

    BOOL IsKeywordClose(char* pszArgv) ;
    BOOL IsKeywordAppend(char* pszArgv) ;
    BOOL IsKeywordCommand(char* pszArgv) ;

    BOOL IsKeywordLv1(char* pszArgv) ;
    BOOL IsKeywordLv2(char* pszArgv) ;
    BOOL IsKeywordForward(char* pszArgv) ;
    BOOL IsKeywordBackward(char* pszArgv) ;
    BOOL IsKeywordCenter(char* pszArgv) ;
    BOOL IsKeywordDelay(char* pszArgv) ;
    BOOL IsKeywordThen(char* pszArgv) ;
    
    BOOL IsKeywordModule(char* pszArgv) ;
    
    BOOL IsCommand(char* pszArgv) ;
    
    BOOL IsKeywordMonitor(char* pszArgv) ;
    BOOL IsGoMonitorTimer(char* pszArgv) ;

    BOOL IsKeywordControlOption(char* pszArgv) ;
	//Add by Annie, 3/7/96
    BOOL IsDiagnosisOption(int nArgc, char* pszArgv[]) ;
	BOOL IsKeywordFly(char* pszArgv) ;
	
	BOOL IsMacroName(char* pszArgv) ;
	BOOL IsCommandName(char* pszArgv) ;        
	
	BOOL IsEvent3Option(char* pszArgv) ;
	BOOL IsKeywordNumber(char* pszArgv) ;
	//BOOL AddrSfr(char* pszArgv1, char* pszArgv2, int &nRet) ;                                           	
	BOOL IsAddrLen(char* pszArgv) ;

	BOOL IsKeywordAddress(char* pszArgv) ;
	BOOL IsKeywordDatum(char* pszArgv) ;
	BOOL IsKeywordCount(char* pszArgv) ;
	WORD AddrToWord(char* pszArgv) ;

	BOOL IsKeywordSymbols(char* pszArgv) ;
	BOOL IsKeywordNosymbols(char* pszArgv) ;
	BOOL IsKeywordCode(char* pszArgv) ;
	BOOL IsKeywordNocode(char* pszArgv) ;
	BOOL IsKeywordWarn(char* pszArgv) ;
	BOOL IsKeywordNowarn(char* pszArgv) ;
	BOOL IsListOptionSub(char* pszArgv) ; 
	BOOL IsListFrameSub(char* pszArgv) ; 
	BOOL IsKeywordOr(char* pszArgv) ;	
	BOOL IsEventOption(char* pszArgv) ;
	BOOL IsKeywordMask(char* pszArgv) ;	
	BOOL IsSingleEvent(char* pszArgv) ;	

	BOOL IsAddrAllP(char* pszArgv) ;		
	BOOL IsAddrAllX(char* pszArgv) ;		
	BOOL IsAddrPX(char* pszArgv) ;		
	BOOL IsAddrXP(char* pszArgv) ;
	BOOL IsAddrXPI(char* pszArgv) ;     
	
	BOOL IsKeywordStatus(char* pszArgv) ;		
	BOOL IsStatusOption(char* pszArgv) ;
	BOOL IsMapAttr(char* pszArgv) ;	
	BOOL IsKeywordDemand(char* pszArgv) ;
	BOOL IsKeywordNodemand(char* pszArgv) ;
	BOOL IsKeywordP(char* pszArgv) ; 
	BOOL IsKeywordX(char* pszArgv) ;
	BOOL IsLoadOptionSub(int nArgc, char* pszArgv[]) ;	
};  // End of class: CSyntaxLib.

#endif
//////////////////////////////// End of File ////////////////////////////////
