
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TRCGRPDI.H__   1.7.1.0.1.0   11 Nov 1996 12:58:42   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TRCGRPDI.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:42   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:28   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:00   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:06   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:36   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:32   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:32   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:35:16   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:08:20   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:08:50   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:46   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:30   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:52:02   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.24   01 Feb 1996 10:13:54   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.18   15 Jan 1996 16:15:06   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:12:30   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:14   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:23:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:12   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:32   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:45:40   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:20:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:54:36   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:49:06   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:54:12   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.H
//
//  Description:The header file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _TRCGRPDI_
    #define _TRCGRPDI_

#include "abitype.h"

struct eventInfo{
	int nActiveEvent;	// 1/2/3

	int nEv1AddrMode;	// 1/2/3
	char Ev1StartAddrTxt[65];
	char Ev1StartAddrTxt2[65];
	char Ev1StartAddrTxt3[65];	
	char Ev1EndAddrTxt[65];
	int  nEv1AddrType;  // 0/1
	
	int nEv1DataMode; 	// 1/2/3
	char Ev1StartDataTxt[65];
	char Ev1StartDataTxt2[65];
	char Ev1StartDataTxt3[65];
	char Ev1EndDataTxt[65];
	int  nEv1DataType; 	// 0
	
	BOOL bEv1S;
	BOOL bEv1F;
	BOOL bEv1R;
	BOOL bEv1W;
	BOOL bEv1AK;
	
	char Ev1CountTxt[10];

	int nEv2AddrMode; 	// 1/2/3
	char Ev2StartAddrTxt[65];
    char Ev2StartAddrTxt2[65];
    char Ev2StartAddrTxt3[65];
	char Ev2EndAddrTxt[65];
	int  nEv2AddrType;	// 0/1
	
	int nEv2DataMode;	// 1/2/3
	char Ev2StartDataTxt[65]; 
	char Ev2StartDataTxt2[65];
	char Ev2StartDataTxt3[65];
	char Ev2EndDataTxt[65];
	int  nEv2DataType;	// 0
	
	BOOL bEv2S;
	BOOL bEv2F;
	BOOL bEv2R;
	BOOL bEv2W;
	BOOL bEv2AK;

	int nEv3HL;	// 1/2
};             

struct filterInfo{
	int nActiveChoice;	// 1/2

	int nDisplayAddrMode;	// 1/2/3
	char DisplayStartAddrTxt[65];
	char DisplayStartAddrTxt2[65];
	char DisplayStartAddrTxt3[65];
	char DisplayEndAddrTxt[65];
	int  nDisplayAddrType;	// 0/1
	
	int nDisplayDataMode;	// 1/2/3
	char DisplayStartDataTxt[65];
	char DisplayStartDataTxt2[65];
	char DisplayStartDataTxt3[65];
	char DisplayEndDataTxt[65];
	int  nDisplayDataType;	// 0
	
	BOOL bDisplayS;
	BOOL bDisplayF;
	BOOL bDisplayR;
	BOOL bDisplayW;
	BOOL bDisplayAK;
	
	int nTraceAddrMode;	// 1/2/3
	char TraceStartAddrTxt[65];
	char TraceStartAddrTxt2[65];
	char TraceStartAddrTxt3[65];
	char TraceEndAddrTxt[65];
	int  nTraceAddrType;	// 0/1
	
	int nTraceDataMode;	// 1/2/3
	char TraceStartDataTxt[65];
	char TraceStartDataTxt2[65];
	char TraceStartDataTxt3[65];
	char TraceEndDataTxt[65];
	int  nTraceDataType;	// 0
	
	BOOL bTraceS;
	BOOL bTraceF;
	BOOL bTraceR;
	BOOL bTraceW;
	BOOL bTraceAK;
}; 

struct traceControlInfo {
	BOOL bStartTrace;
	BOOL bStartTimer;
	
	int nDelay; 	// 1/2/3/4
	char delayTxt[65];
};            

struct level {
	int nSet; // 0-14
	BOOL bTraceOn;
	BOOL bTimerOn;
};                

struct triggerInfo {
	int nActiveLevel;	// 1/2
	struct level level1;
	struct level level2;
	BOOL bTriggerEnable;
	BOOL bRun;
	int nTriggerSet;	// 0-4
};

int GetTokenNum(char*);
int searchc(char*, char, int);

/////////////////////////////////////////////////////////////////////////////
// CCheckPage: never have instance.

class CCheckPage : public CPropertyPage
{
// Construction
public:
	CCheckPage(UINT nIDTemplate);

// Dialog Data
	//{{AFX_DATA(CCheckPage)
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CCheckPage)
		// NOTE: the ClassWizard will add member functions here
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

protected:
	BUS_EVENT	m_EvBus;
	BOOL		m_bEmptyFlag;
    int			m_nold_addrmode;
    int			m_nold_datamode;
	int			m_nErrLocate;	//1:startaddr; 2:endaddr; 3:startdata; 
								//4:enddata; 5:count	
protected:
	CString 	delspace(const char* p);
	void 		chkWildAddr(const char* p);
	void 		chkRangeAddr(int type,const char* p1,const char* p2);
	void 		chkMultipleAddr(char* p);
	void 		chkWildData(const char* p);
	void 		chkRangeData(int type, const char* p1, const char* p2);
    void 		chkSingleData(const char* p);
    void 		chkCount(const char* p);
    void		compressWild(char* p);
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage dialog

class CTrcGrpEventPage : public CCheckPage
{
// Construction
public:
	CTrcGrpEventPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
    virtual void OnOK();
	virtual void OnCancel();
    
// Dialog Data
	//{{AFX_DATA(CTrcGrpEventPage)
	enum { IDD = IDD_TRCGRP_EV };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	
	// Generated message map functions
	//{{AFX_MSG(CTrcGrpEventPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcEvtEv1();
	afx_msg void OnGrptrcEvtEv2();
	afx_msg void OnGrptrcEvtEv3();
	afx_msg void OnGrptrcEvtMulti1();
	afx_msg void OnGrptrcEvtMulti2();
	afx_msg void OnGrptrcEvtRange1();
	afx_msg void OnGrptrcEvtRange2();
	afx_msg void OnGrptrcEvtWild1();
	afx_msg void OnGrptrcEvtWild2();
	afx_msg void OnSelendokGrptrcEvtAddrtype();
	afx_msg void OnSelendokGrptrcEvtDatatype();
	afx_msg void OnChangeGrptrcEvtStartaddr();
	afx_msg void OnChangeGrptrcEvtStartdata();
	afx_msg void OnChangeGrptrcEvtEndaddr();
	afx_msg void OnChangeGrptrcEvtEnddata();
	afx_msg void OnChangeGrptrcEvtCount();
	afx_msg void OnGrptrcEvtAk();
	afx_msg void OnGrptrcEvtF();
	afx_msg void OnGrptrcEvtHigh();
	afx_msg void OnGrptrcEvtLow();
	afx_msg void OnGrptrcEvtR();
	afx_msg void OnGrptrcEvtS();
	afx_msg void OnGrptrcEvtW();

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct eventInfo m_event;
	BOOL	m_bApply;
		
//private function:
private:
	void EnableEventCtrl(BOOL);
	void ShowAddr(int event);
	void ShowData(int event);
	    
    void Ev1Init();
    void Ev2Init();
    void Ev3Init();

    void GetEv1();
    void GetEv2();
    void GetEv3();

    void SetEv1();
    void SetEv2();
    void SetEv3();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage dialog

class CTrcGrpTrcctrlPage : public CCheckPage
{
// Construction
public:
	CTrcGrpTrcctrlPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
	
// Dialog Data
	//{{AFX_DATA(CTrcGrpTrcctrlPage)
	enum { IDD = IDD_TRCGRP_TRCCTRL };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpTrcctrlPage)
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcTrcStarttimer();
	afx_msg void OnGrptrcTrcStarttrace();
	afx_msg void OnGrptrcTrcCentrg();
	afx_msg void OnGrptrcTrcDelay();
	afx_msg void OnGrptrcTrcPosttrg();
	afx_msg void OnGrptrcTrcPretrg();
	afx_msg void OnChangeGrptrcTrcCombo();	
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct traceControlInfo m_traceControl;
	BOOL	m_bApply;
	
//private function:	
private:
	void TraceControlInit();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage dialog

class CTrcGrpTriggerPage : public CPropertyPage
{
// Construction
public:
	CTrcGrpTriggerPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
	
// Dialog Data
	//{{AFX_DATA(CTrcGrpTriggerPage)
	enum { IDD = IDD_TRCGRP_TRIGR };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpTriggerPage)
		// NOTE: the ClassWizard will add member functions here
	virtual BOOL OnInitDialog();
	afx_msg void OnGrptrcTrgLv1();
	afx_msg void OnGrptrcTrgLv2();
	afx_msg void OnSelendokGrptrcTrgEvtype();
	afx_msg void OnGrptrcTrgTrcon();
	afx_msg void OnGrptrcTrgTrcoff();
	afx_msg void OnGrptrcTrgTimeron();
	afx_msg void OnGrptrcTrgTimeroff();
	afx_msg void OnGrptrcTrgEnable();
	afx_msg void OnGrptrcTrgDisable();
	afx_msg void OnGrptrcTrgRun();
	afx_msg void OnSelendokGrptrcTrgCombo();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct triggerInfo m_trigger;
    BOOL	m_bApply;			
//private function:	
private:
	void TriggerInit();
    void GetLevel1();
    void GetLevel2();
    void GetTrigger();
    void SetLevel1();
    void SetLevel2();
    void SetTrigger();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage dialog

class CTrcGrpFilterPage : public CCheckPage
{
// Construction
public:
	CTrcGrpFilterPage();	// standard constructor
	virtual BOOL OnSetActive();
	virtual BOOL OnKillActive();
	virtual void OnOK();
	virtual void OnCancel();
// Dialog Data
	//{{AFX_DATA(CTrcGrpFilterPage)
	enum { IDD = IDD_TRCGRP_FLT };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support

	// Generated message map functions
	//{{AFX_MSG(CTrcGrpFilterPage)
		// NOTE: the ClassWizard will add member functions here
	virtual BOOL OnInitDialog();	
	afx_msg void OnSelendokGrptrcFltAddrtype();
	afx_msg void OnSelendokGrptrcFltDatatype();
	afx_msg void OnGrptrcFltDisplay();
	afx_msg void OnGrptrcFltTrace();
	afx_msg void OnGrptrcFltMulti1();
	afx_msg void OnGrptrcFltMulti2();
	afx_msg void OnGrptrcFltRange1();
	afx_msg void OnGrptrcFltRange2();
	afx_msg void OnGrptrcFltWild1();
	afx_msg void OnGrptrcFltWild2();
	afx_msg void OnChangeGrptrcFltEndaddr();
	afx_msg void OnChangeGrptrcFltEnddata();
	afx_msg void OnChangeGrptrcFltStartaddr();
	afx_msg void OnChangeGrptrcFltStartdata();
	afx_msg void OnGrptrcFltAk();
	afx_msg void OnGrptrcFltF();
	afx_msg void OnGrptrcFltR();
	afx_msg void OnGrptrcFltS();
	afx_msg void OnGrptrcFltW();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

//custum:
//private member:
private:
	struct filterInfo m_filter;
    BOOL m_bApply;
    
public:	
	BOOL 	m_bDisplayChange;

//private function:	
private:
    void FilterInit();
    void DisplayInit();
    void TraceInit();               
    
    void GetDisplayFilter();
    void GetTraceFilter();

    void SetDisplayFilter();
    void SetTraceFilter();

public:
	BOOL OnSet();
};

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog

class CTraceGroupDialog : public CPropertySheet
{
public:
	DECLARE_DYNAMIC(CTraceGroupDialog)
	CTraceGroupDialog(CWnd* pWndParent = NULL);
    CTraceGroupDialog(CWnd* pParent, int tab);

protected:
    //{{AFX_MSG(CTraceGroupDialog)
    afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	void DlgInit(void);
	
// Attributes
	CTrcGrpEventPage	m_eventPage;
	CTrcGrpTrcctrlPage	m_trcctrlPage;
	CTrcGrpTriggerPage	m_triggerPage;
    CTrcGrpFilterPage	m_filterPage;

public:
	BOOL	m_bDisplayChange;
	
public:
	void forlive(BOOL live);	
};
#endif
