
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TRCVIEW.H__   1.7.1.0.1.0   11 Nov 1996 12:59:12   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TRCVIEW.H__  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:12   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:17:42   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:12   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:16   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:06   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7   11 Jun 1996 10:30:02   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:58:40   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:08   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:24   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:16   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:52   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:03:16   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:18   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:18   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:48   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:14   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:32   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:44   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:36   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:40:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:14   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:08   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:14:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:13:24   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:18   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:42   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:26   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:18   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:52   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:06   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:44:56   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:21:06   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:26   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:32   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:47:14   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:53:46   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCVIEW.H
//
//  Description:The header file for the class: CTraceView
//
//  Author:     Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

// trcview.h : header file
//

#ifndef _TRCVIEW_
#define _TRCVIEW_

#include "uicom.h"

#define TRACEMODE				int			//for compatibility with pic project
#define	TRACEMODE_BUS			1
#define	TRACEMODE_INSTRUCTION 	2
#define TRACEMODE_SOURCE		3
#define TRACEMODE_MIXED		    4

typedef struct
{
    WORD       phisicalNo;
    char       frameNo[5];
    char       addr[5];
    char       data[3];
    char       status[3];
    char       spare[6];
    char       portdata[3];
}TRACE_BUSREC;

typedef struct
{
    WORD  phisicalNo;
    char  frameNo[5];
    char  addr[5];
    char  instruction[128];
}TRACE_INSTREC;

typedef struct
{
    WORD  phisicalNo;
    char  frameNo[5];
    char  line[10];
    char  c[256];
}TRACE_SOURCEREC;

class CTraceWindow;

/////////////////////////////////////////////////////////////////////////////
// CTraceView window

class CTraceView : public CWnd
{
// Construction
public:
	CTraceView();  
	virtual ~CTraceView();

private:
	int		m_nHscrollMaxpos;

	int		m_nHscrollPos;   	//for vscroll, this var is m_nCurFrame
	int		m_VscrollFlag;
	BOOL	m_bVscOn;
	CTraceWindow*	m_pFather;

private:
	void 	PaintLines(int y, int lineno, CPaintDC* pdc);
	void	SetWindowTitle(UINT nPos);
public:
	WORD	m_wVscrollMaxpos;
	int 	m_nCharWidth;
	int		m_nLineHeight;
	
	int		m_nLeftfrom;
	WORD	m_wCurFrame;	   
    WORD	m_wLines;
    WORD    m_wTextLines;
    BOOL    m_bNullLine;
    int     m_nCxView;
    int		m_nCyView;
    
	WORD	m_wLastFrame;
	
	char	m_ColumnMode[4];			//1:center align, 2:left align
										//3:free mode
	int		m_nCol1len;
	int		m_nCol2len;
	int		m_nCol3len;
	int		m_nCol4len;  
	int		m_nCol5len;
	int		m_nCol6len;
	int		m_nBusCollen[6];
	int		m_nInsCollen[3];
	int		m_nSrcCollen[3];
	int		m_nMixedCollen[3];
	int		m_nColnum;
	int		m_nMaxSrclen;                   //for src and mixed mode
	int		m_nMaxInstlen;					
	
	TRACE_BUSREC*		m_pBus;
	TRACE_INSTREC*		m_pInst;
	TRACE_SOURCEREC*	m_pSource;
	
	void		DrawColLine(int x);
	void		ReSize(int cx, int cy);  
	void		ReColumn(int cx);
	void		OnModechange(TRACEMODE mode);
	BOOL		CalcMaxlenofSrcorInst(void);
	void		PrepareData(BOOL brefresh);

	
protected:
	// Generated message map functions
	//{{AFX_MSG(CTraceView)
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnPaint();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////
