
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/TSTTEMP.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:26   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/TSTTEMP.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:26   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:48   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:52   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:22   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:04   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:29:30   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:58:08   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:28:44   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:06:00   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:02   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:50   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:40   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:43:08   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:55:12   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:03:26   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:29:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:44:16   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:17:16   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:15:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:15:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:16   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:44   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:12:12   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:15:10   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:08:58   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:12:34   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:38   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:19:12   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:54   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:33:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:29:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:40:24   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:04   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:50:42   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:47:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:30:04   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:34   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:24   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:40   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:56:08   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:04   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:58   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: TSTTEMP.CPP
//
//  Description: The implementation file for the class: CTempFile.
//
//  Author: Chen Jun
//
//  Date: 05/19/95
//
//  Modification:
//      1. 05/19/95, Initial version of the class: CTempFile.
//      2. 09/08/95, Fix bug 3, 35, "CTempFile::AppendStock()".
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "tsttemp.h"
#include "hosterrs.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CTempFile* pTempFile = 0;


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void TstCreateStock(void);
void TstDestroyStock(void);
void TstOpenStock(void);
void TstCloseStock(void);
void TstAppendStock(char* pszPrompt, char* pszResult);
BOOL TstQueryStock(char* pszResult);
void DisplayOutOfMemory(void);

#ifdef _CHEN_
    void Calculate(int nArgc, char* pszArgv[]);
#endif  // _CHEN_


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Create the temporary stock.
void TstCreateStock(void)
{
    // Assertion of the input parameters.
    
    // Create the stock.
    if ( !pTempFile ) {
        pTempFile = new CTempFile;
        if ( !pTempFile ) {
            //AfxMessageBox("Insufficient Memory !");
            DisplayOutOfMemory();
            ASSERT( FALSE );
            return;
        }
    }
    
}   // End of TstCreateStock().


// Destroy the temporary stock.
void TstDestroyStock(void)
{
    // Assertion of the input parameters.
    
    // Destroy the stock.
    if ( pTempFile ) {
        delete pTempFile;
        pTempFile = 0;
    }
    
}   // End of TstDestroyStock().


// Open the stock.
void TstOpenStock(void)
{
    // Assertion of the input parameters.
    
    // The stock is now opened.
    if ( pTempFile ) {
        pTempFile->OpenStock();
    }

}   // End of TstOpenStock().


// Close the stock.
void TstCloseStock(void)
{
    // Assertion of the input parameters.
    
    // The stock is now Closeed.
    if ( pTempFile ) {
        pTempFile->CloseStock();
    }

}   // End of TstCloseStock().


// Append to the temporary stock.
void TstAppendStock(char* pszPrompt, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszPrompt );
    ASSERT( pszResult );
    
    // Append to the stock.
    if ( pTempFile ) {
        pTempFile->AppendStock(pszPrompt, pszResult);
    }

}   // End of TstAppendStock().


// Query from the temporary stock.
BOOL TstQueryStock(char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszResult );
    
    // Query from the stock.
    if ( pTempFile ) {
        return (pTempFile->QueryStock(pszResult));
    }
    else {
        ASSERT( FALSE );
        return (FALSE);
    }

}   // End of TstQueryStock().


/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CTempFile.

// Construction.
CTempFile::CTempFile()
{
    // Initial.
    extern char szAppPath[];
    m_strFileName = szAppPath;
    m_strFileName += "~!@#$%^&.()";
    m_isOpened = FALSE;
    m_isExist = FALSE;

}   // End of CTempFile::CTempFile().


// Destruction.
CTempFile::~CTempFile()
{
    // Destroy the stock.
    if ( m_isExist ) {
        Remove(m_strFileName);
    }

}   // End of CTempFile::~CTempFile().


// Open the stock.
void CTempFile::OpenStock(void)
{
    // Assertion of the input parameters.

    // Open the stock.
    m_nOpenFlag = CFile::typeText | CFile::modeCreate | CFile::modeWrite;
    OpenFile();
    m_isExist = TRUE;
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Now the stock is opened.
    m_isOpened = TRUE;

}   // End of CTempFile::OpenStock().


// Close the stock.
void CTempFile::CloseStock(void)
{
    // Assertion of the input parameters.

    // Close the stock.
    CloseFile();
    
    // Now the stock is closed.
    m_isOpened = FALSE;
    
}   // End of CTempFile::CloseStock().


// Append the Shell Prompt & Command Result to the stock.
void CTempFile::AppendStock(char* pszPrompt, char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszPrompt );
    ASSERT( pszResult );
    
    // The stock must be opened.
    if ( !m_isOpened ) {
        return;
    }
        
    // Append to the stock.
    strcpy(m_pszTempLine, pszPrompt);
    strcat(m_pszTempLine, pszResult);
    
    int nLen = strlen(m_pszTempLine);
    m_pszTempLine[nLen] = 0x0d;
    m_pszTempLine[nLen+1] = 0x0a;
    m_pszTempLine[nLen+2] = 0;
    
    m_pszLineBuf = m_pszTempLine;
    WriteToFile();
    
}   // End of CTempFile::AppendStock().


// Query information from the stock.
BOOL CTempFile::QueryStock(char* pszResult)
{
    // Assertion of the input parameters.
    ASSERT( pszResult );
    ASSERT( NO_ERROR == m_nErrorID );

    // Open the stock.
    m_nOpenFlag = CFile::typeText | CFile::modeRead;
    OpenFile();
    if ( NO_ERROR != m_nErrorID ) {
    	m_nErrorID = NO_ERROR;
    	return FALSE;
    }
    ASSERT( NO_ERROR == m_nErrorID );
    
    // Query from the stock.
    do {
        m_pszLineBuf = m_pszTempLine;
        ReadFromFile();
        if ( NO_ERROR != m_nErrorID ) {
            break;
        }
        else {
            int nLen = strlen(m_pszTempLine);
            if ( nLen > 0 ) {
                if ( '\n' == *(m_pszTempLine+nLen-1) ) {
                    nLen -= 1;
                    *(m_pszTempLine+nLen) = 0;
                }
            }
            if ( strstr(m_pszTempLine, pszResult) ) {
                break;
            }
            else {
                continue;
            }
        }
    } while ( TRUE );

    // Close the stock.
    BOOL isRetValue = ( NO_ERROR == m_nErrorID ) ? TRUE : FALSE;
    m_nErrorID = NO_ERROR;
    CloseFile();
    
    // Return back.
    return (isRetValue);

}   // End of CTempFile::QueryStock().


//////////////////////////////// End of File ////////////////////////////////
