
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/VARFRM.CPP   1.7.1.0.1.0   11 Nov 1996 12:57:16   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/VARFRM.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:57:16   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:12:58   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:24:30   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:51:38   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:43:20   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:48:50   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:51:06   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:27:48   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 08:59:30   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:08:00   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:22:30   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:52:56   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:33:46   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:26   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:48:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:01:58   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:12   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:42:50   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:11:28   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:00   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:12:40   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:32:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:22:02   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:07:28   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:07:42   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:10   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:17:58   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:21:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:10   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:44   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:38   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:02:22   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:02   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:50   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:48:42   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:22:02   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.3   29 Sep 1995 09:49:38   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:58:00   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:34   Shirley
** EasyPack/SLDV0.1a 
** 
**    Rev 1.0   07 Sep 1995 09:55:24   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARFRM.CPP
//
//  Description: The implementation file for the class: CVarFrame.
//
//  Author: Chen Jun
//
//  Date: 07/18/95
//
//  Modification:
//      1. 07/18/95, Initial version of the class: CVarFrame.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "uicom.h"
#include "btnbar.h"
#include "mainfrm.h"

#include "varpane.h"

#include "varfrm.h"
#include "vardoc.h"
#include "varview.h"

#include "varmodi.h"
#include "varsrch.h"
#include "varcast.h"
#include "varadd.h"
#include "varedit.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Global variables.
CMultiDocTemplate* pVarDocTemplate;

BOOL isVarSortByHistory = TRUE;
BOOL isVarDisplayVertically = TRUE;

BOOL isVarWindowActive = FALSE;


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void VarOpenWindow(CMDIFrameWnd* pParent);
void VarCloseWindow(void);

BOOL VarAllocateSpace(void);
void VarReleaseSpace(void);


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
void VarDeleteOneNode(void);
void VarDeleteAll(void);
BOOL VarIsEmpty(void);
void VarSearchNextToken(void);
void VarUpdateWholeWindow(void);


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern CMDIChildWnd* pVariableWnd;      // Defined in UICOM.H
extern BOOL isVariableOn;               // Defined in UICOM.H

extern CStringList* pVarSearchPatternList;  // Defined in VARSRCH.CPP
extern CStringList* pVarTypeCastList;       // Defined in VARCAST.CPP
extern CStringList* pVarAddVariableList;    // Defined in VARADD.CPP
extern CStringList* pVarEditVariableList;   // Defined in VAREDIT.CPP

extern BOOL isStkLocalActive;

extern class VarServer varObject;

extern BOOL GetCpuStatus(unsigned char & uchStatus);

/////////////////////////////////////////////////////////////////////////////
// Public functions.

// Open the Variable window if it's now closed.
void VarOpenWindow(CMDIFrameWnd* /* pParent */)
{
    // Assertion of the input parameters.

    // Only one Variable window.
    if ( ::isVariableOn ) {
        return;
    }

    ::pVarDocTemplate->OpenDocumentFile(NULL);

    ::VarUpdateWholeWindow();
    
}   // End of VarOpenWindow().

// Close the Variable window if it's now opened.
void VarCloseWindow(void)
{
    // Assertion of the input parameters.
    ASSERT( ::pVariableWnd );
    ASSERT( TRUE == ::isVariableOn );

    // Send message to Variable window.
    ::pVariableWnd->SendMessage(WM_CLOSE);

}   // End of VarCloseWindow().

// Allocate the space for the variable list.
BOOL VarAllocateSpace(void)
{
    // Assertion of the input parameters.

    // Allocate ::pVarSearchPatternList.
    ::pVarSearchPatternList = new CStringList;
    ASSERT( ::pVarSearchPatternList );
    if ( !::pVarSearchPatternList ) {
        return (FALSE);
    }
    
    // Allocate ::pVarTypeCastList.
    ::pVarTypeCastList = new CStringList;
    ASSERT( ::pVarTypeCastList );
    if ( !::pVarTypeCastList ) {
        return (FALSE);
    }
    
    // Allocate ::pVarAddVariableList.
    ::pVarAddVariableList = new CStringList;
    ASSERT( ::pVarAddVariableList );
    if ( !::pVarAddVariableList ) {
        return (FALSE);
    }

    // Allocate ::pVarEditVariableList.
    ::pVarEditVariableList = new CStringList;
    ASSERT( ::pVarEditVariableList );
    if ( !::pVarEditVariableList ) {
        return (FALSE);
    }
    
    return (TRUE);
}


// Release the space.
void VarReleaseSpace(void)
{
    // Assertion of the input parameters.

    // Release the allocated space.
    if ( ::pVarSearchPatternList ) {
        delete ::pVarSearchPatternList;
    }
    
    if ( ::pVarTypeCastList ) {
        delete ::pVarTypeCastList;
    }

    if ( ::pVarAddVariableList ) {
        delete ::pVarAddVariableList;
    }

    if ( ::pVarEditVariableList ) {
        delete ::pVarEditVariableList;
    }
}


/////////////////////////////////////////////////////////////////////////////
// CVarFrame

IMPLEMENT_DYNCREATE(CVarFrame, CMDIChildWnd)

// Specify the Window class.
BOOL CVarFrame::PreCreateWindow(CREATESTRUCT& cs)
{
    // Register a custom WndClass and create a window.
    // This must be done because CVarFrame has a custom icon.
    const char* pszVariableFrameClass =
        AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH) (COLOR_WINDOW+1),
            LoadIcon(AfxGetInstanceHandle(), MAKEINTRESOURCE(IDR_VARIABLE)));
    
    // Set to CREATESTRUCT.
    ASSERT( NULL == cs.lpszClass );
    cs.lpszClass = pszVariableFrameClass;

    return TRUE;
}

// Construction.
CVarFrame::CVarFrame()
{
    // Set the Flag.
    ::isVariableOn = TRUE;
    ::pVariableWnd = this;
    
    // Initial.
    m_nErrorID = noError;
}

// Destruction.
CVarFrame::~CVarFrame()
{
    // Reset the flag.
    ::isVariableOn = FALSE;
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Display the error message.
void CVarFrame::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > noError && m_nErrorID < maxError );
    
    // Create the error message table.
    char* pszErrorMessage[] = {
        "",
        "Insufficient memory.",
        "Cannot create bottom pane in Variable window."
    };
    
    // Show the error message.
    AfxMessageBox(pszErrorMessage[m_nErrorID]);
}


/////////////////////////////////////////////////////////////////////////////
// Message map

/*
    ON_COMMAND(ID_VIEW_SORTBYHISTORY, OnViewSortbyHistory)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SORTBYHISTORY, OnUpdateViewSortbyHistory)
    ON_COMMAND(ID_VIEW_SORTBYNAME, OnViewSortbyName)
    ON_UPDATE_COMMAND_UI(ID_VIEW_SORTBYNAME, OnUpdateViewSortbyName)
    ON_COMMAND(ID_VIEW_DISPLAYHORIZONTALLY, OnViewDisplayHorizontally)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAYHORIZONTALLY, OnUpdateViewDisplayHorizontally)
    ON_COMMAND(ID_VIEW_DISPLAYVERTICALLY, OnViewDisplayVertically)
    ON_UPDATE_COMMAND_UI(ID_VIEW_DISPLAYVERTICALLY, OnUpdateViewDisplayVertically)
    ON_COMMAND(ID_VIEW_TYPECAST, OnViewTypeCast)
    ON_UPDATE_COMMAND_UI(ID_VIEW_TYPECAST, OnUpdateViewTypecast)
    ON_COMMAND(ID_VARIABLE_UNDELETE, OnVariableUndelete)
*/
BEGIN_MESSAGE_MAP(CVarFrame, CMDIChildWnd)
    //{{AFX_MSG_MAP(CVarFrame)
    ON_CBN_KILLFOCUS(IDC_SRCHCOMBO, OnSrchComboKillFocus)
    ON_UPDATE_COMMAND_UI(IDC_SRCHCOMBO, OnUpdateSearchCombo)
    ON_WM_CREATE()
    ON_WM_SIZE()
    ON_WM_GETMINMAXINFO()
    ON_COMMAND(ID_EDIT_MODIFYVALUES, OnEditModifyValues)
    ON_COMMAND(ID_EDIT_SEARCH, OnEditSearch)
    ON_COMMAND(ID_EDIT_SEARCHNEXT, OnEditSearchNext)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCHNEXT, OnUpdateEditSearchNext)
    ON_COMMAND(ID_VARIABLE_ADD, OnVariableAdd)
    ON_COMMAND(ID_VARIABLE_DELETE, OnVariableDelete)
    ON_COMMAND(ID_VARIABLE_DELETEALL, OnVariableDeleteAll)
    ON_COMMAND(ID_VARIABLE_EDIT, OnVariableEdit)
    ON_WM_MDIACTIVATE()
    ON_UPDATE_COMMAND_UI(ID_EDIT_MODIFYVALUES, OnUpdateEditModifyvalues)
    ON_UPDATE_COMMAND_UI(ID_EDIT_SEARCH, OnUpdateEditSearch)
    ON_UPDATE_COMMAND_UI(ID_VARIABLE_DELETE, OnUpdateVariableDelete)
    ON_UPDATE_COMMAND_UI(ID_VARIABLE_DELETEALL, OnUpdateVariableDeleteall)
    ON_UPDATE_COMMAND_UI(ID_VARIABLE_EDIT, OnUpdateVariableEdit)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarFrame message handlers

void CVarFrame::OnSrchComboKillFocus(void)
{   
    CMainFrame * pMain = (CMainFrame *)AfxGetApp()->m_pMainWnd;
    CString str = pMain->m_wndToolBar.GetSrchEditText();    
    if(str != "") { 
        pMain->m_wndToolBar.AddSrchText(str);
        ::pVarSearchPatternList->AddTail(str);
    }
}

void CVarFrame::OnUpdateSearchCombo(CCmdUI* pCmdUI)
{
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;
    
    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}


int CVarFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CMDIChildWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here
    
    // Create the bottom pane.
    if ( !m_wndBottomPane.Create(this) ) {
        m_nErrorID = bottomPane;
        DisplayErrorMessage();
        ASSERT( FALSE );
        return -1;
    }

    return 0;
}

void CVarFrame::OnSize(UINT nType, int cx, int cy)
{
    CMDIChildWnd::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here

    // Adjust the Bottom pane position.
    CRect rect(0, cy-bottomHeight+1, cx, cy);
    m_wndBottomPane.MoveWindow(rect);
}

void CVarFrame::OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI)
{
    // TODO: Add your message handler code here and/or call default
    
    // Set the minimum range.
    lpMMI->ptMinTrackSize = CPoint(bottomHeight*10, bottomHeight*4);
    
    CMDIChildWnd::OnGetMinMaxInfo(lpMMI);
}

void CVarFrame::OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd)
{
    CMDIChildWnd::OnMDIActivate(bActivate, pActivateWnd, pDeactivateWnd);
    
    // TODO: Add your message handler code here
    
    // Update the Variable window.
//    if( bActivate && this == pActivateWnd ) {
//        ::VarUpdateWholeWindow();
//    }

    if(bActivate && pActivateWnd == this)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate), 
            LONG(WID_VARIABLE));
    else if(!bActivate && !pActivateWnd)
        GetMDIFrame()->SendMessage(XM_MDIACTIVE, WORD(bActivate)); 
}


void CVarFrame::OnEditModifyValues()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Open the Modify Variable dialog.
    CVarModifyVariableDialog dlg;
    dlg.DoModal();
}

void CVarFrame::OnUpdateEditModifyvalues(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    BOOL bEnable = TRUE;

    unsigned char    uch;

	GetCpuStatus(uch);
	if ( uch ) {
        bEnable = FALSE;
    }
    else if ( ::VarIsEmpty() ) {
        bEnable = FALSE;
    }
    else {
    	::varObject.VarLineToNode(((CVarView*)GetActiveView())->m_nCurRow, 
    							 ((CVarView*)GetActiveView())->m_pVarNode);

        ((CVarView*)GetActiveView())->DetectVarFormat();
        if ( ((CVarView*)GetActiveView())->simpleSign != 
             ((CVarView*)GetActiveView())->m_nBmpStatus ) {
            bEnable = FALSE;
        }
        if ( ((CVarView*)GetActiveView())->m_pVarNode->CanBeModify() != 0 )
        	bEnable = FALSE;
    }
    
    pCmdUI->Enable(bEnable);
}

void CVarFrame::OnEditSearch()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Open the Search Dialog.
    CVarSearchDialog dlg;
    dlg.DoModal();
}

void CVarFrame::OnUpdateEditSearch(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}

void CVarFrame::OnEditSearchNext()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Search the token from the next line.
    ::VarSearchNextToken();
}

void CVarFrame::OnUpdateEditSearchNext(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable the menu item.
    if ( ::VarIsEmpty() ) {
        pCmdUI->Enable(FALSE);
    }
    else {
        pCmdUI->Enable(!::pVarSearchPatternList->IsEmpty());
    }
}

/*
void CVarFrame::OnViewSortbyHistory()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Check the global flag.
    if ( ::isVarSortByHistory ) {
        return;
    }
    
    // Sort by history.
    ::isVarSortByHistory = TRUE;

    // TODO:
    
}

void CVarFrame::OnUpdateViewSortbyHistory(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Set the radio dot or not.
    pCmdUI->SetRadio(::isVarSortByHistory);
}

void CVarFrame::OnViewSortbyName()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Check the global flag.
    if ( !::isVarSortByHistory ) {
        return;
    }
    
    // Sort by name.
    ::isVarSortByHistory = FALSE;

    // TODO:
    
}

void CVarFrame::OnUpdateViewSortbyName(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Set the radio dot or not.
    pCmdUI->SetRadio(!::isVarSortByHistory);
}

void CVarFrame::OnViewDisplayHorizontally()
{
    // TODO: Add your command handler code here

    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Check the global flag.
    if ( !::isVarDisplayVertically ) {
        return;
    }
    
    // Display horizontally.
    ::isVarDisplayVertically = FALSE;

    // TODO:

}

void CVarFrame::OnUpdateViewDisplayHorizontally(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Set the radio dot or not.
    pCmdUI->SetRadio(!::isVarDisplayVertically);
}

void CVarFrame::OnViewDisplayVertically()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Check the global flag.
    if ( ::isVarDisplayVertically ) {
        return;
    }
    
    // Display vertically.
    ::isVarDisplayVertically = TRUE;

    // TODO:

}

void CVarFrame::OnUpdateViewDisplayVertically(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here

    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Set the radio dot or not.
    pCmdUI->SetRadio(::isVarDisplayVertically);
}

void CVarFrame::OnUpdateViewTypecast(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}

void CVarFrame::OnViewTypeCast()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Open Type Cast dialog.
    CVarTypeCastDialog dlg;
    dlg.DoModal();
}
*/

void CVarFrame::OnVariableAdd()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Open Add Variable dialog.
    CVarAddVariableDialog dlg;
    dlg.DoModal();
}

void CVarFrame::OnUpdateVariableDelete(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}

void CVarFrame::OnVariableDelete()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Delete the boot variable node.
    ::VarDeleteOneNode();
}

void CVarFrame::OnUpdateVariableDeleteall(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}

void CVarFrame::OnVariableDeleteAll()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Delete all the variables in the Variable window.
    ::VarDeleteAll();
}

void CVarFrame::OnUpdateVariableEdit(CCmdUI* pCmdUI)
{
    // TODO: Add your command update UI handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Enable or disable according to if the Variable window is empty.
    pCmdUI->Enable(!::VarIsEmpty());
}

void CVarFrame::OnVariableEdit()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;

    // Open Edit Variable dialog.
    CVarEditVariableDialog dlg;
    dlg.DoModal();
}

void CVarFrame::OnVariableUndelete()
{
    // TODO: Add your command handler code here
    
    // Set the identify flag.
    ::isVarWindowActive = TRUE;
    ::isStkLocalActive = FALSE;
}
