
/***************************************************************************
**
**    $Header:   D:/EPSLDV1/SRC/LOG/ZLIST.CPP   1.7.1.0.1.0   11 Nov 1996 12:59:20   ZJRD  $
**
**    $Log:   D:/EPSLDV1/SRC/LOG/ZLIST.CPP  $
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:20   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:00   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:29:30   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:56:34   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:24   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:55:54   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:58:56   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:31:30   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:04:46   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:13:38   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:24:12   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:24   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:14   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:53:52   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:10   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:34   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:52   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:20   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:16   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:08   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:00   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:50   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:44   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:02   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:34   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:44   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:28   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:48   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:20   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:54   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:08   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:48   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:14   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:02   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:27:04   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:51:14   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:48   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:02   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:57:58   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:26   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:16   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  ZLIST.CPP
//
//  Description:The implement file for the class: SingleList.
//
//  Author:     Roger Zhang
//
//  Date:       05/06/95
//
//  Modification:
//
//      1. 05/06/95, Initial version      
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "zlist.h"

/////////////////////////////////////////////////////////////////////////////
//  for debuf use
/////////////////////////////////////////////////////////////////////////////
#ifdef _FDEBUG
FILE * pSListDebug;	// used to dump debug message to a file
#endif

/////////////////////////////////////////////////////////////////////////////
//  Node of the list: SListNode
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SListNode::~SListNode
//
//  Description: Destructor of the class SListNode
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
SListNode::~SListNode(void)
{
    if(m_pElem) delete m_pElem;
}

#ifdef _DEBUG

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SListNode::Dump
//
//  Description: Dump class information on debug phase
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void SListNode::Dump(void) const
{
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_pNext = %p m_pElem = %p\n", m_pNext, m_pElem);
    #else
        TRACE("m_pNext = %p m_pElem = %p\n", m_pNext, m_pElem);
    #endif
    m_pElem->Dump();
}

#endif

/////////////////////////////////////////////////////////////////////////////
//  SingleList
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::~SingleList
//
//  Description: Destructor of the class SingleList
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
SingleList::~SingleList(void)
{
    Clean();
}                                   

#ifdef _DEBUG

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::Dump
//
//  Description: Dump class information on debug phase
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void SingleList::Dump(void) const
{                            
    #ifdef _FDEBUG
        fprintf(pSListDebug, "m_lCount = %ld  m_lMax = %ld\n", m_lCount, m_lMax);    
        fprintf(pSListDebug, "m_pHead = %p m_pTail = %p\n", m_pHead, m_pTail);
    #else
        TRACE("m_lCount = %ld  m_lMax = %ld\n", m_lCount, m_lMax);    
        TRACE("m_pHead = %p m_pTail = %p\n", m_pHead, m_pTail);
    #endif
    SListNode * p = m_pHead;
    long l = 0;
    while(p) {
        #ifdef _FDEBUG
            fprintf(pSListDebug, "Node No.%ld :\n", l++);
        #else
            TRACE("Node No.%ld :\n", l++);
        #endif
        p->Dump();
        p = p->m_pNext;    
    }
}
#endif

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::Clean
//
//  Description: Clean up the list
//
//  Input:  None
//
//  Output: None
//
//  Return: ELIST_OK -- Success
//          ELIST_EMPTY -- List already empty
//
/////////////////////////////////////////////////////////////////////////////
int SingleList::Clean(void)
{
    if(IsEmpty())   return  ELIST_EMPTY;
    else {        
        SListNode * p1 = m_pHead, *p2;
        while(p1) {
            p2 = p1->m_pNext;
            delete p1;
            p1 = p2;
        }
        m_pHead = 0;
        m_pTail = 0;
        m_lCount = 0;
        return  ELIST_OK;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::AddTail
//
//  Description: Add element on the tail of the list
//
//  Input:  
//      pElem -- Pointer to SListElement
//
//  Output: None
//
//  Return: ELIST_OK -- Success
//          ELIST_FULL -- List full
//          ELIST_MEM -- Out of memory
//
/////////////////////////////////////////////////////////////////////////////
int SingleList::AddTail(SListElement * pElem)
{                        
    ASSERT(pElem);
    
    if(IsFull())    return  ELIST_FULL;
    SListNode * p = new SListNode(pElem);
    if(!p)  return  ELIST_MEM;
    else {
        if(IsEmpty()) m_pHead = m_pTail = p;
        else {
            m_pTail->m_pNext = p;
            m_pTail = p;
        }
        ++ m_lCount;
        return ELIST_OK;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::GetFirst 
//
//  Description: Get first element in list
//
//  Input:  None
//
//  Output: None
//
//  Return: Pointer to the element to get
//          0 -- List empty
//
/////////////////////////////////////////////////////////////////////////////
SListElement * SingleList::GetFirst(void) 
{
    if(IsEmpty())   return 0;
    
    m_pIdx = m_pHead;
    SListElement * p = m_pIdx->m_pElem;
    ASSERT(p);
    return p;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::GetNext
//
//  Description: Get next element after last get
//
//  Input:  None
//
//  Output: None
//
//  Return: Pointer to the element to get
//          0 -- List empty or on tail
//
/////////////////////////////////////////////////////////////////////////////
SListElement * SingleList::GetNext(void) 
{      
    if(!m_pIdx) return GetFirst();
                               
    if(m_pIdx->m_pNext == 0)   return 0;
    
    m_pIdx = m_pIdx->m_pNext;
    SListElement * p = m_pIdx->m_pElem;
    ASSERT(p);
    return p;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::Get
//
//  Description: Get current element
//
//  Input:  None
//
//  Output: None
//
//  Return: Pointer to the element to get
//          0 -- List empty
//
/////////////////////////////////////////////////////////////////////////////
SListElement * SingleList::Get(void) 
{
    if(!m_pIdx) return GetFirst();
                               
    SListElement * p = m_pIdx->m_pElem;
    ASSERT(p);
    return p;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::Set
//
//  Description: Set current node by node pointer
//
//  Input:  
//      pIdx -- Pointer to SListNode
//
//  Output: None
//
//  Return: TRUE
//
/////////////////////////////////////////////////////////////////////////////
BOOL SingleList::Set(SListNode * pIdx)
{                                               
    ASSERT(pIdx);

    m_pIdx = pIdx;
    return TRUE;    
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   SingleList::Set
//
//  Description: Set current node by index
//
//  Input:  
//      lIdx -- Index of element
//
//  Output: None
//
//  Return: TRUE
//
/////////////////////////////////////////////////////////////////////////////
BOOL SingleList::Set(long lIdx)
{              
    if(IsEmpty())   return FALSE;
    
    if(lIdx < 0) {
        m_pIdx = m_pHead;   return TRUE;
    } else if(lIdx > m_lCount - 1) {
        m_pIdx = m_pTail;   return TRUE;
    }
    
    m_pIdx = m_pHead;
    for(long l = 0; l < lIdx; l++) m_pIdx = m_pIdx->m_pNext;    
    return TRUE;
}

////////////////////////////////(EOF)////////////////////////////////////////
