
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/ABITRC51.CPP   1.2.1.5   17 Apr 1997 15:40:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/ABITRC51.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:40:46   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:10:58   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:26:30   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:08:38   ZJRD
** 2.09E
** 
**    Rev 1.2.1.0   28 Mar 1997 10:13:38   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:24:58   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:44:10   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:58   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:01:14   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:23:00   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:34:28   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:01:30   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:45:14   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:50:20   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.8   20 Jun 1996 09:29:32   ZJRD
** EasyPack/SLD Version 1.20a
** 
**    Rev 1.6   10 Jun 1996 10:24:10   ZJRD
** EasyPack/SLD Version 1.20
** 
**    Rev 1.4   29 May 1996 09:35:50   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:04:48   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.1   02 May 1996 10:24:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:53:28   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:40:18   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:22:46   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:53:56   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:09:14   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:38   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:24   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:18   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:12   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:02   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:52   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:09:48   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:04   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:36   Shirley
** EasyPack/SLD Version 0.34
** 
**    Rev 1.16   30 Nov 1995 09:08:16   Shirley
** EasyPack/SLD Version 0.33
** 
**    Rev 1.15   28 Nov 1995 15:34:48   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:32   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:52   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:22   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:58   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:10   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:52   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:16   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:52   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:26   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:16   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:47:40   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:24   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:30   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:16   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abitrc51.cpp
**
** Description: this file contains all "TRACE" commands' functions.
** Modification:
** 1. V0.1b
**    1. fixed a bug in AbiClrEvent()
**    2. change AbiClrQualify()
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include <stdio.h>
#include <string.h>

#include "abitype.h"
#include "abimacro.h"

//Frank, 11/28/95, for step_range & step_over_range
static unsigned char pszStepInfo[40];
static unsigned int uStepLen;
STATUS AbiEscape(BOOL fContinue);
static BOOL isInContinueState = FALSE;
extern STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);
/////////////////////////////////////////////////////////////////
// ABI rountine part
//
STATUS AbiGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr);
STATUS AbiSetBp(ADDR addr);
STATUS AbiClrBp(ADDR addr);
STATUS AbiClrAllBp();


STATUS AbiStepOne();
STATUS AbiStepOver();
STATUS AbiStepRange(ADDR stAddr, ADDR endAddr);
STATUS AbiStepOverRange(ADDR stAddr, ADDR endAddr);
STATUS AbiCycle(int *iCycleNum, CYCLE_INFO *cycleInfo);

STATUS AbiReset(ADDR addr);
STATUS AbiAbort();
STATUS AbiGo(FLAG runFlag, ADDR fromAddr, ADDR tillAddr);

STATUS AbiClrEvent(int evId);
STATUS AbiGetEvent(FLAG *byControl, FLAG *byEv3, QUALIFY *pQualify,
                   BUS_EVENT *pEv1, BUS_EVENT *pEv2);
STATUS AbiSetEvent(BUS_EVENT busEvData);
STATUS AbiSetQualify(QUALIFY qualifyData);
STATUS AbiClrQualify();

STATUS AbiGetTrigger(FLAG *byTrigStatus,
                     FLAG *byLv1Status, TRIGGER_LEVEL* pLv1,
                     FLAG *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic);
STATUS AbiSetTrigStatus(FLAG uTraceFlag);
STATUS AbiSetTrigLevel(int levelId, TRIGGER_LEVEL trigLevelData);
STATUS AbiSetTrigLogic(TRIGGER_LOGIC trigLogicData);
STATUS AbiGetTraceLastFrame(UINT* uLastFrame);
STATUS AbiGetTraceBuffer(UINT readDirect, UINT startFrame, UINT endFrame,
                         QUALIFY aQualify,
                         TRACE_INFO* traceInfo, UINT* frameNum, FLAG* readEnd);
//added by john 96.5
STATUS AbiGetTraceSource(UINT startFrame, BYTE count, DWORD addrRange[10],
                         BYTE rangeCount,
                         BYTE* retCount,DWORD* pInputBuf );
                         
STATUS AbiSetTimerStatus(FLAG uTimerFlag);
STATUS AbiSetTraceStatus(FLAG uTimerFlag);


/////////////////////////////////////////////////////////////////
// call ABI sub rountine 
//
extern STATUS SendReceive(UINT uintLoop, int tcount);

/*****************************************************
**
** Name : AbiGetBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_BP,uintLoop);
    SaveVar(addr1,uintLoop,sizeof(ADDR));
    SaveVar(addr2,uintLoop,sizeof(ADDR));
    

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_FOUND)
        memcpy(bpAddr, &inputStream[1],sizeof(ADDR));
    return status;
}

/*****************************************************
**
** Name : AbiSetBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetBp(ADDR bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_BP,uintLoop);
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}


/*****************************************************
**
** Name : AbiClrBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrBp(ADDR bpAddr)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_BP,uintLoop);
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiClrAllBp()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrAllBp()
{
    STATUS status; 
    ADDR bpAddr;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_BP,uintLoop);
    bpAddr.addrType = 0;
    SaveVar(bpAddr, uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiCycle()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiCycle(int *iCycleNum, CYCLE_INFO *cycleInfo)
{
    STATUS status; 
    UINT uintLoop;
    
    uintLoop = 0;
    SaveId(FW_CYCLE, uintLoop);
    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {             
        *iCycleNum = inputStream[1];
        memcpy(cycleInfo, &inputStream[2], (*iCycleNum)*sizeof(CYCLE_INFO));
    }
    
    return status;
}                    


/*****************************************************
**
** Name : AbiStepOver()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepOne()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_ONE,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiStepOver()
**
** Function
**
**    Input  :
**
**    Output :
** Return:
**       0: ICE_OK
**       9: CONTINUE;
** Notes:
**
*****************************************************/
STATUS AbiStepOver()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_OVER,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

/*****************************************************
**
** Name : AbiStepRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepRange(ADDR stAddr, ADDR endAddr)
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_RANGE,uintLoop);
    SaveVar(stAddr, uintLoop, sizeof(ADDR));
    SaveVar(endAddr,uintLoop, sizeof(ADDR));

    status = SendReceive(uintLoop, BASE_TIME);
    if ( status == 0x9) { //require_continue
        UINT i=0;
        while( i < uintLoop) {
          pszStepInfo[i] = outputStream[i];
          i++;
        }
        uStepLen = uintLoop;       
        isInContinueState = TRUE;
    }
    else isInContinueState = FALSE;
    return status;
}


STATUS AbiEscape(BOOL fContinue)
{
    STATUS  status;

    if ( fContinue == FALSE) {
        isInContinueState = FALSE;
        return(ICE_OK);           
    }    
    else if (isInContinueState) {
        UINT i=0;
        while( i < uStepLen) {
          outputStream[i] = pszStepInfo[i];
          i++;
        }
        status = SendReceive(uStepLen, BASE_TIME);
        return(status);
    } 
    return(ICE_OK);
}

/*****************************************************
**
** Name : AbiStepOverRange()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiStepOverRange(ADDR stAddr, ADDR endAddr)
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_STEP_OVER_RANGE,uintLoop);
    SaveVar(stAddr, uintLoop, sizeof(ADDR));
    SaveVar(endAddr,uintLoop, sizeof(ADDR));
    
    status = SendReceive(uintLoop, BASE_TIME);
    if ( status == 0x9) { //require_continue
        UINT i=0;
        while( i < uintLoop) {
          pszStepInfo[i] = outputStream[i];
          i++;
        }
        uStepLen = uintLoop;
        isInContinueState = TRUE;
    }
    else isInContinueState = FALSE;
    
    return status;
}                    
 
/*****************************************************
**
** Name : AbiReset()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
//added by john 96.5
//now if the addr.type == 0x10,it does mean HW RESET.
STATUS AbiReset(ADDR addr)
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_RESET,uintLoop);
    SaveVar(addr, uintLoop, sizeof(ADDR));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}
 
/*****************************************************
**
** Name : AbiAbort()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiAbort()
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_ABORT,uintLoop);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
} 

/*****************************************************
**
** Name : AbiGo()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGo(FLAG runFlag, ADDR fromAddr, ADDR tillAddr)
{ 
    STATUS status;
    UINT uintLoop;
    FLAG reserved= 0;

    uintLoop = 0;
    SaveId(FW_GO,uintLoop);
    SaveVar(runFlag, uintLoop,sizeof(FLAG));
    SaveVar(reserved, uintLoop,sizeof(FLAG));
    SaveVar(fromAddr,uintLoop,sizeof(ADDR));
    SaveVar(tillAddr,uintLoop,sizeof(ADDR));
    

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiGetEvent()
**
** Function
**
**    Input  : none
**
**    Output : byControl: bit0:Qualify, bit1:EV1, bit2:EV2;
**                        = 0:disable, = 1:enable
**             byEv3: 0 or 1; 0:LOW, 1:HIGH
**             pQualify: the struct pointer to store QUALIFY info.
**             pEv1: the struct pointer to store EV1 info.
**             pEv2: the struct pointer to store EV2 info.
**
** Notes: F/W pQualify, pEv1, pEv2's buffer are 0x80, not
**        sizeof(QUALIFY);
**
*****************************************************/
STATUS AbiGetEvent(FLAG *byControl, FLAG *byEv3, QUALIFY *pQualify,
                   BUS_EVENT *pEv1, BUS_EVENT *pEv2)
{ 
    STATUS status;
    UINT uintLoop;

    char *pchQualify, *pchEv1, *pchEv2;
    
    pchQualify = (char *) pQualify;
    pchEv1 = (char *) pEv1;
    pchEv2 = (char *) pEv2;
    
    uintLoop = 0;
    SaveId(FW_GET_EVENT,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *byControl = inputStream[1];
        *byEv3 = inputStream[2];

        for (uintLoop=0; uintLoop < sizeof(QUALIFY); uintLoop++) {
            if (*byControl & 1)
                *pchQualify ++ = inputStream[0x3+uintLoop];
            if (*byControl & 2)
                *pchEv1 ++ = inputStream[0x83+uintLoop];
            if (*byControl & 4)
                *pchEv2 ++ = inputStream[0x103+uintLoop];
        }    
    }
    return status;
}

/*****************************************************
**
** Name : AbiSetEvent()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetEvent(BUS_EVENT busEvData)
{ 
    STATUS status;
    UINT uintLoop;

//    AbiClrEvent(int(busEvData.qlfyType[0]));
    uintLoop = 0;
    SaveId(FW_SET_EVENT,uintLoop);
//    SaveVar(evId, uintLoop,sizeof(int));
    SaveVar(busEvData, uintLoop, sizeof(BUS_EVENT));

    status = SendReceive(uintLoop, BASE_TIME*6);
    return status;
}

/*****************************************************
**
** Name : AbiClrEvent()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrEvent(int evId)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_EVENT,uintLoop);
    switch(evId) {
        case 0:
            outputStream[1] = 0;
            outputStream[2] = 0;
            outputStream[3] = 0;
            outputStream[4] = 0;
            break;
        case 1:
            outputStream[1] = 1;
            outputStream[2] = 0;
            outputStream[3] = 1;
            outputStream[4] = 0;        
            break;
        case 2:
            outputStream[1] = 2;
            outputStream[2] = 0;
            outputStream[3] = 2;
            outputStream[4] = 0;        
            break;
        case 3:
            outputStream[1] = 3;
            outputStream[2] = 0;
            outputStream[3] = 3;
            outputStream[4] = 0;        
            break;
       default:
            return 1;
    }
    uintLoop = 5;
    status = SendReceive(uintLoop, BASE_TIME*2);
    return status;
}

/*****************************************************
**
** Name : AbiSetQualify()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetQualify(QUALIFY qualifyData)
{ 
    STATUS status;
    status = AbiSetEvent(qualifyData);
    return status;
}

/*****************************************************
**
** Name : AbiClrQualify()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiClrQualify()
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_CLR_EVENT,uintLoop);
    outputStream[1] = 0;
    outputStream[2] = 0;
    outputStream[3] = 0;
    outputStream[4] = 0;

    uintLoop = 5;
    status = SendReceive(uintLoop, BASE_TIME*2);
    return status;
}

/*****************************************************
**
** Name : AbiGetTrigger()
**
** Function
**
**    Input  : none
**
**    Output : byTrigStatus: 1:on, 0:off
**             byLv1Status: 0 or 1; 0:not set, 1:set
**             pLv1: the struct pointer to store LV1 info.
**             byLv2Status: 0 or 1; 0:not set, 1:set
**             pLv2: the struct pointer to store LV2 info.
**             pTrigLogic: the struct pointer to store TRIGGER logic info.
**
** Notes:
**
*****************************************************/
STATUS AbiGetTrigger(FLAG *byTrigStatus,
                     FLAG *byLv1Status, TRIGGER_LEVEL* pLv1,
                     FLAG *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic)
{ 
    STATUS status;
    UINT uintLoop;
    UCHAR *chPtr, *pchLv1, *pchLv2, *pchTrigLogic; 
    
    pchLv1 = (UCHAR *) pLv1;
    pchLv2 = (UCHAR *) pLv2;
    pchTrigLogic = (UCHAR *) pTrigLogic;

    uintLoop = 0;
    SaveId(FW_GET_TRIGGER,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *byTrigStatus = inputStream[1];
        *byLv1Status = inputStream[2];

        chPtr = &(inputStream[0x3]);
        chPtr++;  //for skip levelId, 07/20/95
        chPtr++;

        for (uintLoop=0; uintLoop < sizeof(TRIGGER_LEVEL); uintLoop++) {
            *pchLv1 ++ = *chPtr++;
        }
        *byLv2Status = *chPtr++;

        chPtr++;  //for skip levelId, 07/20/95
        chPtr++;
        for (uintLoop=0; uintLoop < sizeof(TRIGGER_LEVEL); uintLoop++) {
            *pchLv2 ++ = *chPtr++;
        }
        for (uintLoop=0; uintLoop < sizeof(TRIGGER_LOGIC); uintLoop++) {
            *pchTrigLogic ++ = *chPtr++;
        }
    }
    return status;
}

/*****************************************************
**
** Name : AbiSetTrigStatus()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTrigStatus(FLAG uTraceFlag)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRIG_ONOFF,uintLoop);
    SaveVar(uTraceFlag, uintLoop, sizeof(FLAG));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiSetTrigLevel()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTrigLevel(int levelId, TRIGGER_LEVEL trigLevelData)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRIG_LEVEL,uintLoop);
    SaveVar(levelId, uintLoop,sizeof(int));
    SaveVar(trigLevelData, uintLoop, sizeof(TRIGGER_LEVEL));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiSetTrigLogic()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTrigLogic(TRIGGER_LOGIC trigLogicData)
{ 
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRIG_LOGIC,uintLoop);
    SaveVar(trigLogicData, uintLoop, sizeof(TRIGGER_LOGIC));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiGetTraceLastFrame()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetTraceLastFrame(UINT* uLastFrame)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_LAST_FRAME,uintLoop);

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        memcpy(uLastFrame, &inputStream[1],sizeof(UINT));
    }
    return(status);
}


/*****************************************************
**
** Name : AbiGetTraceBuffer()
**
** Function : to get the trace buffer content
**
**    Input  : readDirect = 0:down;
**             startFrame =
**             endFrame =
**             aQualify =
**
**    Output :  traceInfo : the storage of
**              frameNum:
**              readEnd = 0:over, 1:not end
**
** Notes:
**
*****************************************************/
STATUS AbiGetTraceBuffer(UINT readDirect, UINT startFrame, UINT endFrame,
                         QUALIFY aQualify,
                         TRACE_INFO* traceInfo, UCHAR* frameNum, FLAG* readEnd )
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_BUFFER,uintLoop);

    SaveVar(readDirect, uintLoop, sizeof(UINT));
    SaveVar(startFrame, uintLoop, sizeof(UINT));
    SaveVar(endFrame, uintLoop, sizeof(UINT));
    SaveVar(aQualify, uintLoop, sizeof(QUALIFY));

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *frameNum = (UCHAR) inputStream[1];
        *readEnd  = (FLAG) inputStream[2];
        memcpy(traceInfo, &inputStream[3], (*frameNum) * sizeof(TRACE_INFO));
    }
    return status;
}

/*****************************************************
**
** Name : AbiGetTraceSource()
**
** Function : to get the trace buffer content
**
**    Input  :
**             startFrame =
**             count =count from start frame
**             addrRange = address range area defined by caller
**             rangeCount = how many range area defined by caller
**
**    Output :  traceInfo : the storage of source trace
**              retCount: how trace frame returned
**              pInputBuf:trace information returned(only include frameNo
**                        and address)
**
** Notes: ADDED BY JOHN 96.5 to support Chris to speed the list source function
**
*****************************************************/
STATUS AbiGetTraceSource(UINT startFrame, BYTE count, DWORD addrRange[10],
                         BYTE rangeCount,
                         BYTE* retCount,DWORD* pInputBuf )
{          

	UCHAR m_uchMajor, m_uchMinor;
	STATUS m_nErrorID = AbiGetFwId(&m_uchMajor, &m_uchMinor);
    if ( 0 != m_nErrorID ) {
        return m_nErrorID;
    }  
    BOOL isOldFw;
    if ( m_uchMajor == 0x13 ||
    	 m_uchMajor == 0x05 ||
    	 m_uchMajor == 0x12 ||
    	 m_uchMajor == 0x22 ||
 		 m_uchMajor == 0x32 ||
 		 m_uchMajor == 0x42  ) {
    	isOldFw = TRUE;
    } else {
    	isOldFw = FALSE;
    }
    
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_TRACE_SOURCE,uintLoop);

    SaveVar(startFrame, uintLoop, sizeof(UINT));
    SaveVar(count, uintLoop, sizeof(BYTE));
    SaveBuffer(&(addrRange[0]),uintLoop,10*sizeof(DWORD));
    SaveVar(rangeCount, uintLoop, sizeof(BYTE));
    

    status = SendReceive(uintLoop, BASE_TIME);
    if (status == ICE_OK) {
        *retCount = (UCHAR) inputStream[1];
        //add by chris, for FW bug.
        if(*retCount>count)
        	*retCount=0;
        memcpy(pInputBuf, &inputStream[2], 8*(*retCount));
    }     
    
    if(isOldFw) {
    	for(int i=(*retCount);i>0;i--) {
    		pInputBuf[(i-1)*2] = pInputBuf[i-1]; 	
    	}
    	for(int j=(*retCount);j>0;j--) {
    		pInputBuf[(j-1)*2+1] = 0; 	
    	}
    }
    return status;
}

/*****************************************************
**
** Name : AbiSetTimerStatus()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTimerStatus(FLAG uTimerFlag)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TIMER_ONOFF,uintLoop);
    SaveVar(uTimerFlag, uintLoop, sizeof(FLAG));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

/*****************************************************
**
** Name : AbiSetTraceStatus()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSetTraceStatus(FLAG uTraceFlag)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SET_TRACE_ONOFF,uintLoop);
    SaveVar(uTraceFlag, uintLoop, sizeof(FLAG));

    status = SendReceive(uintLoop, BASE_TIME);
    return status;
}

