/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/BOPT.CPP   1.2.1.5   17 Apr 1997 15:42:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/BOPT.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:42:08   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:16:14   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:28:06   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:09:44   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:14:44   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:26:00   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:44:44   ZJRD
** Initial revision.
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:15:14   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 12:58:30   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:15:56   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:27:30   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 09:54:36   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.4.1.0   12 Aug 1996 10:53:10   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:36:30   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// bopt.cpp
//
// Michael Long
//                                                                           
// 5/16/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "afx.h"
#include "toolopt.h"    
#include "bc.h"
#include "bcoption.h"
#include "ba.h"
#include "baoption.h"
#include "bl.h"
#include "bloption.h"
#include "be.h"
#include "beoption.h"
#include "blib.h"
#include "blibopti.h"
#include "btab.h"
#include "projopt.h"
#include "bopt.h" 
#include "direct.h"  

extern char szAppPath[_MAX_PATH+1];
/////////////////////////////////////////////////////////////////////////////
// operations
void BOption::SetOption(CWnd *pParent)
{
    CBTab dlg(&m_bcTool, &m_baTool, &m_blTool, &m_blibTool,&m_beTool, pParent);
    dlg.DoModal();
}

BOOL BOption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_bcTool.SaveOption(fp))
        return FALSE;
    if(!m_baTool.SaveOption(fp))
        return FALSE;
    if(!m_blTool.SaveOption(fp))
        return FALSE;
    if(!m_blibTool.SaveOption(fp))
        return FALSE; 
    if(!m_beTool.SaveOption(fp))
        return FALSE; 
  /*  if((_stricmp(m_beTool.m_strPath," ")!=0)&&(_stricmp(m_beTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;*/ 
    return TRUE;
}
                
BOOL BOption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_bcTool.LoadOption(fp))
        return FALSE;
    if(!m_baTool.LoadOption(fp))
        return FALSE;
    if(!m_blTool.LoadOption(fp))
        return FALSE;
    if(!m_blibTool.LoadOption(fp))
        return FALSE;
    if(!m_beTool.LoadOption(fp))
        return FALSE;
  /*  if((_stricmp(m_beTool.m_strPath," ")!=0)&&(_stricmp(m_beTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;*/     
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int BOption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".S03") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL BOption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;
    CString str, str1, str2, str3;
    FILE * fp,*fpold;
    int i, flag, bFlag=0;  
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
    char path[_MAX_PATH];

    const int ncnt=1 ;
    char ad[ncnt];
    fp = fopen(GetName(lpcszProj, ".XCL"), "wt");
    if(!fp)
        goto CMDFAIL;
    
//    CString str3 ;     
    if(m_blTool.m_fZ)
    {
     str3 ="-!define cpu type: -!\n";
     str3 += "-c";
     str3 += m_blTool.m_strCpu;
     str3 +=" ";
    
    
     if(fwrite(str3.GetBuffer(str3.GetLength()), str3.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str3.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
    }
    
     {
        CString strFile(::szAppPath);
        strFile += "ideicc.xcl";
        fpold = fopen(strFile, "rt");
    }
    
    while(feof(fpold)==0){
    
    fread(ad,1,ncnt,fpold);
    fwrite(ad,1,ncnt,fp);
        
    }
         
    fclose(fpold); 
   
        
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i ++) {
        str2 = lst.GetNext(pos);
        flag = GetFileType(str2);
        if(flag != 2) 
         {  
            if(flag==0) bFlag = 1;
            str1 = "";
            str  = GetName(str2, ".R03");
            _splitpath(str, drive, dir, fname, ext); 
            _makepath (path, NULL, NULL, fname, ext);
            str1 += path;
         }
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }   
                            
    
    if(bFlag){
	    str1 = m_blibTool.GetOption();
	
	    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
	        goto CMDFAIL;
	    else
	        str1.ReleaseBuffer();
	
	    if(fputc('\n', fp) == EOF)          
	        goto CMDFAIL;
    }
                      
    str1 = m_blTool.GetOption();
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
     
    str1 =" ";
    str1+="-o ";
    if(m_blTool.m_fW==TRUE)
    str1+=GetName(lpcszProj,".DBG");  
    else
    str1+=GetName(lpcszProj,".A03");

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
    str1 = " ";
    str1 += "-x ";
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
        
    str1 =" ";
    str1+="-l ";
    str1+=GetName(lpcszProj,".map");
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    
    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
}                                              

BOOL BOption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void BOption::Build(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;   
    CString str;
    CString strBuild;
    CString cstr;
    CString astr;
    CString lstr; 
   
    if(_stricmp(m_baTool.m_incPath,m_bcTool.m_incPath)!=0)
    { 
     AfxMessageBox("Include Path of Compiler and Assemble should be same");
     return;
    }
    
    cstr = m_bcTool.m_strPath;
    astr = m_baTool.m_strPath; 
    lstr = m_blTool.m_strPath;
    if(cstr[cstr.GetLength()-1]!='\\')
    cstr = cstr + "\\";
    if(astr[astr.GetLength()-1]!='\\')
    astr = astr + "\\";
    if(lstr[lstr.GetLength()-1]!='\\')
    lstr = lstr + "\\";  
    int nType;                   
    FILE * fp;
    
    fp = fopen(GetName(lpcszProj, ".bat"), "wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
      
     if(!WriteBatchFile(fp, "Set C_LIB="+m_blibTool.m_strPath))
            return;
     if(!WriteBatchFile(fp, "Set C_INCLUDE="+m_bcTool.m_incPath))
            return;
            
    CString strDir ;
    int     strDrive;
    
    char Directory[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR];
    _splitpath(lpcszProj, drive, dir, NULL, NULL);
    _makepath(Directory,drive, dir, NULL, NULL);
    strDrive = drive[0]-'a'+1;
    _chdrive(strDrive);
    //discard '\' in directory 
     
    for(int i=0;i<_MAX_DIR;i++)
     if(dir[i]=='\\' && dir[i+1]=='\0')
      dir[i] = '\0';
    _chdir(dir);    
    char path[_MAX_PATH], fname[_MAX_FNAME],ext[_MAX_EXT];

    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file
            strBuild = cstr + "ICC8051.exe ";
            strBuild += m_bcTool.GetOption();
            strBuild += str;
            _splitpath(str,NULL,NULL,fname,ext);
            _makepath(path,NULL,NULL,fname,ext);
            strBuild += " -o ";
            strBuild += GetName(path, ".R03");           
        } else if(nType == 1) { // asm file
            strBuild = astr + "A8051.exe ";
            strBuild += str;
            strBuild += " ";
            _splitpath(str,NULL,NULL,fname,ext);
            _makepath(path,NULL,NULL,fname,ext);
            strBuild += GetName(path,".LST");
            strBuild += " ";
            strBuild += GetName(path, ".R03");
            strBuild += " "; 
            strBuild +=m_baTool.GetOption();
                        
        } else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
     
    }                                   
    
    // link
    if(!CreateLinkCmdFile(lst, lpcszProj))
        return;
    strBuild = lstr + "XLINK.exe ";
    strBuild += "-f "; 
    strBuild += GetName(lpcszProj, ".XCL");
    if(!WriteBatchFile(fp, strBuild))
        return;
    
     if(!WriteBatchFile(fp, "Pause"))
            return;
                                                    
    fclose(fp);
    
    WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}                                     


    static char BASED_CODE szFilter[] = 
    "Source file (*.cpp)|*.cpp|Source file (*.c)|*.c|Source file (*.asm)|*.asm|All Files (*.*)|*.*||";
 
 void BOption::Editor(CWnd * pParent)
  {
   CString str;        
   CString str1;            
   CString filename;
   
    str1 = m_beTool.m_strPath; 
    
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(str1, drive, dir, fname, ext);
    if(!(_stricmp(ext,".exe")==0||_stricmp(ext,".com")==0))
    {
     AfxMessageBox("Editor command error!");
     return;
    
     }
    CFileDialog dlg(TRUE, NULL, "*.c", 
        OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter, pParent);
    
   dlg.m_ofn.lpstrTitle = "Open File ";
   if(dlg.DoModal() == IDOK) {
      filename = dlg.GetPathName();
      m_beTool.m_strProg = filename;
    
      str = m_beTool.m_strPath + " ";
      str += filename;
      WinExec(str, SW_SHOW);
   }
} 
                