
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/DADMEM.CPP   1.2.1.5   17 Apr 1997 15:47:24   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DADMEM.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:47:24   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:18:50   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:30:14   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:11:14   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:16:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:27:24   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:45:30   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:22   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:38   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:27:48   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:56   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:50:24   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:24   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:26   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:35:04   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:08:08   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:09:40   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:25:34   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:16   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:35:34   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:50:48   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:05:28   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:32:02   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:45:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:18:02   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:37:52   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:23:20   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:10:16   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.16   30 Nov 1995 09:11:06   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:30:14   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:20:28   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:26:52   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:00   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:46   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:14   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:05:36   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:49:42   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:49:06   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:42   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:56   Shirley
** EasyPack/SLD Version 0.1e
** 
**    Rev 1.3   29 Sep 1995 09:52:44   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:52:36   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:44:42   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:22   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : source.cpp
** Author:John Zhou
** Description:
**    This file is for Roger to use in memory window
**
**
**    Finished date: 1995.8
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"
#include "dad.h"
#ifdef MEMORY
#include "dadtbl.h"
#include <string.h>
#include "errcodec.h"
#include "hosterrs.h"

extern unsigned char gEPModule;
extern unsigned long CpuModule_H,CpuModule_L;                                                              
extern unsigned char WherePlace; //used in GetSymbol to decide the code area or xdata area

extern int Asm (unsigned char * PAsmInput, unsigned short AsmAddr,
                unsigned char * PAsmResult,unsigned int *AsmBytes,
                FLAG ABIAddrType  
                );  
extern int DAOne (unsigned char *,unsigned short,unsigned int, OneInstructionPlus *OneInstr);
void CodeHextoText(char *Hex,char *textbuff,int num);
extern int GetSymbol(unsigned char Attribute,//xdata,idate,ibit,code,Sfr
                     unsigned short Address,//0-0xffff
                     unsigned char *Symbol, //return string containing symbol,ended with 0
                     const unsigned char len);// length 

//editted because of the request that I must fill the buffer if having dad error
int MEMDisAsm(   
            long memStartAddr,   // the start address to be disassembly
            int  memLineNo,      //how many instructions to be disassembled
            DADMEMSTRU * dadMemStru, //struct array to save result
            int abiArea , //code area or xdata area
            int *finishedNo //how many instructions is ok
            )

 { 
   FLAG ABIAddrType; //refer to ABI address type
   
   unsigned char DAsmlnCodeBlk[MAXMEMINSTRUCTION*3+10];  //point to codes to be disassembly
   ADDR AddrforABI1,AddrforABI2;
   WORD AddrMax,AddrMin ;
   
   unsigned int InstrIndex;  //index to the current instruction to be dissambled
                             //used in MyInstruction
   unsigned int InputInstrIndex;//index to the current instruction byte being
                                  //disasembled in DAsmlnCodeBlk
   unsigned char OneInstrCode[7]; //defining more memory than it's need
   OneInstructionPlus MyOneInstruction;//for DAOne using

   int i,j;     
   ABIAddrType=abiArea;
   
   
   if(gEPModule>63) return -3;
   
//convert the cpu module to own definition
   if(gEPModule<32)
   {
    CpuModule_L=1;  CpuModule_H=0;
    CpuModule_L<<=gEPModule;
    }                            
    else
     { 
      CpuModule_L=0;  CpuModule_H=1;
      CpuModule_H<<=(gEPModule-32);
      }
//check length
   if(memLineNo==0) return -6;//return for the code length is zero
   if(memLineNo>MAXMEMINSTRUCTION) memLineNo=MAXMEMINSTRUCTION;
//get bytes from ABI
   switch(ABIAddrType)
    {
     case ABI_CODE_ADDR_JOHN  : AddrMax=ABI_CODE_ADDR_JOHN_MAX;AddrMin=ABI_CODE_ADDR_JOHN_MIN;break;
     case ABI_XDATA_ADDR : AddrMax=ABI_XDATA_ADDR_MAX;AddrMin=ABI_XDATA_ADDR_MIN;break;
     //case ABI_IDATA_ADDR : AddrMax=ABI_IDATA_ADDR_MAX;AddrMin=ABI_IDATA_ADDR_MIN;break;
     //case ABI_SFR_ADDR   : AddrMax=ABI_SFR_ADDR_MAX;AddrMin=ABI_SFR_ADDR_MIN;break;
     //case ABI_BIT_ADDR   : AddrMax=ABI_BIT_ADDR_MAX;AddrMin=ABI_BIT_ADDR_MIN;break;
     default           : AddrMax=ABI_CODE_ADDR_JOHN_MAX;AddrMin=ABI_CODE_ADDR_JOHN_MIN;break;
     }
   if((WORD)memStartAddr>AddrMax || (WORD)memStartAddr<AddrMin) return -7;//refer to having wrong address comparing to address type
   
   AddrforABI1.addrType=ABIAddrType;
   AddrforABI1.addr=(WORD)memStartAddr;
   AddrforABI2.addrType=ABIAddrType;
   AddrforABI2.addr=(WORD)((WORD)memStartAddr+(memLineNo*3+5-1));
                                               //5 FOR BACKUP       
   if(AddrforABI1.addr<=AddrforABI2.addr)
    { if(AbiGetMemN(AddrforABI1,AddrforABI2,(char *)DAsmlnCodeBlk)!=0) return -105;}
    else
    {
     ADDR addrTemp;                    
   	 addrTemp.addrType=ABIAddrType;
     addrTemp.addr=AddrMax;
     if(AbiGetMemN(AddrforABI1,addrTemp,(char *)DAsmlnCodeBlk)!=0) return -105;
     addrTemp.addr=AddrMin;
     if(AbiGetMemN(addrTemp,AddrforABI2,(char *)(&DAsmlnCodeBlk[0xffff-AddrforABI1.addr+1]))!=0) return -105;
     }
    
   WherePlace=ABIAddrType;
   InstrIndex=0;//for result struct number
   InputInstrIndex=0;//for input code location

   while(InputInstrIndex<(unsigned int)memLineNo*3+5 
         && InstrIndex<(unsigned int)memLineNo)
    {
     for(i=0;i<3;i++) OneInstrCode[i]=0;
     for(i=0;i<CMd_51[DAsmlnCodeBlk[InputInstrIndex]].ByteNum;i++) 
       OneInstrCode[i]=DAsmlnCodeBlk[InputInstrIndex+i];
     j=DAOne(OneInstrCode,(unsigned short)((memStartAddr+InputInstrIndex)
       %(AddrMax+1L)),CMd_51[DAsmlnCodeBlk[InputInstrIndex]].ByteNum,
       &MyOneInstruction);
     if(j<0) return j;
     
     //record the result                            
     
     //address
     dadMemStru[InstrIndex].address=
       (long)((memStartAddr+InputInstrIndex) %(AddrMax+1L));
     
     //object
     dadMemStru[InstrIndex].code[0]=0; 
     CodeHextoText((char *)(&(MyOneInstruction.InstrString[6])),
                    dadMemStru[InstrIndex].code,
                    CMd_51[DAsmlnCodeBlk[InputInstrIndex]].ByteNum);        
                  
     //instruction
     dadMemStru[InstrIndex].instruction[0]=0;
     
     strcat(dadMemStru[InstrIndex].instruction,
            (char *)(&(MyOneInstruction.InstrString[14])));
     strcat(dadMemStru[InstrIndex].instruction," ");
      {
       unsigned char *OPCODE;
       OPCODE=&(MyOneInstruction.InstrString[21]); 
       while(*OPCODE!=0)
        {
         strcat(dadMemStru[InstrIndex].instruction,(char *)OPCODE);
         strcat(dadMemStru[InstrIndex].instruction,",");
         OPCODE+=strlen((char *)OPCODE)+1;
         }      
       *(
         dadMemStru[InstrIndex].instruction +
         ((strlen(dadMemStru[InstrIndex].instruction)>0)
          ?strlen(dadMemStru[InstrIndex].instruction)-1:0)
        )=0;  
       }
         
     InputInstrIndex+=CMd_51[DAsmlnCodeBlk[InputInstrIndex]].ByteNum;
     InstrIndex++;
     }
   *finishedNo=InstrIndex;
   if(InstrIndex<(unsigned int)memLineNo) return -2;

   return 0;//OK!
//return  0 ok
//return <=-100 DADOne error
//return -2 less intructions than needed
//return -3 invalid cpu moduel
//return -6 return for the code length is zero
//return -7 refer to having wrong address comparing to address type
//return -105 ABI reading error
  }
  
//disassembly function(from DisAsm()) and defined for source
int GetDsm (                                    
			int	 nBankArg,			//6, 7, 8, 9
            long memStartAddr,   // the start address to be disassembly
            int  memLineNo,      //how many instructions to be disassembled
            DADMEMSTRU * dadMemStru, //struct array to save result
            int abiArea  //code area or xdata area
            )            
{            
 int finishedNo;
 int result= MEMDisAsm(   
            memStartAddr,   // the start address to be disassembly
            memLineNo,      //how many instructions to be disassembled
            dadMemStru, //struct array to save result
            abiArea , //code area or xdata area
            &finishedNo //how many instructions is ok
            );
            
 if(result==0)  return 0;  CString strTmp = "";
 
 char tmp[40]; tmp[0]=0;
 switch(result)
 {                                  
  case -2:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_2, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  case -3:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_3, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  case -6:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_6, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  case -7:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_7, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  case -105:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_105, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  default:if(0 != ErrGetErrorText(ER_EMU_DAD_SRC_DEFAULT, strTmp)) break;
          strcat(tmp,strTmp.GetBuffer(strTmp.GetLength()+2)); break;
  }
 
 AfxMessageBox(tmp);
 //fill the buff
 if(memLineNo==0) memLineNo=MAXMEMINSTRUCTION-10;
 for(unsigned int i=(unsigned int)finishedNo;i<(unsigned int)memLineNo;i++) 
  {                
   dadMemStru[i].address=0;
   dadMemStru[i].code[0]=0;
   strcat(dadMemStru[i].code,"00");
   dadMemStru[i].instruction[0]=0;
   strcat(dadMemStru[i].instruction,"NOP?");
   }             
 return result;  
 }              

//this function defined for lANE(MEM window) to call asssembly function                                                                
long MemAssemble(long laneAddr,char *RogerInstr,int abiArea) 
{         
 int i;
 char AsmResult[5]; 
 unsigned int AsmBytes;
 FLAG ABIAddrType;
  
 if(strlen(RogerInstr)>255) 
  {
   return -1;
   }
 
 ABIAddrType=abiArea;
                        
 i=Asm((unsigned char *)RogerInstr,(unsigned short)laneAddr,
       (unsigned char *)AsmResult,&AsmBytes,ABIAddrType);
 
 switch(i)
  {
   case  0:laneAddr+=AsmBytes; return laneAddr;
   
   default:return -1;
   }//switch
                     
 return -1;                    
 }//function   
//ADDED BY JOHN 96.5
extern SFRNAME SFRbit;
extern SFRNAME SFRbyte;
BOOL GetSFRBYTEName(BYTE bAddr,CString &strName )
{ 
  if(gEPModule>63) return FALSE;//invalid cpu mode
//convert the cpu module to own definition 
  if(gEPModule<32)
   {
    CpuModule_L=1;  CpuModule_H=0;
    CpuModule_L<<=gEPModule;
    }                            
    else
     { 
      CpuModule_L=0;  CpuModule_H=1;
      CpuModule_H<<=(gEPModule-32);
      }
      
  int tempInd;            
  
  SFRNAME SFRbyte={(unsigned char*) "            ",0x0,1,0,0};
           
  tempInd=GetByteSFRSymbolIndex(bAddr,&(SFRbyte),CpuModule_H,CpuModule_L);
  if(tempInd>=0)
     {
      strName = (char *)SFRbyte.Name;
      return TRUE;
      }
  return FALSE;    
 }

BOOL GetSFRBitName(BYTE bAddr,CString &strName )
{ 
  if(gEPModule>63) return FALSE;//invalid cpu mode
//convert the cpu module to own definition 
  if(gEPModule<32)
   {
    CpuModule_L=1;  CpuModule_H=0;
    CpuModule_L<<=gEPModule;
    }                            
    else
     { 
      CpuModule_L=0;  CpuModule_H=1;
      CpuModule_H<<=(gEPModule-32);
      }
      
  int tempInd;                       
  SFRNAME SFRbit={(unsigned char*) "            ",0x80,1,0,0};
  tempInd=GetBitSFRSymbolIndex(bAddr,&(SFRbit),CpuModule_H,CpuModule_L);
  if(tempInd>=0)
     {
      strName = (char *)SFRbit.Name;
      return TRUE;
      }
  return FALSE;    
 }

  
#endif
