#include "stdafx.h"
#include "diaginfo.h"
//implement of CInfoTree
POSITION CInfoTree::m_FilePosition;
CStringList CInfoTree::m_theInfoFileBuffer;
CInfoTree* CInfoTree::Get(BYTE bNum)
{ 
	if ((bNum > GetCount()) || (0 == bNum)) return NULL;
	POSITION position = GetHeadPosition();
	for(int i=1; i<bNum; i++) GetNext(position);
	
	return (CInfoTree*) GetAt(position);
	
 }

void CInfoTree::Initial()
{                   
	CString tmpFileStr;
	CStringList tmpStrList;
	POSITION tmpPosition;
	
	if (NULL == m_pTheFather) {
		m_FilePosition = m_theInfoFileBuffer.GetHeadPosition();	
		ASSERT (NULL != m_FilePosition);
		//m_theInfoFileBuffer.GetNext(m_FilePosition);
		m_bLevel = 0;
	} else m_bLevel = ((CInfoTree*)m_pTheFather)->m_bLevel+1;
	m_bType = TYPE_NULL;
	            
	while (NULL != m_FilePosition) {
		tmpFileStr = m_theInfoFileBuffer.GetNext(m_FilePosition);
		if("END" == tmpFileStr) break;
		//try to get every substr from tmpFileStr and store it to tmpStrList
		CString* tmpStr = new CString;  *tmpStr = "";
		for (int i=0; i<tmpFileStr.GetLength(); i++) {
			if ((' ' == tmpFileStr[i]) || ('\t' == tmpFileStr[i])
				|| ('\n' == tmpFileStr[i])) {
				if (*tmpStr != "") {
					tmpStrList.AddTail(tmpStr->GetBuffer(tmpStr->GetLength()+2));
					delete tmpStr;
					tmpStr = new CString;  *tmpStr = "";
				} 
			} else {
				*tmpStr = *tmpStr + tmpFileStr[i];
			}
		}//for		
		delete tmpStr;
		
					     
		tmpPosition = tmpStrList.GetHeadPosition();	
		if (NULL == tmpPosition) {
			tmpStrList.RemoveAll();
			continue;
		}	
			
		if (NULL != tmpPosition) {
			//get level
			CString tmpStr = tmpStrList.GetAt(tmpPosition);
			if ("END" == tmpStr) { 
				tmpStrList.RemoveAll();
				continue;
			}	
			ASSERT (-1 != tmpStr.Find("LEVEL")); 
			ASSERT (6 == tmpStr.GetLength());
			BYTE bTmpLevel = tmpStr[5] - '0';
			
			if (bTmpLevel == m_bLevel) {
				//check if all sons of this subTree is initialized
				if (TYPE_NULL != m_bType) {
					tmpStrList.RemoveAll();
					m_theInfoFileBuffer.GetPrev(m_FilePosition);
					return;	
			    }
	            //initialize the own point settings
	            tmpStrList.GetNext(tmpPosition);
				while(NULL != tmpPosition) {
					tmpStr = tmpStrList.GetNext(tmpPosition);
					if("CONST" == tmpStr) {
						 ASSERT(NULL != tmpPosition);
						 tmpStr = tmpStrList.GetNext(tmpPosition);	             	 
	                     ASSERT(1 == tmpStr.GetLength());
	                     m_bType = TYPE_CONST;
	                     m_bDatum = tmpStr[0]-'0';
	                     ASSERT(NULL != tmpPosition);
	                     tmpStr = tmpStrList.GetNext(tmpPosition);	             	 
	                     ASSERT(0 < tmpStr.GetLength());
	                     m_strNotes = tmpStr;
	                } else if("DATUM" == tmpStr) {      
            			m_bType = TYPE_DATUM;
						if (NULL == tmpPosition) {
							m_strNotes = "";
						} else {
							tmpStr = tmpStrList.GetNext(tmpPosition);
							ASSERT(0 < tmpStr.GetLength());
							if (("CONST" == tmpStr) || 
							 	 ("DATUM" == tmpStr) ||
	                             ("ADDRESS" == tmpStr) ||
	                             ("NOTES" == tmpStr)) {
	                         	tmpStrList.GetPrev(tmpPosition);
	                         	m_strNotes = "";
	                         } else {
	                            m_strNotes = tmpStr;			    
	                         }
	                     }//else end                
                     } else if("ADDRESS" == tmpStr) {
            			 m_bType = TYPE_ADDRESS;
						 if (NULL == tmpPosition) {
						 	m_strNotes = "";
						 } else {
						 	 tmpStr = tmpStrList.GetNext(tmpPosition);
							 ASSERT(0 < tmpStr.GetLength());
							 if (("CONST" == tmpStr) || 
							 	 ("DATUM" == tmpStr) ||
	                             ("ADDRESS" == tmpStr) ||
	                             ("NOTES" == tmpStr)) {
	                         	tmpStrList.GetPrev(tmpPosition);
	                         	m_strNotes = "";
	                         } else {
	                            m_strNotes = tmpStr;			    
	                         } 
	                     } //else end    
                     } else if("NOTES" == tmpStr) {    
            			 m_bType = TYPE_NOTES;
            			 ASSERT(NULL != tmpPosition);
            			 tmpStr = tmpStrList.GetNext(tmpPosition);	             	 
                         ASSERT(0 < tmpStr.GetLength());
                         m_strNotes = tmpStr;             
                     } else ASSERT(FALSE);    
	            }//while  
	            
	        }//if =
	        
	        if (bTmpLevel < m_bLevel) {                         
	        	tmpStrList.RemoveAll();
	        	m_theInfoFileBuffer.GetPrev(m_FilePosition);
				return;	
			}
			
			if (bTmpLevel > m_bLevel) {
				ASSERT(m_bLevel+1 == bTmpLevel);           
				m_theInfoFileBuffer.GetPrev(m_FilePosition);
				CInfoTree* tmpInfoTree = new CInfoTree(this);
				AddTail((CObject*)tmpInfoTree);
			}
        }
        tmpStrList.RemoveAll();
        
    }//while                                                   
    
}//function	        	
 
//construct and destruct 
CInfoTree::CInfoTree(CInfoTree* pTheFather)
{                
	m_strNotes = "NULL";
	m_pTheFather = pTheFather;
	Initial();
	return;
 }
CInfoTree::~CInfoTree()
{                                          
	POSITION tmpPosition = GetHeadPosition();
	CInfoTree *tmpInfoTree;
	while (NULL != tmpPosition) {
	    tmpInfoTree = (CInfoTree*)GetNext(tmpPosition);
		delete (CInfoTree*)tmpInfoTree;
	}	
	RemoveAll();                                    
 }

void CInfoTree::Test()
{ 
	AfxMessageBox(m_strNotes); 
	POSITION tmpPosition = GetHeadPosition();
	CInfoTree *tmpInfoTree;
	while (NULL != tmpPosition) {
	    tmpInfoTree = (CInfoTree*)GetNext(tmpPosition);
	    tmpInfoTree->Test();
	}	
	
 }
