/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/DIAGNO/DIAGNOST.CPP   1.7   17 Apr 1997 16:36:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DIAGNO/DIAGNOST.CPP  $
** 
**    Rev 1.7   17 Apr 1997 16:36:08   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:13:12   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:58:00   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:35:24   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:19:32   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:48:20   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 15:01:22   ZJRD
** Initial revision.
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:24:44   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 13:04:48   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:49:06   ZJRD
** EasyPack/SLD Version 1.9f
** 
**    Rev 1.4.1.3   05 Sep 1996 11:39:44   ZJRD
** EasyPack/SLD Version 1.9e
** 
**    Rev 1.4.1.2   02 Sep 1996 10:04:36   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.4.1.0   12 Aug 1996 11:06:18   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   05 Jun 1996 15:01:00   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.1   29 May 1996 09:43:00   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.0   16 May 1996 09:12:42   ZJRD
** Initial revision.
** 
****************************************************************************/
// diagnost.cpp : implementation file
//
//john chow 96.3
#include "stdafx.h"
#include "diagnost.h"   
#include "abireg51.h"    
#include "diagnres.h"
#include "waningdi.h"
#include "detaildl.h"
#include "colors.h"
#include "uisrlx.h"
#include "diagno.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern BOOL g_bEnhanced;
extern ADDR retAddr;
extern STATUS AbiReset(ADDR addr);
extern STATUS AbiDiagnostic(unsigned char uchOption,unsigned char&);
extern STATUS AbiDiagnostic2(BYTE& bResult1,BYTE& bResult2);
extern STATUS AbiGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff);
extern BOOL jedLoad(CString filename, int nAction);

extern BYTE GetStep();
extern BOOL isStop;
//defined for being used in checking wether there is a ep-sld
BOOL isEpSldRunning = FALSE;           
BOOL isFirstTime = TRUE;                   
BOOL isOldFw = FALSE;
BOOL isCanHWReset = FALSE;
BOOL CALLBACK EnumWndProcx(HWND hwnd,LPARAM lParam)
{                  
    char tmp[256];
    GetWindowText(hwnd,&tmp[0],230);
    //AfxMessageBox(tmp);
    if (NULL != strstr(&tmp[0],"EasyPack/SLD")) {
        isEpSldRunning = TRUE;           
        return FALSE;
    }   
    return TRUE;
 }

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   TestKey
//
//  Description: Test if a specified key pressed
//
//  Input:  
//      wKey -- Key code
//
//  Output: None
//
//  Return: 1 -- The key has been pressed
//          0 -- The key not been pressed
//
/////////////////////////////////////////////////////////////////////////////
int TestKey(WORD wKey)
{   
    /*MSG msg;
    if(PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
        PM_NOREMOVE|PM_NOYIELD)) {
        PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST,
            PM_REMOVE|PM_NOYIELD);
        if(msg.message == WM_KEYDOWN || msg.wParam == wKey) 
            return  1;        
    }            
    return  0;*/
    if(isStop) return 1; else return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox dialog


CDiagnosticBox::CDiagnosticBox(CWnd* pParent /*=NULL*/)
    : CDialog(CDiagnosticBox::IDD, pParent)
{
    //{{AFX_DATA_INIT(CDiagnosticBox)
    m_POIResult = "";
    m_MAPRAMResult = "";
    m_EVENTADDRResult = "";
    m_EVENTDATARAMResult = "";
    m_SPOONRAMResult = "";
    m_EMULATIONRAMResult = "";
    m_TRACERAMResult = "";
    m_AllResult = "";
    //}}AFX_DATA_INIT
    //define time (unit 2 seconds)
    wTimerCounter[0] = 0;//TOTAL TIME   
    wTimerCounter[1] = 1; //POI
    wTimerCounter[2] = 1; //MAPRAM
    wTimerCounter[3] = 3; //EVENTADDR
    wTimerCounter[4] = 1; //EVENTDATARAM
    wTimerCounter[5] = 1; //SPOONRAM
    wTimerCounter[6] = 21; //EMULATIONRAM
    wTimerCounter[7] = 3; //TRACERAM
    
    m_isCanTime = FALSE;
    
    hLib = LoadLibrary("METER.DLL");
    if(hLib < HINSTANCE_ERROR)  return;
}                              

CDiagnosticBox::~CDiagnosticBox()
{ 
    FreeLibrary(hLib);
    if ( m_nTimerID != 0) KillTimer(m_nTimerID);
 }

void CDiagnosticBox::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CDiagnosticBox)
	DDX_Control(pDX, IDC_BUTTON_DETAIL2, m_buttonFunction);
    DDX_Control(pDX, IDC_BUTTON_LOCATE, m_Button_Locate);
    DDX_Control(pDX, ID_BUTTON_DETAIL, m_buttonDetail);
    DDX_Control(pDX, IDCANCEL, m_buttonQuit);
    DDX_Control(pDX, IDC_EMULATIONRAM, m_buttonEmulationRam);
    DDX_Control(pDX, IDC_CHECK_TRACERAM, m_buttonCheckTraceRam);
    DDX_Control(pDX, IDC_CHECK_SPOONRAM, m_buttonCheckSpoonRam);
    DDX_Control(pDX, IDC_CHECK_PIOCTC, m_buttonCheckPIOCTC);
    DDX_Control(pDX, IDC_CHECK_MAPRAM, m_buttonCheckMapRam);
    DDX_Control(pDX, IDC_CHECK_EVENTDATARAM, m_buttonCheckEventDataRam);
    DDX_Control(pDX, IDC_CHECK_EVENTADDRRAM, m_buttonCheckEventAddrRam);
    DDX_Control(pDX, ID_BUTTON_DIAGNOSTIC, m_buttonDiagnostic);
    DDX_Control(pDX, IDC_CHECK_ALL, m_buttonCheckAll);
    DDX_Text(pDX, IDC_STATIC_PIO, m_POIResult);
    DDX_Text(pDX, IDC_STATIC_MAPRAM, m_MAPRAMResult);
    DDX_Text(pDX, IDC_STATIC_EVENTADDRRAM, m_EVENTADDRResult);
    DDX_Text(pDX, IDC_STATIC_EVENTDATARAM, m_EVENTDATARAMResult);
    DDX_Text(pDX, IDC_STATIC_SPOONRAM, m_SPOONRAMResult);
    DDX_Text(pDX, IDC_STATIC_EMULATIONRAM, m_EMULATIONRAMResult);
    DDX_Text(pDX, IDC_STATIC_TRACERAM, m_TRACERAMResult);
    DDX_Text(pDX, IDC_STATIC_ALL, m_AllResult);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDiagnosticBox, CDialog)
    //{{AFX_MSG_MAP(CDiagnosticBox)
    ON_BN_CLICKED(ID_BUTTON_DIAGNOSTIC, OnButtonDiagnostic)
    ON_BN_CLICKED(IDC_CHECK_ALL, OnCheckAll)
    ON_BN_CLICKED(IDC_CHECK_PIOCTC, OnCheckPioctc)
    ON_BN_CLICKED(IDC_CHECK_EVENTADDRRAM, OnCheckEventaddrram)
    ON_BN_CLICKED(IDC_CHECK_EVENTDATARAM, OnCheckEventdataram)
    ON_BN_CLICKED(IDC_CHECK_MAPRAM, OnCheckMapram)
    ON_BN_CLICKED(IDC_CHECK_SPOONRAM, OnCheckSpoonram)
    ON_BN_CLICKED(IDC_CHECK_TRACERAM, OnCheckTraceram)
    ON_BN_CLICKED(IDC_EMULATIONRAM, OnEmulationram)
    ON_WM_TIMER()
    ON_WM_SIZE()
    ON_BN_CLICKED(ID_BUTTON_DETAIL, OnButtonDetail)
    ON_WM_CTLCOLOR()
    ON_WM_DESTROY()
    ON_WM_PAINT()
    ON_BN_CLICKED(IDC_BUTTON_LOCATE, OnButtonLocate)
	ON_BN_CLICKED(IDC_BUTTON_DETAIL2, OnButtonDetail2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CDiagnosticBox message handlers

void CDiagnosticBox::OnButtonDiagnostic()
{                                                            

    // TODO: Add your control notification handler code here 
    //CHECK IF EP-SLD/52/F  IS RUNNING
    if (isFirstTime) {
        EnumWindows(EnumWndProcx,NULL);
        if(isEpSldRunning) {                    
            isEpSldRunning = FALSE;
            int nTmp = MessageBox("             Ep is running!\nDo You Really want to go on with it?","",
                                      MB_YESNO|MB_ICONSTOP);
            if (IDNO == nTmp)   return ;
                else isFirstTime = FALSE;
        }
    }       
    
    int i;
    STATUS retAbi;
    BYTE bLen;
    BYTE pBuff[0x40];
   
   if(g_bEnhanced) {
		for(i=0; i<3; i++)
		{
			retAbi=AbiGetUesData(i, bLen, pBuff);
			if(retAbi)
			{
				AfxMessageBox("This utility is reserved");
				return;
			}
			if(!pBuff[2])
			{
				if(i==0)
					AfxMessageBox("Please download work jed file to ispLSI1016-80LJ U23!");
				else if(i==1)
					AfxMessageBox("Please download work jed file to ispLSI1032E-80LJ U70!");
				else if(i==2)
					AfxMessageBox("Please download work jed file to ispLSI1032E-80LJ U43!");
				else
					ASSERT(0);
				return;
			}
		}
	 }
    
    UpdateData(TRUE);  
    m_POIResult = "";
    m_MAPRAMResult = "";
    m_EVENTADDRResult = "";
    m_EVENTDATARAMResult = "";
    m_SPOONRAMResult = "";
    m_EMULATIONRAMResult = "";
    m_TRACERAMResult = "";  
    m_AllResult = "";
    UpdateData(FALSE); 
    
    m_bPOIResult = 0;
    m_bMAPRAMResult = 0;
    m_bEVENTADDRResult = 0;
    m_bEVENTDATARAMResult = 0;
    m_bSPOONRAMResult = 0;
    m_bEMULATIONRAMResult = 0;
    m_bTRACERAMResult = 0; 
    
    //caculate the total time needed to run this diagnosis
    wTimerCounter[0] = 0;          
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckPIOCTC.GetCheck()) {              
        wTimerCounter[0]+=wTimerCounter[1];
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckMapRam.GetCheck()) {                             
        wTimerCounter[0]+=wTimerCounter[2];     
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventAddrRam.GetCheck()) {                            
        wTimerCounter[0]+=wTimerCounter[3];
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventDataRam.GetCheck()) {                   
        wTimerCounter[0]+=wTimerCounter[4];
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckSpoonRam.GetCheck()) {                       
        wTimerCounter[0]+=wTimerCounter[5];
    }    
    
    if(m_buttonCheckAll.GetCheck() || m_buttonEmulationRam.GetCheck()) {                              
        wTimerCounter[0]+=wTimerCounter[6];
    }    
    
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckTraceRam.GetCheck()) {                          
        wTimerCounter[0]+=wTimerCounter[7];
    }   
    
    //show the meter 
    SetMeter();   
    
    BYTE bTmp=0;
    unsigned char bResult; 
    STATUS tmp;
    
    
    //if isOldFw
    if(isOldFw) {     
        wTimerCounter[0] -=3;
                        
        tmp = AbiDiagnostic(0,bResult);
        if(tmp == ICE_OK && bResult == 0) m_AllResult = "OK";
            else m_AllResult = "FAIL";     
        if(isStop) {
            m_AllResult = "";
            UpdateData(FALSE);  
            DecideDetailButtonStatus();
            DeleteMeter();
            return;
        } else {
            if((bResult&0x01) == 0x01) m_POIResult = "FALSE"; 
            else m_POIResult = "OK";
            if((bResult&0x02) == 0x02) m_MAPRAMResult = "FALSE"; 
            else m_MAPRAMResult = "OK";
            if((bResult&0x04) == 0x04) m_EVENTADDRResult = "FALSE"; 
            else m_EVENTADDRResult = "OK";
            if((bResult&0x08) == 0x08) m_EVENTDATARAMResult = "FALSE"; 
            else m_EVENTDATARAMResult = "OK";
            if((bResult&0x10) == 0x10) m_SPOONRAMResult = "FALSE"; 
            else m_SPOONRAMResult = "OK";
            if((bResult&0x20) == 0x20) m_EMULATIONRAMResult = "FALSE"; 
            else m_EMULATIONRAMResult = "OK";
            if((bResult&0x40) == 0x40) m_TRACERAMResult = "FALSE"; 
            else m_TRACERAMResult = "OK";
            
        }      
        UpdateData(FALSE);  
        m_Meter.SetPartsComplete(100);
        DecideDetailButtonStatus();
        DeleteMeter();
        return;
    } else m_AllResult = "";    
                                    
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckPIOCTC.GetCheck()) {              
        //BeginWaitCursor();      
        tmp = AbiDiagnostic(1,m_nErrPIO);
        if(m_nErrPIO == 0 && tmp == ICE_OK) m_POIResult = "OK";
            else m_POIResult = "FAIL";  
        m_bPOIResult = m_nErrPIO;
        m_nPOIResultAddr = retAddr.addr;
        if(isStop) m_POIResult = "";
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[1])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[1];    
        m_Meter.SetPartsComplete(bTmp);
        //EndWaitCursor();    
    } else m_POIResult = "";  
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();        
        return;
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckMapRam.GetCheck()) {                             
        //BeginWaitCursor();
        if(AbiDiagnostic(2,bResult) == ICE_OK && bResult == 0) m_MAPRAMResult = "OK";
            else m_MAPRAMResult = "FAIL";     
        m_bMAPRAMResult = bResult;         
        m_nMAPRAMResultAddr = retAddr.addr;
        
        if(isStop) m_MAPRAMResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[2])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[2];    
        m_Meter.SetPartsComplete(bTmp);    
        //EndWaitCursor();    
    } else m_MAPRAMResult = "";   
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();    
        return;
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventAddrRam.GetCheck()) {                            
        //BeginWaitCursor();
        if(AbiDiagnostic(3,bResult) == ICE_OK && bResult == 0) m_EVENTADDRResult = "OK";
            else m_EVENTADDRResult = "FAIL";  
        m_bEVENTADDRResult = bResult;    
        m_nEVENTADDRResultAddr = retAddr.addr;
        
        if(isStop) m_EVENTADDRResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[3])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[3];    
        m_Meter.SetPartsComplete(bTmp);    
        //EndWaitCursor();    
    } else m_EVENTADDRResult = "";
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();
        return;
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckEventDataRam.GetCheck()) {                   
        //BeginWaitCursor();
        if(AbiDiagnostic(4,bResult) == ICE_OK && bResult == 0) m_EVENTDATARAMResult = "OK";
            else m_EVENTDATARAMResult = "FAIL";
        m_bEVENTDATARAMResult = bResult;   
        m_nEVENTDATARAMResultAddr = retAddr.addr;
        
        if(isStop) m_EVENTDATARAMResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[4])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[4];    
        m_Meter.SetPartsComplete(bTmp);        
        //EndWaitCursor();    
    } else m_EVENTDATARAMResult = "";      
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();
        return;
    }    
      
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckSpoonRam.GetCheck()) {                       
        //BeginWaitCursor();
        if(AbiDiagnostic(5,bResult) == ICE_OK && bResult == 0) m_SPOONRAMResult = "OK";
            else m_SPOONRAMResult = "FAIL";        
        m_bSPOONRAMResult = bResult;          
        m_nSPOONRAMResultAddr = retAddr.addr;
        if(isStop) m_SPOONRAMResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[5])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[5];    
        m_Meter.SetPartsComplete(bTmp);        
        //EndWaitCursor();    
    } else m_SPOONRAMResult = ""; 
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();
        return;
    }    
    
    if(m_buttonCheckAll.GetCheck() || m_buttonEmulationRam.GetCheck()) {                              
        //BeginWaitCursor();
        if(AbiDiagnostic(6,bResult) == ICE_OK && bResult == 0) m_EMULATIONRAMResult = "OK";
            else m_EMULATIONRAMResult = "FAIL";    
        m_bEMULATIONRAMResult = bResult;     
        m_nEMULATIONRAMResultAddr = retAddr.addr;
        if(isStop) m_EMULATIONRAMResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[6])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[6];    
        m_Meter.SetPartsComplete(bTmp);        
        //EndWaitCursor();    
    } else m_EMULATIONRAMResult = "";
    UpdateData(FALSE);  
    if(TestKey(VK_ESCAPE)) { 
        DecideDetailButtonStatus();
        DeleteMeter();
        return;
    }    
    
    if(m_buttonCheckAll.GetCheck() || m_buttonCheckTraceRam.GetCheck()) {                          
        //BeginWaitCursor();
        tmp = AbiDiagnostic(7,m_nErrTrace);
        if( m_nErrTrace ==0 && tmp == ICE_OK) m_TRACERAMResult = "OK";
            else m_TRACERAMResult = "FAIL";        
        m_bTRACERAMResult = m_nErrTrace;         
        m_nTRACERAMResultAddr = retAddr.addr;
        if(isStop) m_TRACERAMResult = "";    
        bTmp = ((double)(m_bCurrentStep + wTimerCounter[7])*100)/((double)wTimerCounter[0]);
        m_bCurrentStep = m_bCurrentStep + wTimerCounter[7];    
        m_Meter.SetPartsComplete(bTmp);        
        //EndWaitCursor();    
    } else m_TRACERAMResult = "";  
    UpdateData(FALSE);  
                     
    DeleteMeter();
    DecideDetailButtonStatus();
    
}



void CDiagnosticBox::OnCheckAll()
{
    // TODO: Add your control notification handler code here
    //if the fw version is old
    if(isOldFw) {
        DecideDiagnosticButtonStatus();
        return;                        
    }
    
    if(m_buttonCheckAll.GetCheck()) {
        m_buttonCheckPIOCTC.EnableWindow(FALSE);
        m_buttonCheckMapRam.EnableWindow(FALSE);
        m_buttonCheckEventAddrRam.EnableWindow(FALSE);
        m_buttonCheckEventDataRam.EnableWindow(FALSE);
        m_buttonCheckSpoonRam.EnableWindow(FALSE);
        m_buttonEmulationRam.EnableWindow(FALSE);
        m_buttonCheckTraceRam.EnableWindow(FALSE);
    } else { 
        m_buttonCheckPIOCTC.EnableWindow(TRUE);
        m_buttonCheckMapRam.EnableWindow(TRUE);
        m_buttonCheckEventAddrRam.EnableWindow(TRUE);
        m_buttonCheckEventDataRam.EnableWindow(TRUE);
        m_buttonCheckSpoonRam.EnableWindow(TRUE);
        m_buttonEmulationRam.EnableWindow(TRUE);
        m_buttonCheckTraceRam.EnableWindow(TRUE);
    }                            
        
    DecideDiagnosticButtonStatus();
}

void CDiagnosticBox::OnCheckPioctc()
{
    // TODO: Add your control notification handler code here 
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckEventaddrram()
{
    // TODO: Add your control notification handler code here  
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckEventdataram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
                      
}

void CDiagnosticBox::OnCheckMapram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckSpoonram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnCheckTraceram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}

void CDiagnosticBox::OnEmulationram()
{
    // TODO: Add your control notification handler code here
    DecideDiagnosticButtonStatus();
    
}


BOOL CDiagnosticBox::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here   
    m_br.CreateSolidBrush(PALETTEINDEX(COLOR_RED));
    CenterWindow();                       
    //added by dragon
    //for checking fw version
    if(g_bEnhanced) GetDlgItem(IDC_BUTTON_DETAIL2)->EnableWindow(TRUE);
    else GetDlgItem(IDC_BUTTON_DETAIL2)->EnableWindow(FALSE);
    m_buttonDetail.EnableWindow(FALSE);
    m_buttonCheckAll.SetCheck(1);                 
    m_buttonDiagnostic.EnableWindow(TRUE);
    m_buttonCheckPIOCTC.EnableWindow(FALSE);
    m_buttonCheckMapRam.EnableWindow(FALSE);
    m_buttonCheckEventAddrRam.EnableWindow(FALSE);
    m_buttonCheckEventDataRam.EnableWindow(FALSE);
    m_buttonCheckSpoonRam.EnableWindow(FALSE);
    m_buttonEmulationRam.EnableWindow(FALSE);
    m_buttonCheckTraceRam.EnableWindow(FALSE);
    
    m_nTimerID =SetTimer(1,200,NULL);
    if ( m_nTimerID == 0 ) {
        return FALSE;
    }                            
    
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDiagnosticBox::DecideDiagnosticButtonStatus()
{      
      BOOL bResult = FALSE;
      if(m_buttonCheckAll.GetCheck()) bResult = TRUE;
      if(m_buttonCheckPIOCTC.GetCheck()) bResult = TRUE;
      if(m_buttonCheckMapRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckEventAddrRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckEventDataRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckSpoonRam.GetCheck()) bResult = TRUE;
      if(m_buttonEmulationRam.GetCheck()) bResult = TRUE;
      if(m_buttonCheckTraceRam.GetCheck()) bResult = TRUE;
      
      m_buttonDiagnostic.EnableWindow(bResult);
 }

void CDiagnosticBox::DecideDetailButtonStatus()
{ 
      BOOL bResult = FALSE;                      
      
      if(m_MAPRAMResult == "FAIL") bResult = TRUE;
      if(m_EVENTADDRResult == "FAIL") bResult = TRUE;
      if(m_EVENTDATARAMResult == "FAIL") bResult = TRUE;
      if(m_SPOONRAMResult == "FAIL") bResult = TRUE;
      if(m_EMULATIONRAMResult == "FAIL") bResult = TRUE;
      if(m_TRACERAMResult == "FAIL") bResult = TRUE;
      if(m_POIResult == "FAIL") bResult = TRUE;
      
      m_buttonDetail.EnableWindow(bResult);
      if(g_bEnhanced)
      m_buttonFunction.EnableWindow(TRUE);
 } 
 
extern int nCommPort;
void CDiagnosticBox::OnTimer(UINT nIDEvent)
{
    // TODO: Add your message handler code here and/or call default
    
    if ( m_nTimerID != nIDEvent) {
        CDialog::OnTimer(nIDEvent);
        return;
    }
    
    if (!m_isCanTime) return;
    BYTE bTmp;                                     
	bTmp = ((double)(m_bCurrentStep+GetStep())*100)/((double)wTimerCounter[0]);
    
    m_Meter.SetPartsComplete(bTmp);        
    
}

void CDiagnosticBox::SetMeter()
{                                            
    //DISABLE CHECK BUTTON
    m_buttonCheckAll.EnableWindow(FALSE);
    m_buttonCheckPIOCTC.EnableWindow(FALSE);
    m_buttonCheckMapRam.EnableWindow(FALSE);
    m_buttonCheckEventAddrRam.EnableWindow(FALSE);
    m_buttonCheckEventDataRam.EnableWindow(FALSE);
    m_buttonCheckSpoonRam.EnableWindow(FALSE);
    m_buttonEmulationRam.EnableWindow(FALSE);
    m_buttonCheckTraceRam.EnableWindow(FALSE);
    m_buttonFunction.EnableWindow(FALSE);
    
             
    //decide the rect of meter
    CRect rect1,rect2;
    m_buttonDiagnostic.GetWindowRect(rect1);
    m_buttonDetail.GetWindowRect(rect2);
    
    rect1.right = rect2.right;
    ScreenToClient(rect1);
    //delete button to make space for meter
    m_buttonDetail.ShowWindow(SW_HIDE);
    m_buttonDiagnostic.ShowWindow(SW_HIDE);
    m_buttonQuit.SetWindowText("&Stop");
    
    m_Meter.Create(WS_VISIBLE|WS_CHILD|WS_BORDER, rect1,
        this, IDC_METER);       
        
    m_Meter.SetPartsInJob(100);
    m_Meter.SetPartsComplete(0);    
    
    m_isCanTime = TRUE;
    m_bCurrentStep = 0;              
    isStop = FALSE;     
    
    m_buttonQuit.SetFocus();
 }                              
 
void CDiagnosticBox::DeleteMeter()
{   
    m_isCanTime = FALSE;
    isStop = FALSE;
    ((CWinSerialPICAgreeSetup*)((CDiagnoApp*)AfxGetApp())->m_pTheCom)->m_isStop = FALSE;                                    
    
    m_Meter.SetPartsComplete(100);        
    m_Meter.DestroyWindow();
    m_buttonDetail.ShowWindow(SW_SHOW);
    m_buttonDiagnostic.ShowWindow(SW_SHOW);
    m_buttonQuit.SetWindowText("&Quit");
    
    //ENABLE CHECK BUTTON
    m_buttonCheckAll.EnableWindow(TRUE); 
    if (m_buttonCheckAll.GetCheck()) m_buttonCheckAll.EnableWindow(TRUE); 
     else {
        m_buttonCheckPIOCTC.EnableWindow(TRUE);
        m_buttonCheckMapRam.EnableWindow(TRUE);
        m_buttonCheckEventAddrRam.EnableWindow(TRUE);
        m_buttonCheckEventDataRam.EnableWindow(TRUE);
        m_buttonCheckSpoonRam.EnableWindow(TRUE);
        m_buttonEmulationRam.EnableWindow(TRUE);
        m_buttonCheckTraceRam.EnableWindow(TRUE);
        
    }
    
    m_buttonQuit.SetFocus();
    ADDR tmpAddr;
    tmpAddr.addrType = 0x10;
    
    if(isCanHWReset) AbiReset(tmpAddr);
     
 }

extern void TestMessage(void);
void CDiagnosticBox::OnCancel()
{
    // TODO: Add extra cleanup here
    if(m_isCanTime) {    
        //ask user to confirm the action   
        //CWaningDialog * tmpDialog;
        //tmpDialog = new CWaningDialog;
        //tmpDialog->Create(1);     //IDD_DIALOG_WARNING7
        
        if ( MessageBox("        Do you really want to stop it?\nNotes:You must push reset button on EasyPack \n      after your stopping.","",MB_OKCANCEL|MB_ICONSTOP)
             == IDCANCEL ) return;                                                                                       
        //while (0 == tmpDialog->nResult)   WaitMessage();//TestMessage();
        
        //delete tmpDialog;
        
        isStop = TRUE;
        ((CWinSerialPICAgreeSetup*)((CDiagnoApp*)AfxGetApp())->m_pTheCom)->m_isStop = TRUE;
        return;
    }   
    
    CDialog::OnCancel();
}



void CDiagnosticBox::OnSize(UINT nType, int cx, int cy)
{
    CDialog::OnSize(nType, cx, cy);
    
    // TODO: Add your message handler code here
    /*if ( nType == SIZE_MINIMIZED ) return;
    
    CRect rect(20, 200, 130, 215);
    m_Meter.MoveWindow(rect);*/
    
}

//define for show error information
enum {
    D_E_HEAD = 0,
    D_E_PIOCTC = 1,
    D_E_MAP = 5,
    D_E_EVA = 6,
    D_E_EVD = 7,
    D_E_SPOON = 8,
    D_E_EMU = 9,
    D_E_TRC = 10
};

char * strErr[] = {
    "      Diagnosis Error Information",
    "Error IN : port A&B&C.\r\n",
    "Error IN : port A.\r\n",
    "Error IN : port B.\r\n",
    "Error IN : port C.\r\n",
    "Error IN : Map ram.\r\n",
    "Error IN : Event address ram.\r\n",
    "Error IN : Event data ram.\r\n",       
    "Error IN : Spoon ram.\r\n",        
    "Error IN : Emulation ram.\r\n",
    "Error IN : Trace count low & high ram.\r\n",
    "Error IN : Trace count low ram.\r\n",
    "Error IN : Trace count high ram.\r\n",
    "Error IN : Trace address high ram.\r\n",
    "Error IN : Trace address low ram.\r\n",
    "Error IN : Trace data ram.\r\n",
    "Error IN : Trace status ram.\r\n",
    "Error IN : Trace spare ram.\r\n",
    "Error IN : Trace port ram.\r\n"
};  

void CDiagnosticBox::OnButtonDetail()
{
	// TODO: Add your control notification handler code here
    CDiagnResultBox *diagnResultBox = new CDiagnResultBox;
      CString strTmp=""; 
      char  strTmp2[100];
          
      strTmp = strErr[D_E_HEAD];
      diagnResultBox->m_ShowInfo = strTmp + "\r\n\r\n";
      
      
      if(m_POIResult == "FAIL") {
          if((m_nErrPIO&0x07) == 0x07) strTmp = strErr[D_E_PIOCTC];
          else {
            strTmp = "";
            if((m_nErrPIO&0x01) == 0x01) strTmp += strErr[D_E_PIOCTC+1];
            if((m_nErrPIO&0x02) == 0x02) strTmp += strErr[D_E_PIOCTC+2];            
            if((m_nErrPIO&0x04) == 0x04) strTmp += strErr[D_E_PIOCTC+3];
          }
          if((m_bPOIResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nPOIResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_MAPRAMResult == "FAIL") {
          strTmp = strErr[D_E_MAP];       
          if((m_bMAPRAMResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nMAPRAMResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_EVENTADDRResult == "FAIL") {
          strTmp = strErr[D_E_EVA];       
          if((m_bEVENTADDRResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nEVENTADDRResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_EVENTDATARAMResult == "FAIL") {
          strTmp = strErr[D_E_EVD];       
          if((m_bEVENTDATARAMResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nEVENTDATARAMResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_SPOONRAMResult == "FAIL") {
          strTmp = strErr[D_E_SPOON];     
          if((m_bSPOONRAMResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nSPOONRAMResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_EMULATIONRAMResult == "FAIL") {
          strTmp = strErr[D_E_EMU];       
          if((m_bEMULATIONRAMResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nEMULATIONRAMResultAddr);      
          strTmp = strTmp + strTmp2;
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      }
      if(m_TRACERAMResult == "FAIL") {    
          if((m_nErrTrace&0x03) == 0x03) strTmp = strErr[D_E_TRC];
          else {                           
              strTmp = "";
              if((m_nErrTrace&0x01) == 0x01) strTmp += strErr[D_E_TRC+1];                       
              if((m_nErrTrace&0x02) == 0x02) strTmp += strErr[D_E_TRC+2];                                   
          }
          if((m_nErrTrace&0x04) == 0x04) strTmp += strErr[D_E_TRC+3];
          if((m_nErrTrace&0x08) == 0x08) strTmp += strErr[D_E_TRC+4];
          if((m_nErrTrace&0x10) == 0x10) strTmp += strErr[D_E_TRC+5];
          if((m_nErrTrace&0x20) == 0x20) strTmp += strErr[D_E_TRC+6];
          if((m_nErrTrace&0x40) == 0x40) strTmp += strErr[D_E_TRC+7];
          if((m_bTRACERAMResult&0x80)==0x80) 
                sprintf(strTmp2,"Error Address : %04x\r\n",m_nTRACERAMResultAddr);      
          strTmp = strTmp + strTmp2;
          
          diagnResultBox->m_ShowInfo = diagnResultBox->m_ShowInfo + strTmp;    
      } 
      
      diagnResultBox->DoModal();                            
      delete diagnResultBox;    
    
}

HBRUSH CDiagnosticBox::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
    // TODO: Add your message handler code here and/or call default
    if(nCtlColor == CTLCOLOR_METER) {
        pDC->SetTextColor(PALETTEINDEX(COLOR_LTRED/*COLOR_LTBLUE*/));   
        //pDC->SetBkColor(PALETTEINDEX(COLOR_RED)); 
        return (HBRUSH)(m_br.m_hObject);
    } else return CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
    
}

void CDiagnosticBox::OnDestroy()
{
    CDialog::OnDestroy();
    
    m_br.DeleteObject();
    // TODO: Add your message handler code here
    
}

void CDiagnosticBox::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here
    CRect rect1;   
    m_Button_Locate.GetWindowRect(rect1);
    ScreenToClient(rect1);

/*  
    HFONT hFont = (HFONT)::GetStockObject(ANSI_FIXED_FONT);
    CFont font;
    this->SetFont(font.FromHandle(hFont));
*/
    LOGFONT logFont;
    _fmemset(&logFont,0,sizeof(LOGFONT));
    logFont.lfHeight=18;
    logFont.lfWeight=800;
    lstrcpy(logFont.lfFaceName, "Arial");
    CFont font;
    font.CreateFontIndirect(&logFont);                                
    
    dc.SelectObject(&font);
    
    dc.SetBkMode(TRANSPARENT);
    dc.SetTextColor(RGB(255,0,0));  
    CString tmpStr;
    tmpStr = "Warning: Diagnostics will change the original system settings.";
    tmpStr += "\nSo once executed, please reset the EasyPack to ensure the system running normally.";
    dc.DrawText(tmpStr,tmpStr.GetLength(),rect1,DT_WORDBREAK);
    
                                               
    // Do not call CDialog::OnPaint() for painting messages
}

void CDiagnosticBox::OnButtonLocate()
{
    // TODO: Add your control notification handler code here
    //notes this button has no use only for locating the station
    //of warning message
}

extern STATUS AbiDetailDgnst(char& bByte1,char& bByte2,char& bByte3,char& bByte4);

//change by chris, add enhance diagnost function:
//first check if jed file of diagnost status be download, then call abi
void CDiagnosticBox::OnButtonDetail2()
{
	// TODO: Add your control notification handler code here    
BYTE i, bLen, result1, result2;
BYTE pBuff[0x40];
STATUS retAbi;
int	 retJed;

	retJed=jedLoad("du23.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=1)
	{
		AfxMessageBox("du23.jed is not a diagnostics file");
		return;
	}
	
	retJed=jedLoad("du43.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=1)
	{
		AfxMessageBox("du43.jed is not a diagnostics file");
		return;
	}
	
	retJed=jedLoad("du70.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=1)
	{
		AfxMessageBox("du70.jed is not a diagnostics file");
		return;
	}
	
	retJed=jedLoad("wu23.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=2)
	{
		AfxMessageBox("wu23.jed is not a work file");
		return;
	}
	
	retJed=jedLoad("wu43.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=2)
	{
		AfxMessageBox("wu43.jed is not a work file");
		return;
	}
	
	retJed=jedLoad("wu70.jed", 1);
	if(retJed==0)
		return;
	if(retJed!=2)
	{
		AfxMessageBox("wu70.jed is not a work file");
		return;
	}
	
	CWaitDlg	waitdlg;
	if(waitdlg.Create(this, "Download du23.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("du23.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	if(waitdlg.Create(this, "Download du43.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("du43.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	if(waitdlg.Create(this, "Download du70.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("du70.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	if(waitdlg.Create(this, "Waiting while diagnostics in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retAbi=AbiDiagnostic2(result1, result2);
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}
	if(retAbi)
	{
		AfxMessageBox("Diagnostic Abi return Error");
		return;
	}
	if(result1==0&&result2==0)
		wsprintf((char*)pBuff, "Test OK!");
	else	
		//wsprintf((char*)pBuff, "result is %d and %d", result1, result2);
		wsprintf((char*)pBuff, "Errcode is %d, please refer to \"Errcode.doc\" which is in your EPSLD directory.", result1);
	AfxMessageBox((char*)pBuff);

	if(waitdlg.Create(this, "Restore wu23.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("wu23.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	if(waitdlg.Create(this, "Restore wu43.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("wu43.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	if(waitdlg.Create(this, "Restore wu70.jed in process..."))
	{
		waitdlg.ShowWindow(SW_SHOW);
		waitdlg.UpdateWindow();
	}
	retJed=jedLoad("wu70.jed", 0);
	if(retJed==0)
		return;
	if(waitdlg.m_hWnd)
	{
		waitdlg.DestroyWindow();
		UpdateWindow();
	}

	return;
		
//mark by chris, 2/25/97
/*
	CDetailDlgx* pTmpDlg = new CDetailDlgx;
	if (NULL == pTmpDlg) {
		//AfxMessageBox("Not Enough Memery!");
		return;
	}
	     
	char b1,b2,b3,b4;     
    BeginWaitCursor();      
	if (ICE_OK != AbiDetailDgnst(b1,b2,b3,b4)) {
		MessageBox("FW Error!","",MB_ICONSTOP);
		EndWaitCursor();      
		return;
	}                         
	EndWaitCursor();      
	
	CDC* tmpCDC; 
	//byte one
	if ((b1&0x01) == 0x01)
		pTmpDlg->m_b10 = "TVCC LOW";
	else			
	    pTmpDlg->m_b10 = "TVCC HIGH";
	    
	if ((b1&0x02) == 0x02) {
	    pTmpDlg->m_b11 = "EP_ID ERROR";
	}	
	else			
	    pTmpDlg->m_b11 = "EP_ID OK";    
	    
	if ((b1&0x04) == 0x04) {
		pTmpDlg->m_b12 = "NRSTEP/NIDLEPD LOW";
	}	
	else			
	    pTmpDlg->m_b12 = "NRSTEP/NIDLEPD OK";        
	
	if ((b1&0x08) == 0x08) {
		pTmpDlg->m_b13 = "CANEND ERROR";
	}	
	else			
	    pTmpDlg->m_b13 = "CANEND OK";            
	    
	if ((b1&0x010) == 0x010) {
		pTmpDlg->m_b14 = "ENDSP ERROR";
	}	
	else			
	    pTmpDlg->m_b14 = "ENDSP OK";                
	    
	if ((b1&0x020) == 0x020) {
		pTmpDlg->m_b15 = "NCPURUN ERROR";
	}	
	else			
	    pTmpDlg->m_b15 = "NCPURUN OK";                    
	    
	if ((b1&0x040) == 0x040) {
		pTmpDlg->m_b16 = "CANRUN ERROR";
	}	
	else			
	    pTmpDlg->m_b16 = "CANRUN OK";                        
	    
	if ((b1&0x080) == 0x080) {
		pTmpDlg->m_b17 = "GET REG ERROR";
	}	
	else			
	    pTmpDlg->m_b17 = "GET REG OK";                            
	
	//byte two
	if ((b2&0x01) == 0x01) {
		pTmpDlg->m_b20 = "TEST XDATA ERROR";
	}	
	else			
	    pTmpDlg->m_b20 = "TEST XDATA OK";
	    
	if ((b2&0x02) == 0x02) {
		pTmpDlg->m_b21 = "HALT ERROR";
	}	
	else			
	    pTmpDlg->m_b21 = "HALT OK";    
	    
	if ((b2&0x04) == 0x04) {
		pTmpDlg->m_b22 = "TEST PDATA ERROR";
	}	
	else			
	    pTmpDlg->m_b22 = "TEST PDATA OK";        
	
	if ((b2&0x08) == 0x08) {
		pTmpDlg->m_b23 = "FILL ERROR";
	}	
	else			
	    pTmpDlg->m_b23 = "FILL OK";            
	    
	if ((b2&0x010) == 0x010) {
		pTmpDlg->m_b24 = "BREAKPOINT ERROR";
	}	
	else			
	    pTmpDlg->m_b24 = "BREAKPOINT OK";                
	    
	if ((b2&0x020) == 0x020) {
        pTmpDlg->m_b25 = "TRACE FRAME ERROR";
    }    
	else			
        pTmpDlg->m_b25 = "TRACE FRAME OK";
	    
	if ((b2&0x040) == 0x040) {
		pTmpDlg->m_b26 = "TRACE ERROR";
	}	
	else			
	    pTmpDlg->m_b26 = "TRACE OK";                        
	    
	if ((b2&0x080) == 0x080) {
		pTmpDlg->m_b27 = "QUAlIFY ERROR";
	}	
	else			
	    pTmpDlg->m_b27 = "QUALIFY OK";                                
	
	
	//byte three
	if ((b3&0x01) == 0x01) {
		pTmpDlg->m_b30 = "TIMER ERROR";
	}	
	else			
	    pTmpDlg->m_b30 = "TIMER OK";
	    
	if ((b3&0x02) == 0x02) {
		pTmpDlg->m_b31 = "EVENT SET ERROR";
	}	
	else			
	    pTmpDlg->m_b31 = "EVENT SET OK";    
	    
	if ((b3&0x04) == 0x04) {
		pTmpDlg->m_b32 = "EVENT BREAK ERROR";
	}	
	else			
	    pTmpDlg->m_b32 = "EVENT BREAK OK";        
	
	if ((b3&0x08) == 0x08) {
		pTmpDlg->m_b33 = "STEP ERROR";
	}	
	else			
	    pTmpDlg->m_b33 = "STEP OK";            
	    
	if ((b3&0x010) == 0x010) {
		pTmpDlg->m_b34 = "STATUS 'AK' ERROR";
	}	
	else			
	    pTmpDlg->m_b34 = "STATUS 'AK' OK";                
	    
	if ((b3&0x020) == 0x020) {
		pTmpDlg->m_b35 = "ERROR";
	}	
	else			
	    pTmpDlg->m_b35 = "";                    
	    
	if ((b3&0x040) == 0x040) {
		pTmpDlg->m_b36 = "ERROR";
	}	
	else			
	    pTmpDlg->m_b36 = "";                        
	    
	if ((b3&0x080) == 0x080) {
		pTmpDlg->m_b37 = "ERROR";
	}	
	else			
	    pTmpDlg->m_b37 = ""; 
	
	//byte four
	sprintf((pTmpDlg->m_showValue).GetBuffer(20),"%02X",b4);
	(pTmpDlg->m_showValue).ReleaseBuffer();                                       
	pTmpDlg->DoModal();
	    
	delete pTmpDlg;	
*/	
}

/////////////////////////////////////////////////////////////////////////////
// CWaitDlg dialog

CWaitDlg::CWaitDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWaitDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWaitDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CWaitDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWaitDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BOOL CWaitDlg::Create(CWnd* pParent, CString waitMsg)
{
	//{{AFX_DATA_INIT(CSplashWnd)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	if (!CDialog::Create(CWaitDlg::IDD, pParent))
		return FALSE;
	if(!waitMsg.IsEmpty())
		SetDlgItemText(IDC_WAITMSG, waitMsg);
	return TRUE;
}

BEGIN_MESSAGE_MAP(CWaitDlg, CDialog)
	//{{AFX_MSG_MAP(CWaitDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWaitDlg message handlers

BOOL CWaitDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	CenterWindow();
	return TRUE;  // return TRUE  unless you set the focus to a control
}
