/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/DOPT.CPP   1.2.1.5   17 Apr 1997 15:48:16   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DOPT.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:48:16   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:19:30   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:30:54   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:11:50   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:16:52   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:28:00   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:45:52   ZJRD
** Initial revision.
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:17:58   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 13:01:12   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:22:56   ZJRD
** No change.
** 
**    Rev 1.4.1.3   05 Sep 1996 11:34:24   ZJRD
** No change.
** 
**    Rev 1.4.1.2   02 Sep 1996 10:01:26   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.4.1.0   12 Aug 1996 10:50:18   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.1   29 May 1996 09:35:46   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// dopt.cpp
//
// Michael Long
//                                                                           
// 5/16/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "afx.h"
#include "toolopt.h"    
#include "dc.h"
#include "dcoption.h"
#include "da.h"
#include "daoption.h"
#include "dl.h"
#include "dloption.h"
#include "dlib.h"
#include "dlibopti.h"
#include "de.h"
#include "deoption.h"
#include "dtab.h"
#include "projopt.h"
#include "dopt.h" 
#include "direct.h"  

/////////////////////////////////////////////////////////////////////////////
// operations
void DOption::SetOption(CWnd *pParent)
{
    CDTab dlg(&m_dcTool, &m_daTool, &m_dlTool,&m_dlibTool,&m_deTool, pParent);
    dlg.DoModal();
}

BOOL DOption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_dcTool.SaveOption(fp))
        return FALSE;
    if(!m_daTool.SaveOption(fp))
        return FALSE;
    if(!m_dlTool.SaveOption(fp))
        return FALSE;
    if(!m_dlibTool.SaveOption(fp))
        return FALSE;
    if(!m_deTool.SaveOption(fp))
        return FALSE;
  /* if((_stricmp(m_deTool.m_strPath," ")!=0)&&(_stricmp(m_deTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;*/      
        
    return TRUE;
}
                
BOOL DOption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_dcTool.LoadOption(fp))
        return FALSE;
    if(!m_daTool.LoadOption(fp))
        return FALSE;
    if(!m_dlTool.LoadOption(fp))
        return FALSE;
    if(!m_dlibTool.LoadOption(fp))
        return FALSE;
    if(!m_deTool.LoadOption(fp))
        return FALSE;
  /*   if((_stricmp(m_deTool.m_strPath," ")!=0)&&(_stricmp(m_deTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;*/     
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int DOption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".asm") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL DOption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;
    CString str, str1, str2;
    FILE * fp;
    int i, flag, bFlag=0;
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
    char path[_MAX_PATH];

    
    fp = fopen(GetName(lpcszProj, ".cmd"), "wt");
    if(!fp)
        goto CMDFAIL;
             
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i ++) {
        str2 = lst.GetNext(pos);
        
        flag = GetFileType(str2);
        if(flag != 2)       
         {  
            if(flag == 0) bFlag = 1;
            str1 = "";
            str  = GetName(str2, ".obj");
            _splitpath(str, drive, dir, fname, ext); 
            _makepath (path, NULL, NULL, fname, ext);
            str1 += path;
         }
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(i < lst.GetCount() - 1) {
            if(fputc(',', fp) == EOF)          
                goto CMDFAIL;
        } else {
            if(fputc(' ', fp) == EOF)          
                goto CMDFAIL;
        }
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
    
    if(bFlag){
	    str1 = ",";
	    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
	        goto CMDFAIL;
	    else 
	        str1.ReleaseBuffer();
	        
	    if(fputc('\n', fp) == EOF)          
	        goto CMDFAIL;
	        
	    str1 = m_dlibTool.GetOption();
	
	    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
	        goto CMDFAIL;
	    else
	        str1.ReleaseBuffer();
	
	    if(fputc('\n', fp) == EOF)          
	        goto CMDFAIL;
    }
                      
    str1 = "to ";
    str1 += GetName(lpcszProj, ".omf");                   
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
   /* if(fputc('\n', fp) == EOF)          
        goto CMDFAIL; */
        
    str1 = m_dlTool.GetOption();

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
}                                              

BOOL DOption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void DOption::Build(const CStringList &lst, LPCSTR lpcszProj)
{
    POSITION pos;   
    CString str;
    CString strBuild;
    CString cstr;
    CString astr;
    CString lstr; 
    
     if(_stricmp(m_daTool.m_incPath,m_dcTool.m_incPath)!=0)
    { 
     AfxMessageBox("Include Path of Compiler and Assemble should be same");
     return;
    }

    cstr = m_dcTool.m_strPath;
    astr = m_daTool.m_strPath; 
    lstr = m_dlTool.m_strPath;
    if(cstr[cstr.GetLength()-1]!='\\')
    cstr = cstr + "\\";
    if(astr[astr.GetLength()-1]!='\\')
    astr = astr + "\\";
    if(lstr[lstr.GetLength()-1]!='\\')
    lstr = lstr + "\\"; 
    int nType;                   
    FILE * fp;
    
    fp = fopen(GetName(lpcszProj, ".bat"), "wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
     if(!WriteBatchFile(fp, "Set C51LIB="+m_dlibTool.m_strPath))
            return;
     if(!WriteBatchFile(fp, "Set C51INCLUDE="+m_dcTool.m_incPath))
           return; 
    
        
    CString strDir ;
    int     strDrive;
    
    char Directory[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR];
       
    _splitpath(lpcszProj, drive, dir, NULL, NULL);
    _makepath(Directory,drive, dir, NULL, NULL);
    
    strDrive = drive[0]-'a'+1;
    
    _chdrive(strDrive);
    //discard '\' in directory 
     
    for(int i=0;i<_MAX_DIR;i++)
     if(dir[i]=='\\' && dir[i+1]=='\0')
      dir[i] = '\0';
    _chdir(dir);    
   char path[_MAX_PATH], fname[_MAX_FNAME],ext[_MAX_EXT];

    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file  
            strBuild =  cstr + "c51.exe "; 
            strBuild += str;
            strBuild += " ";
            strBuild += m_dcTool.GetOption();
       //     strBuild += " ";
            _splitpath(str,NULL,NULL,fname,ext);
            _makepath(path,NULL,NULL,fname,ext);
            strBuild += "OJ(";
            strBuild += GetName(path, ".obj");
            strBuild += ")";           
        } else if(nType == 1) { // asm file
            strBuild = astr + "A51.exe ";
            strBuild += str;
          //  strBuild += " ";
            strBuild += m_daTool.GetOption(); 
            _splitpath(str,NULL,NULL,fname,ext);
            _makepath(path,NULL,NULL,fname,ext);
            strBuild += "OJ( ";
            strBuild += GetName(path, ".obj");
            strBuild += ")";     
            
        } else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
        
     }                                   
    
    // link
   // if(!CreateLinkCmdFile(lst, lpcszProj))
   //     return;
    strBuild = lstr + "L51.exe "; 
   for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
    _splitpath(str,NULL,NULL,fname,ext);
    _makepath(path,NULL,NULL,fname,ext);

    strBuild += GetName(path, ".obj");
    strBuild += ",";
    }
    strBuild += m_dlibTool.GetOption(); 
    strBuild += "to ";
    strBuild += GetName(lpcszProj, ".omf");                   
                
   // strBuild += "@"; 
   // strBuild += GetName(lpcszProj, ".cmd");
   
    if(!WriteBatchFile(fp, strBuild))
        return;
    
    if(!WriteBatchFile(fp, "Pause"))
            return;

    fclose(fp);
    
    WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}

static char BASED_CODE szFilter[] = 
    "Source file (*.cpp)|*.cpp|Source file (*.c)|*.c|Source file (*.asm)|*.asm|All Files (*.*)|*.*||";
                                                    
void DOption::Editor(CWnd * pParent)
  {
   CString str;        
   CString str1;     
   CString filename;
    
    str1 =m_deTool.m_strPath;
    
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(str1,drive, dir, fname, ext);
    if(!(_stricmp(ext,".exe")==0||_stricmp(ext,".com")==0)){
    
     AfxMessageBox("Editor command error!");
     return;
    
     }

 CFileDialog dlg(TRUE, NULL, "*.c", 
        OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter, pParent);
    
   dlg.m_ofn.lpstrTitle = "Open File ";
   if(dlg.DoModal() == IDOK) {
      filename = dlg.GetPathName();
      m_deTool.m_strProg = filename;
    
      str = m_deTool.m_strPath + " ";
      str += filename;
      WinExec(str, SW_SHOW);
   }
} 
                               