
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EMUSTEPF.H__   1.2.1.5   17 Apr 1997 15:48:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EMUSTEPF.H__  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:48:58   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:20:18   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:31:36   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:12:24   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:17:26   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:28:30   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:46:12   ZJRD
** Initial revision.
** 
****************************************************************************/

// Note:   Replace emustep.h of epsld project to improve performance of
//		   C source level step.  12/18/96, chris.

typedef unsigned short PADDR;

enum OUT_FLAG {
    OUT_STATEMENT   = 0,
    OUT_FUNCTION    = 1,
    OUT_USER_DEFINED= 2
};

enum STRATAGEM {
    JUST_DO_NOTHING = 0,
    JUST_GO_OUTSIDE = 1,
    JUST_STEP_ONE = 2,
    JUST_GO_TO_FIRST_JUMP = 3,
}; 

struct NODE {
    PADDR addr;
    struct NODE * next;
}; 

class CEmuStepServer {
private:
    PADDR m_uStart;
    PADDR m_uFromAddr;
    PADDR m_uTillAddr;

    NODE * indexHead;
    NODE * bpHead;

    unsigned char * m_uchMasnCode;
    unsigned short m_nMasnCmdsLen;

public:
    
    STRATAGEM m_stratagem;

    BOOL m_fAsmMode;
    BOOL m_fAbiRet;
    BOOL m_fTooBigRoutine;

private:
    BOOL AddBpNode(PADDR uAddr);
    BOOL AddIndexNode(PADDR uAddr);

protected:
    STATUS EmuClrTempBp();
    STATUS EmuSetTempBp(PADDR uAddr);
    BOOL EmuFreeRun();

    ADDR MakeAbiAddr(PADDR nAddr);
    STRATAGEM AnalyseCmdSet(int nStepOpt, int nGetType = OUT_STATEMENT);
    int IsSpecialMasnCode(unsigned char uchMasnCode);
    
    void AsmStepOver();
    void AsmStepOut(BOOL bOverRet, BOOL bOver=FALSE);
//add by chris, 12/19/96
    void AsmStepInto(BOOL bIntoCall, BOOL bOver=FALSE);
    BOOL JustGoOutside();
    BOOL TrytoGoOutside(int nType = OUT_STATEMENT);
    
public:     
    CEmuStepServer();
    
    void StepOne(int nType = OUT_STATEMENT);
    void StepOver(int nType = OUT_STATEMENT);

    void StepOverReturn();
    void StepTillReturn();
    void StepIntoCall();
    void StepTillCall();

    void SetStepRange(PADDR paddrFrom, PADDR paddrTill);
    void UpdateAllWindows();
};
    

