/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/FMTSYM.H__   1.2.1.4   17 Apr 1997 15:52:32   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/FMTSYM.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:52:32   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:23:56   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:34:40   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:14:48   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:19:56   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:30:22   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:46:48   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:16:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:31:46   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:58:50   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:51:04   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:54:52   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:57:52   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:44   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:10   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:16:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:31:04   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:18   Shirley
** No change.
** 
**    Rev 1.0   12 Apr 1996 10:35:50   Shirley
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:   Fmtsym.h
**
**  Description:  Describe the class of CFormatSymbol. The sub class deprived
**                from the class CFormatString. This class process the symbol
**                The symbol format is:
**                   #ModuleName:#SymbolName
**
**  Status:       Initialization
**                1996/02/16                    Daniel Lin
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef __FMTSYM__H
#define __FMTSYM__H

class CFormatSymbol : public CFormatString
{
   private:
      CString  m_strOriginSymbol;   // Oringinal symbol string as the format
                                    // #ModuleName:#SymbolName
      CString  m_strModule;         // The module name
      CString  m_strSymbol;         // The symbol name
      DWORD    m_dwData;            // Converted address data
      unsigned char m_uchType;      // Segment space type
      
   public:
      UINT     m_uSymData;          // 0 -- Symbol
                                    // 1 -- Symbol Data   
      
      // Constructor
      CFormatSymbol(const CString& str);
      CFormatSymbol(const char* lpsz);

      //Implementation
      virtual  void Convert();      // Process the convert   
      
      CString  GetModuleName()      // Return the module name
      {
         return m_strModule;
      };
      
      CString  GetSymbolName()      // Return the symbol name
      {
         return m_strSymbol;
      };
      
      DWORD    GetAddress()            // Return the symbol data
      {
         return m_dwData;
      };
      
      unsigned char GetSpace()      // Return the space type
      {
         return m_uchType;
      };
};

#endif

//////////////////////////////////(EOF)///////////////////////////////////////
