// comm.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CCommunication class
#include "abitype.h"

#define FlashSWErr      0x40
#define FlashECErr      0x41
#define FlashPRGErr     0x42
#define FlashRECErr     0x43

#define LEAD_CODE       ':'
#define HEAD_OK			0x55
#define HEAD_FAIL 		0xaa
#define REC_OK			0x5a
#define REC_FAIL        0xa5

#define HAND_SHAKE      0x44

#define FLASH_SWITCH    0x60
#define FLASH_ERASE     0x61
#define FLASH_PROG      0x62    

#define MAX_REC_LEN  	255
      
enum CONTROL_PORT {
  P_W_PCE    =    1,   // output to write PCE from LPT is XXXXXXX1
  P_R_PCE    =    2,   // output to read PCE from LPT is XXXXXX1X
  P_S_RDY    =    0x08,// SWITCH = 1, from portInp
  P_R_RDY    =    0x10,// SWITCH = 1, from portInp
  P_SWITCH   =    0,   // SWITCH\ = 1, portStatus
  P_NORMAL   =    8    // let all control to output disactive
};

enum STATUS_PORT {
   P_I_MASK =      0xB8
};




class CCommunication
{    
   private:
      int nCommType;
      unsigned int PortInp;
      unsigned int PortDataAdr;
      unsigned int PortStatusAdr;
   
   public:
	  unsigned char ReceiveBuf[2048];
	  unsigned char TransmitBuf[512];
	  unsigned int TStreamLen;
	  unsigned int RStreamLen;   

   public:
      CCommunication();
      ~CCommunication(); 
//      STATUS  SendReceive(UINT, int); 
//      STATUS  GetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);
   protected:
   	  BOOL TransmitByte(unsigned char);
	  unsigned char ReceiveByte(void);
	  BOOL TransmitStream(unsigned int); 
      unsigned char ReceiveStream(void);  
//      void  SaveId(UCHAR,UINT&); 
};       