/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/GRIDMEM.CPP   1.2.1.4   17 Apr 1997 15:52:40   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/GRIDMEM.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:52:40   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:24:04   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:34:48   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:14:54   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:20:02   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:30:26   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:46:52   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  GRIDMEM.CPP
//
//  Description:The implement file for the class: CGridMem
//
//  Author:     Chris
//
//  Date:       09/10/96
//
//  Modification:
//
//      1. 09/10/95, Initial version
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "gridmem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CGridMem::CGridMem()
{   
	m_nMinLines=0;
	m_nMaxLines=100;
	m_nMinRows=0;
	m_nMaxRows=100;
	m_nLines=15;
	m_nRows=16;
	m_nPosX=0;
	m_nPosY=0;
	m_nGridHeight=17;
	m_nGridWidth=30;
	
	m_lpszTitle=new char[100];
	ASSERT(m_lpszTitle!=NULL);
	int i;
	for(i=0;i<=99;i++)
		m_lpszTitle[i]='\0';

//	SetTitle();	
	DoRect();
}

CGridMem::~CGridMem()
{                             
	if (m_lpszTitle!=NULL)
		delete m_lpszTitle;
}

void CGridMem::SetMaxLines(int nLines)
{
	m_nMaxLines = nLines;
}

void CGridMem::SetMinLines(int nLines)
{
	m_nMinLines = nLines;
}

void CGridMem::SetMaxRows(int nLines)
{
	m_nMaxRows = nLines;
}             

void CGridMem::SetMinRows(int nLines)
{
	m_nMinRows = nLines;
}                       

void CGridMem::SetPos(int x,int y, int delta)
{
	m_nDeltax = delta;
	m_nPosX = x;
	m_nPosY = y;
}               

void CGridMem::SetLines(int nLines)
{
	m_nLines = nLines;
}                     

void CGridMem::SetRows(int nLines)
{
	m_nRows = nLines;
}                    

void CGridMem::SetGridHeight(int h)
{
	m_nGridHeight = h;
}                     

void CGridMem::SetGridWidth(int w)
{
	m_nGridWidth = w;
}

void CGridMem::DeleteLines(int nLines)
{
	m_nLines -= nLines;
	if (m_nLines < m_nMinLines) 
		m_nLines = m_nMinLines;
}                              

void CGridMem::DeleteRows(int nLines)
{
	m_nRows -= nLines;
	if (m_nRows < m_nMinRows)
		m_nRows = m_nMinRows;
}

void CGridMem::AddLines(int nLines)
{
	m_nLines += nLines;
	if (m_nLines > m_nMaxLines)
		m_nLines = m_nMaxLines;
}

void CGridMem::AddRows(int nLines)
{
	m_nRows += nLines;
	if (m_nRows > m_nMaxRows)
		m_nRows = m_nMaxRows;
}                   

void CGridMem::DoRect()
{
	m_rectPos.left = m_nPosX;
	m_rectPos.top = m_nPosY;
	m_rectPos.right = m_nPosX + m_nRows * m_nGridWidth;
	m_rectPos.bottom = m_nPosY + m_nLines * m_nGridHeight;
}                                 

void CGridMem::SetTitle()
{
	m_lpszTitle[0]='0';
	m_lpszTitle[1]='\0';
	m_lpszTitle[2]='1';
	m_lpszTitle[3]='\0';
	m_lpszTitle[4]='2';
	m_lpszTitle[5]='\0';
	m_lpszTitle[6]='3';
	m_lpszTitle[7]='\0';
	m_lpszTitle[8]='4';
	m_lpszTitle[9]='\0';
	m_lpszTitle[10]='5';
	m_lpszTitle[11]='\0';
	m_lpszTitle[12]='6';
	m_lpszTitle[13]='\0';
	m_lpszTitle[14]='7';
	m_lpszTitle[15]='\0';
	m_lpszTitle[16]='8';
	m_lpszTitle[17]='\0';
	m_lpszTitle[18]='9';
	m_lpszTitle[19]='\0';
	m_lpszTitle[20]='A';
	m_lpszTitle[21]='\0';
	m_lpszTitle[22]='B';
	m_lpszTitle[23]='\0';
	m_lpszTitle[24]='C';
	m_lpszTitle[25]='\0';
	m_lpszTitle[26]='D';
	m_lpszTitle[27]='\0';
	m_lpszTitle[28]='E';
	m_lpszTitle[29]='\0';
	m_lpszTitle[30]='F';
	m_lpszTitle[31]='\0';
}   

void CGridMem::Show(CDC* dc,BOOL bBorder)
{
	ASSERT(m_nRows<=m_nMaxRows);
	ASSERT(m_nMinRows<=m_nRows);
	ASSERT(m_nRows>=0);
	ASSERT(m_nLines<=m_nMaxLines);
	ASSERT(m_nMinLines<=m_nLines);
	ASSERT(m_nLines>=0);
	ASSERT(m_nGridHeight>=0);
	ASSERT(m_nGridWidth>=0);
	ASSERT(dc!=NULL);

	if (m_nRows == 0) return;
	if (m_nLines == 0) return;
	if (m_nGridHeight == 0) return;
	if (m_nGridWidth == 0) return;

	CPen pen;
	CPen greyPen;
	CPen whitePen;
	CPen blackPen;
	CPen *oldPen;
	COLORREF oldColor;
	SIZE size;
	RECT rect;
	char* lpszText;
	UINT nCount;
	int addx,addy;
	int i;
	int x,y;
	
	m_nPosX+=m_nDeltax;
	m_rectPos.left+=m_nDeltax;
	m_rectPos.right+=m_nDeltax;
	
	pen.CreatePen(PS_SOLID,1,PALETTEINDEX(7));
	greyPen.CreatePen(PS_SOLID,1,PALETTEINDEX(12));
	whitePen.CreatePen(PS_SOLID,1,PALETTEINDEX(19));
	blackPen.CreatePen(PS_SOLID,1,PALETTEINDEX(0));
	oldPen = dc->SelectObject(&pen);
	
	for(i=0;i<=m_nRows;i++)
	{
		x = m_nPosX + i*m_nGridWidth;
		dc->MoveTo(x,m_nPosY);
		dc->LineTo(x,m_rectPos.bottom);
	}
	
	for(i=0;i<=m_nLines;i++)
	{
		y = m_nPosY + i*m_nGridHeight;
		dc->MoveTo(m_nPosX,y);
		dc->LineTo(m_rectPos.right,y);
	}        

	lpszText = m_lpszTitle;
	dc->SelectStockObject(SYSTEM_FONT);                   
    oldColor = dc->SetBkColor(PALETTEINDEX(7));
	for(i=0;i<m_nRows;i++)
	{         
		rect.top = m_nPosY;
		rect.left = m_nPosX + i*m_nGridWidth;
		rect.bottom = m_nPosY+m_nGridHeight;
		rect.right = m_nPosX + (i+1)*m_nGridWidth;
		
		nCount = strlen(lpszText);
		
	    size = dc->GetOutputTextExtent(lpszText, nCount);
		addx = (rect.right - rect.left - size.cx) / 2;
	    addy = (rect.bottom - rect.top - size.cy) / 2;
	    if(bBorder==2)
	    	addx=10;
	    dc->ExtTextOut(rect.left+addx, rect.top+addy, 
	        ETO_CLIPPED | ETO_OPAQUE, 
	        &rect, 
	        lpszText, 
	        nCount, 
	        NULL);
	    dc->SelectObject(&blackPen);
	    dc->MoveTo(rect.left,rect.top);
	    dc->LineTo(rect.right,rect.top);
	    dc->LineTo(rect.right,rect.bottom);
	    dc->LineTo(rect.left,rect.bottom);
	    dc->LineTo(rect.left,rect.top);
	    dc->SelectObject(&whitePen);
	    dc->MoveTo(rect.left+1,rect.top+1);
	    dc->LineTo(rect.right-1,rect.top+1);
	    dc->MoveTo(rect.left+1,rect.top+1);
	    dc->LineTo(rect.left+1,rect.bottom-1);
	    dc->SelectObject(&greyPen);
	    dc->MoveTo(rect.right-1,rect.top+1);
	    dc->LineTo(rect.right-1,rect.bottom-1);
	    dc->LineTo(rect.left+1,rect.bottom-1);
	    lpszText+=nCount;
	    lpszText++;
	}
	
	if (bBorder)
	{
		dc->SelectObject(&blackPen);
		dc->MoveTo(m_rectPos.left,m_rectPos.top);
		dc->LineTo(m_rectPos.right,m_rectPos.top);
		dc->LineTo(m_rectPos.right,m_rectPos.bottom);
		dc->LineTo(m_rectPos.left,m_rectPos.bottom);
		dc->LineTo(m_rectPos.left,m_rectPos.top);
	}   
	
    dc->SetBkColor(oldColor);

	dc->SelectObject(oldPen);

	m_nPosX-=m_nDeltax;
	m_rectPos.left-=m_nDeltax;
	m_rectPos.right-=m_nDeltax;
}

int CGridMem::GetLeftPos()
{
	return m_rectPos.left+m_nDeltax;
}

int CGridMem::GetRightPos()
{
	return m_rectPos.right+m_nDeltax;
}

RECT CGridMem::GetGridRect(int x,int y)
{
	RECT rect;
	rect.left = m_nPosX + x * m_nGridWidth+m_nDeltax;
	rect.top = m_nPosY + y * m_nGridHeight;
	rect.right = rect.left + m_nGridWidth;
	rect.bottom = rect.top + m_nGridHeight;
	return rect;
}
