
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/MEMBASE.CPP   1.2.1.4   17 Apr 1997 15:55:58   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/MEMBASE.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:58   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:27:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:37:50   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:17:02   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:22:06   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:32:12   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:47:50   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:54   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:10   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:16   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:50   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:53:56   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:32   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:12   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:34   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:38:14   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:58   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:50   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:36   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:36:42   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:28:06   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:49:40   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:10   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:24   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:54   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:12:46   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:24   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:12   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:00   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:58   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:12   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:46   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:24   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:56   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:40   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:00   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:30   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:06   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:20   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:28   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:48:48   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:26   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:52:38   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:46   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:22   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:53:48   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:45:14   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:40   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: MEMBASE.CPP
//
//  Description: The implementation file for the class: CMemoryBase.
//
//  Author: Chen Jun
//
//  Date: 04/17/95
//
//  Modification:
//      1. 04/17/95, Initial version of the class: CMemoryBase.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "symbscty.h"
#include "membase.h"
#include "hosterrs.h"
#include "uicom.h"

/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.


/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
extern int TestKey(WORD wKey);  // Defined in UICOM.CPP
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
extern RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);



/////////////////////////////////////////////////////////////////////////////
// Executable codes.


/////////////////////////////////////////////////////////////////////////////
// Public functions.

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CMemoryBase.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemory::CMemoryBase().
//
//  Description: The construction of the class: CMemoryBase.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBase::CMemoryBase()
{
    // Allocate a space.
    m_pszVar = new char[MAX_DIGIT];
    if ( !m_pszVar ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        memset(m_pszVar, 0, sizeof(m_pszVar));
    }
    
    m_pszResult = new char[LINE_LENGTH];
    if ( !m_pszResult ) {
        AfxMessageBox("Insufficient Memory !");
        ASSERT( FALSE );
        return;
    }
    else {
        memset(m_pszResult, 0, sizeof(m_pszResult));
    }
    
    // Initialization.
    m_nErrorID = 0;

}   // End of CMemoryBase::CMemoryBase().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemory::~CMemoryBase().
//
//  Description: The destruction of the class: CMemoryBase.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CMemoryBase::~CMemoryBase()
{
    // Free the allocated space.
    if ( m_pszVar ) {
        delete []m_pszVar;
    }
    
    if ( m_pszResult ) {
        delete []m_pszResult;
    }

}   // End of CMemoryBase::~CMemoryBase().



/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::StrToVar().
//
//  Description: Convert the string to an unsigned long value.
//
//  Input:  pszConvStr - The string to be converted.
//
//  Output: m_ulVar - An unsigned long value.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::StrToVar(char* pszConvStr)
{
    // Assertion of the input parameters.
    ASSERT( pszConvStr );
    
    // Convertion.
    char* pszStopStr;
    m_ulVar = strtoul(pszConvStr, &pszStopStr, 16);

}   // End of CMemoryBase::StrToVar().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::VarToStr().
//
//  Description: Convert an unsigned long value to a string.
//
//  Input:  ulConvVar - The converted value.
//
//  Output: m_pszVarString - The ASCII digital string.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::VarToStr(unsigned long ulConvVar)
{
    // Assertion of the input parameters.

    // Convert an unsigned long value to the string.
    _ultoa(ulConvVar, m_pszVar, 16);
    
}   // End of CMemoryBase::VarToStr().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  pszArgv - Input address with memory attribute.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(char* pszAddr, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr );
    
    unsigned char uch;
    
    if ( ':' == pszAddr[1] ||':'==pszAddr[2]) {
        // Convert the "X:xxxx" form.
        ASSERT( 'P' == toupper(*pszAddr) ||
                'X' == toupper(*pszAddr) ||
                'I' == toupper(*pszAddr) ||
                'R' == toupper(*pszAddr) ||
                'B' == toupper(*pszAddr) );

        switch ( toupper(*pszAddr) ) {
            case 'P':
                if(pszAddr[1]==':')
                	uch = MEM_PROGRAM;
                else if(pszAddr[1]=='0')
                	uch = MEM_BANK1;
                else if(pszAddr[1]=='1')
                	uch = MEM_BANK2;
                else if(pszAddr[1]=='2')
                	uch = MEM_BANK3;
                else if(pszAddr[1]=='3')
                	uch = MEM_BANK4;
                else
                	ASSERT(0);
                break;
            case 'X':
                uch = MEM_EXTERNAL;
                break;
            case 'I':
                uch = MEM_INTERNAL;
                break;
            case 'R':
                uch = MEM_SFR;
                break;
            case 'B':
            	uch = MEM_BIT;
                break;
            default:
                uch = MEM_UNDEFINE;
                ASSERT( FALSE );
                break;
        }
        if(':' == pszAddr[1])
        	StrToVar(pszAddr+2);
        else
        	StrToVar(pszAddr+3);
    }
    else {
        // Convert the "xxxx" form.
        StrToVar(pszAddr);
        if(g_nBankNum)
        	uch=MEM_BANK1;
        else
        	uch = MEM_PROGRAM;
    }

    unsigned short uAddr = (unsigned short) m_ulVar;
    
    // Set the ADDR structure.
    addr.m_uchType = uch;
    addr.m_uAddr = uAddr;

}   // End of CMemoryBase::SetAddrVar().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  pszArgv - Input address with memory attribute.
//          pszLength - Length between Start address & End address.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(char* pszAddr, char* pszLength, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( pszAddr );
    ASSERT( pszLength );
    
    unsigned char uch;
    if ( ':' == pszAddr[1] || ':' == pszAddr[2] ) {
        // Convert the "X:xxxx" form.
        ASSERT( 'P' == toupper(*pszAddr) ||
                'X' == toupper(*pszAddr) ||
                'I' == toupper(*pszAddr) ||
                'R' == toupper(*pszAddr) ||
                'B' == toupper(*pszAddr) );

        char ch = (char) toupper(*pszAddr);
        switch ( ch ) {
            case 'P':
                if(pszAddr[1]==':')
                	uch = MEM_PROGRAM;
                else if(pszAddr[1]=='0')
                	uch = MEM_BANK1;
                else if(pszAddr[1]=='1')
                	uch = MEM_BANK2;
                else if(pszAddr[1]=='2')
                	uch = MEM_BANK3;
                else if(pszAddr[1]=='3')
                	uch = MEM_BANK4;
                else
                	ASSERT(0);
                break;
            case 'X':
                uch = MEM_EXTERNAL;
                break;
            case 'I':
                uch = MEM_INTERNAL;
                break;
            case 'R':
                uch = MEM_SFR;
                break;
            case 'B':
                uch = MEM_BIT;
                break;
            default:
                uch = MEM_UNDEFINE;
                ASSERT( FALSE );
                break;
        }
        if(':' == pszAddr[1])
        	StrToVar(pszAddr+2);
        else
        	StrToVar(pszAddr+3);
    }
    else {
        // Convert the "xxxx" form.
        StrToVar(pszAddr);
        if(g_nBankNum)
        	uch=MEM_BANK1;
        else
        	uch = MEM_PROGRAM;
    }

    DWORD dwAddr = m_ulVar;
    StrToVar(pszLength);
    //dwAddr += (unsigned short) (m_ulVar - 1);
    dwAddr += (m_ulVar - 1);
    
    // Set the ADDR structure.
    if(uch>5&&dwAddr>0xffff)
    {
     	addr.m_uchType=BYTE(uch+(dwAddr>>16));
     	addr.m_uAddr=WORD(dwAddr);
    }
    else
    {
    	addr.m_uchType = uch;
    	addr.m_uAddr = WORD(dwAddr);
    }

}   // End of CMemoryBase::SetAddrVar().

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::SetAddrVar().
//
//  Description: Set the address with the memory space.
//
//  Input:  nType - P, X, I, R, B.
//          ulAddr - address value.
//
//  Output: addr - Structure "CMemoryAddr" variable.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::SetAddrVar(int nType, unsigned long ulAddr, CMemoryAddr& addr)
{
    // Assertion of the input parameters.
    ASSERT( nType >= MEM_UNDEFINE && nType <= MEM_BANK4 );
    
    // Set the ADDR structure.
    addr.m_uchType = (unsigned char) nType;
    addr.m_uAddr = (unsigned short) ulAddr;

}   // End of CMemoryBase::SetAddrVar().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::EscapeAbort().
//
//  Description: Test if abort by pressing ESC key.
//
//  Input:  None.
//
//  Output: nErrorID - The ID of the ABI error.
//
//  Return: TRUE - abort; FALSE - no abort.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CMemoryBase::EscapeAbort(void)
{
    // Assertion of the input parameters.
    
    // Test the key value.
    if ( 1 == ::TestKey(VK_ESCAPE) ) {
        ShowLine("Abort by user.");
        return (TRUE);
    }
    else {
        return (FALSE);
    }

}   // End of CMemoryBase::EscapeAbort().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CMemoryBase::DisplayErrorMessage().
//
//  Description: Display the ABI error messages of the Memory server.
//
//  Input:  nErrorID - The ID of the ABI error.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CMemoryBase::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT(m_nErrorID >= ICE_FAIL_STEP && m_nErrorID <= ICE_FLASH_REC_ERROR);

    // Dispatch ABI error message.
    char* pszAbiError;
    pszAbiError = new char [256];
/*    
    switch ( m_nErrorID ) {
        case ICE_FAIL_STEP:
            //pszAbiError = "Target cannot step.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MEM_WRITE:
            //pszAbiError = "Memory write failure.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MAP_INCLUDE:
            //pszAbiError = "Map status not included.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FAIL_MAP_BOUNDARY:
            //pszAbiError = "Map address boundary error.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_NOT_FOUND:
            //pszAbiError = "Not found.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_FOUND:
            //pszAbiError = "Found.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_TIME_OUT:
            //pszAbiError = "Communication failure.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_PARA_ERROR:
            //pszAbiError = "Parameter error.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_EP_RUNNING:
            //pszAbiError = "EP running.";
            ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);
            break;
        case ICE_TRACE_RUNNING:
            pszAbiError = "Trace running.";
            break;
        case ICE_TRACE_READ_OVER:
            pszAbiError = "Trace read over.";
            break;
        case ICE_COMMAND_INVALID:
            pszAbiError = "Invalid command.";
            break;
        case ICE_FLASH_SW_ERROR:
            pszAbiError = "Flash EPROM switching error.";
            break;
        case ICE_FLASH_EC_ERROR:
            pszAbiError = "Flash EPROM earsing error.";
            break;
        case ICE_FLASH_PRG_ERROR:
            pszAbiError = "Flash EPROM programming error.";
            break;
        case ICE_FLASH_REC_ERROR:
            pszAbiError = "Flash EPROM recording error.";
            break;
        default:
            ASSERT( FALSE );
            pszAbiError = "Parameter error.";
            break;
    }
*/  
    //Add by Daniel Lin on 5/30/1996
    //
    ::ErrGetErrorText(ER_ICE_OK+m_nErrorID, pszAbiError);    
    
    // Display the ABI error message.
    if ( !m_isServer ) {
        ShowLine(pszAbiError);
    }
    else {
        AfxMessageBox(pszAbiError);
    }
    
    delete [] pszAbiError;
    
}   // End of CMemoryBase::DisplayErrorMessage().

//////////////////////////////// End of File ////////////////////////////////
