/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/STATUS.CPP   1.2.1.4   17 Apr 1997 16:01:22   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/STATUS.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:01:22   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:34:30   ZJRD
** 2.09F
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  STATUS.CPP
//
//  Description:The implement file for the class: CSuperStatusBar
//
//  Date:       08/12/96
//
//  Modification:
//
//      1. 08/12/96, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "status.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CSuperStatusBar

IMPLEMENT_DYNAMIC(CSuperStatusBar, CStatusBar)

BEGIN_MESSAGE_MAP(CSuperStatusBar, CStatusBar)
    //{{AFX_MSG_MAP(CSuperStatusBar)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSuperStatusBar construction/destruction

CSuperStatusBar::CSuperStatusBar()
{
    // TODO: add member initialization code here
    m_nColorFlag = 0;
}

CSuperStatusBar::~CSuperStatusBar()
{
}

/////////////////////////////////////////////////////////////////////////////
// CSuperStatusBar implementation.

void CSuperStatusBar::UpdateStatusBar(void)
{
    // Change the pane info.
    UINT nID, nStyle;
    int nIndex, cxWidth;
        
    // Pane 0.
    nIndex = 0;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_STRETCH|SBPS_NORMAL, cxWidth);
    
    // Pane 1.
    nIndex = 1;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NOBORDERS, 2);

    // Pane 2.
    nIndex = 2;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NORMAL, 70);
    SetPaneText(nIndex, "");
    
    // Pane 3.
    nIndex = 3;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NOBORDERS, 2);

    // Pane 4.
    nIndex = 4;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NORMAL, 70);
    SetPaneText(nIndex, "");
    
    // Pane 5.
    nIndex = 5;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NOBORDERS, 2);

    // Pane 6.
    nIndex = 6;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NORMAL, 70);
    SetPaneText(nIndex, "");
    
    // Pane 7.
    nIndex = 7;
    GetPaneInfo(nIndex, nID, nStyle, cxWidth);
    SetPaneInfo(nIndex, nID, SBPS_NOBORDERS, 2);
}

void CSuperStatusBar::UpdateStatusBar(int nIndex, const CString strPrompt)
{
    // Update the index information.
    SetPaneText(nIndex, strPrompt);
    if ( nIndex == 2 ) {
    	int nNowColor = 0;
		if ( strPrompt.Find("Running") != -1 ) nNowColor = 1;   	
    	if ( m_nColorFlag != nNowColor ) {
	    	m_nColorFlag = nNowColor;
    		UpdateColor();
    	}
    }
}

void CSuperStatusBar::UpdateStatusBar(BOOL bRunning)
{
	// Hilite if running.
	CDC* pDC = GetDC();

	for ( int i(2); i <= 8; i += 2 ) {
		// Get rect.
		CRect rect;
		GetItemRect(i, rect);
                    
		// Fill rect.
		COLORREF cr = bRunning ? RGB(255,255,128) : RGB(192,192,192);
		CBrush brush(cr);
		CBrush* pBrushOld = pDC->SelectObject(&brush);
		rect.left += 1;
		rect.top += 1;
		rect.right -= 1;
		rect.bottom -= 1;
		pDC->FillRect(rect, &brush);
		pDC->SelectObject(pBrushOld);

		// Pane: 2, 4, 6.
		CString str;
		GetPaneText(i, str);
		
		pDC->SetTextColor(RGB(0,0,0));
		pDC->SetBkMode(TRANSPARENT);
		pDC->TextOut(rect.left, rect.top, str);
	}

	ReleaseDC(pDC);
}

void CSuperStatusBar::OnPaint()
{
	CRect rect;
	GetUpdateRect(&rect);
	CStatusBar::OnPaint();

	// TODO: Add your message handler code here
	if ( m_nColorFlag ) {
		CDC *pDC;     
		//CBrush brush(RGB(255,255,0));
//	    CPen NewPen(PS_SOLID,1,RGB(127,63,0));
//	    CPen NewPen(PS_SOLID,1,RGB(255,255,0));
//	    CPen NewPen(PS_SOLID,1,RGB(0,192,192));
//	    CPen NewPen(PS_SOLID,1,RGB(127,255,255));
	    CPen NewPen(PS_SOLID,1,RGB(127,127,0));
	
		pDC = GetDC();
	
	    CPen *pOldPen = pDC->SelectObject(&NewPen);
	    int mode = pDC->GetROP2();
	    pDC->SetROP2(R2_MERGEPEN); 
//	    pDC->SetROP2(R2_MASKPEN); 
//	    pDC->SetROP2(R2_NOTMASKPEN); 
//	    pDC->SetROP2(R2_MASKPENNOT); 
//	    pDC->SetROP2(R2_MERGEPENNOT); 
	//	GetClientRect(&rect);		
		for( int i=rect.top;i<rect.bottom;i++) {
			pDC->MoveTo(rect.left,i);
			pDC->LineTo(rect.right,i);
		}
	    pDC->SetROP2( mode );
	    pDC->SelectObject(pOldPen);
	    ReleaseDC(pDC);
	}
}

void CSuperStatusBar::UpdateColor(void)
{ 
	Invalidate();
	UpdateWindow();
/*
	CRect rect;
	CDC *pDC;     
    CPen NewPen(PS_SOLID,1,RGB(128,255,128));
	
	pDC = GetDC();
	
    CPen *pOldPen = pDC->SelectObject(&NewPen);
    int mode = pDC->GetROP2();
    pDC->SetROP2(R2_XORPEN); 
	GetClientRect(&rect);		
	for( int i=rect.top;i<rect.bottom;i++) {
		pDC->MoveTo(rect.left,i);
		pDC->LineTo(rect.right,i);
	}
    pDC->SetROP2( mode );
    pDC->SelectObject(pOldPen);
    ReleaseDC(pDC);
*/    
}
