
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMCALC.H__   1.2.1.4   17 Apr 1997 16:03:14   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMCALC.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:14   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:36:12   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:12   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:24   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:40   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:22   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMCALC.H
**
**  Description:
**      C expression calculate basic class : CSymCalc (SYM_TOKEN_NODE)
**      Major header file used by expression.
**
**  Status:  CODED
**
**    Rev 1.0   21 March 1996 10:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _SYMCALC_H_
#define _SYMCALC_H_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symtoken.h"
//#include "symsyn.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

    
                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/**********************************************************************
*                                                                     *
*    The Expression use this class to save token information          *
*                                                                     *
**********************************************************************/                        

class CSymCalc {
//private :
public:
    SYMTOKENTYPE symType ;
    int typeOpt;
    BUILT_IN_TYPE typeValue;
    ExpressionValue result;
    SYM_DESCRIPTOR symDesc;
    ADDRESS_TYPE addr;
	TYPE_INDEX typeIndex;
	BOOLEAN isGlobal;
	int nComplexType;
	int m_nFlag;
	int m_nTkNum;

public :
    CSymCalc() {
        symType = SYMTOKEN_UNKNOWN;
        typeOpt = 0;       
        typeValue = BI_UNKNOWN;
        result.l = 0L;
        symDesc = 0L;
        nComplexType = 0;                 
        m_nFlag = -1;
        m_nTkNum = -1;
    }
    CSymCalc(SYM_TOKEN_NODE *pNode) {
    	symType = pNode->symType;
    	typeOpt = pNode->typeOpt;
    	typeValue = pNode->typeValue;
    	memcpy( &result , &pNode->result , sizeof( ExpressionValue ) );
    	symDesc = pNode->symDesc;    
    	addr.segType = pNode->addr.segType;
    	addr.addr = pNode->addr.addr;      
    	typeIndex = pNode->typeIndex;
    	isGlobal = pNode->isGlobal;
    	nComplexType = pNode->nComplexType;
        m_nFlag = -1;
        m_nTkNum = pNode->nTkNum;
    }
    CSymCalc(CSymCalc *pNode) {
    	symType = pNode->symType;
    	typeOpt = pNode->typeOpt;
    	typeValue = pNode->typeValue;
    	memcpy( &result , &pNode->result , sizeof( ExpressionValue ) );
    	symDesc = pNode->symDesc;    
    	addr.segType = pNode->addr.segType;
    	addr.addr = pNode->addr.addr;      
    	typeIndex = pNode->typeIndex;
    	isGlobal = pNode->isGlobal;
    	nComplexType = pNode->nComplexType;
        m_nFlag = pNode->m_nFlag;
        m_nTkNum = pNode->m_nTkNum;
    }
	~CSymCalc() {
	}

public :
	void AddOneDim(void) {
		typeOpt++;
	}
	int GetDimNum(void) {
		return typeOpt;
	}
	 	
public :
	int ModifyResult(int nResultFlag);
	int CheckValue(void);
	int CheckOneOperate(int nType);
	int CheckTwoOperate(CSymCalc* pNode1,int nType);
	int CheckAssignOperate(CSymCalc *pNode1, int nType);
	int CheckOperate(int nType);
	int Increment(void);
	int Decrement(void);
	int Plus(void);
	int Minus(void);
	int BitNot(void);
	int LogNot(void);
	int operator+(CSymCalc& pNode1);
	int operator-(CSymCalc& pNode1);
	int operator*(CSymCalc& pNode1);
	int operator/(CSymCalc& pNode1);
	int operator%(CSymCalc& pNode1);
	int operator>>(CSymCalc& pNode1);
	int operator<<(CSymCalc& pNode1);
	int operator<(CSymCalc& pNode1);
	int operator>(CSymCalc& pNode1);
	int operator<=(CSymCalc& pNode1);
	int operator>=(CSymCalc& pNode1);
	int operator==(CSymCalc& pNode1);
	int operator!=(CSymCalc& pNode1);
	int operator&(CSymCalc& pNode1);
	int operator^(CSymCalc& pNode1);
	int operator|(CSymCalc& pNode1);
	int operator&&(CSymCalc& pNode1);
	int operator||(CSymCalc& pNode1);           
	int PointValue(void);
	int GetValue(void);
	int CheckStructOpt(CSymCalc* pNode1,int nType);
//	int Struct(CSymCalc* pNode1,int nType);
//	int Struct(CSymCalc* pNode1,int nType,class CSymSyntax *pObj);
	int Struct(CSymCalc* pNode1,int nType,void *pVoid);
	int CheckArrayOperate(CSymCalc* pNode1,int& nType ,unsigned long& ul);
	int CArray(unsigned long ul);	    
	int Omf51Array(unsigned long* pArray , int nDim);
	int Assignment(CSymCalc* pNode1,void* pVoid);
	int SetValue(CSymCalc* pNode1,void* pVoid);
	
	int ConvertValue(unsigned char& uc);
	int ConvertValue(unsigned short& ui);
	int ConvertValue(unsigned long& ul);
	int ConvertValue(char& c);
	int ConvertValue(short& i);
	int ConvertValue(long& l);
	int ConvertValue(float& f);
	int ConvertValue(double& d);
	void Display(void);
	int GetStatus(BOOL& bResult);
	int DisplayValue(char* temp);
};   
                
                
#endif
/******************************** E O F ***********************************/
