
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMCLI.H__   1.2.1.4   17 Apr 1997 16:03:20   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMCLI.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:20   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:36:18   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:20   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:28   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:46   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:26   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:20   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symcli.h
**
**  Description:
**     Prototype for the symbol server CLI parse routines
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/ECB2S/SRC/LOG/SYMCLI.H__   1.2.1.4   17 Apr 1997 16:03:20   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symwind.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif


//--------------------------------------------------------------------------
// SendMessageToCli
//--------------------------------------------------------------------------
RETCODE SendMessageToCli(U8 FAR *msgPtr);


/***************************************************************************
** RemoveSymbols
**
** Description: Removes all loaded symbols and reinitializes the symbol
**              table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT RemoveSymbols(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
** DisplaySymbols
**
** Description: Prints all symbols in the symbol table.
**
** Input Parameters:
**    cmdString: a string of parsed tokens passed by the CLI
**    argc: number of tokens
**    argv[]: array holding an index to the parsed tokens in cmdString
** Output Parameters:
**    none:
** Errors:
**
***************************************************************************/
RETCODE EXPORT DisplaySymbols(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// Count
//
// Displays the number of symbols in the various tables
//--------------------------------------------------------------------------
RETCODE EXPORT
Count(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// NameOf
//
// Converts an address into a symbol and displays it
//--------------------------------------------------------------------------
RETCODE EXPORT
NameOf(LPSTR cmdString, U32 argc, U32 argv[]);


//--------------------------------------------------------------------------
// AddressOf
//
// Converts a symbol path and name into an address; uses #mod#func#var
//   naming convention
//--------------------------------------------------------------------------
RETCODE EXPORT
AddressOf(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolOpenFile
//
// Sets symbol output to go to <file>.
// Only one parameter is allowed - the path and filename
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolOpenFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// SymbolCloseFile
//
// Closes file opened by SymbolOpenFile
// No parameters are allowed.
//--------------------------------------------------------------------------
RETCODE EXPORT
SymbolCloseFile(LPSTR cmdString, U32 argc, U32 argv[]);

//--------------------------------------------------------------------------
// DisplayTypes
//
// Diplay all types in symbol table.
//                    
//--------------------------------------------------------------------------
RETCODE EXPORT
DisplayTypes(LPSTR cmdString, U32 argc, U32 argv[]);

/****************************************************************************
**
**  TskCheckAbort
**
**  Description:
**    Acts as replacement for Windows API function GetAsyncKeyState(VK_ESCAPE)
**    As such it should match its behavior and return type.
**    This new version only calls when the app is active, as
**    defined by the "appIsActive" flag.  This is a crude
**    indication of focus.
**
**  Parameters:
**     aborted   flag: FALSE if esc not pressed, TRUE if pressed.
**
*****************************************************************************/

RETCODE EXPORT TskCheckAbort(BOOLEAN FAR *abort);

#ifdef __cplusplus
}
#endif

#define _SYMCLI_
#endif
/******************************** E O F ***********************************/
