
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMERRS.H__   1.2.1.4   17 Apr 1997 16:03:32   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMERRS.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:32   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:36:32   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:30   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:38   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:54   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:34   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:24   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  hosterrs.h
**
**  Description:
**     Host system errors are defined here, along with typical masks.
**
**  Status:  CODED
**
**  Date:	3/20/96 	by:  Jamoon
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HOSTERRS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symbscty.h" 

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define E_ERRSIZE           256     // maximum size of error text


// E_SEVERITY_MASK mask out the error property 
#define E_SEVERITY_MASK    	0xFF000000L
#define E_UNKNOWN         	0x00000000L
#define E_INFORMATIVE       0x10000000L
#define E_WARNING          	0x01000000L
#define E_ERROR				0x02000000L
#define E_FATAL            	0x04000000L
#define E_SEVERE           	0x08000000L
#define E_SEVERITYID(x) 	( (x) & E_SEVERITY_MASK )

// use E_COMPONET_MASK to mask out the componet that send the error
// detecting component id is upper 2 bytes less top 8 bits 
#define E_COMPONENT_MASK   	0x00FF0000L
#define E_MODULEID(x)  		( (x) & E_COMPONENT_MASK )

// module id define
#define MOD_UNKNOWN			0x00000000L

// error number is lower 2 bytes 
#define E_ERROR_NUMBER_MASK   0x0000FFFFL
#define E_ERRORID(x)  (U16) ((x) & E_ERROR_NUMBER_MASK)


#define E_DIALOG	0
#define E_SHELL		1

// error id and recovery id in errcodec.h
#include "symerrs1.h"


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/



/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text or recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used. 
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**					 or recover type, and recover number
**    output :
**       lpszError : error string
**       strError 
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
RETCODE EXPORT ErrGetErrorText(U32 errorCode, LPSTR lpszError ...);
RETCODE EXPORT ErrGetErrorText(U32 errorCode, CString& strError ...);


/*****************************************************************************
** ErrGetErrorText
**
** Description:
**   Retrieve error text and recover text and plug in optional arguments.  
**	 The *caller* is expected to have allocated storage for the return 
**	 string of size E_ERRSIZE if LPSTR is used
**	 Optional arguments must fit with the error format string. Refer to 
**	 wvsprintf() window function for the format-control character sequences.
**
** Parameters:
**    input :
**       errCode :   error type, and error number 
**		 recCode :	 recover type, and recover number
**    output :
**       lpszError : error string 
**		 lpszRecov : recover string
**       strError  : error CString
**		 strRecov  : recover CString
** Return :
**		GOOD(0) for success    FAILURE(-1) for failure	
*****************************************************************************/
RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode,
				LPSTR lpszError, LPSTR lpszRecov ...);
RETCODE EXPORT ErrGetErrorText(U32 errCode,U32 recCode,
				CString& strError, CString& strRecov ...);



/****************************************************************************
**
**  ErrDisplayError
**
**  Description:
**     Obtain and display the error text corresponding to the given error code
**     with MessageBox, optional arguments must fit with the error  format  
**     string. Refer to wvsprintf() window function for the format-control  
**     character sequences.
**
**  Parameters:
**     input:
**        errCode          error code
**        recCode          recovery code, recCode = 0 for no recovery
**     output:
**
*****************************************************************************/
RETCODE EXPORT ErrDisplayError(U32 errCode, U32 recCode ...);
RETCODE EXPORT ErrDisplayError(U32 errCode);


#define _HOSTERRS_
#endif
/******************************** E O F ***********************************/
