
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMORD.H__   1.2.1.4   17 Apr 1997 16:04:12   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMORD.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:12   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:37:58   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:06   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:14   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:32   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:06   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:48   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: ordtbl.h
**
** Title: Ordinal Table
**
** Purpose:
**  Class and methods for managing the ordinal table - list of offsets to
**  symbols in the order they are loaded.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMORD.H__   1.2.1.4   17 Apr 1997 16:04:12   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _ORDTBL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "sympool.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef U32 ORDINAL_INDEX;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

class OrdinalTable : public MemPool {

public:

//------------------------------------------------------------------------
// OrdinalTable() - contructor
//
// Purpose:
//    Initialize ordinal table variables for table creation and expansion.
//---------------------------------------------------------------------------
OrdinalTable();    // constructor


//------------------------------------------------------------------------
// AddSymOffsetToOT
//
// Purpose:
//    Put the offset to the symbol into the next free space in the ordinal
//    table.  Return the index number where loaded.
//
// Input parameters:
//    symOffset:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    ordinalIndex:
//       ORDINAL_INDEX index (into ordinal table) where symbol offset placed
//
// Error:
//    Returns calling error messages
//------------------------------------------------------------------------
RETCODE
AddSymOffsetToOT(TABLE_OFFSET symOffset, ORDINAL_INDEX& ordIndex);


//------------------------------------------------------------------------
// GetOffset
//
// Purpose:
//    Retrieve offset to symbol table item given the index to the ordinal
//    table.
//
// Input parameters:
//    ordIndex:
//       ORDINAL_INDEX index into ordinal table; the index is an even size
//       of a TABLE_OFFSET
//
// Output parameters:
//    itemOffset:
//       offset into symbol table of item
//
// Error:
//    Reports ER_INDEX_NOT_IN_TABLE if the index field is NULL or
//    Reports ER_INDEX_OUT_OF_BOUNDS if the requested index is larger than
//       last item in the table or larger than the table size
//------------------------------------------------------------------------
RETCODE GetOffset(ORDINAL_INDEX ordIndex,
                  TABLE_OFFSET& itemOffset);


//------------------------------------------------------------------------
// GetOrdinalCount
//
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
U32 GetOrdinalCount(void) { return (GetAvailMemOffset()
                            / sizeof(TABLE_OFFSET)); };

//------------------------------------------------------------------------
// GetOrdinalFromPercent
//
// Purpose:
//    Given a percentage value (0 - 100), return the ordinal value
//    (location) closest to the percentage value requested.
//    e.g. 0  (%) = first location
//         100(%) = last location
//
// Input parameter:
//    percent: desired percentage of total entry count
//
// Return value:
//    ordinal index (0 to n) that is the closest to the percentage of the
//    total table size requested
//
// Errors: No errors; limits percent to 100
//------------------------------------------------------------------------
U32 GetOrdinalFromPercent(U8 percent);

//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
void ObliterateTable(void);

};  // end of class OrdinalTable

#define _ORDTBL_
#endif
/******************************** E O F *************************************/
