
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMSTACK.CPP   1.2.1.4   17 Apr 1997 16:04:22   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMSTACK.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:22   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:38:18   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:12   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:20   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:38   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:12   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:54   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  SYMSTACK.CPP
**
**  Description:
**      member function of class CSymStack
**
**  Status:  CODED
**
**    Rev 1.0   13 March 1996 10:00:00pm   Gates Hua
** Initial revision.
**
**  Copyright (C) 1996 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include "symblsvr.h"
#include "symstack.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/


                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/***************************************************************************
*                                                                          *
*  IsEmpty  --  check stack status                                         *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       GOOD -- stack is empty                                             *
*       FAILURE -- stack is not empty                                      *
*                                                                          *
***************************************************************************/
int CSymStack::IsEmpty(void)
{
	if ( m_pBottom == 0 ) return GOOD;
    return FAILURE;
}

/***************************************************************************
*                                                                          *
*  DeleteStack  --  free stack memory                                      *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       GOOD -- free memory OK                                             *
*       FAILURE -- free memory FAILURE                                     *
*                                                                          *
***************************************************************************/
int CSymStack::DeleteStack(void)
{
	struct StackNode *temp;
	
	temp = m_pTop;
	while( m_pTop ) {
		m_pTop = m_pTop->next;
		delete temp;
		temp = m_pTop;
	}
	m_pBottom = 0;
	m_pTop = 0;
		
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  Push  --  push one data to stack                                        *
*  parameter :                                                             *
*       pNode  --  data pointer                                            *
*  return value :                                                          *
*       GOOD -- OK                                                         *
*       FAILURE -- FAILURE                                                 *
*                                                                          *
***************************************************************************/
int CSymStack::Push(void* pNode)
{
	struct StackNode *temp;
	
	if ( pNode == 0 ) return FAILURE;
	temp = new struct StackNode;
	if ( temp == 0 ) return FAILURE;
	temp->pNode = pNode;
	if ( m_pBottom == 0 ) {
		m_pTop = temp;
	}                    
	else {
		temp->prev = m_pBottom;
		m_pBottom->next = temp;
	}
	m_pBottom = temp;
	
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  Pop  --  pop one data from stack                                        *
*  parameter :                                                             *
*       pNode  --  data pointer                                            *
*  return value :                                                          *
*       GOOD -- OK                                                         *
*       FAILURE -- FAILURE                                                 *
*                                                                          *
***************************************************************************/
int CSymStack::Pop(void*& pNode)
{
	struct StackNode *temp;
	
	if ( m_pBottom == 0 ) return FAILURE;
	pNode = m_pBottom->pNode;
	if ( pNode == 0 ) return FAILURE;
	temp = m_pBottom;
	m_pBottom = m_pBottom->prev;
	if ( m_pBottom == 0 ) {
		m_pTop = 0;
	}                    
	else {
		m_pBottom->next = 0;
	}
	delete temp;
	
    return GOOD;
}

/******************************** E O F ***********************************/
