
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMUTIL.H__   1.2.1.4   17 Apr 1997 16:05:20   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMUTIL.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:05:20   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:39:22   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:38   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:48   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:29:04   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:34   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:52:10   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: symutil.h
**
** Title: Utility Routines for Symbol Server
**
** Purpose:
**    Catch-all for definitions and functions needed by multiple symbol files
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMUTIL.H__   1.2.1.4   17 Apr 1997 16:05:20   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _SYMUTIL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symblsvr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMBOLS_LOADED  0L  // for on-demand, indicates symbols all loaded ;
 
#ifndef DEFAULT_START_ADDR 
#define DEFAULT_START_ADDR 0xFFFFFFFFL   
#endif 

#ifndef DEFAULT_END_ADDR 
#define DEFAULT_END_ADDR   0L
#endif

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b))
#endif

#ifndef min
#define min(a,b)    (((a) < (b)) ? (a) : (b))
#endif

                       /**********************************
                        *                                *
                        *       FUNCTION PROTOTYPES      *
                        *                                *
                        **********************************/
BOOLEAN
UtilIsValidSymDescriptor(SYM_DESCRIPTOR symDesc);

RETCODE
UtilGetAddrFromSymDesc(SYM_DESCRIPTOR symDesc,
                       BASE_ADDRESS *baseAddr);

/*--------------------------------------------------------------------------*/
/* UtilOnDemandLoad
**
** Purpose:
**    Allows the symbol server to call the code loader so symbols for a 
**    module can be loaded on demand.
**
** Input parameters:
**    inputSymbol: a symbol descriptor to a func/block/module.  This will
**                 be used to find out if the modules symbols have been 
**                 loaded.
**
** Output parameters:
**
** Error: Reports error symbol is not a func/block/module or if the load
**        fails.
*/
/*--------------------------------------------------------------------------*/
RETCODE
UtilOnDemandLoad(SYM_DESCRIPTOR inputSymbol);


//------------------------------------------------------------------------
// UtilCmpTimestamp
//
// Purpose:
//       Return the difference between two timestamps;
//       Returns 0 if they are identical in all fields,
//          <0 if t1 < t2,
//          >0 if t1 > t2
//       where the value returned is the amount of difference, in
//       the first field where they differ.
//
// Input parameters:
//       time1: pointer to the first timestamp.
//       time2: pointer to the second timestamp.
//
// Output parameters:
//
//------------------------------------------------------------------------
S16 UtilCmpTimestamp(TIMESTAMP_TYPE *time1, TIMESTAMP_TYPE *time2);

//------------------------------------------------------------------------
// UtilDeleteTables
//
// Purpose:
//    Removes all tables and dynamically allocated memory
//
// Input parameters:
//
// Output parameters:
//
//------------------------------------------------------------------------
RETCODE UtilDeleteTables(VOID);

#define _SYMUTIL_
#endif
/******************************** E O F *************************************/
