 
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYNCORE1.CPP   1.2.1.4   17 Apr 1997 16:05:32   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYNCORE1.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:05:32   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:39:44   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:46:44   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:54   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:29:08   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:38:38   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:52:14   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:15:36   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:52   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:16:52   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:28:26   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:55:30   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:49:14   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:53:32   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:28:04   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:56:42   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:30:04   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:07:20   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:10:18   ZJRD
** EasyPack/SLD Version 1.93
** 
**    Rev 1.1   02 May 1996 10:26:56   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:10   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:35:40   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SYNCORE1.CPP
//
//  Description: The implementation file for the class: CSyntaxCore.
//
//  Author: Chen Jun
//
//  Date: 05/17/95
//
//  Modification:
//      1. 05/17/95, Initial version of the class: CSyntaxCore.
//      2. 10/10/95, Remove Stepoption command.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "syncore.h"
//Add by Annie, 3/15/96
#include "address.h"
#include "addrapi.h"
#include "ctype.h"
#include "abibase.h"
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.


/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.


/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
//Define in the Syntax.cpp
void DisplayOutOfMemory(void);
void ShowLine(char* pszBuffer);
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

 
/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCore.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::CSyntaxCore().
//
//  Description: The construction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::CSyntaxCore()
{
    // Command parsing varibles initialization.
    m_nArgc = 0;
    for ( int i = 0; i < MAX_ARGV; i++ ) {
        m_pszArgv[i] = 0;
    }

    // Syntax error ID initialization.
    m_nErrorID = 0;

}   // End of CSyntaxCore::CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::~CSyntaxCore().
//
//  Description: The destruction of the class: CSyntaxCore.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCore::~CSyntaxCore()
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc >= 0 && m_nArgc <= MAX_ARGV );

    // Release the allocated space.
    for ( int i = 0; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            delete []m_pszArgv[i];
            m_pszArgv[i] = 0;
        }
    }

}   // End of CSyntaxCore::~CSyntaxCore().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::PreStringData().
//
//  Description: Pre-process the "string" & data.
//
//  Input:  nArgc - Subscribution of the "string"/data argument.
//          nDigit - bit:1; byte:2; word:4; long:8
//
//  Output: m_nArgc & m_nArgv.
//
//  Return: FALSE - syntax error; TRUE - OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCore::PreStringData(int nArgc, unsigned uDigit)
{
    // Assertion of the input parameters.
    ASSERT( 1 == uDigit || 2 == uDigit ||
            4 == uDigit || 8 == uDigit );

    // Pre-process the "string" & data.
    BOOL isString = FALSE;
    char pszArgv[260];
    memset(pszArgv, 0, sizeof(pszArgv));

    if ( '\"' == *m_pszArgv[nArgc] ) {
        isString = TRUE;
    }

    for ( int i = nArgc; i < m_nArgc; i++ ) {
        if ( m_pszArgv[i] ) {
            if ( FALSE == isString ) {  
            	//Add by Annie, 3/20
            	if ('0' == m_pszArgv[i][0] && 
            		'X' == toupper(m_pszArgv[i][1])) {
                	if (2 == strlen(m_pszArgv[i])) { 
						m_nErrorID = SYNTAX_ERROR;                		
                		return (FALSE);             
                	}	
                	if ( strlen(m_pszArgv[i]) > (uDigit+2) ) {
                    	m_nErrorID = SYNTAX_ERROR;
                    	return (FALSE);
                	}                    
                	else {
                		for (UINT j = 0; j<strlen(m_pszArgv[i]) ; j++)
                			m_pszArgv[i][j] = m_pszArgv[i][j+2];
                	}
                	
                }
                else {        
                	char* p = m_pszArgv[i];
    				while ( *p ) {
			        	if ( !isdigit(*p) ) {     
			        		m_nErrorID = SYNTAX_ERROR;
			            	return (FALSE);
        				}                  
        				p++;
        			}                          
                	int nValue = atoi(m_pszArgv[i]);
    				itoa(nValue,m_pszArgv[i],16);  
                	if ( strlen(m_pszArgv[i]) > uDigit ) {
                    	m_nErrorID = SYNTAX_ERROR;
                    	return (FALSE);
                	}
                }	
            }
            strcat(pszArgv, m_pszArgv[i]);
            FreeMem(m_pszArgv[i]);
            if ( FALSE == isString ) {
                strcat(pszArgv, " ");
            }
            else {
                pszArgv[strlen(pszArgv)-1] = 0;
            }
        }
    }
    m_nArgc = nArgc + 1;

    //m_pszArgv[m_nArgc-1] = new char[MAX_CMDLINE+1];
    int nNewLen = MAX_CMDLINE+1;
    NewMem(m_pszArgv[m_nArgc-1], nNewLen);
    if ( !m_pszArgv[m_nArgc-1] ) {
        //AfxMessageBox("Insufficient Memory !");
        DisplayOutOfMemory();
        ASSERT( FALSE );
        return (FALSE);
    }
    else {
        memset(m_pszArgv[m_nArgc-1], 0, sizeof(m_pszArgv[m_nArgc-1]));
        for ( i = strlen(pszArgv)-1; i >= 0; i-- ) {
            if ( ' ' != pszArgv[i] ) {
                break;
            }
            else {
                pszArgv[i] = 0;
            }
        }
        if ( !isString ) {
            strcat(pszArgv, " ");
        }
        strcpy(m_pszArgv[m_nArgc-1], pszArgv);
        //DumpText(m_pszArgv[m_nArgc-1]);
    }
    
    return (TRUE);

}   // End of CSyntaxCore::PreStringData().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxDispatch().
//
//  Description: Invoke the syntax checking routine.
//
//  Input:  nCommandID - ID of the command.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
void CSyntaxCore::SyntaxDispatch(const int nCommandID)
{
    // Assertion of the input parameters.
    ASSERT( nCommandID >= MIN_CMDID && nCommandID <= MAX_CMDID );

    // Reset the error ID.
    m_nErrorID = 0;
        
    // Dispatch the syntax checking routine.
    switch ( nCommandID ) {
        case CMDID_RUNMACRO:
			SyntaxCheckRunMacro();
			break;
		case CMDID_VARDEFINE:
			SyntaxCheckVarDefine();
			break;			
		case CMDID_ALIAS:
			SyntaxCheckAlias();
			break;	
        case CMDID_ASSEMBLE:
            SyntaxCheckAssemble();
            break;
        case CMDID_BIT:
            SyntaxCheckBit();
            break;
        case CMDID_BREAKPOINT:
            SyntaxCheckBreakpoint();
            break;
        case CMDID_BYTE:
            SyntaxCheckByte();
            break;
        case CMDID_CHECKSUM:
            SyntaxCheckChecksum();
            break;
        case CMDID_CLEAR:
            SyntaxCheckClear();
            break;
        case CMDID_COMPARE:
            SyntaxCheckCompare();
            break;
        case CMDID_CONTROL:
            SyntaxCheckControl();
            break;
        case CMDID_COPY:
            SyntaxCheckCopy();
            break;
        case CMDID_CYCLE:
            SyntaxCheckCycle();
            break;
        case CMDID_DISASSEMBLE:
            SyntaxCheckDisassemble();
            break;          
        //Add by Annie, 3/7/96
        case CMDID_DIAGNOSIS:
            SyntaxCheckDiagnosis();
        	break;
        case CMDID_EVENT:
            SyntaxCheckEvent();
            break;
        case CMDID_EV1:  
            SyntaxCheckEv1();
            break;
        case CMDID_EV2:
            SyntaxCheckEv2();
            break;
        case CMDID_EV3:
            SyntaxCheckEv3();
            break;
        case CMDID_FILL:
            SyntaxCheckFill();
            break;
        case CMDID_GO:
            SyntaxCheckGo();
            break;
        case CMDID_HALT:
            SyntaxCheckHalt();
            break;
        case CMDID_HELP:
            SyntaxCheckHelp();
            break;
        case CMDID_IDENTIFY:
            SyntaxCheckIdentify();
            break;
        case CMDID_INCLUDE:
            SyntaxCheckInclude();                      
            break;
        case CMDID_INPORT:
            SyntaxCheckInport();
            break;
        case CMDID_JUMP:
            SyntaxCheckJump();
            break;
        case CMDID_LEVEL:
            SyntaxCheckLevel();
            break;
        case CMDID_LV1:
            SyntaxCheckLv1();
            break;
        case CMDID_LV2:
            SyntaxCheckLv2();
            break;
        case CMDID_LIST:
            SyntaxCheckList();
            break;
        case CMDID_LOG:
            SyntaxCheckLog();
            break;
        case CMDID_LONG:
            SyntaxCheckLong();
            break;
        case CMDID_MAP:
            SyntaxCheckMap();
            break;
        //Add by Annie, 4/1/96
        case CMDID_MACRO:
        	SyntaxCheckMacro(); 
        	break;
        case CMDID_MDEL:
        	SyntaxCheckMdel(); 
        	break;
        case CMDID_MEMORY:
            SyntaxCheckMemory();
            break;
        //Add by Annie, 4/1/96
        case CMDID_MEND:
        	SyntaxCheckMend(); 
        	break;
        case CMDID_MLIST:
        	SyntaxCheckMlist(); 
        	break;
        case CMDID_OUTPORT:
            SyntaxCheckOutport();
            break;
        case CMDID_PORT:
            SyntaxCheckPort();
            break;
        case CMDID_QUALIFY:
            SyntaxCheckQualify();
            break;
        case CMDID_REGISTER:
            SyntaxCheckRegister();
            break;
        case CMDID_RESET:
            SyntaxCheckReset();
            break;
        case CMDID_RESTART:
            SyntaxCheckRestart();
            break;
        case CMDID_SEARCH:
            SyntaxCheckSearch();
            break;
        case CMDID_STEP:
            SyntaxCheckStep();
            break;
        case CMDID_TEST:
            SyntaxCheckTest();
            break;
        case CMDID_TIMER:
            SyntaxCheckTimer();
            break;
        case CMDID_TRACE:
            SyntaxCheckTrace();
            break;
        case CMDID_TRIGGER:
            SyntaxCheckTrigger();
            break;
        case CMDID_UPLOAD:
            SyntaxCheckUpload();
            break;
        case CMDID_VERIFY:
            SyntaxCheckVerify();
            break;
        case CMDID_WORD:
            SyntaxCheckWord();
            break;
        case CMDID_CREATE:
            SyntaxCheckCreate();
            break;
        case CMDID_DELETE:
            SyntaxCheckDelete();
            break;
        case CMDID_LOAD:
            SyntaxCheckLoad();
            break;
        case CMDID_QUERY:
            SyntaxCheckQuery();
            break;
        case CMDID_SSAVE:
            SyntaxCheckSsave();
            break;
        case CMDID_SRECALL:
            SyntaxCheckSrecall();
            break;
        case CMDID_SYMBOL:
            SyntaxCheckSymbol();
            break;
        case CMDID_WATCH:
            SyntaxCheckWatch();
            break;
    #ifdef _CHEN_
        case CMDID_CALCULATE:
            SyntaxCheckCalculate();
            break;
    #endif  // _CHEN_

    #ifdef _GATES
        case CMDID_COUNT:
            SyntaxCheckCount();
            break;
        case CMDID_LINE:
            SyntaxCheckLine();
            break;
        case CMDID_STATEMENT:
            SyntaxCheckStatement();
            break;
        case CMDID_VOID:
            SyntaxCheckVoid();
            break;
        case CMDID_TYPE:
            SyntaxCheckType();
            break;
    #endif  // _GATES

		case CMDID_FW:                        
			break;
        default:
            ASSERT( FALSE );
            break;
    }
    
}   // End of CSyntaxCore::SyntaxDispatch().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCore::SyntaxCheck***().
//
//  Description: Syntax check kernel routine. 58 routines.
//
//  Input:  m_nArgc - The number of the command parameters.
//          m_pszArgv[nArgc] - The contents of the command parameters.
//
//  Output: m_nErrorID - ID of the syntax error.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
//@macroname 	[(arg0,...,arg9)]
void CSyntaxCore::SyntaxCheckRunMacro(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    char* p = new char[260];  
    int nRet = 0;
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
            strcpy(p,m_pszArgv[0]+1);
            if ( !IsFilename(p, nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
            }
            break;
		default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    delete []p;
	p = 0;                                    

}	//End of CSyntaxCore::SyntaxCheckRunMacro().                  
                  
//$variable = value
void CSyntaxCore::SyntaxCheckVarDefine(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc = 1 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	
	if ('$' != m_pszArgv[0][0])           
		m_nErrorID = SYNTAX_ERROR;
}                  

// Alias [original_name new_name]
void CSyntaxCore::SyntaxCheckAlias(void)    
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
    	case 1:
    		break;
        case 3:
        	if ( !IsCommandName(m_pszArgv[1]) ||
				 !IsCommandName(m_pszArgv[2]) ) {
				m_nErrorID = SYNTAX_ERROR;			
			}					        		 
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
	}        

}                           
                               
// Assemble     [adr]
void CSyntaxCore::SyntaxCheckAssemble(void)
{   
    char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_PROGRAME)) {
              	m_nErrorID = nRet;
            	break;
            }                                 
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);                                  
        	if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            	break;
            }   
        	break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    
    if (szArgv) {
    	delete []szArgv;
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckAssemble().

// Bit          bit-adr {0|1} [..{0|1}]
void CSyntaxCore::SyntaxCheckBit(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 1) ) {
        return;
    }

    char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);
    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:    
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_BIT)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
                break;
            }
            if ( !IsBAddr(m_pszArgv[1]) && !IsBAddrDefault(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;            	
            }
            if ( !IsDataBit(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
            if ( !IsBitRange(m_pszArgv[1], m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }                     
        	break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;    
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckBit().


// BReakpoint   [adr]
void CSyntaxCore::SyntaxCheckBreakpoint(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.

    char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }                      
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
        	break;

        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;                   
    	szArgv = 0;
    }	
    
}   // End of CSyntaxCore::SyntaxCheckBreakpoint().


// Byte         adr data1 [.. data32]
void CSyntaxCore::SyntaxCheckByte(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Pre-process the field: "string" & Data.
    if ( m_nArgc < 3 ) {
        m_nErrorID = SYNTAX_ERROR;
        return;
    }
    
    int nArgc = 2;
    if ( !PreStringData(nArgc, 2) ) { 
    	m_nErrorID = SYNTAX_ERROR;
        return;
    }

    // Check command syntax.      
    char* szArgv;
    szArgv = new char[260];
    ASSERT(szArgv);
    switch ( m_nArgc ) {
        case 3:
            if (!ConvertAddress(m_pszArgv[1], szArgv, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }                
            if (IsBAddr(szArgv)) {
            	if( !IsDataBit(m_pszArgv[2])) {
            		m_nErrorID = SYNTAX_ERROR;
                	break;
            	}                 
            }	
            else if ( !IsData(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }
            if ( !IsDataRange(m_nArgc, m_pszArgv, 1) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }    
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);
        	
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsRAddr(m_pszArgv[1]) &&
                 !IsBAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            } 
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckByte().


// CHecksum     adr1 {adr2|Length length}
void CSyntaxCore::SyntaxCheckChecksum(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 3:                                 
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2], SPACE_EXTERNAL);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                     
			                                         
			NewMem(m_pszArgv[1], strlen(szArgv1)+1);
			NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
            
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }
            break;
        case 4:
        	if ( !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
				m_nErrorID = nRet;                
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsIAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }                               
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	

}   // CSyntaxCore::SyntaxCheckChecksum().


// CLear        {All|adr}
void CSyntaxCore::SyntaxCheckClear(void)
{
	char* szArgv;
    szArgv = new char[260]; 
    ASSERT(szArgv);

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 2:         
        	if ( IsKeywordAll(m_pszArgv[1]) ) {
            	break;    
            }                     
	        if (!ConvertAddress(m_pszArgv[1], szArgv, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            
            NewMem(m_pszArgv[1], strlen(szArgv)+1);
            strcpy(m_pszArgv[1],szArgv);                                  
            if ( !IsPAddr(m_pszArgv[1]) && 
                 !IsPAddrDefault(m_pszArgv[1])) {                 
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
            
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv) {
    	delete []szArgv;    
    	szArgv = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckClear().


// COMpare      adr1 {adr2|Length length} adr3
void CSyntaxCore::SyntaxCheckCompare(void)
{
	char* szArgv1;
    char* szArgv2; 
    char* szArgv3;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
	szArgv3 = new char[260];         
    ASSERT(szArgv3);
    ADDR_RETCODE retCode;
    
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
        	retCode = AdrShlCheck2Addr(m_pszArgv[1], m_pszArgv[2], SPACE_EXTERNAL);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                     
            if (!ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
                m_nErrorID = LEN_OUT_OF_RANGE;
                break;
            }                             
            if ( !IsPAddr(szArgv1) && 
                 !IsXAddr(szArgv1) &&
                 !IsXAddrDefault(szArgv1) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            else if ( !IsPAddr(szArgv3) &&
                      !IsXAddr(szArgv3) &&
                      !IsXAddrDefault(szArgv3) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }                                
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            NewMem(m_pszArgv[3], strlen(szArgv3)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
            strcpy(m_pszArgv[3],szArgv3); 
            break;                                          
        
        case 5:                              
        	if (  !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet, SPACE_EXTERNAL)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            } 
            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;                    
                m_nErrorID = nRet;                
                break;
            }                                                               
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
        	
            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
            strcpy(m_pszArgv[4],szArgv3);            
        	break;

        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
	if (szArgv2) {
		delete []szArgv2;
		szArgv2 = 0;
	}	
    if (szArgv3) {
    	delete []szArgv3;    
    	szArgv3 = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckCompare().


// CONtrol      [ {Reset|Ea|Eben} {Enable|Disable} ]
void CSyntaxCore::SyntaxCheckControl(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }

    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 3:
            if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            else if ( !IsKeywordEnable(m_pszArgv[2]) && 
                      !IsKeywordDisable(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckControl().


// Copy         adr1 {adr2|Length length} adr3
void CSyntaxCore::SyntaxCheckCopy(void)
{
	char* szArgv1;
    char* szArgv2; 
    char* szArgv3;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
	szArgv3 = new char[260];         
    ASSERT(szArgv3);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 4:
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2], SPACE_EXTERNAL);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_EXTERNAL)) {
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	m_nErrorID = nRet;
            	break;
            }	                                     
            if (!ConvertAddress(m_pszArgv[3], szArgv3, nRet, SPACE_EXTERNAL)) {
              	m_nErrorID = nRet;
            	break;
            }
            if ( !IsAddrRange(szArgv1, szArgv2, szArgv3) ) {
                m_nErrorID = SYNTAX_ERROR;
                break;
            }                             
            if ( !IsPAddr(szArgv1) && 
                 !IsXAddr(szArgv1) &&
                 !IsIAddr(szArgv1) &&                  
                 !IsXAddrDefault(szArgv1) ) {
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            else if ( !IsPAddr(szArgv3) &&
                      !IsXAddr(szArgv3) &&
                      !IsIAddr(szArgv3) &&
                      !IsXAddrDefault(szArgv3) ) {
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }                                
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            NewMem(m_pszArgv[3], strlen(szArgv3)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
            strcpy(m_pszArgv[3],szArgv3); 
            break;                                          
        
        case 5:
        	if (  !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet) ) {
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_EXTERNAL)) {
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[4], szArgv3, nRet, SPACE_EXTERNAL)) {
              	m_nErrorID = nRet;
            	break;
            } 
            if ( !IsLengthRange(szArgv2, m_pszArgv[3], szArgv3, nRet) ) {
                m_nErrorID = nRet;                
                break;
            }
            if ( !IsPAddr(szArgv2) &&
                 !IsXAddr(szArgv2) &&                  
                 !IsIAddr(szArgv2) &&                  
                 !IsXAddrDefault(szArgv2) ) {
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }
            else if ( !IsPAddr(szArgv3) &&
                      !IsXAddr(szArgv3) &&             
                      !IsIAddr(szArgv3) &&                  
                      !IsXAddrDefault(szArgv3) ) {
                m_nErrorID = ADDR_TYPE_ERROR;
                break;
            }                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
        	
            NewMem(m_pszArgv[4], strlen(szArgv3)+1);
            strcpy(m_pszArgv[4],szArgv3);            
        	break;

        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
    if (szArgv2) {
    	delete []szArgv2;    
    	szArgv2 = 0;
    }	
    if (szArgv3) {
    	delete []szArgv3;            
    	szArgv3 = 0;
    }	
}   // End of CSyntaxCore::SyntaxCheckCopy().


// CYcle
void CSyntaxCore::SyntaxCheckCycle(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckCycle().

// Disassemble  [adr1 [adr2|Length length]]
void CSyntaxCore::SyntaxCheckDisassemble(void)
{
	char* szArgv1;
    char* szArgv2;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1);
    szArgv2 = new char[260];         
    ASSERT(szArgv2);
    ADDR_RETCODE retCode;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
	        if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
			
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }
            break;
            
        case 3:      
        	retCode = AdrShlCheck2Addr(m_pszArgv[1],m_pszArgv[2], SPACE_PROGRAME);
            if (ADR_OK != retCode) {       
            	//m_nErrorID = SYNTAX_ERROR;
            	m_nErrorID = NOT_SHOW_ERROR;
            	break;
            }	                              
            if (!ConvertAddress(m_pszArgv[1], szArgv1, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	
            if (!ConvertAddress(m_pszArgv[2], szArgv2, nRet)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                     
            NewMem(m_pszArgv[1], strlen(szArgv1)+1);
            NewMem(m_pszArgv[2], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv1);                                  
            strcpy(m_pszArgv[2],szArgv2); 
            
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsPAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            }
            break;                                          

        case 4:
        	if (  !IsKeywordLength(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            	break;
            }
            if ( !IsAddrLen(m_pszArgv[3], nRet) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;
                break;
            }   
            if ( !IsLengthRange(m_pszArgv[1], m_pszArgv[3], nRet, SPACE_PROGRAME) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = nRet;                
            	break;
            }                     
            if (!ConvertAddress(m_pszArgv[1], szArgv2, nRet, SPACE_PROGRAME)) {
              	//m_nErrorID = SYNTAX_ERROR;
              	m_nErrorID = nRet;
            	break;
            }	                                                                
            NewMem(m_pszArgv[1], strlen(szArgv2)+1);
            strcpy(m_pszArgv[1],szArgv2);                                  
            
            ConvertLen(m_pszArgv[3], szArgv1);
           	NewMem(m_pszArgv[3], strlen(szArgv1)+1);
            strcpy(m_pszArgv[3],szArgv1);                                  
            if ( !IsPAddr(m_pszArgv[1]) &&
                 !IsXAddr(m_pszArgv[1]) &&
                 !IsXAddrDefault(m_pszArgv[1]) ) {
                //m_nErrorID = SYNTAX_ERROR;
                m_nErrorID = ADDR_TYPE_ERROR;
            } 
            break;

        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
    if (szArgv1) {
    	delete []szArgv1;    
    	szArgv1 = 0;
    }	
    if (szArgv2) {
    	delete []szArgv2;    
    	szArgv2 =0;
    }	
}   // End of CSyntaxCore::SyntaxCheckDisassemble().
                               
//Add by Annie, 3/7/96
//!DIAgnotics [ [PIO] [MAP] [EVENTADDR] [EVENTDATA] [SPOON] [EMULATION] [TRACE] ]
void CSyntaxCore::SyntaxCheckDiagnosis(void)
{            
	// Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
	
    // Check command syntax.
    switch ( m_nArgc ) {
	    case 1:        
            break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:                    
            if ( !IsDiagnosisOption(m_nArgc, m_pszArgv) ) {
	                m_nErrorID = SYNTAX_ERROR;
	        }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }
}  //End of CSyntacCore::SyntaxCheckDiagnosis()

// Event        [CLear]
// Event 1 ... = EV1 ...
// Event 2 ... = EV2 ...
// Event 3 ... = EV3 ...
void CSyntaxCore::SyntaxCheckEvent(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1); 
    ADDR_RETCODE retCode;    

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        return;
    }
    else if ( 1 == m_nArgc ) {
        delete []szArgv1;
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) && 
             !IsEventID(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        delete []szArgv1;        
        return;
    }
    else if ( 3 == m_nArgc ) {
        if ( !IsEventID(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }
        else if ( 0 == stricmp(m_pszArgv[1],"3") ) {
            if ( !IsKeywordHigh(m_pszArgv[2]) &&
                 !IsKeywordLow(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
        }
        else {
            if ( !IsKeywordClear(m_pszArgv[2]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
        }                
        delete []szArgv1;        
        return;
    }
    else {
        if ( 0 == stricmp(m_pszArgv[1], "1") ) {
            // Event 1 ...
            // Check m_pszArgv[2].
            if ( 0 != stricmp(m_pszArgv[2], "ADDRESS") &&
                 0 != stricmp(m_pszArgv[2], "DATUM") &&
                 0 != stricmp(m_pszArgv[2], "STATUS") &&
                 0 != stricmp(m_pszArgv[2], "COUNT") ) {
                m_nErrorID = SYNTAX_ERROR;
        		delete []szArgv1;                
                return;
            }
            
            // Initial flag.
            BOOL isA = FALSE;
            BOOL isD = FALSE;
            BOOL isS = FALSE;
            BOOL isC = FALSE;
            int nIndex = 2;
    
            // Check m_pszArgv[].
            while ( nIndex < m_nArgc ) {
                if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                    // "ADDRESS...".
                    if ( isA ) {
                        m_nErrorID = SYNTAX_ERROR;
        				delete []szArgv1;                        
                        return;
                    }
                    else {
                        isA = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
        				delete []szArgv1;                        
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
			        	retCode = AdrShlCheck2Addr(m_pszArgv[nIndex],
			        			  m_pszArgv[nIndex+1], SPACE_PROGRAME);
			            if (ADR_OK != retCode) {       
			            	//m_nErrorID = SYNTAX_ERROR;
			            	m_nErrorID = NOT_SHOW_ERROR;
			            	break;
			            }			        
				        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
				        	, SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
        					delete []szArgv1;			              	
			            	return;
			            }		            
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = ADDR_TYPE_ERROR;
        					delete []szArgv1;                            
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
        						delete []szArgv1;                                
                                return;
                            }
	                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
	                        	, SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				              	m_nErrorID = nRet;
        						delete []szArgv1;				              	
				            	return;
				            }		            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                            if ( !IsPAddr(m_pszArgv[nIndex]) &&
                                 !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                //m_nErrorID = SYNTAX_ERROR;
                                m_nErrorID = ADDR_TYPE_ERROR;
        						delete []szArgv1;                                
                                return;
                            }
                            else {
                                nIndex++;
                            }
                        }
                    }
		            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
		            		, SPACE_PROGRAME)) {
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                	if ( IsPAddr(m_pszArgv[nIndex]) ||
	                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
		                    nIndex++;
		                    if ( nIndex >= m_nArgc ) {
		                        delete []szArgv1;
		                        return;
		                    }
		                    for ( int i = 2; i <= 10; i++ ) {
								if (!ConvertAddress(m_pszArgv[nIndex], 
									szArgv1, nRet, SPACE_PROGRAME)) {
					              	//m_nErrorID = SYNTAX_ERROR;
					            	//return;
					            	break;
					            }		            
					            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[nIndex],szArgv1);                                  
		                                            
		                        if ( IsPAddr(m_pszArgv[nIndex]) ||
		                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
		                            nIndex++;
		                            if ( nIndex >= m_nArgc ) {
		                                delete []szArgv1;
		                                return;
		                            }
		                        }
		                        else {
		                            break;
		                        }
		                   	}                                   
	                	}   
	                }
                    else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        nIndex++;
                    } 
                    else {
                        m_nErrorID = SYNTAX_ERROR;       
                        delete []szArgv1;
                        return;
                    }
                }   // End of "ADDRESS...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                    // "DATUM...".
                    if ( isD ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isD = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                            else {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                        }
                    }
                    else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {   
                        	delete []szArgv1;
                            return;
                        }
                    }
                    else if ( IsEventData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                        	delete []szArgv1;
                            return;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                }   // End of "DATUM...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                    // "STATUS...".
                    if ( isS ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isS = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    // Is "S", "F", "R", "W" or "AK".
                    BOOL isStatusS = FALSE;
                    BOOL isStatusF = FALSE;
                    BOOL isStatusR = FALSE;
                    BOOL isStatusW = FALSE;
                    BOOL isStatusAK = FALSE;
    
                    if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                        isStatusS = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                        isStatusF = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                        isStatusR = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                        isStatusW = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                        isStatusAK = TRUE;
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
    
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                    for ( int j = 2; j <= 5; j++ ) {
                        if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                            if ( !isStatusS ) {
                                isStatusS = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                            if ( !isStatusF ) {
                                isStatusF = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;	
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                            if ( !isStatusR ) {
                                isStatusR = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                            if ( !isStatusW ) {
                                isStatusW = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                            if ( !isStatusAK ) {
                                isStatusAK = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }   // End of "STATUS...".
                
                else if ( 0 == stricmp(m_pszArgv[nIndex], "COUNT") ) {
                    // "COUNT...".
                    if ( isC ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isC = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( IsAddrData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                        	delete []szArgv1;
                            return;
                        }
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                }   // End of "COUNT...".
                
                else {
                    // Not "A", "D", "S" or "C".
                    //m_nErrorID = SYNTAX_ERROR;
	                if (isA)                    
	                	m_nErrorID = ADDR_ERROR;
	                if (isD)	                
	                	m_nErrorID = DATA_ERROR;
	                if (isS)                    
	                	m_nErrorID = STATUS_ERROR;
	                if (isC)	                
	                	m_nErrorID = COUNT_ERROR;                	
                    delete []szArgv1;
                    return;
                }
                
            }   // End of while()...
        }   // End of Event 1.
        
        else if ( 0 == stricmp(m_pszArgv[1], "2") ) {
            // Event 2 ...    
            // Check m_pszArgv[1].
            if ( 0 != stricmp(m_pszArgv[2], "ADDRESS") &&
                 0 != stricmp(m_pszArgv[2], "DATUM") &&
                 0 != stricmp(m_pszArgv[2], "STATUS") ) {
                m_nErrorID = SYNTAX_ERROR;
                delete []szArgv1;
                return;
            }
            
            // Initial flag.
            BOOL isA = FALSE;
            BOOL isD = FALSE;
            BOOL isS = FALSE;
            int nIndex = 2;
    
            // Check m_pszArgv[].
            while ( nIndex < m_nArgc ) {
                if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                    // "ADDRESS...".
                    if ( isA ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isA = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
			        	retCode = AdrShlCheck2Addr(m_pszArgv[nIndex],
			        			m_pszArgv[nIndex+1], SPACE_PROGRAME);
			            if (ADR_OK != retCode) {       
			            	//m_nErrorID = SYNTAX_ERROR;
			            	m_nErrorID = NOT_SHOW_ERROR;
			            	break;
			            }			        
				        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet, SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
			              	delete []szArgv1;
			            	return;
			            }		            
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
	                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
	                        	, SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				              	m_nErrorID = nRet;
				              	delete []szArgv1;
				            	return;
				            }		            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                            if ( !IsPAddr(m_pszArgv[nIndex]) &&
                                 !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                            else {
                                nIndex++;
                            }
                        }
                    }
		            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
		            	, SPACE_PROGRAME)) {
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                	if ( IsPAddr(m_pszArgv[nIndex]) ||
	                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
		                    nIndex++;
		                    if ( nIndex >= m_nArgc ) {
		                    	delete []szArgv1;
		                        return;
		                    }
		                    for ( int i = 2; i <= 10; i++ ) {
								if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
									, SPACE_PROGRAME)) {
					              	//m_nErrorID = SYNTAX_ERROR;
					            	//return;
					            	break;
					            }		            
					            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
					            strcpy(m_pszArgv[nIndex],szArgv1);                                  
		                                            
		                        if ( IsPAddr(m_pszArgv[nIndex]) ||
		                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
		                            nIndex++;
		                            if ( nIndex >= m_nArgc ) {
		                            	delete []szArgv1;
		                                return;
		                            }
		                        }
		                        else {
		                            break;
		                        }
		                   	}                                   
	                	}   
	                }
                    else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        nIndex++;
                    } 
                    else {
                        m_nErrorID = SYNTAX_ERROR;       
                        delete []szArgv1;
                        return;
                    }
                }   // End of "ADDRESS...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                    // "DATUM...".
                    if ( isD ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isD = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                            else {
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                        }
                    } 
                    else if ( IsEventData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {   
                        	delete []szArgv1;
                            return;
                        }
                    }
                    else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                        	delete []szArgv1;
                            return;
                        }
                    } 
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                }   // End of "DATUM...".
    
                else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                    // "STATUS...".
                    if ( isS ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        isS = TRUE;
                    }
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    // Is "S", "F", "R", "W" or "AK".
                    BOOL isStatusS = FALSE;
                    BOOL isStatusF = FALSE;
                    BOOL isStatusR = FALSE;
                    BOOL isStatusW = FALSE;
                    BOOL isStatusAK = FALSE;
    
                    if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                        isStatusS = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                        isStatusF = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                        isStatusR = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                        isStatusW = TRUE;
                    }
                    else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                        isStatusAK = TRUE;
                    }
                    else {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
    
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                    for ( int j = 2; j <= 5; j++ ) {
                        if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                            if ( !isStatusS ) {
                                isStatusS = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                            if ( !isStatusF ) {
                                isStatusF = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                            if ( !isStatusR ) {
                                isStatusR = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                            if ( !isStatusW ) {
                                isStatusW = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                            if ( !isStatusAK ) {
                                isStatusAK = TRUE;
                                nIndex++;
                                if ( nIndex >= m_nArgc ) {
                                	delete []szArgv1;
                                    return;
                                }
                            }
                            else {
                                m_nErrorID = SYNTAX_ERROR;
                                delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            break;
                        }
                    }
                }   // End of "STATUS...".
                
                else {
                    // Not "A", "D", or "S".
                    //m_nErrorID = SYNTAX_ERROR;
	                if (isA)                    
	                	m_nErrorID = ADDR_ERROR;
	                if (isD)	                
	                	m_nErrorID = DATA_ERROR;
	                if (isS)                    
	                	m_nErrorID = STATUS_ERROR;
                    delete []szArgv1;
                    return;
                }
                
            }   // End of while()...
        }   // End of Event 2.
        
        else {
            m_nErrorID = SYNTAX_ERROR;           
            delete []szArgv1;
            return;
        }
    }
	if (szArgv1) {
		delete []szArgv1;
		szArgv1 = 0;
	}	
}   // CSyntaxCore::SyntaxCheckEvent().


// EV1          [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] 
//              [COUNT datum] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckEv1(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1); 
    ADDR_RETCODE retCode;       
    //int nRet;

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        return;
    }
    else if ( 1 == m_nArgc ) {
    	delete []szArgv1;
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }                
        delete []szArgv1;
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") &&
             0 != stricmp(m_pszArgv[1], "COUNT") ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        BOOL isC = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {  
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }                      
		        	retCode = AdrShlCheck2Addr(m_pszArgv[nIndex],
		        			m_pszArgv[nIndex+1], SPACE_PROGRAME);
		            
		            if (ADR_OK != retCode) {       
		            	//m_nErrorID = SYNTAX_ERROR;
		            	m_nErrorID = NOT_SHOW_ERROR;
		            	break;
		            }			        
			        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
			        	SPACE_PROGRAME)) {
		              	//m_nErrorID = SYNTAX_ERROR;
		              	m_nErrorID = nRet;
		              	delete []szArgv1;
		            	return;
		            }		            
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        //m_nErrorID = SYNTAX_ERROR;
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }    
                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
                        	SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
			              	delete []szArgv1;
			            	return;
			            }		            
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                        
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = ADDR_TYPE_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
	            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
	            		 SPACE_PROGRAME)) {
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                	if ( IsPAddr(m_pszArgv[nIndex]) ||
                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( nIndex >= m_nArgc ) {
	                    	delete []szArgv1;
	                        return;
	                    }
	                    for ( int i = 2; i <= 10; i++ ) {
							if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet,
								 SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				            	//return;
				            	break;
				            }		            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                                            
	                        if ( IsPAddr(m_pszArgv[nIndex]) ||
	                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                            nIndex++;
	                            if ( nIndex >= m_nArgc ) {
	                            	delete []szArgv1;
	                                return;
	                            }
	                        }
	                        else {
	                            break;
	                        }
	                   	}                                   
                	}   
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                } 
                else {
                    //m_nErrorID = SYNTAX_ERROR;   //NOTE    
                    m_nErrorID = ADDR_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        //m_nErrorID = SYNTAX_ERROR;
                        m_nErrorID = DATA_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = DATA_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                    }
                }                  
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {   
                    	delete []szArgv1;
                        return;
                    }
                }
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                } 
                else {
                    //m_nErrorID = SYNTAX_ERROR; //NOTE
                    m_nErrorID = DATA_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = STATUS_ERROR;
                    delete []szArgv1;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                	delete []szArgv1;
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = STATUS_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = STATUS_ERROR;
                            delete []szArgv1;	
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = STATUS_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = STATUS_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = STATUS_ERROR;
                            delete []szArgv1;	
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            
            else if ( 0 == stricmp(m_pszArgv[nIndex], "COUNT") ) {
                // "COUNT...".
                if ( isC ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isC = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsAddrData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                }
                else {
                    //m_nErrorID = SYNTAX_ERROR;
                    m_nErrorID = COUNT_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "COUNT...".
            
            else {
                // Not "A", "D", "S" or "C".
                //m_nErrorID = SYNTAX_ERROR;
                if (isA)                    
                	m_nErrorID = ADDR_ERROR;
                if (isD)	                
                	m_nErrorID = DATA_ERROR;
                if (isS)                    
                	m_nErrorID = STATUS_ERROR;
                if (isC)	                
                	m_nErrorID = COUNT_ERROR;                	
                delete []szArgv1;
                return;
            }
        }   // End of while()...
    }   // End of else...
	if (szArgv1) {
		delete []szArgv1;
		szArgv1 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckEv1().


// EV2          [ [ADDRESS {Range adr1 adr2|xadr|badrs..}] 
//              [DATUM {Range data1 data2|xdata|bdatum}] 
//              [STATUS status..] ] |
//              [CLear]
//
//              Note: where <status> is: S, F, R, W, AK; 10 badrs.
void CSyntaxCore::SyntaxCheckEv2(void)
{
	char* szArgv1;
    szArgv1 = new char[260]; 
    ASSERT(szArgv1); 
    ADDR_RETCODE retCode;    

    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    if ( m_nArgc < 1 ) {
        m_nErrorID = SYNTAX_ERROR;
        delete []szArgv1;
        return;
    }
    else if ( 1 == m_nArgc ) {
    	delete []szArgv1;
        return;
    }
    else if ( 2 == m_nArgc ) {
        if ( !IsKeywordClear(m_pszArgv[1]) ) {
            m_nErrorID = SYNTAX_ERROR;
        }                
        delete []szArgv1;
        return;
    }
    else {  // m_nArgc >= 3.
        // Check m_pszArgv[1].
        if ( 0 != stricmp(m_pszArgv[1], "ADDRESS") &&
             0 != stricmp(m_pszArgv[1], "DATUM") &&
             0 != stricmp(m_pszArgv[1], "STATUS") ) {
            m_nErrorID = SYNTAX_ERROR;
            delete []szArgv1;
            return;
        }
        
        // Initial flag.
        BOOL isA = FALSE;
        BOOL isD = FALSE;
        BOOL isS = FALSE;
        int nIndex = 1;

        // Check m_pszArgv[].
        while ( nIndex < m_nArgc ) {
            if ( 0 == stricmp(m_pszArgv[nIndex], "ADDRESS") ) {
                // "ADDRESS...".
                if ( isA ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isA = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
		        	retCode = AdrShlCheck2Addr(m_pszArgv[nIndex],
		        			m_pszArgv[nIndex+1], SPACE_PROGRAME);
		            if (ADR_OK != retCode) {       
		            	//m_nErrorID = SYNTAX_ERROR;
		            	m_nErrorID = NOT_SHOW_ERROR;
		            	break;
		            }			        
			        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
			        	, SPACE_PROGRAME)) {
		              	//m_nErrorID = SYNTAX_ERROR;
		              	m_nErrorID = nRet;
		              	delete []szArgv1;
		            	return;
		            }		            
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                    if ( !IsPAddr(m_pszArgv[nIndex]) &&
                         !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                        //m_nErrorID = SYNTAX_ERROR;
                        m_nErrorID = ADDR_TYPE_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
                        	, SPACE_PROGRAME)) {
			              	//m_nErrorID = SYNTAX_ERROR;
			              	m_nErrorID = nRet;
			              	delete []szArgv1;
			            	return;
			            }		            
			            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
			            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                        if ( !IsPAddr(m_pszArgv[nIndex]) &&
                             !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                            //m_nErrorID = SYNTAX_ERROR;
                            m_nErrorID = ADDR_TYPE_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                        }
                    }
                }
	            else if (ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
	            		, SPACE_PROGRAME)) {
		            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
		            strcpy(m_pszArgv[nIndex],szArgv1);                                  
                	if ( IsPAddr(m_pszArgv[nIndex]) ||
                         IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                    nIndex++;
	                    if ( nIndex >= m_nArgc ) {
	                    	delete []szArgv1;
	                        return;
	                    }
	                    for ( int i = 2; i <= 10; i++ ) {
							if (!ConvertAddress(m_pszArgv[nIndex], szArgv1, nRet
								, SPACE_PROGRAME)) {
				              	//m_nErrorID = SYNTAX_ERROR;
				            	//return;
				            	break;
				            }		            
				            NewMem(m_pszArgv[nIndex], strlen(szArgv1)+1);
				            strcpy(m_pszArgv[nIndex],szArgv1);                                  
	                                            
	                        if ( IsPAddr(m_pszArgv[nIndex]) ||
	                             IsPAddrDefault(m_pszArgv[nIndex]) ) {
	                            nIndex++;
	                            if ( nIndex >= m_nArgc ) {
	                            	delete []szArgv1;
	                                return;
	                            }
	                        }
	                        else {
	                            break;
	                        }
	                   	}                                   
                	}   
                }
                else if ( IsWildcardAddr(m_pszArgv[nIndex]) ) {
                    nIndex++;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;       
                    delete []szArgv1;
                    return;
                }
            }   // End of "ADDRESS...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "DATUM") ) {
                // "DATUM...".
                if ( isD ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isD = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    if ( !IsEventData(m_pszArgv[nIndex]) ) {
                        m_nErrorID = SYNTAX_ERROR;
                        delete []szArgv1;
                        return;
                    }
                    else {
                        nIndex++;
                        if ( nIndex >= m_nArgc ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        if ( !IsEventData(m_pszArgv[nIndex]) ) {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                        else {
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                    }
                }
                else if ( IsEventData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {   
                    	delete []szArgv1;
                        return;
                    }
                } 
                else if ( IsWildcardData(m_pszArgv[nIndex]) ) {
                    nIndex++;
                    if ( nIndex >= m_nArgc ) {
                    	delete []szArgv1;
                        return;
                    }
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
            }   // End of "DATUM...".

            else if ( 0 == stricmp(m_pszArgv[nIndex], "STATUS") ) {
                // "STATUS...".
                if ( isS ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                else {
                    isS = TRUE;
                }
                nIndex++;
                if ( nIndex >= m_nArgc ) {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }
                // Is "S", "F", "R", "W" or "AK".
                BOOL isStatusS = FALSE;
                BOOL isStatusF = FALSE;
                BOOL isStatusR = FALSE;
                BOOL isStatusW = FALSE;
                BOOL isStatusAK = FALSE;

                if ( !stricmp(m_pszArgv[nIndex],"S") && !isStatusS ) {
                    isStatusS = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"F") && !isStatusF ) {
                    isStatusF = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"R") && !isStatusR ) {
                    isStatusR = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"W") && !isStatusW ) {
                    isStatusW = TRUE;
                }
                else if ( !stricmp(m_pszArgv[nIndex],"AK") && !isStatusAK ) {
                    isStatusAK = TRUE;
                }
                else {
                    m_nErrorID = SYNTAX_ERROR;
                    delete []szArgv1;
                    return;
                }

                nIndex++;
                if ( nIndex >= m_nArgc ) {
                	delete []szArgv1;
                    return;
                }
                for ( int j = 2; j <= 5; j++ ) {
                    if ( 0 == stricmp(m_pszArgv[nIndex], "S") ) {
                        if ( !isStatusS ) {
                            isStatusS = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "F") ) {
                        if ( !isStatusF ) {
                            isStatusF = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "R") ) {
                        if ( !isStatusR ) {
                            isStatusR = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "W") ) {
                        if ( !isStatusW ) {
                            isStatusW = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else if ( 0 == stricmp(m_pszArgv[nIndex], "AK") ) {
                        if ( !isStatusAK ) {
                            isStatusAK = TRUE;
                            nIndex++;
                            if ( nIndex >= m_nArgc ) {
                            	delete []szArgv1;
                                return;
                            }
                        }
                        else {
                            m_nErrorID = SYNTAX_ERROR;
                            delete []szArgv1;
                            return;
                        }
                    }
                    else {
                        break;
                    }
                }
            }   // End of "STATUS...".
            else {
                // Not "A", "D", or "S".
                //m_nErrorID = SYNTAX_ERROR;   
                if (isA)                    
                	m_nErrorID = ADDR_ERROR;
                if (isD)	                
                	m_nErrorID = DATA_ERROR;
                if (isS)                    
                	m_nErrorID = STATUS_ERROR;
                //if (isC)	                
                //	m_nErrorID = COUNT_ERROR;                	
                delete []szArgv1;
                return;
            }
        }   // End of while()...
    }   // End of else...
	if (szArgv1) {
		delete []szArgv1;
		szArgv1 = 0;
	}	
}   // End of CSyntaxCore::SyntaxCheckEv2().


// EV3          [High|Low]
void CSyntaxCore::SyntaxCheckEv3(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nArgc > 0 );
    ASSERT( 0 == m_nErrorID );
    for ( int i = 0; i < m_nArgc; i++ ) {
        ASSERT( m_pszArgv[i] );
    }
    
    // Check command syntax.
    switch ( m_nArgc ) {
        case 1:
            break;
        case 2:
            if ( !IsKeywordHigh(m_pszArgv[1]) &&
                 !IsKeywordLow(m_pszArgv[1]) ) {
                m_nErrorID = SYNTAX_ERROR;
            }
            break;
        default:
            m_nErrorID = SYNTAX_ERROR;
            break;
    }

}   // End of CSyntaxCore::SyntaxCheckEv3().

void CSyntaxCore::FreeMem(char* &pszBuffer)
{
	if (pszBuffer != 0) {
		delete []pszBuffer;
		pszBuffer = 0;
	}	
}    

void CSyntaxCore::NewMem(char* &pszBuffer, int nLen)
{
	FreeMem(pszBuffer);
	pszBuffer = new char[nLen+2];
	if (!pszBuffer) {
		//AfxMessageBox("Insufficient Memory !");
		DisplayOutOfMemory();
	}

}
//////////////////////////////// End of File ////////////////////////////////
