/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/TOOLWND.CPP   1.2.1.4   17 Apr 1997 16:06:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/TOOLWND.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:06:46   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:41:40   ZJRD
** 2.09F
** 
****************************************************************************/

// toolwnd.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "UICOM.H"
#include "toolwnd.h"
#include "hwtip.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                   

extern BOOL browseOpenSwitch;
DWORD  dwDelay=0;

#define CHICKDELAY 2000
#undef  USE_DELAY
/////////////////////////////////////////////////////////////////////////////
// CToolWnd

CToolWnd::CToolWnd()
{  
    m_pLeftBtn =new CToolButton();
    m_pRightBtn=new CToolButton();
    m_pSource  =new CToolButton();
    m_pMixed   =new CToolButton();
    m_pAsm     =new CToolButton();
}

CToolWnd::~CToolWnd()
{        
    delete m_pLeftBtn; 
    delete m_pRightBtn;
    delete m_pSource;  
    delete m_pMixed;
    delete m_pAsm;      
}
                
BOOL CToolWnd::PreTranslateMessage(MSG *pMsg)
{      
#ifdef USE_DELAY
  if(pMsg->message==WM_LBUTTONDOWN && (dwDelay+CHICKDELAY)>GetTickCount())
     return TRUE;
#endif
     
  return CWnd::PreTranslateMessage(pMsg);   
}

BOOL CToolWnd::Create(CWnd *pParent)
{
 const char * pszBrowseClass =
              AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW , 
                                 ::LoadCursor(NULL,IDC_ARROW),
                                 (HBRUSH)(GetStockObject(GRAY_BRUSH)),
                                 NULL);
                            
 return CreateEx(0, pszBrowseClass, 
                 NULL, WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS,
                 0,0,0,0,
                 pParent->GetSafeHwnd(),NULL,NULL);
}                                            

void CToolWnd::OnDestroy()
{
	ASSERT_VALID(m_pLeftBtn);
	ASSERT_VALID(m_pRightBtn);
	ASSERT_VALID(m_pSource);
	ASSERT_VALID(m_pMixed);
	ASSERT_VALID(m_pAsm);
    
	m_pLeftBtn-> DestroyWindow();
	m_pRightBtn->DestroyWindow();
	m_pSource->  DestroyWindow();
	m_pMixed->   DestroyWindow();
	m_pAsm->     DestroyWindow();
	// TODO: Add your message handler code here
	CWnd::OnDestroy();
	
}

void CToolWnd::EnableBrowseNext(BOOL bEnabled)
{
	m_pRightBtn->EnableWindow(bEnabled);
}

void CToolWnd::EnableBrowsePrev(BOOL bEnabled)
{
	m_pLeftBtn-> EnableWindow(bEnabled);
}

BEGIN_MESSAGE_MAP(CToolWnd, CWnd)
	//{{AFX_MSG_MAP(CToolWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_DESTROY()
	ON_WM_PAINT()
	ON_COMMAND(ID_VIEW_MIXED, OnViewMixed)
	ON_COMMAND(ID_VIEW_SOURCEONLY, OnViewSourceonly)
	ON_COMMAND(ID_VIEW_ASM, OnViewAsm)
	ON_COMMAND(ID_FILE_PREVMODULE, OnFilePrevmodule)
	ON_COMMAND(ID_FILE_NEXTMODULE, OnFileNextmodule)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CToolWnd message handlers
void CToolWnd::OnFilePrevmodule()
{
	// TODO: Add your command handler code here
	MessageBeep(-1);
    pBrowseWnd->PostMessage(WM_COMMAND,ID_FILE_PREVMODULE);
	
}

void CToolWnd::OnFileNextmodule()
{
	// TODO: Add your command handler code here
	MessageBeep(-1);
    pBrowseWnd->PostMessage(WM_COMMAND,ID_FILE_NEXTMODULE);
	
}

void CToolWnd::SetBtn(int nIdx)
{
	m_pSource->m_bDown=nIdx==1?1:0;
	m_pMixed->m_bDown=nIdx==2?1:0;
	m_pAsm->m_bDown=nIdx==3?1:0;
	if(nIdx==1)
	{
		m_pMixed->SetState(m_pMixed->m_bDown);
		m_pAsm->SetState(m_pAsm->m_bDown);      
		m_pSource->SetState(m_pSource->m_bDown);
	}else if(nIdx==2)
	{
		m_pSource->SetState(m_pSource->m_bDown);
		m_pAsm->SetState(m_pAsm->m_bDown);      
		m_pMixed->SetState(m_pMixed->m_bDown);
	} 
	else
	{
		m_pSource->SetState(m_pSource->m_bDown);
		m_pMixed->SetState(m_pMixed->m_bDown);
		m_pAsm->SetState(m_pAsm->m_bDown);      
	}
}  

void CToolWnd::OnViewAsm()                             
{
	// TODO: Add your command handler code here
#ifdef USE_DELAY
  if((dwDelay+CHICKDELAY)>GetTickCount())
    return;
  else  dwDelay=GetTickCount();
#endif
    
  if(browseOpenSwitch)
  {
	if(isBrowseOn)
   	   pBrowseWnd->PostMessage(WM_COMMAND,ID_VIEW_ASM);
	m_pMixed->m_bDown=0;
	m_pSource->m_bDown=0;
	m_pAsm->m_bDown=1;
  }
  else
  {
    MessageBeep(-1);     
    if(!m_pSource->m_bDown&&!m_pMixed->m_bDown&&!m_pAsm->m_bDown)
    {
      if(isBrowseOn)
        pBrowseWnd->SetFocus();
      return;
    }  

	m_pMixed->m_bDown=0;
	m_pSource->m_bDown=0;
//	m_pAsm->m_bDown=0;
  } 	
	m_pSource->SetState(m_pSource->m_bDown);
	m_pMixed->SetState(m_pMixed->m_bDown);
	m_pAsm->SetState(m_pAsm->m_bDown);

  if(isBrowseOn)
     pBrowseWnd->SetFocus();
	
}                       

void CToolWnd::OnViewMixed()                             
{
	// TODO: Add your command handler code here

#ifdef USE_DELAY
  if((dwDelay+CHICKDELAY)>GetTickCount())
    return;
  else  dwDelay=GetTickCount();
#endif

  if(browseOpenSwitch)
  {
	if(isBrowseOn)
   	   pBrowseWnd->PostMessage(WM_COMMAND,ID_VIEW_MIXED);
	m_pMixed->m_bDown=1;
	m_pSource->m_bDown=0;
	m_pAsm->m_bDown=0;
  }
  else
  {
    MessageBeep(-1);     
    if(!m_pSource->m_bDown&&!m_pMixed->m_bDown&&!m_pAsm->m_bDown)
    {
      if(isBrowseOn)
        pBrowseWnd->SetFocus();
      return;
    }  

	m_pMixed->m_bDown=0;
	m_pSource->m_bDown=0;
//	m_pAsm->m_bDown=0;
  } 	
	m_pSource->SetState(m_pSource->m_bDown);
	m_pMixed->SetState(m_pMixed->m_bDown);
	m_pAsm->SetState(m_pAsm->m_bDown);

  if(isBrowseOn)
     pBrowseWnd->SetFocus();
	
}

void CToolWnd::OnViewSourceonly()
{
	// TODO: Add your command handler code here          
#ifdef USE_DELAY
  if((dwDelay+CHICKDELAY)>GetTickCount())
    return;
  else  dwDelay=GetTickCount();
#endif
  
  if(browseOpenSwitch)
  {
	if(isBrowseOn)
	   pBrowseWnd->PostMessage(WM_COMMAND,ID_VIEW_SOURCEONLY);
    m_pSource->m_bDown=1;
    m_pMixed->m_bDown=0;
    m_pAsm->m_bDown=0;
  }
  else
  {
    MessageBeep(-1);     
    if(!m_pSource->m_bDown&&!m_pMixed->m_bDown&&!m_pAsm->m_bDown)
    {
      if(isBrowseOn)
        pBrowseWnd->SetFocus();
      return;
    }  
    m_pSource->m_bDown=0;
    m_pMixed->m_bDown=0;
//    m_pAsm->m_bDown=0;
  }  
    m_pMixed->SetState(m_pMixed->m_bDown);
    m_pSource->SetState(m_pSource->m_bDown);
    m_pAsm->SetState(m_pAsm->m_bDown);
  
  if(isBrowseOn)
     pBrowseWnd->SetFocus();
    
}                                       

void CToolWnd::ResetButton()
{
    m_pSource->m_bDown=0;
    m_pMixed->m_bDown=0;
    m_pAsm->m_bDown=0;
    m_pMixed-> SetState(m_pMixed->m_bDown);
    m_pSource->SetState(m_pSource->m_bDown);
    m_pAsm->   SetState(m_pAsm->m_bDown);
}

int CToolWnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here

	ASSERT_VALID(m_pLeftBtn);
	ASSERT_VALID(m_pRightBtn);
	ASSERT_VALID(m_pSource);
	ASSERT_VALID(m_pMixed);
	ASSERT_VALID(m_pAsm);
	
	BOOL bLeftBtn=
    m_pLeftBtn-> Create(CToolButton::FTB_LEFT, NULL, this,ID_FILE_PREVMODULE);
    BOOL bRightBtn=
    m_pRightBtn->Create(CToolButton::FTB_RIGHT, NULL, this,ID_FILE_NEXTMODULE);
    BOOL bMixed=
    m_pMixed->   Create(CToolButton::FTB_MIXED, "mixed", this,ID_VIEW_MIXED);
    BOOL bSource=
    m_pSource->  Create(CToolButton::FTB_SOURCE, "source", this,ID_VIEW_SOURCEONLY);
    BOOL bAsm=
    m_pAsm->  Create(CToolButton::FTB_ASM, "asm", this,ID_VIEW_ASM);
    
    if(!(bLeftBtn&&bSource&&bMixed))
       return -1;
       
	return 0;
}

void CToolWnd::OnSize(UINT nType, int cx, int cy)
{
	CWnd::OnSize(nType, cx, cy);
	if(cx<=2*cy) return;
	// TODO: Add your message handler code here 
	int nWide=(cx-2*cy)/10;

	ASSERT_VALID(m_pLeftBtn);
	ASSERT_VALID(m_pRightBtn);
	ASSERT_VALID(m_pSource);
	ASSERT_VALID(m_pMixed);
	ASSERT_VALID(m_pAsm);

	m_pLeftBtn-> MoveWindow(0,0,cy,cy);
	m_pRightBtn->MoveWindow(cx-cy,0,cy,cy);
	
    m_pAsm->   MoveWindow(cx-cy-(nWide*4-4),0,nWide*4-4,cy);                        
    m_pMixed-> MoveWindow((cx-nWide*4+4)/2,0,nWide*4-4,cy);
    m_pSource->MoveWindow(cy,0,nWide*4-4,cy);
}

void CToolWnd::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	if(m_pMixed->m_bDown&&browseOpenSwitch)
	{
	   m_pSource->RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pAsm->   RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pMixed-> RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	}     
	else if(m_pSource->m_bDown&&browseOpenSwitch)
	{
	   m_pAsm->   RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pMixed-> RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pSource->RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	}
	else if(m_pAsm->m_bDown&&browseOpenSwitch)
	{
	   m_pMixed-> RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pSource->RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pAsm->   RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	}
	else
	{
	   m_pAsm->   RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pMixed-> RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	   m_pSource->RedrawWindow(NULL,NULL,RDW_INVALIDATE|RDW_UPDATENOW);
	}   
	// Do not call CWnd::OnPaint() for painting messages
}
                     
                
/////////////////////////////////////////////////////////////////////////////
// CToolButton

CToolButton::CToolButton()
{
    m_pFont    =new CFont;
    m_bDown=0;
}

CToolButton::~CToolButton()
{      
    if(m_pFont)
	   m_pFont->    DeleteObject();
    delete m_pFont;
}

BOOL CToolButton::Create(int nStyle, LPCSTR lpTitle,CWnd *pParent,UINT uID)
{               
  m_strTitle=lpTitle;
  m_nStyle  =nStyle;              

  LOGFONT     logFont;
  _fmemset(&logFont,0,sizeof(LOGFONT));
  logFont.lfHeight=-12;
  logFont.lfWeight=FW_BOLD;
  lstrcpy(logFont.lfFaceName,"Arial");

  if(m_pFont)
     m_pFont->CreateFontIndirect(&logFont);
  
  ASSERT(m_nStyle==FTB_LEFT   ||
         m_nStyle==FTB_RIGHT  ||
         m_nStyle==FTB_SOURCE || 
         m_nStyle==FTB_MIXED  ||
         m_nStyle==FTB_ASM);
  return CButton::Create(NULL,WS_CHILD|WS_VISIBLE|BS_OWNERDRAW|BS_PUSHBUTTON,
                         CFrameWnd::rectDefault,pParent,uID);
}    
/* DrawLRFrame ----------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CToolButton::DrawLRDownFrame(CDC *pDC, LPRECT pRect)
{                        
  CRect rect=*pRect;
  HBRUSH hWGFrame = CreateSolidBrush(RGB(192,192,192));
  HBRUSH hGFrame  = CreateSolidBrush(RGB(128,128,128));
            
  HGDIOBJ hOldBrush = pDC->SelectObject(hGFrame);
  pDC->FillRect(&rect, CBrush::FromHandle(hWGFrame));

  if (hGFrame != NULL)
  {
    pDC->PatBlt(0, 0, rect.right-1, 1, PATCOPY);
    pDC->PatBlt(0, 0, 1, rect.bottom-1, PATCOPY);
    pDC->PatBlt(0, rect.bottom-1, rect.right-1, 1, PATCOPY);
    pDC->PatBlt(rect.right-1, 0, 1, rect.bottom-1, PATCOPY);
  }                    
  
  pRect->left+=2;
  pRect->right-=2;  
  pRect->top+=2;
  pRect->bottom-=2;  
  
  pDC->SelectObject(hOldBrush);
  DeleteObject(hWGFrame);
  DeleteObject(hGFrame);
}     

/* DrawFrame -------------------------------------------------------*/
/*-----------------------------------------------------------------*/
void  CToolButton::DrawLRUpFrame(CDC *pDC, LPRECT pRect)
{                                                 
  CRect rect=*pRect;
  HBRUSH hWFrame  = CreateSolidBrush(RGB(255,255,255));
  HBRUSH hWGFrame = CreateSolidBrush(RGB(192,192,192));
  HBRUSH hGFrame  = CreateSolidBrush(RGB(128,128,128));
  HBRUSH hBFrame  = CreateSolidBrush(RGB(0,0,0));
            
  HGDIOBJ hOldBrush = pDC->SelectObject(hWFrame);
  pDC->FillRect(&rect, CBrush::FromHandle(hWGFrame));
  
//white            
  if (hWFrame != NULL)
  {
    pDC->PatBlt(1, 1, rect.right-1, 1, PATCOPY);
    pDC->PatBlt(1, 1, 1, rect.bottom-1, PATCOPY);
  }

/*
//LG
  if (hWGFrame != NULL)
  { 
    pDC->SelectObject(hWGFrame);
    pDC->PatBlt(1, 1, rect.right-2, 1, PATCOPY);
    pDC->PatBlt(1, 1, 1, rect.bottom-2, PATCOPY);
  }
*/    
//G
  if (hGFrame != NULL)
  { 
    pDC->SelectObject(hGFrame);
    pDC->PatBlt(1, rect.bottom-2, rect.right-2, 1, PATCOPY);
    pDC->PatBlt(rect.right-2, 1, 1, rect.bottom-2, PATCOPY);
  }                            
  
//B
  if (hBFrame != NULL)
  { 
    pDC->SelectObject(hBFrame);
    pDC->PatBlt(0, rect.bottom-1, rect.right, 1, PATCOPY);
    pDC->PatBlt(rect.right-1, 0, 1, rect.bottom, PATCOPY);
  }                            
  
  pRect->left+=4;
  pRect->right-=4;  
  pRect->top+=4;
  pRect->bottom-=4;  
  
  pDC->SelectObject(hOldBrush);
  DeleteObject(hWFrame);
  DeleteObject(hWGFrame);
  DeleteObject(hGFrame);
  DeleteObject(hBFrame);

}

void CToolButton::DrawLR(CDC *pDC, CRect rect, BOOL bDown,BOOL bLeft)
{                                         
  CRect r=rect;
  CBrush brush(RGB(192,192,192));  
  CBrush brushGray(RGB(128,128,128));  
  CBrush brushBlk(RGB(0,0,0));
  CPen   pen(PS_SOLID,1,RGB(0,0,0));
  CPen   penGray(PS_SOLID,1,RGB(128,128,128));
  CPen   *pOldPen;
  CBrush *pOldBrush;          
  
  if(bDown)
     DrawLRDownFrame(pDC, &r);
  else
     DrawLRUpFrame(pDC, &r);
     
  pDC->FillRect(&r, &brush);

  if(m_bDisable)
  {                 
   pOldBrush=pDC->SelectObject(&brushGray);
   pOldPen  =pDC->SelectObject(&penGray);
  }
  else
  {                                       
   pOldBrush=pDC->SelectObject(&brushBlk);
   pOldPen  =pDC->SelectObject(&pen);
  }        
  
  int nHLen=rect.Width()/3;
  int nVLen=rect.Height()/4;
  CPoint pointLPos[3],pointRPos[3];
  pointLPos[0]=CPoint(nHLen+1+1-2,nVLen*2-1);
  pointLPos[1]=CPoint(nHLen*2-2,nVLen+1-1);
  pointLPos[2]=CPoint(nHLen*2-2,nVLen*3-1-1);
  
  pointRPos[0]=CPoint(nHLen+2,nVLen+1-1);
  pointRPos[1]=CPoint(nHLen*2-1-1+2, nVLen*2-1);
  pointRPos[2]=CPoint(nHLen+2,nVLen*3-1-1);
  
  if(bLeft)
     pDC->Polygon(pointLPos,3);
  else
     pDC->Polygon(pointRPos,3);
     
  pDC->SelectObject(pOldPen);
  pDC->SelectObject(pOldBrush);                            
} 

/* DrawSMDownFrame ----------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CToolButton::DrawSMDownFrame(CDC *pDC, LPRECT pRect)
{              
  CRect rect(pRect);
  int nPre=rect.Width()/8;
  CPoint point[4]; 
  point[0]=CPoint(rect.Width(),0);
  point[1]=CPoint(rect.Width()-nPre,rect.Height()-1);
  point[2]=CPoint(nPre,rect.Height()-1);
  point[3]=CPoint(0,0);

  CPen   penBlack(PS_SOLID,1,RGB(0,0,0));
  CPen   penWhite(PS_SOLID,1,RGB(255,255,255));
  CPen   *pOldPen;

  CBrush brushBlack(RGB(192,192,192));
  CBrush brushWhite(RGB(255,255,255));
  CBrush *pOldBrush; 

  CFont  *pOldFont;
  

  pOldBrush=pDC->SelectObject(&brushWhite);
  pOldPen  =pDC->SelectObject(&penWhite);
  
  pDC->Polygon(point,4);

  pDC->SelectObject(&penBlack);
  pDC->Polyline(point,4);
  
  pDC->SelectObject(pOldBrush);
  pDC->SelectObject(pOldPen);

  pOldFont=pDC->SelectObject(m_pFont);
  pDC->SetTextColor(RGB(0,0,0));
  pDC->SetBkColor(RGB(255,255,255));
  pDC->DrawText(m_strTitle,m_strTitle.GetLength(),
                CRect(nPre,1,rect.Width()-nPre,rect.Height()),
                DT_CENTER|DT_VCENTER);
  pDC->SelectObject(pOldFont);              
  
}        
/* UpSMUpFrame ------------------------------------------------------*/
/*-----------------------------------------------------------------*/
void CToolButton::DrawSMUpFrame(CDC *pDC, LPRECT pRect)
{        
  CRect rect(pRect);
  
  int nPre=rect.Width()/8;
  CPoint point[4];
  point[0]=CPoint(0,0);
  point[1]=CPoint(rect.Width(),0);
  point[2]=CPoint(rect.Width()-nPre,rect.Height()-1);
  point[3]=CPoint(nPre,rect.Height()-1);
  
  CPen   penBlack(PS_SOLID,1,RGB(0,0,0));
  CPen   *pOldPen;

  CBrush brush(RGB(192,192,192));
  CBrush *pOldBrush; 
  CFont  *pOldFont;
  

  pOldBrush=pDC->SelectObject(&brush);
  pOldPen=pDC->SelectObject(&penBlack);
  pDC->Polygon(point,4);

  pOldFont=pDC->SelectObject(m_pFont);
  pDC->SetTextColor(RGB(0,0,0));
  pDC->SetBkColor(RGB(192,192,192));
  pDC->DrawText(m_strTitle,m_strTitle.GetLength(),
                CRect(nPre,1,rect.Width()-nPre,rect.Height()),
                DT_CENTER|DT_VCENTER);
  pDC->SelectObject(pOldFont);       
  

}        


BEGIN_MESSAGE_MAP(CToolButton, CButton)
	//{{AFX_MSG_MAP(CToolButton)
	ON_WM_ERASEBKGND()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CToolButton message handlers
void CToolButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{
	// TODO: Add your message handler code here and/or call default

	LPDRAWITEMSTRUCT pDrawItem=lpDrawItemStruct;
	CDC *pDC=CDC::FromHandle(pDrawItem->hDC);
	CRect rect(&pDrawItem->rcItem);                    
	
	if(m_nStyle==FTB_SOURCE||m_nStyle==FTB_MIXED||m_nStyle==FTB_ASM)
	{           
	   if(m_bDown)
	      DrawSMDownFrame(pDC, &rect);
	   else
	      DrawSMUpFrame(pDC, &rect);
	}             
	else
	if(pDrawItem->itemAction&(ODA_DRAWENTIRE))
	{ 
	  if(pDrawItem->itemState&(ODS_DISABLED))
	  {   
	     m_bDisable=1;
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);
	    return;  
	  }           
	  m_bDisable=0;  
	  if(pDrawItem->itemState&(ODS_SELECTED))
	  {  
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 1,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 1,0);
	  }   
	  else
	  {
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);
	  
	  }
	  
	}//if            
	else if(pDrawItem->itemAction&(ODA_SELECT))
	{
	  if(pDrawItem->itemState&(ODS_DISABLED))
	  {   
	     m_bDisable=1;
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);
	      
	    return;  
	  }           
	  m_bDisable=0;  
	  if(pDrawItem->itemState&(ODS_SELECTED))
	  {
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 1,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 1,0);
	  }
	  else
	  {    
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);
	  }
	}
	else if(pDrawItem->itemAction&(ODA_FOCUS))
	{
	  if(pDrawItem->itemState&(ODS_DISABLED))
	  {   
	     m_bDisable=1;
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);

	    return;  
	  }           
	  m_bDisable=0;  

	  if(pDrawItem->itemState&(ODS_FOCUS))
	  {
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 1,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 1,0);
	  }
	  else
	  {    
	    if(m_nStyle==FTB_LEFT)
	      DrawLR(pDC,rect, 0,1);
	    else if(m_nStyle==FTB_RIGHT)
	      DrawLR(pDC,rect, 0,0);
	  }
	}
	  
	
}

BOOL CToolButton::OnEraseBkgnd(CDC* )
{
	// TODO: Add your message handler code here and/or call default
	
	return 1;//CButton::OnEraseBkgnd(pDC);
}


void CToolButton::OnMouseMove(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
    CStatusBar *pWnd=(CStatusBar *)AfxGetApp()->m_pMainWnd->
                      GetDescendantWindow(AFX_IDW_STATUS_BAR);
                      
    switch(m_nStyle)
    {
      case FTB_LEFT:
           pWnd->SetWindowText("Browse previous module"); 
           break;
      case FTB_RIGHT:
           pWnd->SetWindowText("Browse next module"); 
           break;
      case FTB_SOURCE:
           pWnd->SetWindowText("Browse as source mode"); 
           break;
      case FTB_MIXED:
           pWnd->SetWindowText("Browse as mixed mode"); 
           break;                                       
      case FTB_ASM:
           pWnd->SetWindowText("Browse disassemble mode"); 
           break;
           
    }
	CButton::OnMouseMove(nFlags, point);
}
