/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/TOOLWND.H__   1.2.1.4   17 Apr 1997 16:06:48   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/TOOLWND.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:06:48   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:41:42   ZJRD
** 2.09F
** 
****************************************************************************/

// toolwnd.h : header file
//
/////////////////////////////////////////////////////////////////////////////
// CToolButton window

class CToolButton : public CButton
{
// Construction
public:
	CToolButton();

// Attributes     
public:
    enum {FTB_LEFT, FTB_RIGHT, FTB_SOURCE, FTB_MIXED, FTB_ASM};
    CString m_strTitle;
    BOOL    m_bDown;
    
private:
    int    m_nStyle;
    CFont *m_pFont; 
    BOOL   m_bDisable;  
    int    m_nDelay;
    CRect  m_wndRect;
    
// Operations
protected:  
    void DrawLR(CDC *pDC, CRect rect, BOOL bDown,BOOL bLeft);
    void DrawLRDownFrame(CDC *pDC, LPRECT pRect);
    void DrawLRUpFrame(CDC *pDC, LPRECT pRect);
    void DrawSMDownFrame(CDC *pDC, LPRECT pRect);
    void DrawSMUpFrame(CDC *pDC, LPRECT pRect);
    
public:
    BOOL Create(int nStyle, LPCSTR lpTitle,CWnd *pParent,UINT uID);
    
// Implementation
public:
	virtual ~CToolButton();
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);

protected:
	// Generated message map functions
	//{{AFX_MSG(CToolButton)
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CToolWnd window

class CToolWnd : public CWnd
{
// Construction
public:
	CToolWnd();

// Attributes
private:
   CToolButton *m_pLeftBtn;
   CToolButton *m_pRightBtn;
   CToolButton *m_pSource;
   CToolButton *m_pMixed;
   CToolButton *m_pAsm;
   
public:
   BOOL Create(CWnd *pParent);
   void ResetButton();
   void EnableBrowseNext(BOOL bEnabled);
   void EnableBrowsePrev(BOOL bEnabled);
   void SetBtn(int nIdx);
      
// Operations
public:

// Implementation
public:
	virtual ~CToolWnd();

protected:
	// Generated message map functions
	virtual BOOL PreTranslateMessage(MSG *pMsg);
	//{{AFX_MSG(CToolWnd)
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnDestroy();
	afx_msg void OnViewMixed();
	afx_msg void OnViewAsm();
	afx_msg void OnViewSourceonly();
	afx_msg void OnPaint();
	afx_msg void OnFilePrevmodule();
	afx_msg void OnFileNextmodule();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
