
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/TRCGRPDI.CPP   1.2.1.4   17 Apr 1997 16:07:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/TRCGRPDI.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:07:08   ZJRD
** 2.09G
** 
**    Rev 1.2.1.3   16 Apr 1997 10:41:58   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:47:42   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:26:50   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:30:08   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:39:26   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:52:42   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:52   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:01:08   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:22:44   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:34:10   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:01:14   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:30   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:48   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:51:56   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:33:32   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:05:38   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:11:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:32   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:57:18   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:42:40   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.24   01 Feb 1996 10:16:46   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.21   24 Jan 1996 10:32:22   Shirley
** EasyPack/SLD Version 0.34d
** 
**    Rev 1.20   23 Jan 1996 11:24:12   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.18   15 Jan 1996 16:12:34   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:36   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:58   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:52   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:20   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:40   Shirley
** EasyPack/SLD Version 0.30
** 
**    Rev 1.12   12 Nov 1995 11:28:36   Shirley
** EasyPack/SLD Version 0.24
** 
**    Rev 1.11   08 Nov 1995 16:29:24   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:54   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.7   27 Oct 1995 13:47:54   Shirley
** EasyPack/SLD Version 0.1g
** 
**    Rev 1.4   13 Oct 1995 13:24:12   Shirley
** EasyPack/SLD Version 0.1d
** 
**    Rev 1.0   07 Sep 1995 09:54:14   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  TRCGRPDI.CPP
//
//  Description:The implement file for the class: CTraceGroupDialog
//
//  Author:     Lane Li, Chris Fang
//
//  Date:       09/10/95
//
//  Modification:
//
//      1. 09/10/95, Initial version
//      2. Link with address server, 3/28/1996
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"                
#include "resource.h"
#include "xview.h"
#include "abibase.h"
#include "trcserve.h"
//#include "trcview.h"
//#include "trcwin.h"
#include "trcgrpdi.h"
#include "stdlib.h"
#include "uicom.h"

#include "address.h"
#include "addrapi.h"

//#include "errhand.h"
#include "cpust.h"
#include "hosterrs.h"


#ifdef _DEBUG          
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern class CBusEvent ev1;
extern class CBusEvent ev2;
extern class CExtEvent ev3;
extern class CLevel Le1;
extern class CLevel Le2;
extern class CTrigger Trig;
extern class CQualify qlfy;
extern QUALIFY softQlfy;
extern unsigned char traceStatus;
extern unsigned char timerStatus;

extern STATUS AbiSetTrigLevel(int,TRIGGER_LEVEL);
extern STATUS AbiSetTrigLogic(TRIGGER_LOGIC);
extern STATUS AbiSetQualify(QUALIFY);
extern STATUS AbiGetCpuStatus(UINT *uCpuStatus);
extern void TraceWnd(unsigned char);
extern void TimerWnd(unsigned char);

extern int GetCurrentBank(void);

int GetTokenNum(char* string)
{
    char separation[3];
    char* temp;
    char* str1=new char[strlen(string)+1];
    int num;
    
    separation[0]=' ';
    separation[1]=',';
    separation[2]='\0';       
    num = 0;     
    
    if(!str1)
    {
        ErrDisplayError(ER_OUT_OF_MEMORY);
        return -1;
    }   
    strcpy(str1,string);
    
    temp = strtok(str1, separation);
    if (temp == NULL) 
    {   
        delete str1;
        return num;
    }   
    
    do
    {
        num++;
        temp = strtok(NULL, separation);
    }while(temp!=NULL);    
    
    delete str1;
    return num;
}              

int searchc(char* str1, char ch, int count)
{
    int i=0;
    int p=0;
    
    if (count==0) return 0;
    
    do
    {
        if (*str1==ch) i++;
        str1++; 
        p++;
    }while((i<count)&&(*str1!='\0'));
    return(p-1);
}           

const char* RetAddrText(WORD space, WORD addr)
{
static char buf[10];

    buf[0]=NULL;
    if(space<6||space>9)
        wsprintf(buf, "%x", addr);
    else
        wsprintf(buf, "P%d:%x", space-6, addr);
    return buf;
}

void SetAddrText(WORD addrSpace, WORD addr, char* pBuf)
{
    strcpy(pBuf, RetAddrText(addrSpace, addr));
}

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog Dialog

IMPLEMENT_DYNAMIC(CTraceGroupDialog, CPropertySheet)

void CTraceGroupDialog::DlgInit(void)
{
    m_bDisplayChange=FALSE;
    AddPage(&m_eventPage);
    AddPage(&m_trcctrlPage);
    AddPage(&m_triggerPage);
    AddPage(&m_filterPage);
}

CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent /*=NULL*/)
    : CPropertySheet("Trace Setup", pParent)
{
    DlgInit();
}                       

CTraceGroupDialog::CTraceGroupDialog(CWnd* pParent, int tab)
    : CPropertySheet("Trace Setup", pParent, tab)
{                               
    DlgInit();
}

void CTraceGroupDialog::forlive(BOOL live)
{
    m_bModeless=live;
}

BEGIN_MESSAGE_MAP(CTraceGroupDialog, CPropertySheet)
    //{{AFX_MSG_MAP(CTraceGroupDialog)
    ON_WM_CREATE()
    ON_WM_SYSCOMMAND()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTraceGroupDialog message handlers
int CTraceGroupDialog::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    // Add the preview window to the property sheet.

    int nReturn;
    if ((nReturn = CPropertySheet::OnCreate(lpCreateStruct))
        != 0)
        return nReturn;

    CenterWindow();
    return 0;
}

void CTraceGroupDialog::OnSysCommand(UINT nID, LPARAM lParam)
{
    // TODO: Add your message handler code here and/or call default
    
    // Disable to move or restore dialog.
    switch ( nID & 0x0FFF0 )
    {
        case SC_MOVE:
            return;
        default:
            break;
    }
        
    CPropertySheet::OnSysCommand(nID, lParam);
}

//void CTraceGroupDialog::OnOK()
//{
//  ASSERT_VALID(this);
//  
//    bStillOn=FALSE;
//  if (GetActivePage()->OnKillActive())
//  {
//      GetActivePage()->OnOK();
//      if (!m_bModeless&&!bStillOn)
//          EndDialog(IDOK);
//  }
//}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage dialog


CTrcGrpEventPage::CTrcGrpEventPage()
    : CCheckPage(CTrcGrpEventPage::IDD)
{
    //{{AFX_DATA_INIT(CTrcGrpEventPage)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_event.nActiveEvent = 1;
    m_event.nEv1AddrMode = 1;
    m_event.Ev1StartAddrTxt[0]='\0';
    m_event.Ev1StartAddrTxt2[0]='\0';
    m_event.Ev1StartAddrTxt3[0]='\0';
    m_event.Ev1EndAddrTxt[0]='\0';
    m_event.nEv1AddrType = 0;
    m_event.nEv1DataMode = 1;
    m_event.Ev1StartDataTxt[0]='\0'; 
    m_event.Ev1StartDataTxt2[0]='\0';
    m_event.Ev1StartDataTxt3[0]='\0';
    m_event.Ev1EndDataTxt[0]='\0';
    m_event.nEv1DataType=0;
    
    m_event.bEv1S = FALSE;
    m_event.bEv1F = FALSE;
    m_event.bEv1R = FALSE;
    m_event.bEv1W = FALSE;
    m_event.bEv1AK = FALSE;
    
    m_event.Ev1CountTxt[0]='\0';

    m_event.nEv2AddrMode = 1;
    m_event.Ev2StartAddrTxt[0]='\0'; 
    m_event.Ev2StartAddrTxt2[0]='\0';
    m_event.Ev2StartAddrTxt3[0]='\0';
    m_event.Ev2EndAddrTxt[0]='\0';
    m_event.nEv2AddrType = 0;
    m_event.nEv2DataMode = 1;
    m_event.Ev2StartDataTxt[0]='\0'; 
    m_event.Ev2StartDataTxt2[0]='\0';
    m_event.Ev2StartDataTxt3[0]='\0';
    m_event.Ev2EndDataTxt[0]='\0';
    m_event.nEv2DataType=0;
    
    m_event.bEv2S = FALSE;
    m_event.bEv2F = FALSE;
    m_event.bEv2R = FALSE;
    m_event.bEv2W = FALSE;
    m_event.bEv2AK = FALSE; 
    
    m_event.nEv3HL = 1;
    
    m_nIDHelp=IDD_TRCGRP_EVENT;
    m_bApply=FALSE;
    
    GetEv1();
    GetEv2();
    GetEv3();
}

BOOL CTrcGrpEventPage::OnSetActive()
{
    CPropertyPage::OnSetActive();
    SetModified(m_bApply);
    return TRUE;
}

BOOL CTrcGrpEventPage::OnKillActive()
{
    if(m_bApply)
        m_bChanged=FALSE;
    return TRUE;        
}

void CTrcGrpEventPage::OnOK()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
    if(!m_bApply)
        return;
    if(OnSet())
    {
        CPropertyPage::OnOK();
        SetModified(FALSE);
        m_bApply=FALSE;
    }
    else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpEventPage::OnCancel()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}
void CTrcGrpEventPage::EnableEventCtrl(BOOL bEnable)
{
    GetDlgItem(IDC_GRPTRC_EVT_STATIC2)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDRMODE)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_RANGE1)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_MULTI1)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_WILD1)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_ADDR)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATAMODE)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_RANGE2)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_MULTI2)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_WILD2)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_DATA)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_STATUS)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_S)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_F)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_R)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_W)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_AK)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(bEnable);

    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(!bEnable);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(!bEnable);
}

void CTrcGrpEventPage::ShowAddr(int ev)
{
    if (m_event.nEv1AddrMode!=1&&ev==1||m_event.nEv2AddrMode!=1&&ev==2)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
        
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
        CComboBox* a=(CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
        a->SetCurSel((ev==1)?m_event.nEv1AddrType:m_event.nEv2AddrType);
    }
    if(ev==1)
    {
        if(m_event.nEv1AddrMode==1)
            {
             SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
             SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);
            }
        else if(m_event.nEv1AddrMode==2)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2);
        else if(m_event.nEv1AddrMode==3)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3);
    }
    else
    {
        if(m_event.nEv2AddrMode==1)
            {
             SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
             SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);
            }
        else if(m_event.nEv2AddrMode==2)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2);
        else if(m_event.nEv2AddrMode==3)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3);
    }
}

void CTrcGrpEventPage::ShowData(int ev)
{
    if (m_event.nEv1DataMode!=1&&ev==1||m_event.nEv2DataMode!=1&&ev==2)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
        
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
        CComboBox* a=(CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
        a->SetCurSel((ev==1)?m_event.nEv1DataType:m_event.nEv2DataType);
    }
    if(ev==1)
    {
        if(m_event.nEv1DataMode==1)
            {
             SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
             SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);
            }
        else if(m_event.nEv1DataMode==2)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2);
        else if(m_event.nEv1DataMode==3)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3);
    }
    else
    {
        if(m_event.nEv2DataMode==1)
            {
             SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
             SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);
            }
        else if(m_event.nEv2DataMode==2)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2);
        else if(m_event.nEv2DataMode==3)
            SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3);
    }

}

void CTrcGrpEventPage::Ev1Init()
{
    BOOL old=m_bApply;
    m_bApply=TRUE;      //walk through
    if (m_event.nEv1AddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
    }
    if (m_event.nEv1DataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
    }

    switch (m_event.nEv1AddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
        default:
            break;
    }

    switch (m_event.nEv1DataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
        default:
            break;
    }

    if(m_event.nEv1AddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt);
        }
    else if(m_event.nEv1AddrMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2);
    else if(m_event.nEv1AddrMode==3)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3);

    CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv1AddrType);

    t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv1DataType);
    if(m_event.nEv1DataMode==1) 
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt);
        }              
    else if(m_event.nEv1DataMode==2)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2);    
    else if(m_event.nEv1DataMode==3)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3);    
    SetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt);
    
    if (m_event.bEv1S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

    if (m_event.bEv1F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

    if (m_event.bEv1R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

    if (m_event.bEv1W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

    if (m_event.bEv1AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
    m_bApply=old;    
}

void CTrcGrpEventPage::Ev2Init()
{
    BOOL old=m_bApply;
    m_bApply=TRUE;
    if (m_event.nEv2AddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
    }
    if (m_event.nEv2DataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Da&ta");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_EVT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
    }

    switch (m_event.nEv2AddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE1,IDC_GRPTRC_EVT_WILD1,IDC_GRPTRC_EVT_WILD1);
        default:
            break;
    }

    switch (m_event.nEv2DataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_EVT_RANGE2,IDC_GRPTRC_EVT_WILD2,IDC_GRPTRC_EVT_WILD2);
        default:
            break;
    }
    if(m_event.nEv2AddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt);
        }
    else if(m_event.nEv2AddrMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2);
    else if(m_event.nEv2AddrMode==3)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3);

    CWnd* t=GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2AddrType);

    t=GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_event.nEv2DataType);
    if(m_event.nEv2DataMode==1) 
        {
         SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt);
         SetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt);
        }              
    else if(m_event.nEv2DataMode==2)
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2);    
    else if(m_event.nEv2DataMode==3)    
        SetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3);    

    if (m_event.bEv2S) CheckDlgButton(IDC_GRPTRC_EVT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_S, FALSE);

    if (m_event.bEv2F) CheckDlgButton(IDC_GRPTRC_EVT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_F, FALSE);

    if (m_event.bEv2R) CheckDlgButton(IDC_GRPTRC_EVT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_R, FALSE);

    if (m_event.bEv2W) CheckDlgButton(IDC_GRPTRC_EVT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_W, FALSE);

    if (m_event.bEv2AK) CheckDlgButton(IDC_GRPTRC_EVT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_EVT_AK, FALSE);
    m_bApply=old;
}

void CTrcGrpEventPage::Ev3Init()
{
    switch (m_event.nEv3HL)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_HIGH);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_EVT_HIGH,IDC_GRPTRC_EVT_LOW,IDC_GRPTRC_EVT_LOW);
            break;
        default:
            break;
    }
}                                     

void CTrcGrpEventPage::GetEv1()
{
    int i,j, ii;  
    char txt[200];
            
    if (ev1.m_nClearflag==1)
    {
        m_event.nEv1AddrMode = 1;
        m_event.Ev1StartAddrTxt[0]='\0';
        m_event.Ev1StartAddrTxt2[0]='\0';
        m_event.Ev1StartAddrTxt3[0]='\0';
        m_event.Ev1EndAddrTxt[0]='\0';
        m_event.nEv1AddrType = 0;
        m_event.nEv1DataMode = 1;
        m_event.Ev1StartDataTxt[0]='\0'; 
        m_event.Ev1StartDataTxt2[0]='\0'; 
        m_event.Ev1StartDataTxt3[0]='\0'; 
        m_event.Ev1EndDataTxt[0]='\0';
        m_event.nEv1DataType=0;
        m_event.bEv1S = FALSE;
        m_event.bEv1F = FALSE;
        m_event.bEv1R = FALSE;
        m_event.bEv1W = FALSE;
        m_event.bEv1AK = FALSE;
        m_event.Ev1CountTxt[0]='\0';
        return;
    }          
    
    switch (ev1.m_busEv.qlfyType[4])
    {
        case 0:                                  
            m_event.nEv1AddrMode = 3;
            strcpy(m_event.Ev1StartAddrTxt3,"xxxx");
            break;
        case 2:                    
            _itoa(ev1.m_busEv.addr[0][0],m_event.Ev1StartAddrTxt3,2);
            i = strlen(m_event.Ev1StartAddrTxt3);
            strncpy(txt,m_event.Ev1StartAddrTxt3,64);
            strcpy(&(m_event.Ev1StartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_event.Ev1StartAddrTxt3[j]='0';
                      
            if ((ev1.m_busEv.addr[1][0]&0x8000)==0)
                m_event.Ev1StartAddrTxt3[0]='x';
                
            if ((ev1.m_busEv.addr[1][0]&0x4000)==0)
                m_event.Ev1StartAddrTxt3[1]='x';

            if ((ev1.m_busEv.addr[1][0]&0x2000)==0)
                m_event.Ev1StartAddrTxt3[2]='x';

            if ((ev1.m_busEv.addr[1][0]&0x1000)==0)
                m_event.Ev1StartAddrTxt3[3]='x';

            if ((ev1.m_busEv.addr[1][0]&0x800)==0)
                m_event.Ev1StartAddrTxt3[4]='x';

            if ((ev1.m_busEv.addr[1][0]&0x400)==0)
                m_event.Ev1StartAddrTxt3[5]='x';

            if ((ev1.m_busEv.addr[1][0]&0x200)==0)
                m_event.Ev1StartAddrTxt3[6]='x';

            if ((ev1.m_busEv.addr[1][0]&0x100)==0)
                m_event.Ev1StartAddrTxt3[7]='x';

            if ((ev1.m_busEv.addr[1][0]&0x80)==0)
                m_event.Ev1StartAddrTxt3[8]='x';

            if ((ev1.m_busEv.addr[1][0]&0x40)==0)
                m_event.Ev1StartAddrTxt3[9]='x';

            if ((ev1.m_busEv.addr[1][0]&0x20)==0)
                m_event.Ev1StartAddrTxt3[10]='x';

            if ((ev1.m_busEv.addr[1][0]&0x10)==0)
                m_event.Ev1StartAddrTxt3[11]='x';

            if ((ev1.m_busEv.addr[1][0]&0x8)==0)
                m_event.Ev1StartAddrTxt3[12]='x';

            if ((ev1.m_busEv.addr[1][0]&0x4)==0)
                m_event.Ev1StartAddrTxt3[13]='x';

            if ((ev1.m_busEv.addr[1][0]&0x2)==0)
                m_event.Ev1StartAddrTxt3[14]='x';

            if ((ev1.m_busEv.addr[1][0]&0x1)==0)
                m_event.Ev1StartAddrTxt3[15]='x';
                
            m_event.Ev1StartAddrTxt3[16]='\0';
            compressWild(m_event.Ev1StartAddrTxt3);
            m_event.nEv1AddrMode = 3;
            break;
        case 0x10:                       
            SetAddrText(ev1.m_busEv.addr[0][1], ev1.m_busEv.addr[0][0],
                        m_event.Ev1StartAddrTxt);
            SetAddrText(ev1.m_busEv.addr[1][1], ev1.m_busEv.addr[1][0],
                        m_event.Ev1EndAddrTxt);
            m_event.nEv1AddrType = 0;
            m_event.nEv1AddrMode = 1;
            break;
        case 0x40:                   
            m_event.Ev1StartAddrTxt2[0]=NULL;
            for(ii=0; ii<int(ev1.m_busEv.addrCount); ii++)
            {
                strcat(m_event.Ev1StartAddrTxt2,
                    RetAddrText(ev1.m_busEv.addr[ii][1], ev1.m_busEv.addr[ii][0]));
                strcat(m_event.Ev1StartAddrTxt2," ");
            }
            m_event.nEv1AddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (ev1.m_busEv.qlfyType[6])
    {
        case 0:   
            m_event.nEv1DataMode = 3;                     
            strcpy(m_event.Ev1StartDataTxt3,"xx");
            break;
        case 2:
            _itoa(((WORD)ev1.m_busEv.data1),m_event.Ev1StartDataTxt3,2);
//          strncpy(m_event.Ev1StartDataTxt, &(m_event.Ev1StartDataTxt[8]), 8);
            i = strlen(m_event.Ev1StartDataTxt3);
            strncpy(txt,m_event.Ev1StartDataTxt3,64);
            strcpy(&(m_event.Ev1StartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_event.Ev1StartDataTxt3[j]='0';
                      
            if ((ev1.m_busEv.data2&0x80)==0)
                m_event.Ev1StartDataTxt3[0]='x';

            if ((ev1.m_busEv.data2&0x40)==0)
                m_event.Ev1StartDataTxt3[1]='x';

            if ((ev1.m_busEv.data2&0x20)==0)
                m_event.Ev1StartDataTxt3[2]='x';

            if ((ev1.m_busEv.data2&0x10)==0)
                m_event.Ev1StartDataTxt3[3]='x';

            if ((ev1.m_busEv.data2&0x8)==0)
                m_event.Ev1StartDataTxt3[4]='x';

            if ((ev1.m_busEv.data2&0x4)==0)
                m_event.Ev1StartDataTxt3[5]='x';

            if ((ev1.m_busEv.data2&0x2)==0)
                m_event.Ev1StartDataTxt3[6]='x';

            if ((ev1.m_busEv.data2&0x1)==0)
                m_event.Ev1StartDataTxt3[7]='x';
                
            m_event.Ev1StartDataTxt3[8]='\0';
            compressWild(m_event.Ev1StartDataTxt3);
            m_event.nEv1DataMode = 3;
            break;
        case 0x10:
            sprintf(m_event.Ev1StartDataTxt,"0x%02x",ev1.m_busEv.data1);
            //sprintf(m_event.Ev1StartDataTxt,"%u",ev1.m_busEv.data1);
            sprintf(m_event.Ev1EndDataTxt,"0x%02x",ev1.m_busEv.data2);
            //sprintf(m_event.Ev1EndDataTxt,"%u",ev1.m_busEv.data2);
            m_event.nEv1DataType=0;
            m_event.nEv1DataMode = 1;
            break;
        case 0x1:
            sprintf(m_event.Ev1StartDataTxt2,"0x%02x",ev1.m_busEv.data1);
            //sprintf(m_event.Ev1StartDataTxt2,"%u",ev1.m_busEv.data1);
            m_event.nEv1DataMode = 2;
        default:
            break;
    }             

    m_event.bEv1S = FALSE;
    m_event.bEv1F = FALSE;
    m_event.bEv1R = FALSE;
    m_event.bEv1W = FALSE;
    m_event.bEv1AK = FALSE;
    switch (ev1.m_busEv.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((ev1.m_busEv.status&1)==1)
                m_event.bEv1S = TRUE;
            if ((ev1.m_busEv.status&2)==2)
                m_event.bEv1F = TRUE;
            if ((ev1.m_busEv.status&4)==4)
                m_event.bEv1R = TRUE;
            if ((ev1.m_busEv.status&8)==8)
                m_event.bEv1W = TRUE;
            if ((ev1.m_busEv.status&0x10)==0x10)
                m_event.bEv1AK = TRUE;
            break;            
        default:
            break;
    }             
    
    switch (ev1.m_busEv.qlfyType[10])
    {
        case 0:
            m_event.Ev1CountTxt[0]='0';
            m_event.Ev1CountTxt[1]=0;
            break;
        case 1:
            //sprintf(m_event.Ev1CountTxt,"0x%x",ev1.m_busEv.count);
            sprintf(m_event.Ev1CountTxt,"0x%04x",ev1.m_busEv.count);
        default:
            break;
    }

}

void CTrcGrpEventPage::GetEv2()
{
    int i,j, ii;
    char txt[200];
            
    if (ev2.m_nClearflag==1)
    {  
        m_event.nEv2AddrMode = 1;
        m_event.Ev2StartAddrTxt[0]='\0';
        m_event.Ev2StartAddrTxt2[0]='\0';
        m_event.Ev2StartAddrTxt3[0]='\0';
        m_event.Ev2EndAddrTxt[0]='\0';
        m_event.nEv2AddrType = 0;
        m_event.nEv2DataMode = 1;
        m_event.Ev2StartDataTxt[0]='\0'; 
        m_event.Ev2StartDataTxt2[0]='\0';
        m_event.Ev2StartDataTxt3[0]='\0';
        m_event.Ev2EndDataTxt[0]='\0';
        m_event.nEv2DataType=0;
        m_event.bEv2S = FALSE;
        m_event.bEv2F = FALSE;
        m_event.bEv2R = FALSE;
        m_event.bEv2W = FALSE;
        m_event.bEv2AK = FALSE;
        return;
    }          
    
    switch (ev2.m_busEv.qlfyType[4])
    {
        case 0:                                  
            m_event.nEv2AddrMode = 3;
            strcpy(m_event.Ev2StartAddrTxt3,"xxxx");
            break;
        case 2:                    
            _itoa(ev2.m_busEv.addr[0][0],m_event.Ev2StartAddrTxt3,2);
            i = strlen(m_event.Ev2StartAddrTxt3);
            strncpy(txt,m_event.Ev2StartAddrTxt3,64);
            strcpy(&(m_event.Ev2StartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_event.Ev2StartAddrTxt3[j]='0';
                      
            if ((ev2.m_busEv.addr[1][0]&0x8000)==0)
                m_event.Ev2StartAddrTxt3[0]='x';
                
            if ((ev2.m_busEv.addr[1][0]&0x4000)==0)
                m_event.Ev2StartAddrTxt3[1]='x';

            if ((ev2.m_busEv.addr[1][0]&0x2000)==0)
                m_event.Ev2StartAddrTxt3[2]='x';

            if ((ev2.m_busEv.addr[1][0]&0x1000)==0)
                m_event.Ev2StartAddrTxt3[3]='x';

            if ((ev2.m_busEv.addr[1][0]&0x800)==0)
                m_event.Ev2StartAddrTxt3[4]='x';

            if ((ev2.m_busEv.addr[1][0]&0x400)==0)
                m_event.Ev2StartAddrTxt3[5]='x';

            if ((ev2.m_busEv.addr[1][0]&0x200)==0)
                m_event.Ev2StartAddrTxt3[6]='x';

            if ((ev2.m_busEv.addr[1][0]&0x100)==0)
                m_event.Ev2StartAddrTxt3[7]='x';

            if ((ev2.m_busEv.addr[1][0]&0x80)==0)
                m_event.Ev2StartAddrTxt3[8]='x';

            if ((ev2.m_busEv.addr[1][0]&0x40)==0)
                m_event.Ev2StartAddrTxt3[9]='x';

            if ((ev2.m_busEv.addr[1][0]&0x20)==0)
                m_event.Ev2StartAddrTxt3[10]='x';

            if ((ev2.m_busEv.addr[1][0]&0x10)==0)
                m_event.Ev2StartAddrTxt3[11]='x';

            if ((ev2.m_busEv.addr[1][0]&0x8)==0)
                m_event.Ev2StartAddrTxt3[12]='x';

            if ((ev2.m_busEv.addr[1][0]&0x4)==0)
                m_event.Ev2StartAddrTxt3[13]='x';

            if ((ev2.m_busEv.addr[1][0]&0x2)==0)
                m_event.Ev2StartAddrTxt3[14]='x';

            if ((ev2.m_busEv.addr[1][0]&0x1)==0)
                m_event.Ev2StartAddrTxt3[15]='x';
                                       
            m_event.Ev2StartAddrTxt3[16]='\0';
            compressWild(m_event.Ev2StartAddrTxt3);
            m_event.nEv2AddrMode = 3;
            break;
        case 0x10:                       
            SetAddrText(ev2.m_busEv.addr[0][1], ev2.m_busEv.addr[0][0],
                        m_event.Ev2StartAddrTxt);
            SetAddrText(ev2.m_busEv.addr[1][1], ev2.m_busEv.addr[1][0],
                        m_event.Ev2EndAddrTxt);
            m_event.nEv2AddrType = 0;
            m_event.nEv2AddrMode = 1;
            break;
        case 0x40:                   
            m_event.Ev2StartAddrTxt2[0]=NULL;
            for(ii=0; ii<int(ev2.m_busEv.addrCount); ii++)
            {
                strcat(m_event.Ev2StartAddrTxt2,
                    RetAddrText(ev2.m_busEv.addr[ii][1], ev2.m_busEv.addr[ii][0]));
                strcat(m_event.Ev2StartAddrTxt2," ");
            }
            m_event.nEv2AddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (ev2.m_busEv.qlfyType[6])
    {
        case 0:   
            m_event.nEv2DataMode = 3;                     
            strcpy(m_event.Ev2StartDataTxt3,"xx");
            break;
        case 2:
            _itoa(((WORD)ev2.m_busEv.data1),m_event.Ev2StartDataTxt3,2);
//          strncpy(m_event.Ev2StartDataTxt, &(m_event.Ev2StartDataTxt[8]), 8);
            i = strlen(m_event.Ev2StartDataTxt3);
            strncpy(txt,m_event.Ev2StartDataTxt3,64);
            strcpy(&(m_event.Ev2StartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_event.Ev2StartDataTxt3[j]='0';
                      
            if ((ev2.m_busEv.data2&0x80)==0)
                m_event.Ev2StartDataTxt3[0]='x';

            if ((ev2.m_busEv.data2&0x40)==0)
                m_event.Ev2StartDataTxt3[1]='x';

            if ((ev2.m_busEv.data2&0x20)==0)
                m_event.Ev2StartDataTxt3[2]='x';

            if ((ev2.m_busEv.data2&0x10)==0)
                m_event.Ev2StartDataTxt3[3]='x';

            if ((ev2.m_busEv.data2&0x8)==0)
                m_event.Ev2StartDataTxt3[4]='x';

            if ((ev2.m_busEv.data2&0x4)==0)
                m_event.Ev2StartDataTxt3[5]='x';

            if ((ev2.m_busEv.data2&0x2)==0)
                m_event.Ev2StartDataTxt3[6]='x';

            if ((ev2.m_busEv.data2&0x1)==0)
                m_event.Ev2StartDataTxt3[7]='x';
                
            m_event.Ev2StartDataTxt3[8]='\0';
            compressWild(m_event.Ev2StartDataTxt3);
            m_event.nEv2DataMode = 3;
            break;
        case 0x10:
            sprintf(m_event.Ev2StartDataTxt,"0x%02x",ev2.m_busEv.data1);
            //sprintf(m_event.Ev2StartDataTxt,"%u",ev2.m_busEv.data1);
            sprintf(m_event.Ev2EndDataTxt,"0x%02x",ev2.m_busEv.data2);
            //sprintf(m_event.Ev2EndDataTxt,"%u",ev2.m_busEv.data2);
            m_event.nEv2DataType=0;
            m_event.nEv2DataMode = 1;
            break;
        case 0x1:
            sprintf(m_event.Ev2StartDataTxt2,"0x%02x",ev2.m_busEv.data1);
            //sprintf(m_event.Ev2StartDataTxt2,"%u",ev2.m_busEv.data1);
            m_event.nEv2DataMode = 2;
        default:
            break;
    }             

    m_event.bEv2S = FALSE;
    m_event.bEv2F = FALSE;
    m_event.bEv2R = FALSE;
    m_event.bEv2W = FALSE;
    m_event.bEv2AK = FALSE;
    switch (ev2.m_busEv.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((ev2.m_busEv.status&1)==1)
                m_event.bEv2S = TRUE;
            if ((ev2.m_busEv.status&2)==2)
                m_event.bEv2F = TRUE;
            if ((ev2.m_busEv.status&4)==4)
                m_event.bEv2R = TRUE;
            if ((ev2.m_busEv.status&8)==8)
                m_event.bEv2W = TRUE;
            if ((ev2.m_busEv.status&0x10)==0x10)
                m_event.bEv2AK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTrcGrpEventPage::GetEv3()
{
    if (ev3.m_nClearflag==1)
    {  
        m_event.nEv3HL = 0;
        return;
    }
    if (ev3.m_extEv.extrn==0) m_event.nEv3HL = 2;
    else m_event.nEv3HL = 1;
}

void CTrcGrpEventPage::SetEv1()
{
WORD    lVar1;
    
    ev1.m_nClearflag = 0;    
    ev1.m_eventID = 1;
    
    lVar1=0;
    if (m_event.bEv1S) lVar1+=0x1;
    if (m_event.bEv1F) lVar1+=0x2;
    if (m_event.bEv1R) lVar1+=0x4;
    if (m_event.bEv1W) lVar1+=0x8;
    if (m_event.bEv1AK) lVar1+=0x10;
    
    m_EvBus.status = (DWORD)lVar1;
    if (lVar1>0) 
        m_EvBus.qlfyType[8]=1;
    else 
        m_EvBus.qlfyType[8]=0;

    BeginWaitCursor();
    int nErrorID = AbiSetEvent(m_EvBus);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev1.m_busEv),&(m_EvBus),sizeof(BUS_EVENT));
    }
    else
    {
        ErrDisplayError(ER_TRCGRPF_EV_SETERROR, 0, 1);
    }   
}

void CTrcGrpEventPage::SetEv2()
{
    long lVar1;

    ev2.m_nClearflag = 0;
    ev2.m_eventID=2;

    lVar1=0;
    if (m_event.bEv2S) lVar1+=0x1;
    if (m_event.bEv2F) lVar1+=0x2;
    if (m_event.bEv2R) lVar1+=0x4;
    if (m_event.bEv2W) lVar1+=0x8;
    if (m_event.bEv2AK) lVar1+=0x10;
    
    m_EvBus.status = (DWORD)lVar1;
    if (lVar1>0) 
        m_EvBus.qlfyType[8]=1;
    else 
        m_EvBus.qlfyType[8]=0;
    
    BeginWaitCursor();
    int nErrorID = AbiSetEvent(m_EvBus);
    EndWaitCursor();
    
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev2.m_busEv),&(m_EvBus),sizeof(BUS_EVENT));
    }
    else
    {
        ErrDisplayError(ER_TRCGRPF_EV_SETERROR, 0, 2);
    }   
}

void CTrcGrpEventPage::SetEv3()
{
    ev3.m_nClearflag = 0;
    ev3.m_tmpExtEv.qlfyType[0]=3;   
    switch (m_event.nEv3HL)
    {
        case 1:
            ev3.m_nStatusflag = 1;
            ev3.m_tmpExtEv.qlfyType[9]=1;
            ev3.m_tmpExtEv.extrn = 1;
            break;
        case 2:
            ev3.m_nStatusflag = 0;
            ev3.m_tmpExtEv.qlfyType[9]=1;
            ev3.m_tmpExtEv.extrn = 0;
            break;
        default:
            ev3.m_tmpExtEv.qlfyType[9]=0;
            ev3.m_nClearflag = 1;
            break;
    }
    BeginWaitCursor();
    int nErrorID = AbiSetEvent(ev3.m_tmpExtEv);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(ev3.m_extEv),&(ev3.m_tmpExtEv),sizeof(BUS_EVENT));
    }
    else
    {
        ErrDisplayError(ER_TRCGRPF_EV_SETERROR, 0, 3);
    }   
}

BOOL CTrcGrpEventPage::OnSet()              //tab1
{

    unsigned char status;

    GetCpuStatus(status);
    if(status==STATUS_GO)               //CPU is run
    {
        ErrDisplayError(ER_GOFLY_ERR_MSG);
        return FALSE;
    }

    m_bEmptyFlag=TRUE;
    m_nold_addrmode=0;
    m_nold_datamode=0;

    m_nErrLocate=0;     //1:startaddr; 2:endaddr; 3:startdata; 4:enddata
                        //5:count.
    switch(m_event.nActiveEvent)                        //ev1
    {
     case 1:
        m_EvBus.setMode=0;
        m_EvBus.qlfyType[0]=1;
        if(m_event.nEv1AddrMode==3)             //default
            chkWildAddr(m_event.Ev1StartAddrTxt3);
        else if(m_event.nEv1AddrMode==1)
            chkRangeAddr(m_event.nEv1AddrType, m_event.Ev1StartAddrTxt,
                        m_event.Ev1EndAddrTxt);
        else if(m_event.nEv1AddrMode==2)
            chkMultipleAddr(m_event.Ev1StartAddrTxt2);
        if(m_nErrLocate)
            break;
        if(m_event.nEv1DataMode==3)
            chkWildData(m_event.Ev1StartDataTxt3);
        else if(m_event.nEv1DataMode==1)
            chkRangeData(m_event.nEv1DataType, m_event.Ev1StartDataTxt,
                        m_event.Ev1EndDataTxt);
        else if(m_event.nEv1DataMode==2)
            chkSingleData(m_event.Ev1StartDataTxt2);
        if(m_nErrLocate)
            break;
        chkCount(m_event.Ev1CountTxt, 1);
        if(m_nErrLocate)
            break;
        if(m_event.bEv1S||m_event.bEv1F||m_event.bEv1R
                       ||m_event.bEv1W||m_event.bEv1AK
                       ||!m_bEmptyFlag)
        {
            SetEv1();
            if(m_nold_datamode)
            {
                m_event.nEv1DataMode=3;
                strcpy(m_event.Ev1StartDataTxt3,"xx");
            }
            if(m_nold_addrmode)
            {
                m_event.nEv1AddrMode=3;
                strcpy(m_event.Ev1StartAddrTxt3,"xxxx");
            }
            if(m_nold_addrmode||m_nold_datamode)
                Ev1Init();
            return TRUE;    
        }
        else
        {
            ErrDisplayError(ER_TRCGRP_NONEINPUT);
            return FALSE;
        }
           break;
     case 2:                                         //ev2
        m_EvBus.setMode=0;
        m_EvBus.qlfyType[0]=2;
        if(m_event.nEv2AddrMode==3)             //default
            chkWildAddr(m_event.Ev2StartAddrTxt3);
        else if(m_event.nEv2AddrMode==1)
            chkRangeAddr(m_event.nEv2AddrType, m_event.Ev2StartAddrTxt,
                        m_event.Ev2EndAddrTxt);
        else if(m_event.nEv2AddrMode==2)
            chkMultipleAddr(m_event.Ev2StartAddrTxt2);
        if(m_nErrLocate)
            break;
        if(m_event.nEv2DataMode==3)             //data
            chkWildData(m_event.Ev2StartDataTxt3);
        else if(m_event.nEv2DataMode==1)
            chkRangeData(m_event.nEv2DataType, m_event.Ev2StartDataTxt,
                        m_event.Ev2EndDataTxt);
        else if(m_event.nEv2DataMode==2)
            chkSingleData(m_event.Ev2StartDataTxt2);
        if(m_nErrLocate)
            break;
        if(m_event.bEv2S||m_event.bEv2F||m_event.bEv2R
                       ||m_event.bEv2W||m_event.bEv2AK
                       ||!m_bEmptyFlag)
        {
            SetEv2();
            if(m_nold_datamode)
            {
                m_event.nEv2DataMode=3;
                strcpy(m_event.Ev2StartDataTxt3,"xx");
            }
            if(m_nold_addrmode)
            {
                m_event.nEv2AddrMode=3;
                strcpy(m_event.Ev2StartAddrTxt3,"xxxx");
            }
            if(m_nold_addrmode||m_nold_datamode)
                Ev2Init();
            return TRUE;    
        }
        else
        {
            ErrDisplayError(ER_TRCGRP_NONEINPUT);
            return FALSE;
        }
           break;   
     case 3:                                            //ev3
        SetEv3();
        return TRUE;
     default:
        return FALSE;
    }
    if(m_nErrLocate==1)
        GetDlgItem(IDC_GRPTRC_EVT_STARTADDR)->SetFocus();
    else if(m_nErrLocate==2)
        GetDlgItem(IDC_GRPTRC_EVT_ENDADDR)->SetFocus();
    else if(m_nErrLocate==3)
        GetDlgItem(IDC_GRPTRC_EVT_STARTDATA)->SetFocus();
    else if(m_nErrLocate==4)
        GetDlgItem(IDC_GRPTRC_EVT_ENDDATA)->SetFocus();
    else if(m_nErrLocate==5)
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->SetFocus();
    return FALSE;
}

void CTrcGrpEventPage::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTrcGrpEventPage)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}                                         

BEGIN_MESSAGE_MAP(CTrcGrpEventPage, CPropertyPage)
    //{{AFX_MSG_MAP(CTrcGrpEventPage)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV1, OnGrptrcEvtEv1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV2, OnGrptrcEvtEv2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_EV3, OnGrptrcEvtEv3)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI1, OnGrptrcEvtMulti1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_MULTI2, OnGrptrcEvtMulti2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE1, OnGrptrcEvtRange1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_RANGE2, OnGrptrcEvtRange2)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD1, OnGrptrcEvtWild1)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_WILD2, OnGrptrcEvtWild2)
    ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_ADDRTYPE, OnSelendokGrptrcEvtAddrtype)
    ON_CBN_SELCHANGE(IDC_GRPTRC_EVT_DATATYPE, OnSelendokGrptrcEvtDatatype)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTADDR, OnChangeGrptrcEvtStartaddr)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_STARTDATA, OnChangeGrptrcEvtStartdata)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDADDR, OnChangeGrptrcEvtEndaddr)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_ENDDATA, OnChangeGrptrcEvtEnddata)
    ON_EN_CHANGE(IDC_GRPTRC_EVT_COUNT, OnChangeGrptrcEvtCount)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_AK, OnGrptrcEvtAk)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_F, OnGrptrcEvtF)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_HIGH, OnGrptrcEvtHigh)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_LOW, OnGrptrcEvtLow)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_R, OnGrptrcEvtR)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_S, OnGrptrcEvtS)
    ON_BN_CLICKED(IDC_GRPTRC_EVT_W, OnGrptrcEvtW)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcGrpEventPage message handlers

BOOL CTrcGrpEventPage::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CheckRadioButton(IDC_GRPTRC_EVT_EV1,IDC_GRPTRC_EVT_EV3,IDC_GRPTRC_EVT_EV1);
    GetDlgItem(IDC_GRPTRC_EVT_HIGH)->EnableWindow(FALSE);
    GetDlgItem(IDC_GRPTRC_EVT_LOW)->EnableWindow(FALSE);
    Ev1Init();
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpEventPage::OnGrptrcEvtEv1()
{
    // TODO: Add your control notification handler code here
    if(m_event.nActiveEvent == 1)
        return;
    if(m_event.nActiveEvent == 2)
    {
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(TRUE);
    }
    else
        EnableEventCtrl(TRUE);
        
    m_event.nActiveEvent = 1;                            
    
    Ev1Init();
}

void CTrcGrpEventPage::OnGrptrcEvtEv2()
{
    // TODO: Add your control notification handler code here
    if(m_event.nActiveEvent == 2)
        return;
    if(m_event.nActiveEvent == 1)
    {
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);
    }
    else
    {
        EnableEventCtrl(TRUE);
        GetDlgItem(IDC_GRPTRC_EVT_STATIC_COUNT)->EnableWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_EVT_COUNT)->EnableWindow(FALSE);
    }
    m_event.nActiveEvent = 2;
    
    Ev2Init();
}

void CTrcGrpEventPage::OnGrptrcEvtEv3()
{
    // TODO: Add your control notification handler code here
    if(m_event.nActiveEvent == 3)
        return;
    m_event.nActiveEvent = 3;
    
    EnableEventCtrl(FALSE);
    Ev3Init();
}

void CTrcGrpEventPage::OnGrptrcEvtMulti1()
{
    // TODO: Add your control notification handler code here
    
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1AddrMode==2)
                return;
            m_event.nEv1AddrMode = 2;
            ShowAddr(1);
            break;
        case 2:
            if(m_event.nEv2AddrMode==2)
                return;
            m_event.nEv2AddrMode = 2;
            ShowAddr(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnGrptrcEvtMulti2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1DataMode==2)
                return;
            m_event.nEv1DataMode = 2;
            ShowData(1);
            break;
        case 2:
            if(m_event.nEv2DataMode==2)
                return;
            m_event.nEv2DataMode = 2;
            ShowData(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnGrptrcEvtRange1()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1AddrMode==1)
                return;
            m_event.nEv1AddrMode = 1;
            ShowAddr(1);
            break;
        case 2:
            if(m_event.nEv2AddrMode==1)
                return;
            m_event.nEv2AddrMode = 1;
            ShowAddr(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnGrptrcEvtRange2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1DataMode==1)
                return;
            m_event.nEv1DataMode = 1;
            ShowData(1);
            break;
        case 2:
            if(m_event.nEv2DataMode==1)
                return;
            m_event.nEv2DataMode = 1;
            ShowData(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnGrptrcEvtWild1()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1AddrMode==3)
                return;
            m_event.nEv1AddrMode = 3;
            ShowAddr(1);
            break;
        case 2:
            if(m_event.nEv2AddrMode==3)
                return;
            m_event.nEv2AddrMode = 3;
            ShowAddr(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnGrptrcEvtWild2()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            if(m_event.nEv1DataMode==3)
                return;
            m_event.nEv1DataMode = 3;
            ShowData(1);
            break;
        case 2:
            if(m_event.nEv2DataMode==3)
                return;
            m_event.nEv2DataMode = 3;
            ShowData(2);
            break;
        default:
            break;
    }
}

void CTrcGrpEventPage::OnSelendokGrptrcEvtAddrtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_ADDRTYPE);
    int i=t->GetCurSel();
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1AddrType = i;
            break;
        case 2:
            m_event.nEv2AddrType = i;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnSelendokGrptrcEvtDatatype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_EVT_DATATYPE);
    int i=t->GetCurSel();
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.nEv1DataType = i;
            break;
        case 2:
            m_event.nEv2DataType = i;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }    
}

void CTrcGrpEventPage::OnChangeGrptrcEvtStartaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:
        if(m_event.nEv1AddrMode==1)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt,64);
        else if(m_event.nEv1AddrMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt2,164);
        else if(m_event.nEv1AddrMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev1StartAddrTxt3,64);
            break;
        case 2:                                                          
        if(m_event.nEv2AddrMode==1) 
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt,64);
        else if(m_event.nEv2AddrMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt2,164);
        else if(m_event.nEv2AddrMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTADDR,m_event.Ev2StartAddrTxt3,64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnChangeGrptrcEvtStartdata()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
        if(m_event.nEv1DataMode==1)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt,64);
        else if(m_event.nEv1DataMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt2,64);
        else if(m_event.nEv1DataMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev1StartDataTxt3,64);
            break;
        case 2:                                                          
        if(m_event.nEv2DataMode==1)         
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt,64);
        else if(m_event.nEv2DataMode==2)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt2,64);
        else if(m_event.nEv2DataMode==3)
            GetDlgItemText(IDC_GRPTRC_EVT_STARTDATA,m_event.Ev2StartDataTxt3,64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnChangeGrptrcEvtEndaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev1EndAddrTxt,64);
            break;
        case 2:                                                          
            GetDlgItemText(IDC_GRPTRC_EVT_ENDADDR,m_event.Ev2EndAddrTxt,64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnChangeGrptrcEvtEnddata()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev1EndDataTxt,64);
            break;
        case 2:                                                          
            GetDlgItemText(IDC_GRPTRC_EVT_ENDDATA,m_event.Ev2EndDataTxt,64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnChangeGrptrcEvtCount()
{
    // TODO: Add your control notification handler code here
    switch (m_event.nActiveEvent)
    {
        case 1:   
            GetDlgItemText(IDC_GRPTRC_EVT_COUNT,m_event.Ev1CountTxt,64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtAk()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_AK)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1AK = check;
            break;
        case 2:                                                          
            m_event.bEv2AK = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtF()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_F)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1F = check;
            break;
        case 2:                                                          
            m_event.bEv2F = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtHigh()
{
    // TODO: Add your control notification handler code here
    if(m_event.nEv3HL==1)
        return;
    m_event.nEv3HL = 1;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtLow()
{
    // TODO: Add your control notification handler code here
    if(m_event.nEv3HL==2)
        return;
    m_event.nEv3HL = 2;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtR()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_R)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1R = check;
            break;
        case 2:                                                          
            m_event.bEv2R = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtS()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_S)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1S = check;
            break;
        case 2:                                                          
            m_event.bEv2S = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpEventPage::OnGrptrcEvtW()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_EVT_W)==0) check=FALSE;
    else check=TRUE;
    switch (m_event.nActiveEvent)
    {
        case 1:   
            m_event.bEv1W = check;
            break;
        case 2:                                                          
            m_event.bEv2W = check;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage dialog

CTrcGrpTrcctrlPage::CTrcGrpTrcctrlPage()
    : CCheckPage(CTrcGrpTrcctrlPage::IDD)
{
    //{{AFX_DATA_INIT(CTrcGrpTrcctrlPage)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
UINT status;
    if(AbiGetCpuStatus(&status)!=ICE_OK)            //by chris
        {
         ErrDisplayError(ER_ABI_CPUSTATUS);
         m_traceControl.bStartTrace= traceStatus;
         m_traceControl.bStartTimer = timerStatus;
        }         
    else    
        { 
         traceStatus=unsigned char(m_traceControl.bStartTrace
                        =(status&0x0004)?TRUE:FALSE);
         timerStatus=unsigned char(m_traceControl.bStartTimer
                        =(status&0x0100)?TRUE:FALSE);
        }
    switch (Trig.m_trig.TrigFlg)
    {
        case 0:
            m_traceControl.nDelay = 4;
            //sprintf(m_traceControl.delayTxt,"0x%x",Trig.m_trig.DlayCnt);
            sprintf(m_traceControl.delayTxt,"%u",Trig.m_trig.DlayCnt);
            break;
        case 1:
            m_traceControl.nDelay = 3;
            break;
        case 2:
            m_traceControl.nDelay = 1;
            break;
        case 3:
            m_traceControl.nDelay = 2;
            break;
        default:
            break;  
    }
    m_nIDHelp=IDD_TRCGRP_CONTROL;
    m_bApply=FALSE;
}

BOOL CTrcGrpTrcctrlPage::OnSetActive()
{
    CPropertyPage::OnSetActive();
    SetModified(m_bApply);
    return TRUE;
}

BOOL CTrcGrpTrcctrlPage::OnKillActive()
{
    if(m_bApply)
        m_bChanged=FALSE;
    return TRUE;        
}

void CTrcGrpTrcctrlPage::OnOK()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
    if(!m_bApply)
        return;
    if(OnSet())
    {
        CPropertyPage::OnOK();
        SetModified(FALSE);
        m_bApply=FALSE; 
    }
    else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpTrcctrlPage::OnCancel()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpTrcctrlPage::TraceControlInit()
{                                             
    BOOL old=m_bApply;
    m_bApply=TRUE;
    if (m_traceControl.bStartTrace) CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, TRUE);
    else CheckDlgButton(IDC_GRPTRC_TRC_STARTTRACE, FALSE);
    
    if (m_traceControl.bStartTimer) CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, TRUE);
    else CheckDlgButton(IDC_GRPTRC_TRC_STARTTIMER, FALSE);
    
    switch (m_traceControl.nDelay)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_PRETRG);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_CENTRG);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_POSTTRG);
            break;
        case 4:
            CheckRadioButton(IDC_GRPTRC_TRC_PRETRG, IDC_GRPTRC_TRC_DELAY, IDC_GRPTRC_TRC_DELAY);
            break;
        default:
            break;
    }
    
    if (m_traceControl.nDelay==4) 
    {
        GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
        SetDlgItemText(IDC_GRPTRC_TRC_COMBO,m_traceControl.delayTxt);
    }
    else GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
    m_bApply=old;
}                          

BOOL CTrcGrpTrcctrlPage::OnSet()                    //tab2
{
    ADDRESS adr;
    ADDR_RETCODE    ret;
    unsigned char status;

    GetCpuStatus(status);
    if(status==STATUS_GO)               //CPU is run
    {
        ErrDisplayError(ER_GOFLY_ERR_MSG);
        return FALSE;
    }
    
    if (m_traceControl.nDelay==4)
        chkCount(m_traceControl.delayTxt);
    if(m_nErrLocate)
    {
        GetDlgItem(IDC_GRPTRC_TRC_COMBO)->SetFocus();
        m_nErrLocate = 0;
        return FALSE;
    }
    if(traceStatus!=m_traceControl.bStartTrace)
        TraceWnd(unsigned char(m_traceControl.bStartTrace));
    if(timerStatus!=m_traceControl.bStartTimer)
        TimerWnd(unsigned char(m_traceControl.bStartTimer));
    if(m_traceControl.nDelay==4||
        Trig.m_trig.TrigFlg!=2&&m_traceControl.nDelay==1||
        Trig.m_trig.TrigFlg!=3&&m_traceControl.nDelay==2||
        Trig.m_trig.TrigFlg!=1&&m_traceControl.nDelay==3)
    switch (m_traceControl.nDelay)
    {
        case 1:
            Trig.m_tmpTrig.TrigFlg = 2;         //backward
            break;
        case 2:
            Trig.m_tmpTrig.TrigFlg = 3;         //center
            break;
        case 3:
            Trig.m_tmpTrig.TrigFlg = 1;         //forward
            break;
        case 4:
            Trig.m_tmpTrig.TrigFlg = 0;         //delay count
            //just like chkcount routine
            ret=AdrTextToAddr(m_traceControl.delayTxt, adr, 0);
            if(ret!=ADR_OK||adr.adrAddress>0xffff)
            {
                ErrDisplayError(ER_TRCGRP_COUNT_ERR);
                return FALSE;
            }
            Trig.m_tmpTrig.DlayCnt=adr.adrAddress;
            break;
        default:
            break;  
    }
    TRIGGER_LOGIC trig;
    memcpy(&trig,&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
    BeginWaitCursor();
    int nErrorID=AbiSetTrigLogic(trig);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Trig.m_trig),&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
        return TRUE;
    }
    else
    {
        ErrDisplayError(ER_TRCGRP_TRIGGER_SETERROR);
        return FALSE; 
    }
}

void CTrcGrpTrcctrlPage::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTrcGrpTrcctrlPage)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpTrcctrlPage, CPropertyPage)
    //{{AFX_MSG_MAP(CTrcGrpTrcctrlPage)
        // NOTE: the ClassWizard will add message map macros here
    ON_BN_CLICKED(IDC_GRPTRC_TRC_STARTTIMER, OnGrptrcTrcStarttimer)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_STARTTRACE, OnGrptrcTrcStarttrace)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_CENTRG, OnGrptrcTrcCentrg)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_DELAY, OnGrptrcTrcDelay)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_POSTTRG, OnGrptrcTrcPosttrg)
    ON_BN_CLICKED(IDC_GRPTRC_TRC_PRETRG, OnGrptrcTrcPretrg)
    ON_EN_CHANGE(IDC_GRPTRC_TRC_COMBO, OnChangeGrptrcTrcCombo)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTrcctrlPage message handlers
BOOL CTrcGrpTrcctrlPage::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    TraceControlInit();
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcStarttimer()
{
    // TODO: Add your control notification handler code here
        m_traceControl.bStartTimer = !m_traceControl.bStartTimer;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }    
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcStarttrace()
{
    // TODO: Add your control notification handler code here
    m_traceControl.bStartTrace = !m_traceControl.bStartTrace;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }    
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcCentrg()
{
    // TODO: Add your control notification handler code here
    if(m_traceControl.nDelay == 2)
        return;
    m_traceControl.nDelay = 2;
    GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }    
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcDelay()
{
    // TODO: Add your control notification handler code here
    if(m_traceControl.nDelay==4)
        return;
    m_traceControl.nDelay = 4;
    GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(TRUE);
    GotoDlgCtrl(GetDlgItem(IDC_GRPTRC_TRC_COMBO));
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcPosttrg()
{
    // TODO: Add your control notification handler code here
    if(m_traceControl.nDelay==3)
        return;
    m_traceControl.nDelay = 3;
    GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTrcctrlPage::OnGrptrcTrcPretrg()
{
    // TODO: Add your control notification handler code here
    if(m_traceControl.nDelay==1)
        return;
    m_traceControl.nDelay = 1;
    GetDlgItem(IDC_GRPTRC_TRC_COMBO)->EnableWindow(FALSE);
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTrcctrlPage::OnChangeGrptrcTrcCombo()
{
    // TODO: Add your control notification handler code here
    
    GetDlgItemText(IDC_GRPTRC_TRC_COMBO, m_traceControl.delayTxt, 64);
    if(!m_bApply&&m_traceControl.delayTxt[0]!=0)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage dialog

CTrcGrpTriggerPage::CTrcGrpTriggerPage()
    : CPropertyPage(CTrcGrpTriggerPage::IDD)
{
    //{{AFX_DATA_INIT(CTrcGrpTriggerPage)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_trigger.nActiveLevel = 1;
    m_trigger.level1.nSet = 11;
    m_trigger.level1.bTraceOn = TRUE;
    m_trigger.level1.bTimerOn = TRUE;
    m_trigger.level2.nSet = 0;
    m_trigger.level2.bTraceOn = TRUE;
    m_trigger.level2.bTimerOn = TRUE;
    m_trigger.bTriggerEnable = TRUE;
    m_trigger.bRun = TRUE;
    m_trigger.nTriggerSet = 1;
    GetTrigger();
    GetLevel1();
    GetLevel2();
    m_bApply=FALSE; 
    m_nIDHelp=IDD_TRCGRP_TRIGGER;
}

BOOL CTrcGrpTriggerPage::OnSetActive()
{
    CPropertyPage::OnSetActive();
    SetModified(m_bApply);
    return TRUE;
}

BOOL CTrcGrpTriggerPage::OnKillActive()
{
    if(m_bApply)
        m_bChanged=FALSE;
    return TRUE;
}

void CTrcGrpTriggerPage::OnOK()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
    if(!m_bApply)
        return;
    if(OnSet())
    {   CPropertyPage::OnOK();
        SetModified(FALSE);
        m_bApply=FALSE;
    }
    else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpTriggerPage::OnCancel()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpTriggerPage::TriggerInit()
{           
    CComboBox* a;
    switch (m_trigger.nActiveLevel)
    {
        case 1:               
            CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV1);
            
            a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
            a->SetCurSel(m_trigger.level1.nSet);
            
            if (m_trigger.level1.bTraceOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
            
            if (m_trigger.level1.bTimerOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
            
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_TRG_LV1, IDC_GRPTRC_TRG_LV2, IDC_GRPTRC_TRG_LV2);
            
            a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
            a->SetCurSel(m_trigger.level2.nSet);
            
            if (m_trigger.level2.bTraceOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
            
            if (m_trigger.level2.bTimerOn)
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
            else
                CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
            
            break;
        default:
            break;
    }                           
    
    if (m_trigger.bTriggerEnable)
        CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_ENABLE);
    else
        CheckRadioButton(IDC_GRPTRC_TRG_ENABLE, IDC_GRPTRC_TRG_DISABLE, IDC_GRPTRC_TRG_DISABLE);
    
    CheckDlgButton(IDC_GRPTRC_TRG_RUN, m_trigger.bRun);

    a = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
    a->SetCurSel(m_trigger.nTriggerSet);
}

void CTrcGrpTriggerPage::GetLevel1()
{
    switch (Le1.m_levelStructSave.Condition)
    {
        case (DWORD)0x0:
            m_trigger.level1.nSet = 0;
            break;
        case (DWORD)0xAAAAAAAA:
            m_trigger.level1.nSet = 1;
            break;
        case (DWORD)0xEEEEEEEE:
            m_trigger.level1.nSet = 2;
            break;
        case (DWORD)0xFAFAFAFA:
            m_trigger.level1.nSet = 3;
            break;
        case (DWORD)0xE0E0E0E0:
            m_trigger.level1.nSet = 4;
            break;
        case (DWORD)0xC8C8C8C8:
            m_trigger.level1.nSet = 5;
            break;
        case (DWORD)0xFEFEFEFE:
            m_trigger.level1.nSet = 6;
            break;
        case (DWORD)0x88888888:
            m_trigger.level1.nSet = 7;
            break;
        case (DWORD)0xA0A0A0A0:
            m_trigger.level1.nSet = 8;
            break;
        case (DWORD)0xF8F8F8F8:
            m_trigger.level1.nSet = 9;
            break;
        case (DWORD)0xECECECEC:
            m_trigger.level1.nSet = 10;
            break;
        case (DWORD)0x80808080:
            m_trigger.level1.nSet = 11;
            break;
        case (DWORD)0xCCCCCCCC:
            m_trigger.level1.nSet = 12;
            break;
        case (DWORD)0xFCFCFCFC:
            m_trigger.level1.nSet = 13;
            break;
        case (DWORD)0xA8A8A8A8:
            m_trigger.level1.nSet = 14;
            break;
        case (DWORD)0xC0C0C0C0:
            m_trigger.level1.nSet = 15;
            break;
        case (DWORD)0xEAEAEAEA:
            m_trigger.level1.nSet = 16;
            break;
        case (DWORD)0xF0F0F0F0:
            m_trigger.level1.nSet = 17;
            break;
        default:
            break;
    }
    
    if (Le1.m_levelStruct.TraceFlg==1)
        m_trigger.level1.bTraceOn=TRUE;
    else
        m_trigger.level1.bTraceOn=FALSE;
    
    if (Le1.m_levelStruct.TimerFlg==1)
        m_trigger.level1.bTimerOn=TRUE;
    else
        m_trigger.level1.bTimerOn=FALSE;
}

void CTrcGrpTriggerPage::GetLevel2()
{
    switch (Le2.m_levelStructSave.Condition)
    {
        case (DWORD)0x0:
            m_trigger.level2.nSet = 0;
            break;
        case (DWORD)0xAAAAAAAA:
            m_trigger.level2.nSet = 1;
            break;
        case (DWORD)0xEEEEEEEE:
            m_trigger.level2.nSet = 2;
            break;
        case (DWORD)0xFAFAFAFA:
            m_trigger.level2.nSet = 3;
            break;
        case (DWORD)0xE0E0E0E0:
            m_trigger.level2.nSet = 4;
            break;
        case (DWORD)0xC8C8C8C8:
            m_trigger.level2.nSet = 5;
            break;
        case (DWORD)0xFEFEFEFE:
            m_trigger.level2.nSet = 6;
            break;
        case (DWORD)0x88888888:
            m_trigger.level2.nSet = 7;
            break;
        case (DWORD)0xA0A0A0A0:
            m_trigger.level2.nSet = 8;
            break;
        case (DWORD)0xF8F8F8F8:
            m_trigger.level2.nSet = 9;
            break;
        case (DWORD)0xECECECEC:
            m_trigger.level2.nSet = 10;
            break;
        case (DWORD)0x80808080:
            m_trigger.level2.nSet = 11;
            break;
        case (DWORD)0xCCCCCCCC:
            m_trigger.level2.nSet = 12;
            break;
        case (DWORD)0xFCFCFCFC:
            m_trigger.level2.nSet = 13;
            break;
        case (DWORD)0xA8A8A8A8:
            m_trigger.level2.nSet = 14;
            break;
        case (DWORD)0xC0C0C0C0:
            m_trigger.level2.nSet = 15;
            break;
        case (DWORD)0xEAEAEAEA:
            m_trigger.level2.nSet = 16;
            break;
        case (DWORD)0xF0F0F0F0:
            m_trigger.level2.nSet = 17;
            break;
        default:
            break;
    }
    
    if (Le2.m_levelStruct.TraceFlg==1)
        m_trigger.level2.bTraceOn=TRUE;
    else
        m_trigger.level2.bTraceOn=FALSE;
    
    if (Le2.m_levelStruct.TimerFlg==1)
        m_trigger.level2.bTimerOn=TRUE;
    else
        m_trigger.level2.bTimerOn=FALSE;
}

void CTrcGrpTriggerPage::GetTrigger()
{
    if (Trig.m_trig.RunFlg==0)
        m_trigger.bRun=FALSE;
    else
        m_trigger.bRun=TRUE;
        
    if (Trig.m_trig.LevelCount==1)
    {
        if (Trig.m_trig.LevelID[0]==1)
            m_trigger.nTriggerSet=1;
        else if (Trig.m_trig.LevelID[0]==2)
            m_trigger.nTriggerSet=2;
        else
            m_trigger.nTriggerSet=0;
    }
    else if (Trig.m_trig.LevelCount==2)
    {
        if ((Trig.m_trig.LevelID[0]==1)&&(Trig.m_trig.LevelID[1]==2))
            m_trigger.nTriggerSet=3;
        else
            m_trigger.nTriggerSet=0;
    }
    else
    {
        m_trigger.nTriggerSet=0;
    }                              
    
    if (Trig.m_nOnOffFlg==1)
        m_trigger.bTriggerEnable=TRUE;
    else
        m_trigger.bTriggerEnable=FALSE;
}

void CTrcGrpTriggerPage::SetLevel1()
{
    switch (m_trigger.level1.nSet)
    {
        case 0:
            Le1.m_levelStruct.Condition = 0x0;
            break;
        case 1:
            Le1.m_levelStruct.Condition = 0xAAAAAAAA;
            break;
        case 2:
            Le1.m_levelStruct.Condition = 0xEEEEEEEE;
            break;
        case 3:
            Le1.m_levelStruct.Condition = 0xFAFAFAFA;
            break;
        case 4:
            Le1.m_levelStruct.Condition = 0xE0E0E0E0;
            break;
        case 5:
            Le1.m_levelStruct.Condition = 0xC8C8C8C8;
            break;
        case 6:
            Le1.m_levelStruct.Condition = 0xFEFEFEFE;
            break;
        case 7:
            Le1.m_levelStruct.Condition = 0x88888888;
            break;
        case 8:
            Le1.m_levelStruct.Condition = 0xA0A0A0A0;
            break;
        case 9:
            Le1.m_levelStruct.Condition = 0xF8F8F8F8;
            break;
        case 10:
            Le1.m_levelStruct.Condition = 0xECECECEC;
            break;
        case 11:
            Le1.m_levelStruct.Condition = 0x80808080;
            break;
        case 12:
            Le1.m_levelStruct.Condition = 0xCCCCCCCC;
            break;
        case 13:
            Le1.m_levelStruct.Condition = 0xFCFCFCFC;
            break;
        case 14:
            Le1.m_levelStruct.Condition = 0xA8A8A8A8;
            break;
        case 15:
            Le1.m_levelStruct.Condition = 0xC0C0C0C0;
            break;
        case 16:
            Le1.m_levelStruct.Condition = 0xEAEAEAEA;
            break;
        case 17:
            Le1.m_levelStruct.Condition = 0xF0F0F0F0;
            break;
    }
    
    if (m_trigger.level1.bTraceOn)
        Le1.m_levelStruct.TraceFlg=1;
    else
        Le1.m_levelStruct.TraceFlg=2;

    if (m_trigger.level1.bTimerOn)
        Le1.m_levelStruct.TimerFlg=1;
    else
        Le1.m_levelStruct.TimerFlg=2;
    
    TRIGGER_LEVEL trigLevel;
    memcpy(&trigLevel,&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
    BeginWaitCursor();
    int nErrorID=AbiSetTrigLevel(1,trigLevel);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Le1.m_levelStructSave),&(Le1.m_levelStruct),sizeof(TRIGGER_LEVEL));
    }
    else
    {
        ErrDisplayError(ER_TRCGRPF_LV_SETERROR, 0, 1);
    }
}

void CTrcGrpTriggerPage::SetLevel2()
{
    switch (m_trigger.level2.nSet)
    {
        case 0:
            Le2.m_levelStruct.Condition = 0x0;
            break;
        case 1:
            Le2.m_levelStruct.Condition = 0xAAAAAAAA;
            break;
        case 2:
            Le2.m_levelStruct.Condition = 0xEEEEEEEE;
            break;
        case 3:
            Le2.m_levelStruct.Condition = 0xFAFAFAFA;
            break;
        case 4:
            Le2.m_levelStruct.Condition = 0xE0E0E0E0;
            break;
        case 5:
            Le2.m_levelStruct.Condition = 0xC8C8C8C8;
            break;
        case 6:
            Le2.m_levelStruct.Condition = 0xFEFEFEFE;
            break;
        case 7:
            Le2.m_levelStruct.Condition = 0x88888888;
            break;
        case 8:
            Le2.m_levelStruct.Condition = 0xA0A0A0A0;
            break;
        case 9:
            Le2.m_levelStruct.Condition = 0xF8F8F8F8;
            break;
        case 10:
            Le2.m_levelStruct.Condition = 0xECECECEC;
            break;
        case 11:
            Le2.m_levelStruct.Condition = 0x80808080;
            break;
        case 12:
            Le2.m_levelStruct.Condition = 0xCCCCCCCC;
            break;
        case 13:
            Le2.m_levelStruct.Condition = 0xFCFCFCFC;
            break;
        case 14:
            Le2.m_levelStruct.Condition = 0xA8A8A8A8;
            break;
        case 15:
            Le2.m_levelStruct.Condition = 0xC0C0C0C0;
            break;
        case 16:
            Le2.m_levelStruct.Condition = 0xEAEAEAEA;
            break;
        case 17:
            Le2.m_levelStruct.Condition = 0xF0F0F0F0;
            break;
    }
    
    if (m_trigger.level2.bTraceOn)
        Le2.m_levelStruct.TraceFlg=1;
    else
        Le2.m_levelStruct.TraceFlg=2;

    if (m_trigger.level2.bTimerOn)
        Le2.m_levelStruct.TimerFlg=1;
    else
        Le2.m_levelStruct.TimerFlg=2;

    TRIGGER_LEVEL trigLevel;
    memcpy(&trigLevel,&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
    BeginWaitCursor();
    int nErrorID=AbiSetTrigLevel(2,trigLevel);
    EndWaitCursor();
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Le2.m_levelStructSave),&(Le2.m_levelStruct),sizeof(TRIGGER_LEVEL));
    }
    else
    {
        ErrDisplayError(ER_TRCGRPF_LV_SETERROR, 0, 2);
    }
}

void CTrcGrpTriggerPage::SetTrigger()
{
    if (m_trigger.bRun==FALSE)
        Trig.m_tmpTrig.RunFlg=0;
    else
        Trig.m_tmpTrig.RunFlg=1;

    switch (m_trigger.nTriggerSet)
    {
        case 0:
            Trig.m_tmpTrig.LevelCount=0;
            Trig.m_tmpTrig.LevelID[0]=0;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 1:
            Trig.m_tmpTrig.LevelCount=1;
            Trig.m_tmpTrig.LevelID[0]=1;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 2:
            Trig.m_tmpTrig.LevelCount=1;
            Trig.m_tmpTrig.LevelID[0]=2;
            Trig.m_tmpTrig.LevelID[2]=0;
            break;
        case 3:
            Trig.m_tmpTrig.LevelCount=2;
            Trig.m_tmpTrig.LevelID[0]=1;
            Trig.m_tmpTrig.LevelID[1]=2;
            break;
        default:
            break;  
    }   
    
    BYTE old=Trig.m_nOnOffFlg;
    if (m_trigger.bTriggerEnable)
        Trig.m_nOnOffFlg=1;
    else
        Trig.m_nOnOffFlg=0;
    
    TRIGGER_LOGIC trig;
    memcpy(&trig,&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
    BeginWaitCursor();
    int nErrorID=AbiSetTrigLogic(trig);
    EndWaitCursor();
    if(old!=Trig.m_nOnOffFlg)
    {
        BeginWaitCursor();
        nErrorID|=AbiSetTrigStatus(FLAG(Trig.m_nOnOffFlg));
        EndWaitCursor();
    }   
    if (ICE_OK==nErrorID)
    {
        memcpy(&(Trig.m_trig),&(Trig.m_tmpTrig),sizeof(TRIGGER_LOGIC));
    }
    else
    {
        ErrDisplayError(ER_TRCGRP_TRIGGER_SETERROR);
    }
}

BOOL CTrcGrpTriggerPage::OnSet()            //tab3
{
    unsigned char status;

    GetCpuStatus(status);
    if(status==STATUS_GO)               //CPU is run
    {
        ErrDisplayError(ER_GOFLY_ERR_MSG);
        return FALSE;
    }
    
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            SetLevel1();
            break;
        case 2:
            SetLevel2();
            break;
        default:
            break;
    }
    SetTrigger();
    return TRUE;
}

void CTrcGrpTriggerPage::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTrcGrpTriggerPage)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpTriggerPage, CPropertyPage)
    //{{AFX_MSG_MAP(CTrcGrpTriggerPage)
        // NOTE: the ClassWizard will add message map macros here
    ON_BN_CLICKED(IDC_GRPTRC_TRG_LV1, OnGrptrcTrgLv1)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_LV2, OnGrptrcTrgLv2)
    ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_EVTYPE, OnSelendokGrptrcTrgEvtype)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TRCON, OnGrptrcTrgTrcon)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TRCOFF, OnGrptrcTrgTrcoff)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TIMERON, OnGrptrcTrgTimeron)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_TIMEROFF, OnGrptrcTrgTimeroff)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_ENABLE, OnGrptrcTrgEnable)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_DISABLE, OnGrptrcTrgDisable)
    ON_BN_CLICKED(IDC_GRPTRC_TRG_RUN, OnGrptrcTrgRun)
    ON_CBN_SELCHANGE(IDC_GRPTRC_TRG_COMBO, OnSelendokGrptrcTrgCombo)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpTriggerPage message handlers

BOOL CTrcGrpTriggerPage::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    TriggerInit();
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpTriggerPage::OnGrptrcTrgLv1()
{
    // TODO: Add your control notification handler code here
    if(m_trigger.nActiveLevel==1)
        return;
    m_trigger.nActiveLevel = 1;
    TriggerInit();
}

void CTrcGrpTriggerPage::OnGrptrcTrgLv2()
{
    // TODO: Add your control notification handler code here
    if(m_trigger.nActiveLevel==2)
        return;
    m_trigger.nActiveLevel = 2;
    TriggerInit();
}

void CTrcGrpTriggerPage::OnSelendokGrptrcTrgEvtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_EVTYPE);
    int i = t->GetCurSel();
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            m_trigger.level1.nSet = i;
            break;
        case 2:
            m_trigger.level2.nSet = i;
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgTrcon()
{
    // TODO: Add your control notification handler code here
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            if(m_trigger.level1.bTraceOn == TRUE)
                return;
            m_trigger.level1.bTraceOn = TRUE;
            break;
        case 2:
            if(m_trigger.level2.bTraceOn ==TRUE)
                return;
            m_trigger.level2.bTraceOn = TRUE;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgTrcoff()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TRCON, IDC_GRPTRC_TRG_TRCOFF, IDC_GRPTRC_TRG_TRCOFF);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            if(m_trigger.level1.bTraceOn == FALSE)
                return;
            m_trigger.level1.bTraceOn = FALSE;
            break;
        case 2:
            if(m_trigger.level2.bTraceOn == FALSE)
                return;
            m_trigger.level2.bTraceOn = FALSE;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgTimeron()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMERON);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            if(m_trigger.level1.bTimerOn)
                return;
            m_trigger.level1.bTimerOn = TRUE;
            break;
        case 2:
            if(m_trigger.level2.bTimerOn)
                return;
            m_trigger.level2.bTimerOn = TRUE;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgTimeroff()
{
    // TODO: Add your control notification handler code here
//  CheckRadioButton(IDC_GRPTRC_TRG_TIMERON, IDC_GRPTRC_TRG_TIMEROFF, IDC_GRPTRC_TRG_TIMEROFF);
    switch (m_trigger.nActiveLevel)
    {
        case 1:
            if(!m_trigger.level1.bTimerOn)
                return;
            m_trigger.level1.bTimerOn = FALSE;
            break;
        case 2:
            if(!m_trigger.level2.bTimerOn)
                return;
            m_trigger.level2.bTimerOn = FALSE;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgEnable()
{
    // TODO: Add your control notification handler code here
    if(m_trigger.bTriggerEnable)
        return;
    m_trigger.bTriggerEnable = TRUE;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgDisable()
{
    // TODO: Add your control notification handler code here
    if(!m_trigger.bTriggerEnable)
        return;
    m_trigger.bTriggerEnable = FALSE;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnGrptrcTrgRun()
{
    // TODO: Add your control notification handler code here
    if (IsDlgButtonChecked(IDC_GRPTRC_TRG_RUN)==0) m_trigger.bRun = FALSE;
    else m_trigger.bRun = TRUE;
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpTriggerPage::OnSelendokGrptrcTrgCombo()
{
    // TODO: Add your control notification handler code here
    CComboBox* t = (CComboBox *)GetDlgItem(IDC_GRPTRC_TRG_COMBO);
    m_trigger.nTriggerSet = t->GetCurSel();
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage dialog

CTrcGrpFilterPage::CTrcGrpFilterPage()
    : CCheckPage(CTrcGrpFilterPage::IDD)
{
    //{{AFX_DATA_INIT(CTrcGrpFilterPage)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_filter.nActiveChoice = 1;                 
    m_filter.nDisplayAddrMode = 1;
    m_filter.DisplayStartAddrTxt[0]='\0';
    m_filter.DisplayStartAddrTxt2[0]='\0';
    m_filter.DisplayStartAddrTxt3[0]='\0';
    m_filter.DisplayEndAddrTxt[0]='\0';
    m_filter.nDisplayAddrType = 0;
    m_filter.nDisplayDataMode = 1;
    m_filter.DisplayStartDataTxt[0]='\0';
    m_filter.DisplayStartDataTxt2[0]='\0';
    m_filter.DisplayStartDataTxt3[0]='\0';
    m_filter.DisplayEndDataTxt[0]='\0';
    m_filter.nDisplayDataType=0;
    
    m_filter.bDisplayS = FALSE;
    m_filter.bDisplayF = FALSE;
    m_filter.bDisplayR = FALSE;
    m_filter.bDisplayW = FALSE;
    m_filter.bDisplayAK = FALSE;
    
    m_filter.nTraceAddrMode = 1;
    m_filter.TraceStartAddrTxt[0]='\0';
    m_filter.TraceStartAddrTxt2[0]='\0';    
    m_filter.TraceStartAddrTxt3[0]='\0';
    m_filter.TraceEndAddrTxt[0]='\0';
    m_filter.nTraceAddrType = 0;
    m_filter.nTraceDataMode = 1;
    m_filter.TraceStartDataTxt[0]='\0';
    m_filter.TraceStartDataTxt2[0]='\0';
    m_filter.TraceStartDataTxt3[0]='\0';    
    m_filter.TraceEndDataTxt[0]='\0';
    m_filter.nTraceDataType=0;
    
    m_filter.bTraceS = FALSE;
    m_filter.bTraceF = FALSE;
    m_filter.bTraceR = FALSE;
    m_filter.bTraceW = FALSE;
    m_filter.bTraceAK = FALSE;                   
    
    m_bDisplayChange=FALSE;
    m_bApply=FALSE;
    m_nIDHelp=IDD_TRCGRP_FILTER;
    
    GetDisplayFilter();
    GetTraceFilter();
}

BOOL CTrcGrpFilterPage::OnSetActive()
{
    CPropertyPage::OnSetActive();
    SetModified(m_bApply);
    return TRUE;
}

BOOL CTrcGrpFilterPage::OnKillActive()
{
    if(m_bApply)
        m_bChanged=FALSE;
    return TRUE;
}

void CTrcGrpFilterPage::OnOK()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
    if(!m_bApply)
        return;
    if(OnSet())
    {   
        CPropertyPage::OnOK();
        SetModified(FALSE);
        m_bApply=FALSE;
        ASSERT(m_pParentWnd->IsKindOf(RUNTIME_CLASS(CTraceGroupDialog)));
        ((CTraceGroupDialog*)m_pParentWnd)->m_bDisplayChange=m_bDisplayChange;
    }
    else ((CTraceGroupDialog*)GetParent())->forlive(TRUE);
}

void CTrcGrpFilterPage::OnCancel()
{
    ((CTraceGroupDialog*)GetParent())->forlive(FALSE);
}

void CTrcGrpFilterPage::FilterInit()
{   
    BOOL old=m_bApply;
    m_bApply=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_DISPLAY);   
            DisplayInit();
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_DISPLAY,IDC_GRPTRC_FLT_TRACE,IDC_GRPTRC_FLT_TRACE); 
            TraceInit();
            break;
        default:
            break;
    }
    m_bApply=old;
}                   

void CTrcGrpFilterPage::DisplayInit()
{
    if (m_filter.nDisplayAddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
    }
    if (m_filter.nDisplayDataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Da&ta");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
    }

    switch (m_filter.nDisplayAddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
        default:
            break;
    }

    switch (m_filter.nDisplayDataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
        default:
            break;
    }

    if(m_filter.nDisplayAddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.DisplayEndAddrTxt);
        }
    else if(m_filter.nDisplayAddrMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt2);
    else if(m_filter.nDisplayAddrMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.DisplayStartAddrTxt3);
    CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_filter.nDisplayAddrType);

    t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_filter.nDisplayDataType);
    if(m_filter.nDisplayDataMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.DisplayEndDataTxt);
        }
    else if(m_filter.nDisplayDataMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt2);
    else if(m_filter.nDisplayDataMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.DisplayStartDataTxt3);
    if (m_filter.bDisplayS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

    if (m_filter.bDisplayF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

    if (m_filter.bDisplayR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

    if (m_filter.bDisplayW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

    if (m_filter.bDisplayAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}

void CTrcGrpFilterPage::TraceInit()
{
    if (m_filter.nTraceAddrMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Addr&ess");
    }                       
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTADDR)->SetWindowText("Start Addr&ess");
    }
    if (m_filter.nTraceDataMode!=1)
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(FALSE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Da&ta");
    }
    else
    {
        GetDlgItem(IDC_GRPTRC_FLT_DATATYPE)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->ShowWindow(TRUE);
        GetDlgItem(IDC_GRPTRC_FLT_STATIC_STARTDATA)->SetWindowText("Start Da&ta");
    }

    switch (m_filter.nTraceAddrMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_RANGE1);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_MULTI1);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE1,IDC_GRPTRC_FLT_WILD1,IDC_GRPTRC_FLT_WILD1);
        default:
            break;
    }

    switch (m_filter.nTraceDataMode)
    {
        case 1:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_RANGE2);
            break;
        case 2:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_MULTI2);
            break;
        case 3:
            CheckRadioButton(IDC_GRPTRC_FLT_RANGE2,IDC_GRPTRC_FLT_WILD2,IDC_GRPTRC_FLT_WILD2);
        default:
            break;
    }

    if(m_filter.nTraceAddrMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.TraceEndAddrTxt);
        }
    else if(m_filter.nTraceAddrMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt2);
    else if(m_filter.nTraceAddrMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR,m_filter.TraceStartAddrTxt3);
    CWnd* t=GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    CComboBox* a=(CComboBox *)t;
    a->SetCurSel(m_filter.nTraceAddrType);

    t=GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    a=(CComboBox *)t;
    a->SetCurSel(m_filter.nTraceDataType);
    
    if(m_filter.nTraceDataMode==1)
        {
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt);
         SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.TraceEndDataTxt);
        }
    else if(m_filter.nTraceDataMode==2)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt2);  
    else if(m_filter.nTraceDataMode==3)
         SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA,m_filter.TraceStartDataTxt3);  
    
    if (m_filter.bTraceS) CheckDlgButton(IDC_GRPTRC_FLT_S, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_S, FALSE);

    if (m_filter.bTraceF) CheckDlgButton(IDC_GRPTRC_FLT_F, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_F, FALSE);

    if (m_filter.bTraceR) CheckDlgButton(IDC_GRPTRC_FLT_R, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_R, FALSE);

    if (m_filter.bTraceW) CheckDlgButton(IDC_GRPTRC_FLT_W, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_W, FALSE);

    if (m_filter.bTraceAK) CheckDlgButton(IDC_GRPTRC_FLT_AK, TRUE);
    else CheckDlgButton(IDC_GRPTRC_FLT_AK, FALSE);
}

void CTrcGrpFilterPage::GetDisplayFilter()
{
    int i,j, ii;
    char txt[200];
            
    switch (softQlfy.qlfyType[4])
    {
        case 0:                                  
            m_filter.nDisplayAddrMode = 3;
            strcpy(m_filter.DisplayStartAddrTxt3,"xxxx");
            break;
        case 2:                    
            _itoa(softQlfy.addr[0][0],m_filter.DisplayStartAddrTxt3,2);
            i = strlen(m_filter.DisplayStartAddrTxt3);
            strncpy(txt,m_filter.DisplayStartAddrTxt3,64);
            strcpy(&(m_filter.DisplayStartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_filter.DisplayStartAddrTxt3[j]='0';
                      
            if ((softQlfy.addr[1][0]&0x8000)==0)
                m_filter.DisplayStartAddrTxt3[0]='x';
                
            if ((softQlfy.addr[1][0]&0x4000)==0)
                m_filter.DisplayStartAddrTxt3[1]='x';

            if ((softQlfy.addr[1][0]&0x2000)==0)
                m_filter.DisplayStartAddrTxt3[2]='x';

            if ((softQlfy.addr[1][0]&0x1000)==0)
                m_filter.DisplayStartAddrTxt3[3]='x';

            if ((softQlfy.addr[1][0]&0x800)==0)
                m_filter.DisplayStartAddrTxt3[4]='x';

            if ((softQlfy.addr[1][0]&0x400)==0)
                m_filter.DisplayStartAddrTxt3[5]='x';

            if ((softQlfy.addr[1][0]&0x200)==0)
                m_filter.DisplayStartAddrTxt3[6]='x';

            if ((softQlfy.addr[1][0]&0x100)==0)
                m_filter.DisplayStartAddrTxt3[7]='x';

            if ((softQlfy.addr[1][0]&0x80)==0)
                m_filter.DisplayStartAddrTxt3[8]='x';

            if ((softQlfy.addr[1][0]&0x40)==0)
                m_filter.DisplayStartAddrTxt3[9]='x';

            if ((softQlfy.addr[1][0]&0x20)==0)
                m_filter.DisplayStartAddrTxt3[10]='x';

            if ((softQlfy.addr[1][0]&0x10)==0)
                m_filter.DisplayStartAddrTxt3[11]='x';

            if ((softQlfy.addr[1][0]&0x8)==0)
                m_filter.DisplayStartAddrTxt3[12]='x';

            if ((softQlfy.addr[1][0]&0x4)==0)
                m_filter.DisplayStartAddrTxt3[13]='x';

            if ((softQlfy.addr[1][0]&0x2)==0)
                m_filter.DisplayStartAddrTxt3[14]='x';

            if ((softQlfy.addr[1][0]&0x1)==0)
                m_filter.DisplayStartAddrTxt3[15]='x';
                
            m_filter.DisplayStartAddrTxt3[16]='\0';
            compressWild(m_filter.DisplayStartAddrTxt3);
            m_filter.nDisplayAddrMode = 3;
            break;
        case 0x10:                       
//            SetAddrText(softQlfy.addr[0][1], softQlfy.addr[0][0],
            SetAddrText(0, softQlfy.addr[0][0],
                        m_filter.DisplayStartAddrTxt);
//            SetAddrText(softQlfy.addr[1][1], softQlfy.addr[1][0],
            SetAddrText(0, softQlfy.addr[1][0],
                        m_filter.DisplayEndAddrTxt);
            m_filter.nDisplayAddrType = 0;
            m_filter.nDisplayAddrMode = 1;
            break;
        case 0x40:                   
            m_filter.DisplayStartAddrTxt2[0]=NULL;
            for(ii=0; ii<int(softQlfy.addrCount); ii++)
            {
                strcat(m_filter.DisplayStartAddrTxt2,
//                  RetAddrText(softQlfy.addr[ii][1], softQlfy.addr[ii][0]));
                    RetAddrText(0, softQlfy.addr[ii][0]));
                strcat(m_filter.DisplayStartAddrTxt2," ");
            }
            m_filter.nDisplayAddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (softQlfy.qlfyType[6])
    {
        case 0:   
            m_filter.nDisplayDataMode = 3;                     
            strcpy(m_filter.DisplayStartDataTxt3,"xx");
            break;
        case 2:
            _itoa(((WORD)softQlfy.data1),m_filter.DisplayStartDataTxt3,2);
//          strncpy(m_filter.DisplayStartDataTxt, &(m_filter.DisplayStartDataTxt[8]), 8);
            i = strlen(m_filter.DisplayStartDataTxt3);
            strncpy(txt,m_filter.DisplayStartDataTxt3,64);
            strcpy(&(m_filter.DisplayStartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_filter.DisplayStartDataTxt3[j]='0';
                      
            if ((softQlfy.data2&0x80)==0)
                m_filter.DisplayStartDataTxt3[0]='x';

            if ((softQlfy.data2&0x40)==0)
                m_filter.DisplayStartDataTxt3[1]='x';

            if ((softQlfy.data2&0x20)==0)
                m_filter.DisplayStartDataTxt3[2]='x';

            if ((softQlfy.data2&0x10)==0)
                m_filter.DisplayStartDataTxt3[3]='x';

            if ((softQlfy.data2&0x8)==0)
                m_filter.DisplayStartDataTxt3[4]='x';

            if ((softQlfy.data2&0x4)==0)
                m_filter.DisplayStartDataTxt3[5]='x';

            if ((softQlfy.data2&0x2)==0)
                m_filter.DisplayStartDataTxt3[6]='x';

            if ((softQlfy.data2&0x1)==0)
                m_filter.DisplayStartDataTxt3[7]='x';
                
            m_filter.DisplayStartDataTxt3[8]='\0';
            compressWild(m_filter.DisplayStartDataTxt3);
            m_filter.nDisplayDataMode = 3;
            break;
        case 0x10:
            sprintf(m_filter.DisplayStartDataTxt,"0x%02x",softQlfy.data1);
            //sprintf(m_filter.DisplayStartDataTxt,"%u",softQlfy.data1);
            sprintf(m_filter.DisplayEndDataTxt,"0x%02x",softQlfy.data2);
            //sprintf(m_filter.DisplayEndDataTxt,"%u",softQlfy.data2);
            m_filter.nDisplayDataType=0;
            m_filter.nDisplayDataMode = 1;
            break;
        case 0x1:
            sprintf(m_filter.DisplayStartDataTxt2,"0x%02x",softQlfy.data1);
            //sprintf(m_filter.DisplayStartDataTxt2,"%u",softQlfy.data1);
            m_filter.nDisplayDataMode = 2;
        default:
            break;
    }             

    m_filter.bDisplayS = FALSE;
    m_filter.bDisplayF = FALSE;
    m_filter.bDisplayR = FALSE;
    m_filter.bDisplayW = FALSE;
    m_filter.bDisplayAK = FALSE;
    switch (softQlfy.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((softQlfy.status&1)==1)
                m_filter.bDisplayS = TRUE;
            if ((softQlfy.status&2)==2)
                m_filter.bDisplayF = TRUE;
            if ((softQlfy.status&4)==4)
                m_filter.bDisplayR = TRUE;
            if ((softQlfy.status&8)==8)
                m_filter.bDisplayW = TRUE;
            if ((softQlfy.status&0x10)==0x10)
                m_filter.bDisplayAK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTrcGrpFilterPage::GetTraceFilter()
{
    int i,j, ii;
    char txt[200];
            
    if (qlfy.m_nClearflag==1)
    {  
        m_filter.nTraceAddrMode = 1;
        m_filter.TraceStartAddrTxt[0]='\0';
        m_filter.TraceEndAddrTxt[0]='\0';
        m_filter.nTraceAddrType = 0;
        m_filter.nTraceDataMode = 1;
        m_filter.TraceStartDataTxt[0]='\0';
        m_filter.TraceEndDataTxt[0]='\0';
        m_filter.nTraceDataType=0;
        m_filter.bTraceS = FALSE;
        m_filter.bTraceF = FALSE;
        m_filter.bTraceR = FALSE;
        m_filter.bTraceW = FALSE;
        m_filter.bTraceAK = FALSE;
        return;
    }          
    
    switch (qlfy.m_qlfy.qlfyType[4])
    {
        case 0:                                  
            m_filter.nTraceAddrMode = 3;
            strcpy(m_filter.TraceStartAddrTxt3,"xxxx");
            break;
        case 2:                    
            _itoa(qlfy.m_qlfy.addr[0][0],m_filter.TraceStartAddrTxt3,2);
            i = strlen(m_filter.TraceStartAddrTxt3);
            strncpy(txt,m_filter.TraceStartAddrTxt3,64);
            strcpy(&(m_filter.TraceStartAddrTxt3[16-i]),txt);
            for(j=0;j<16-i;j++)
                m_filter.TraceStartAddrTxt3[j]='0';
                      
            if ((qlfy.m_qlfy.addr[1][0]&0x8000)==0)
                m_filter.TraceStartAddrTxt3[0]='x';
                
            if ((qlfy.m_qlfy.addr[1][0]&0x4000)==0)
                m_filter.TraceStartAddrTxt3[1]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x2000)==0)
                m_filter.TraceStartAddrTxt3[2]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x1000)==0)
                m_filter.TraceStartAddrTxt3[3]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x800)==0)
                m_filter.TraceStartAddrTxt3[4]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x400)==0)
                m_filter.TraceStartAddrTxt3[5]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x200)==0)
                m_filter.TraceStartAddrTxt3[6]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x100)==0)
                m_filter.TraceStartAddrTxt3[7]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x80)==0)
                m_filter.TraceStartAddrTxt3[8]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x40)==0)
                m_filter.TraceStartAddrTxt3[9]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x20)==0)
                m_filter.TraceStartAddrTxt3[10]='x';
                                                
            if ((qlfy.m_qlfy.addr[1][0]&0x10)==0)
                m_filter.TraceStartAddrTxt3[11]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x8)==0)
                m_filter.TraceStartAddrTxt3[12]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x4)==0)
                m_filter.TraceStartAddrTxt3[13]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x2)==0)
                m_filter.TraceStartAddrTxt3[14]='x';

            if ((qlfy.m_qlfy.addr[1][0]&0x1)==0)
                m_filter.TraceStartAddrTxt3[15]='x';
                
            m_filter.TraceStartAddrTxt3[16]='\0';
            compressWild(m_filter.TraceStartAddrTxt3);
            m_filter.nTraceAddrMode = 3;
            break;
        case 0x10:                       
            SetAddrText(qlfy.m_qlfy.addr[0][1], qlfy.m_qlfy.addr[0][0],
                        m_filter.TraceStartAddrTxt);
            SetAddrText(qlfy.m_qlfy.addr[1][1], qlfy.m_qlfy.addr[1][0],
                        m_filter.TraceEndAddrTxt);
            m_filter.nTraceAddrType = 0;
            m_filter.nTraceAddrMode = 1;
            break;
        case 0x40:                   
            m_filter.TraceStartAddrTxt2[0]=NULL;
            for(ii=0; ii<int(qlfy.m_qlfy.addrCount); ii++)
            {
                strcat(m_filter.TraceStartAddrTxt2,
                    RetAddrText(qlfy.m_qlfy.addr[ii][1], qlfy.m_qlfy.addr[ii][0]));
                strcat(m_filter.TraceStartAddrTxt2," ");
            }
            m_filter.nTraceAddrMode = 2;
            break;
        default:
            break;
    }             
    
    switch (qlfy.m_qlfy.qlfyType[6])
    {
        case 0:   
            m_filter.nTraceDataMode = 3;                     
            strcpy(m_filter.TraceStartDataTxt3,"xx");
            break;
        case 2:
            _itoa(((WORD)qlfy.m_qlfy.data1),m_filter.TraceStartDataTxt3,2);
//          strncpy(m_filter.TraceStartDataTxt, &(m_filter.TraceStartDataTxt[8]), 8);
            i = strlen(m_filter.TraceStartDataTxt3);
            strncpy(txt,m_filter.TraceStartDataTxt3,64);
            strcpy(&(m_filter.TraceStartDataTxt3[8-i]),txt);
            for(j=0;j<8-i;j++)
                m_filter.TraceStartDataTxt3[j]='0';
                      
            if ((qlfy.m_qlfy.data2&0x80)==0)
                m_filter.TraceStartDataTxt3[0]='x';

            if ((qlfy.m_qlfy.data2&0x40)==0)
                m_filter.TraceStartDataTxt3[1]='x';

            if ((qlfy.m_qlfy.data2&0x20)==0)
                m_filter.TraceStartDataTxt3[2]='x';
                                                 
            if ((qlfy.m_qlfy.data2&0x10)==0)
                m_filter.TraceStartDataTxt3[3]='x';

            if ((qlfy.m_qlfy.data2&0x8)==0)
                m_filter.TraceStartDataTxt3[4]='x';

            if ((qlfy.m_qlfy.data2&0x4)==0)
                m_filter.TraceStartDataTxt3[5]='x';

            if ((qlfy.m_qlfy.data2&0x2)==0)
                m_filter.TraceStartDataTxt3[6]='x';

            if ((qlfy.m_qlfy.data2&0x1)==0)
                m_filter.TraceStartDataTxt3[7]='x';
                
            m_filter.TraceStartDataTxt3[8]='\0';    
            compressWild(m_filter.TraceStartDataTxt3);
            m_filter.nTraceDataMode = 3;
            break;
        case 0x10:
            sprintf(m_filter.TraceStartDataTxt,"0x%02x",qlfy.m_qlfy.data1);
            //sprintf(m_filter.TraceStartDataTxt,"%u",qlfy.m_qlfy.data1);
            sprintf(m_filter.TraceEndDataTxt,"0x%02x",qlfy.m_qlfy.data2);
            //sprintf(m_filter.TraceEndDataTxt,"%u",qlfy.m_qlfy.data2);
            m_filter.nTraceDataType=0;
            m_filter.nTraceDataMode = 1;
            break;
        case 0x1:
            sprintf(m_filter.TraceStartDataTxt2,"0x%02x",qlfy.m_qlfy.data1);
            //sprintf(m_filter.TraceStartDataTxt2,"%u",qlfy.m_qlfy.data1);
            m_filter.nTraceDataMode = 2;
        default:
            break;
    }             

    m_filter.bTraceS = FALSE;
    m_filter.bTraceF = FALSE;
    m_filter.bTraceR = FALSE;
    m_filter.bTraceW = FALSE;
    m_filter.bTraceAK = FALSE;
    switch (qlfy.m_qlfy.qlfyType[8])
    {
        case 0:
            break;
        case 1:
            if ((qlfy.m_qlfy.status&1)==1)
                m_filter.bTraceS = TRUE;
            if ((qlfy.m_qlfy.status&2)==2)
                m_filter.bTraceF = TRUE;
            if ((qlfy.m_qlfy.status&4)==4)
                m_filter.bTraceR = TRUE;
            if ((qlfy.m_qlfy.status&8)==8)
                m_filter.bTraceW = TRUE;
            if ((qlfy.m_qlfy.status&0x10)==0x10)
                m_filter.bTraceAK = TRUE;
            break;            
        default:
            break;
    }             
}

void CTrcGrpFilterPage::SetDisplayFilter()
{
    long lVar1;   
    
    memcpy(&softQlfy,&m_EvBus,sizeof(BUS_EVENT));
    
    lVar1=0;
    if (m_filter.bDisplayS) lVar1+=0x1;
    if (m_filter.bDisplayF) lVar1+=0x2;
    if (m_filter.bDisplayR) lVar1+=0x4;
    if (m_filter.bDisplayW) lVar1+=0x8;
    if (m_filter.bDisplayAK) lVar1+=0x10;
    
    softQlfy.status = (DWORD)lVar1;
    if (lVar1>0) softQlfy.qlfyType[8]=1;
    else softQlfy.qlfyType[8]=0;
}

void CTrcGrpFilterPage::SetTraceFilter()
{
    long lVar1;
    
    qlfy.m_nClearflag = 0;
    
    lVar1=0;
    if (m_filter.bTraceS) lVar1+=0x1;
    if (m_filter.bTraceF) lVar1+=0x2;
    if (m_filter.bTraceR) lVar1+=0x4;
    if (m_filter.bTraceW) lVar1+=0x8;
    if (m_filter.bTraceAK) lVar1+=0x10;
    
    m_EvBus.status = (DWORD)lVar1;
    if (lVar1>0) 
        m_EvBus.qlfyType[8]=1;
    else 
        m_EvBus.qlfyType[8]=0;
    BeginWaitCursor();
    int nErrorID = AbiSetQualify(m_EvBus);
    EndWaitCursor();
    
    if (ICE_OK==nErrorID)
    {
        memcpy(&(qlfy.m_qlfy),&m_EvBus,sizeof(QUALIFY));
    }
    else
    {
        ErrDisplayError(ER_TRCGRP_QUALIFY_SETERROR);
    }   
}
      
BOOL CTrcGrpFilterPage::OnSet()                     //tab4
{
    m_bEmptyFlag=TRUE;
    m_nold_addrmode=0;
    m_nold_datamode=0;

    m_nErrLocate=0;     //1:startaddr; 2:endaddr; 3:startdata; 4:enddata
                        //5:count.

    switch(m_filter.nActiveChoice)
    {
     case 1:                                        //display
        m_EvBus.setMode=0;
        m_EvBus.qlfyType[0]=0;
        if(m_filter.nDisplayAddrMode==3)
            chkWildAddr(m_filter.DisplayStartAddrTxt3);
        else if(m_filter.nDisplayAddrMode==1)
            chkRangeAddr(m_filter.nDisplayAddrType, m_filter.DisplayStartAddrTxt,
                    m_filter.DisplayEndAddrTxt);
        else if(m_filter.nDisplayAddrMode==2)
            chkMultipleAddr(m_filter.DisplayStartAddrTxt2);
        if(m_nErrLocate)
            break;
        if(m_filter.nDisplayDataMode==3)
            chkWildData(m_filter.DisplayStartDataTxt3);
        else if(m_filter.nDisplayDataMode==1)
            chkRangeData(m_filter.nDisplayDataType, m_filter.DisplayStartDataTxt,
                        m_filter.DisplayEndDataTxt);
        else if(m_filter.nDisplayDataMode==2)
            chkSingleData(m_filter.DisplayStartDataTxt2);
        if(m_nErrLocate)
            break;
        if(m_filter.bDisplayS||m_filter.bDisplayF||m_filter.bDisplayR
                       ||m_filter.bDisplayW||m_filter.bDisplayAK
                       ||!m_bEmptyFlag)
        {
            SetDisplayFilter();
            if(m_nold_datamode)
            {
                m_filter.nDisplayDataMode=3;
                strcpy(m_filter.DisplayStartDataTxt3,"xx");
            }
            if(m_nold_addrmode)
            {
                m_filter.nDisplayAddrMode=3;
                strcpy(m_filter.DisplayStartAddrTxt3,"xxxx");
            }
            if(m_nold_addrmode||m_nold_datamode) 
                DisplayInit();
            m_bDisplayChange=TRUE;
            return TRUE;    
        }
        else
        {
            ErrDisplayError(ER_TRCGRP_NONEINPUT);
            return FALSE;
        }
        break;
     case 2:                                        //trace
        unsigned char status;

        GetCpuStatus(status);
        if(status==STATUS_GO)               //CPU is run
        {
            ErrDisplayError(ER_GOFLY_ERR_MSG);
            return FALSE;
        }
        
        m_EvBus.setMode=1;
        m_EvBus.qlfyType[0]=0;
        if(m_filter.nTraceAddrMode==3)
            chkWildAddr(m_filter.TraceStartAddrTxt3);
        else if(m_filter.nTraceAddrMode==1)
            chkRangeAddr(m_filter.nTraceAddrType, m_filter.TraceStartAddrTxt,
                        m_filter.TraceEndAddrTxt);
        else if(m_filter.nTraceAddrMode==2)
            chkMultipleAddr(m_filter.TraceStartAddrTxt2);
        if(m_nErrLocate)
            break;
        if(m_filter.nTraceDataMode==3)
            chkWildData(m_filter.TraceStartDataTxt3);
        else if(m_filter.nTraceDataMode==1)
            chkRangeData(m_filter.nTraceDataType, m_filter.TraceStartDataTxt,
                        m_filter.TraceEndDataTxt);
        else if(m_filter.nTraceDataMode==2)
            chkSingleData(m_filter.TraceStartDataTxt2);
        if(m_nErrLocate)
            break;
        if(m_filter.bTraceS||m_filter.bTraceF||m_filter.bTraceR
                       ||m_filter.bTraceW||m_filter.bTraceAK
                       ||!m_bEmptyFlag)
        {
            SetTraceFilter();
            if(m_nold_datamode)
            {
                m_filter.nTraceDataMode=3;
                strcpy(m_filter.TraceStartDataTxt3,"xx");
            }
            if(m_nold_addrmode)
            {
                m_filter.nTraceAddrMode=3;
                strcpy(m_filter.TraceStartAddrTxt3,"xxxx");
            }
            if(m_nold_addrmode||m_nold_datamode) 
                TraceInit();
            return TRUE;    
        }
        else
        {
            ErrDisplayError(ER_TRCGRP_NONEINPUT);
            return FALSE;
        }
        break;
     default:
        return FALSE;
    }
    if(m_nErrLocate==1)
        GetDlgItem(IDC_GRPTRC_FLT_STARTADDR)->SetFocus();
    else if(m_nErrLocate==2)
        GetDlgItem(IDC_GRPTRC_FLT_ENDADDR)->SetFocus();
    else if(m_nErrLocate==3)
        GetDlgItem(IDC_GRPTRC_FLT_STARTDATA)->SetFocus();
    else if(m_nErrLocate==4)
        GetDlgItem(IDC_GRPTRC_FLT_ENDDATA)->SetFocus();
    return FALSE;
}

void CTrcGrpFilterPage::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CTrcGrpFilterPage)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTrcGrpFilterPage, CPropertyPage)
    //{{AFX_MSG_MAP(CTrcGrpFilterPage)
        // NOTE: the ClassWizard will add message map macros here
    ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_ADDRTYPE, OnSelendokGrptrcFltAddrtype)
    ON_CBN_SELCHANGE(IDC_GRPTRC_FLT_DATATYPE, OnSelendokGrptrcFltDatatype)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_DISPLAY, OnGrptrcFltDisplay)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_TRACE, OnGrptrcFltTrace)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI1, OnGrptrcFltMulti1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_MULTI2, OnGrptrcFltMulti2)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE1, OnGrptrcFltRange1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_RANGE2, OnGrptrcFltRange2)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD1, OnGrptrcFltWild1)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_WILD2, OnGrptrcFltWild2)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDADDR, OnChangeGrptrcFltEndaddr)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_ENDDATA, OnChangeGrptrcFltEnddata)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTADDR, OnChangeGrptrcFltStartaddr)
    ON_EN_CHANGE(IDC_GRPTRC_FLT_STARTDATA, OnChangeGrptrcFltStartdata)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_AK, OnGrptrcFltAk)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_F, OnGrptrcFltF)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_R, OnGrptrcFltR)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_S, OnGrptrcFltS)
    ON_BN_CLICKED(IDC_GRPTRC_FLT_W, OnGrptrcFltW)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CTrcGrpFilterPage message handlers
BOOL CTrcGrpFilterPage::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    FilterInit();
    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTrcGrpFilterPage::OnSelendokGrptrcFltAddrtype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_ADDRTYPE);
    int i=t->GetCurSel();
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            m_filter.nDisplayAddrType = i;
            break;
        case 2:
            m_filter.nTraceAddrType = i;
            break;
        default:
            break;
    }
}

void CTrcGrpFilterPage::OnSelendokGrptrcFltDatatype()
{
    // TODO: Add your control notification handler code here
    CComboBox* t;
    t = (CComboBox *)GetDlgItem(IDC_GRPTRC_FLT_DATATYPE);
    int i=t->GetCurSel();
    switch (m_filter.nActiveChoice)
    {
        case 1:   
            m_filter.nDisplayDataType = i;
            break;
        case 2:
            m_filter.nTraceDataType = i;
            break;
        default:
            break;
    }
    
}

void CTrcGrpFilterPage::OnGrptrcFltDisplay()
{
    // TODO: Add your control notification handler code here
    m_filter.nActiveChoice = 1;
    
    FilterInit();
}

void CTrcGrpFilterPage::OnGrptrcFltTrace()
{
    // TODO: Add your control notification handler code here
    m_filter.nActiveChoice = 2;
    
    FilterInit();
}

void CTrcGrpFilterPage::OnGrptrcFltMulti1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 2;
            break;
        case 2:
            m_filter.nTraceAddrMode = 2;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt2);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt2);
            break;
        default:
            break;
    }

}

void CTrcGrpFilterPage::OnGrptrcFltMulti2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 2;
            break;
        case 2:
            m_filter.nTraceDataMode = 2;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt2);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt2);
            break;
        default:
            break;
    }
}

void CTrcGrpFilterPage::OnGrptrcFltRange1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 1;
            break;
        case 2:
            m_filter.nTraceAddrMode = 1;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.DisplayEndAddrTxt);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDADDR,m_filter.TraceEndAddrTxt);
            break;
        default:
            break;
    }

}

void CTrcGrpFilterPage::OnGrptrcFltRange2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 1;
            break;
        case 2:
            m_filter.nTraceDataMode = 1;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.DisplayEndDataTxt);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt);
            SetDlgItemText(IDC_GRPTRC_FLT_ENDDATA,m_filter.TraceEndDataTxt);
            break;
        default:
            break;
    }
    
}

void CTrcGrpFilterPage::OnGrptrcFltWild1()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayAddrMode = 3;
            break;
        case 2:
            m_filter.nTraceAddrMode = 3;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt3);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt3);
            break;
        default:
            break;
    }
}

void CTrcGrpFilterPage::OnGrptrcFltWild2()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.nDisplayDataMode = 3;
            break;
        case 2:
            m_filter.nTraceDataMode = 3;
            break;
        default:
            break;
    }
    FilterInit();
    switch (m_filter.nActiveChoice)
    {
        case 1:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt3);
            break;
        case 2:
            SetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt3);
            break;
        default:
            break;
    }
}

void CTrcGrpFilterPage::OnChangeGrptrcFltEndaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDADDR, m_filter.DisplayEndAddrTxt, 64);
            break;
        case 2:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDADDR, m_filter.TraceEndAddrTxt, 64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnChangeGrptrcFltEnddata()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDDATA, m_filter.DisplayEndDataTxt, 64);
            break;
        case 2:
            GetDlgItemText(IDC_GRPTRC_FLT_ENDDATA, m_filter.TraceEndDataTxt, 64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnChangeGrptrcFltStartaddr()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            if(m_filter.nDisplayAddrMode == 1)//range
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt, 64);
            else if(m_filter.nDisplayAddrMode == 2)//multiple
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt2, 164);
            else if(m_filter.nDisplayAddrMode == 3)//wildcard
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.DisplayStartAddrTxt3, 64);
            break;
        case 2:
            if(m_filter.nTraceAddrMode == 1)//range
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt, 64);
            else if(m_filter.nTraceAddrMode == 2)//multiple
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt2, 164);
            else if(m_filter.nTraceAddrMode == 3)//wildcard
                GetDlgItemText(IDC_GRPTRC_FLT_STARTADDR, m_filter.TraceStartAddrTxt3, 64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnChangeGrptrcFltStartdata()
{
    // TODO: Add your control notification handler code here
    switch (m_filter.nActiveChoice)
    {
        case 1:
            if(m_filter.nDisplayDataMode ==1)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt, 64);
            else if(m_filter.nDisplayDataMode ==2)
                    GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt2, 64);
            else if(m_filter.nDisplayDataMode ==3)
                    GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.DisplayStartDataTxt3, 64);
            break;
        case 2:
            if(m_filter.nTraceDataMode ==1)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt, 64);
            if(m_filter.nTraceDataMode ==2)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt2, 64);
            if(m_filter.nTraceDataMode ==3)
                GetDlgItemText(IDC_GRPTRC_FLT_STARTDATA, m_filter.TraceStartDataTxt3, 64);
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnGrptrcFltAk()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_AK)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayAK = check;
            break;
        case 2:
            m_filter.bTraceAK = check;  
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnGrptrcFltF()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_F)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayF = check;
            break;
        case 2:
            m_filter.bTraceF = check;   
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnGrptrcFltR()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_R)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayR = check;
            break;
        case 2:
            m_filter.bTraceR = check;   
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnGrptrcFltS()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_S)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayS = check;
            break;
        case 2:
            m_filter.bTraceS = check;   
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

void CTrcGrpFilterPage::OnGrptrcFltW()
{
    // TODO: Add your control notification handler code here
    BOOL check;
    if (IsDlgButtonChecked(IDC_GRPTRC_FLT_W)==0) check=FALSE;
    else check=TRUE;
    switch (m_filter.nActiveChoice)
    {
        case 1:
            m_filter.bDisplayW = check;
            break;
        case 2:
            m_filter.bTraceW = check;   
            break;
        default:
            break;
    }
    if(!m_bApply)
    {
        m_bApply=TRUE;
        SetModified(TRUE);
    }
}

/////////////////////////////////////////////////////////////////////////////
// CCheckPage dialog

CCheckPage::CCheckPage(UINT nIDTemplate)
    : CPropertyPage(nIDTemplate)
{
    //{{AFX_DATA_INIT(CCheckPage)
        // NOTE: the ClassWizard will add member initialization here
    //}}AFX_DATA_INIT
    m_bEmptyFlag=TRUE;
    m_nold_addrmode=0;
    m_nold_datamode=0;
    m_nErrLocate=0;
}

CString CCheckPage::delspace(const char* p)
{                                                 
int i=0, len;
CString thin;
    
    while(p[i++]==' ');
    i--;
    thin=&p[i];
    len=thin.GetLength();
    
    for(i=len-1; i>=0; i--)
        if(thin[i]!=' ')
            break;
    thin=thin.Left(i+1);
    return thin;    
}

void CCheckPage::chkWildAddr(const char* p)
{
int     i, j, len;
char    wa[16];
unsigned char hb;
CString str;
    
    str=delspace(p);
    len = str.GetLength();
    if (len==0)
    {
        m_nold_addrmode=3;
        m_EvBus.qlfyType[4]=0;
        m_EvBus.qlfyType[5]=0;
        return;
    }
    m_bEmptyFlag=FALSE;
    str.MakeUpper();
    if(str.Find('X')==-1)
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_DATA1_NOWILD);
        return;
    }
    if (len<=4&&len>0)
    {
        for(i=0;i<len;i++)
            if(!(str[i]>='0'&&str[i]<='9'
                ||str[i]>='A'&&str[i]<='F'||str[i]=='X'))
            {
                m_nErrLocate=1;
                ErrDisplayError(ER_TRCGRP_ADDR_INVALIDCHAR);
                return;
            }
        for(i=0; i<(4-len)*4; i++)
            wa[i]=0;
        for(j=0;i<16;i+=4,j++)
        {
            hb=unsigned char((str[j]=='X')?0xff:(str[j]>='0'&&str[j]<='9'?
                        str[j]-'0':str[j]-'A'+10));
            wa[i]=(hb==0xff)?'X':hb&8?'1':'0';
            wa[i+1]=(hb==0xff)?'X':hb&4?'1':'0';
            wa[i+2]=(hb==0xff)?'X':hb&2?'1':'0';
            wa[i+3]=(hb==0xff)?'X':hb&1?'1':'0';
        }
    }
    else if(len<=16&&len>4)
    {
        for(i=0;i<len;i++)
            if(str[i]!='0'&&str[i]!='1'&&str[i]!='X')
            {
                m_nErrLocate=1;
                ErrDisplayError(ER_TRCGRP_ADDR_INVALIDCHAR);
                return;
            }
        for(i=0; i<16-len; i++)
            wa[i]=0;
        for(j=0;i<16;i++,j++)
        {
            wa[i]=str[j];
        }
    }
    else
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_ADDR1_ERR);
        return;
    }
    m_EvBus.addr[0][0]=0;
    m_EvBus.addr[1][0]=0xffff;
    m_EvBus.addrCount=2;
    m_EvBus.qlfyType[4]=2;
    m_EvBus.qlfyType[5]=0;
    for(j=0;j<16;j++)
    {
        switch (wa[j])
        {
            case 'X':
                m_EvBus.addr[1][0]-=(WORD)(1<<(15-j));
                break;
            case '0':
                break;
            case '1':
                m_EvBus.addr[0][0]+=(WORD)(1<<(15-j));
                break;
            default:
                break;
        }
    }
}

void CCheckPage::chkRangeAddr(int type,const char* p1,const char* p2)
{                                                                           
ADDRESS adr1, adr2;
ADDR_RETCODE    ret1, ret2;
CString str=p1; 
    
    ret1=AdrTextToAddr(str, adr1);
    str=p2;
    ret2=AdrTextToAddr(str, adr2);
    if(ret1==ret2&&ret1==ADR_EMPTY)
    {
        m_nold_addrmode=1;
        m_EvBus.qlfyType[4]=0;
        m_EvBus.qlfyType[5]=0;
        return;
    }
    m_bEmptyFlag=FALSE;
    if(ret1!=ADR_OK)
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_ADDR1_ERR);
        return;
    }          
    if(ret2!=ADR_OK)
    {
        m_nErrLocate=2;
        ErrDisplayError(ER_TRCGRP_ADDR2_ERR);
        return;
    }
    if(type==1)     //length
    {
        adr2.adrAddress+=adr1.adrAddress-1;
        adr2.adrSpace=adr1.adrSpace;
    }
    if(adr1.adrSpace==SPACE_UNDEFINE||adr1.adrSpace==SPACE_PROGRAME)
    {
        adr1.adrSpace=(ADDR_SPACE)GetCurrentBank();
    }
    else if(adr1.adrSpace>1&&adr1.adrSpace<6)
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_ADDR1_ERR);
        return;
    }
    if(adr2.adrSpace==SPACE_UNDEFINE||adr2.adrSpace==SPACE_PROGRAME)
    {
        adr2.adrSpace=(ADDR_SPACE)GetCurrentBank();
    }
    else if(adr2.adrSpace>1&&adr2.adrSpace<6)
    {
        m_nErrLocate=2;
        ErrDisplayError(ER_TRCGRP_ADDR2_ERR);
        return;
    }
    if(adr2.adrSpace<adr1.adrSpace||(adr2.adrSpace==adr1.adrSpace)&&
        adr2.adrAddress<adr1.adrAddress)
    {
        m_nErrLocate=2;
        ErrDisplayError(ER_TRCGRP_ADDR_ORDER);
        return;
    }
    if(!AdrCheckAddrRange(adr1))
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_ADDR1_OUTRANGE);
        return;
    }
    if(!AdrCheckAddrRange(adr2))
    {
        m_nErrLocate=2;
        ErrDisplayError(ER_TRCGRP_ADDR2_OUTRANGE);
        return;
    }
    m_EvBus.qlfyType[4]=0x10;
    m_EvBus.qlfyType[5]=0;
    m_EvBus.addrCount=2;
    m_EvBus.addr[0][0]=(WORD)adr1.adrAddress;
    m_EvBus.addr[1][0]=(WORD)adr2.adrAddress;
    m_EvBus.addr[0][1]=(BYTE)adr1.adrSpace;
    m_EvBus.addr[1][1]=(BYTE)adr2.adrSpace;
}                               

void CCheckPage::chkMultipleAddr(char* p)
{
int     i;  
char    txt1[200];
char*   ptr;
CString str;
ADDRESS adr;
ADDR_RETCODE    ret;

    i=GetTokenNum(p);
    if (i>10)
    {
        m_nErrLocate=1;
        ErrDisplayError(ER_TRCGRP_ADDR_TOOMUCH);
        return;
    }
    if (i==0)
    {
        m_nold_addrmode=2;
        m_EvBus.qlfyType[4]=0;
        m_EvBus.qlfyType[5]=0;
        return;
    }
    m_bEmptyFlag=FALSE;
    strcpy(txt1,p);
    ptr=strtok(txt1," ,");
    i=0;
    do
    {
        str=ptr;
        ret=AdrTextToAddr(str, adr);
        if(ret!=ADR_OK)
        {
            m_nErrLocate=1;
            ErrDisplayError(ER_TRCGRPF_ADDR_ERR, 0, i+1);
            return;
        }
        if(adr.adrSpace==SPACE_UNDEFINE)
            adr.adrSpace=(ADDR_SPACE)GetCurrentBank();
        if(!AdrCheckAddrRange(adr))
        {
            m_nErrLocate=1;
            ErrDisplayError(ER_TRCGRPF_ADDR_OUTRANGE, 0, i+1);
            return;
        }
        m_EvBus.addr[i][0]=(WORD)adr.adrAddress;
        m_EvBus.addr[i][1]=(BYTE)adr.adrSpace;
        ptr = strtok(NULL, " ,");
        i++;
    }while(ptr!=NULL);
    m_EvBus.qlfyType[4]=0x40;
    m_EvBus.qlfyType[5]=0;
    m_EvBus.addrCount =(WORD) i;
}

void CCheckPage::chkWildData(const char* p)
{
int     i, j, len;
char    wa[8];
unsigned char hb;
CString str;
    
    str=delspace(p);
    len = str.GetLength();
    if (i==0)
    {
        m_nold_datamode=3;
        m_EvBus.qlfyType[6]=0;
        m_EvBus.qlfyType[7]=0;
        return;
    }
    m_bEmptyFlag=FALSE; 
    str.MakeUpper();
    if(str.Find('X')==-1)
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_NOWILD);
        return;
    }
    if (len<=2&&len>0)
    {
        for(i=0;i<len;i++)
            if(!(str[i]>='0'&&str[i]<='9'
                ||str[i]>='A'&&str[i]<='F'||str[i]=='X'))
            {
                m_nErrLocate=3;
                ErrDisplayError(ER_TRCGRP_DATA1_ERR);
                return;
            }
        for(i=0; i<(2-len)*4; i++)
            wa[i]=0;
        for(j=0;i<8;i+=4,j++)
        {
            hb=unsigned char((str[j]=='X')?0xff:(str[j]>='0'&&str[j]<='9'?
                        str[j]-'0':str[j]-'A'+10));
            wa[i]=(hb==0xff)?'X':hb&8?'1':'0';
            wa[i+1]=(hb==0xff)?'X':hb&4?'1':'0';
            wa[i+2]=(hb==0xff)?'X':hb&2?'1':'0';
            wa[i+3]=(hb==0xff)?'X':hb&1?'1':'0';
        }   
    }
    else if(len<=8&&len>2)
    {
        for(i=0;i<len;i++)
            if(str[i]!='0'&&str[i]!='1'&&str[i]!='X')
            {
                m_nErrLocate=3;
                ErrDisplayError(ER_TRCGRP_DATA1_ERR);
                return;
            }
        for(i=0; i<8-len; i++)
            wa[i]=0;
        for(j=0;i<8;i++,j++)
        {
            wa[i]=str[j];
        }
    }
    else
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_ERR);
        return;
    }
    m_EvBus.data1=0;
    m_EvBus.data2=0xffff;
    m_EvBus.qlfyType[6]=2;
    m_EvBus.qlfyType[7]=0;
    for(j=0;j<8;j++)
    {
        switch (wa[j])
        {
            case 'X':
                m_EvBus.data2-=(WORD)(1<<(7-j));
                break;
            case '0':
                break;
            case '1':
                m_EvBus.data1+=(WORD)(1<<(7-j));
                break;
            default:
                break;
        }
    }
}

void CCheckPage::chkRangeData(int type,
                const char* p1, const char* p2)
{               
ADDRESS adr1, adr2;
ADDR_RETCODE    ret1, ret2;
CString str=p1;

    ret1=AdrTextToAddr(str, adr1, 0);
    str=p2;
    ret2=AdrTextToAddr(str, adr2, 0);
    if(ret1==ret2&&ret1==ADR_EMPTY)
    {
        m_nold_datamode=1;
        m_EvBus.qlfyType[6]=0;
        m_EvBus.qlfyType[7]=0;
        return;
    }
    m_bEmptyFlag=FALSE;
    if(ret1!=ADR_OK)
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_ERR);
        return;
    }   
    if(adr1.adrAddress>0xff)
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_OUTRANGE);
        return;
    }       
    if(ret2!=ADR_OK)
    {
        m_nErrLocate=4;
        ErrDisplayError(ER_TRCGRP_DATA2_ERR);
        return;
    }
    if(type==1)     //length
        adr2.adrAddress+=adr1.adrAddress-1;
    if(adr2.adrAddress<adr1.adrAddress)
    {
        m_nErrLocate=4;
        ErrDisplayError(ER_TRCGRP_DATA_ORDER);
        return;
    }
    if(adr2.adrAddress>0xff)
    {
        m_nErrLocate=4;
        ErrDisplayError(ER_TRCGRP_DATA2_OUTRANGE);
        return;
    }
    m_EvBus.qlfyType[6]=0x10;
    m_EvBus.qlfyType[7]=0;
    m_EvBus.data1=adr1.adrAddress;
    m_EvBus.data2=adr2.adrAddress;
}

void CCheckPage::chkSingleData(const char* p)
{                                                   
ADDRESS adr;
ADDR_RETCODE    ret;
CString str=p;
    
    ret=AdrTextToAddr(str, adr, 0);
    if(ret==ADR_EMPTY)
    {
        m_nold_datamode=2;
        m_EvBus.qlfyType[6]=0;
        m_EvBus.qlfyType[7]=0;
        return;
    }
    m_bEmptyFlag=FALSE;
    if(ret!=ADR_OK)
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_ERR);
        return;
    }
    if(adr.adrAddress>0xff)
    {
        m_nErrLocate=3;
        ErrDisplayError(ER_TRCGRP_DATA1_OUTRANGE);
        return;
    }
    m_EvBus.qlfyType[6]=1;
    m_EvBus.qlfyType[7]=0;
    m_EvBus.data1=adr.adrAddress;
}

void CCheckPage::chkCount(const char* p, int nType)
{                                             
ADDRESS adr;
ADDR_RETCODE    ret;
CString str=p;
    
    ret=AdrTextToAddr(str, adr, 0);
    if(ret==ADR_EMPTY)
    {
        m_EvBus.qlfyType[10]=0;
        m_EvBus.count=0;
        return;
    }
    m_bEmptyFlag=FALSE;                             
    if ( nType ) {
        if(ret!=ADR_OK||adr.adrAddress>0xffff||
            adr.adrSpace!=SPACE_UNDEFINE)
        {
            m_nErrLocate=5;
            ErrDisplayError(ER_TRCGRP_COUNT_ERR);
            return;
        }
    }
    else {
        if(ret!=ADR_OK||adr.adrAddress>0x7fff||
            adr.adrSpace!=SPACE_UNDEFINE)
        {
            m_nErrLocate=5;
            ErrDisplayError(ER_TRCGRP_COUNT_ERR);
            return;
        }
    }
    if(adr.adrAddress==0)
    {
        m_EvBus.qlfyType[10]=0;
        m_EvBus.count=0;
        return;
    }
    m_EvBus.qlfyType[10]=1;
    m_EvBus.count=adr.adrAddress;
}

void CCheckPage::compressWild(char* p)
{
int i, temp;
int hexnum=strlen(p);
char buf[5];
    
    ASSERT(hexnum==16||hexnum==8);
    for(i=0; i<hexnum; i+=4)
    {
        if(p[i]=='x'||p[i+1]=='x'||p[i+2]=='x'||p[i+3]=='x')
            if(p[i]=='x'&&p[i+1]=='x'&&p[i+2]=='x'&&p[i+3]=='x')
                continue;
            else
                return;
        continue;           
    }
    for(i=0; i<hexnum/4; i++)
    {
        if(p[4*i]=='x')
        {
            p[i]='x';
            continue;
        }
        temp=8*(p[4*i]-'0')+4*(p[4*i+1]-'0')+2*(p[4*i+2]-'0')+p[4*i+3]-'0';
        itoa(temp, buf, 16);
        p[i]=buf[0];
    }
    p[i]=0;
}

void CCheckPage::DoDataExchange(CDataExchange* pDX)
{
    CPropertyPage::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCheckPage)
        // NOTE: the ClassWizard will add DDX and DDV calls here
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCheckPage, CPropertyPage)
    //{{AFX_MSG_MAP(CCheckPage)
        // NOTE: the ClassWizard will add message map macros here
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCheckPage message handlers
