
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/VARINIT.H__   1.2.1.4   17 Apr 1997 16:09:16   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/VARINIT.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:09:16   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:44:42   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:49:10   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:28:14   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:31:34   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:40:44   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:53:38   ZJRD
** Initial revision.
** 
****************************************************************************/

#ifndef _VARINIT_H_

#define _VARINIT_H_

#include "symsyn.h"

#define VAR_GLOBAL  0x01
#define VAR_USEDEF  0x02
#define VAR_NOVALID 0x04
#define VAR_COMPLEX 0x08
#define VAR_ROOT    0x10
#define VAR_EXTEND  0x20
#define VAR_REG     0x40
#define VAR_RESTORE 0x80

struct VarNode {
    CString command;
    int flag;           
    int flag1;
    CSymSyntax *pExp;
    int num;
    int line;
    U32 desc;
    U32 typeIndex;
    ADDRESS_TYPE addr;
    ADDRESS_TYPE result;
    CString name;
    CString typeName;
    CString value;
    struct VarNode* son ;
    struct VarNode* father ;
    struct VarNode* next ;
    struct VarNode* prev;

public :
    VarNode()
    {
        son = father = 0;
        next = prev = 0;
        flag = VAR_ROOT;
        desc = 0;
        typeIndex = 0;
        num = 0;
        line = 1;       
        flag1 = 0;
        pExp = 0;
    }              
    ~VarNode()
    {
      if ( flag1 && pExp ) 
         delete pExp;
      pExp = 0;   
    }
    
public :
   void FreeNode() {
      if ( flag1 && pExp ) 
         delete pExp;
      pExp = 0;   
      flag1 = 0;
   }
   void CopyNode(VarNode *pNode) {
      if ( 0 == pNode ) return;
       command = pNode->command;
       flag = pNode->flag;           
       flag1 = pNode->flag1;
       pExp = pNode->pExp;
       //int num;
       line = pNode->line;
       desc = pNode->desc;
       typeIndex = pNode->typeIndex;
       addr.segType = pNode->addr.segType;
       addr.addr = pNode->addr.addr;
       result.segType = pNode->result.segType;
       result.addr = pNode->result.addr;
       name = pNode->name;
       typeName = pNode->typeName;
       value = pNode->value;
//     struct VarNode* son ;
//     struct VarNode* father ;
//     struct VarNode* next ;
//     struct VarNode* prev;
      pNode->flag1 = 0;
      pNode->pExp = 0;
   }
public :
   int CanBeModify();
};

struct VarNodeIndex {
    struct VarNode* node;
    struct VarNodeIndex* next;
    struct VarNodeIndex* prev;

public :
    VarNodeIndex() {
        node = 0;
        next = 0;
        prev = 0;
    }
};

class VarServer : public stkServer {
public :
    struct VarNode* varListHeader;
    struct VarNode* curVarNode;
    char   buff[1024];
    struct VarNodeIndex* namePtr;

public :
    VarServer() : stkServer() {
        varListHeader = curVarNode = 0;
        namePtr = 0;
    }

   int CheckVar(char *str,SYM_DESCRIPTOR &desc,
   TYPE_INDEX &typeIndex,BOOLEAN &isGlobal,ADDRESS_TYPE& addr);

    int AddVar( char *str );
    int AddLocalVar(SYM_DESCRIPTOR desc,CString name);
    int Add( struct VarNode* node );
    int Delete( struct VarNode* node );
    int DeleteLocal(SYM_DESCRIPTOR desc);
    void DeleteAllLocal(void);
    void VarMaxLine(int& nLine);
    
    int IsLegalValue(int nLine , CString str);
    int CheckValue(struct VarNode* node, char *str);
    
    int ModifyValue(int nLine , CString str);
    int SetValue(struct VarNode* node, char *str);
//    int VarBuildIndex();
//    int VarDeleteIndex();
    void VarDeleteAll();
    int VarExtendedNode( struct VarNode* node );
    int VarCompressNode( struct VarNode* node );
    int VarUpdataExtendedNode( struct VarNode* node );
    int EditNode(struct VarNode *node , char *str);
    int UpdataAllLocal();
    int UpdataAllNode( );
    int UpdataOneNode( struct VarNode* node );
    int UpdataOneNodeValue( struct VarNode* node );
    void ShowOneNode( struct VarNode* node );
    void ShowVarToShell();
    void ClearNode( struct VarNode* node );
    int VarLineToNode(int nRow,struct VarNode *& node);
    int VarNodeToPos(struct VarNode* node,int& nPos);
    void UpdataLine( int nLine , struct VarNode * node );
    void VarAddrToStr(ADDRESS_TYPE addr,CString& str);
    int Search( char *str , int & nLine );
    int SearchNext( char *str , int nStartLine , int & nLine ); 

	int UpdataRestoreNode( VarNode *node );
	int SaveVar(void);
	int RestoreVar(void);
};

#endif
