
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/VARPANE.CPP   1.2.1.4   17 Apr 1997 16:09:22   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/VARPANE.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:09:22   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:44:48   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:49:16   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:28:18   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:31:38   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:40:48   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:53:42   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:04   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:00:20   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:20:52   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:32:20   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:59:24   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:46:22   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 10:51:16   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:53:22   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:32:02   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:03:14   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:12:04   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:27:06   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:00:48   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:37:52   Shirley
** No change.
** 
**    Rev 1.29   02 Apr 1996 09:30:54   Shirley
** No change.
** 
**    Rev 1.28   15 Feb 1996 08:52:22   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:06:54   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:33:24   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:48:18   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:12:38   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:22   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:02   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:40   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:10   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:10:26   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:11:28   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:12:24   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:11:40   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:32:18   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:48   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:28:08   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:56   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:08   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:06   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:38   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:48   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:22   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:10   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:00   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:53:34   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:55:36   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:14   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:08   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: VARPANE.CPP
//
//  Description: The implementation file for the class: CVarPane.
//
//  Author: Chen Jun
//
//  Date: 07/03/95
//
//  Modification:
//      1. 07/03/95, Initial version of the class: CVarPane.
//
/////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include "resource.h"

#include "symblsvr.h"
#include "stkinit.h"
#include "varinit.h"

#include "varpane.h"
#include "vartype.h"

#include "colors.h"


/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CVarPane

// Create Bottom pane in the Variable window.
BOOL CVarPane::Create(CWnd* pParent)
{
    // Assertion of the input parameters.
    
    // Register a custom WndClass and create a window.
    LPCSTR pszBottomClass =
        AfxRegisterWndClass(CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS,
            LoadCursor(NULL, IDC_ARROW),
            (HBRUSH)(GetStockObject(LTGRAY_BRUSH)));
            
    LPCSTR pszTitle = "";            
            
    DWORD dwStyle = WS_CHILD|WS_VISIBLE|WS_CLIPSIBLINGS|WS_BORDER;
    
    const CRect rect(0,0,0,0);

    // Create a new sub-window.
    return CWnd::Create(pszBottomClass, pszTitle, dwStyle, rect, 
        pParent, IDW_VAR_BOTTOM);
}

// Initialize the class member.
void CVarPane::InitialMember(void)
{
    // Initialization.
    m_strAddress = "";
    m_strType = "";
}

// Construction.
CVarPane::CVarPane()
{
    // Initial class members.
    InitialMember();
}

// Destruction.
CVarPane::~CVarPane()
{
}


/////////////////////////////////////////////////////////////////////////////
// Common function.

// Draw the 3-D frame. Refer to UICOM.CPP written by Roger.
void CVarPane::DrawFrame(CDC * pDC, CRect &rect)
{        
    CPen pen1(PS_SOLID, 1, PALETTEINDEX(COLOR_DKGRAY));    
    CPen pen2(PS_SOLID, 1, PALETTEINDEX(COLOR_WHITE));    
    CPen * penOld;
    
    pDC->MoveTo(rect.left, rect.bottom);

    penOld = pDC->SelectObject(&pen1);

    pDC->LineTo(rect.left, rect.top);
    pDC->LineTo(rect.right, rect.top);

    pDC->SelectObject(&pen2);

    pDC->LineTo(rect.right, rect.bottom);
    pDC->LineTo(rect.left, rect.bottom);

    pDC->SelectObject(penOld);
}             

// Display the error message.
void CVarPane::DisplayErrorMessage(void) const
{
    // Assertion of the input parameters.
    ASSERT( m_nErrorID > noError && m_nErrorID < maxError );
    
    // Create the error message table.
    char* pszErrorMessage[] = {
        "",
        "Insufficient memory."
    };
    
    // Show the error message.
    AfxMessageBox(pszErrorMessage[m_nErrorID]);
}


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CVarPane, CWnd)
    //{{AFX_MSG_MAP(CVarPane)
    ON_WM_CREATE()
    ON_WM_PAINT()
    ON_WM_LBUTTONDBLCLK()
    ON_WM_SETCURSOR()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CVarPane message handlers

int CVarPane::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CWnd::OnCreate(lpCreateStruct) == -1)
        return -1;
    
    // TODO: Add your specialized creation code here

    // Set standard font & Get the font size.
    CDC* pDC = GetDC();
    pDC->SelectStockObject(ANSI_FIXED_FONT);
    TEXTMETRIC tm;
    pDC->GetTextMetrics(&tm);
    m_nFontWidth = tm.tmAveCharWidth;
    m_nFontHeight = tm.tmHeight + tm.tmExternalLeading;
    ReleaseDC(pDC);

    // Set the pane position.
    m_nTop = (bottomHeight - m_nFontHeight) / 2;
    m_nFirst = m_nFontWidth*11;
    m_nSecond = m_nFontWidth*27;
         
    return 0;
}

void CVarPane::OnPaint()
{
    CPaintDC dc(this); // device context for painting
    
    // TODO: Add your message handler code here

    // Set font & color.
    dc.SelectStockObject(ANSI_FIXED_FONT);
    dc.SetBkColor(PALETTEINDEX(COLOR_LTGRAY));
    dc.SetTextColor(PALETTEINDEX(COLOR_BLACK));

    // Draw the frame.
    CRect rectPane;
    GetClientRect(rectPane);
    int nLeft = m_nFontWidth*10;
    int nRight = m_nFontWidth*18;
    DrawFrame(&dc, CRect(nLeft,1,nRight,rectPane.bottom-1));

    nLeft = m_nFontWidth*26;
    nRight = rectPane.right-1;
    DrawFrame(&dc, CRect(nLeft,1,nRight,rectPane.bottom-1));

    // Write the item name.
    dc.TextOut(m_nFontWidth*1, m_nTop, CString("Address:"));
    dc.TextOut(m_nFontWidth*20, m_nTop, CString("Type:"));
        
    // Output the Address.
    dc.TextOut(m_nFirst, m_nTop, m_strAddress);
    
    // Output the Type.
    dc.TextOut(m_nSecond, m_nTop, m_strType);
    
    // Do not call CWnd::OnPaint() for painting messages
}

void CVarPane::OnLButtonDblClk(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default
    
    // Open the dialog to show the detail definition for the complex type.
    if ( point.x >= m_nFontWidth*20 ) {
//        CVarTypeDialog dlg;
//        dlg.DoModal();
    }
    
    CWnd::OnLButtonDblClk(nFlags, point);
}

/*
void CVarPane::OnRButtonDown(UINT nFlags, CPoint point)
{
    // TODO: Add your message handler code here and/or call default

    // Create the popup menu.
    CMenu* pPopupMenu = new CMenu;
    ASSERT( NULL != pPopupMenu );
    if ( !pPopupMenu ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        return;
    }
    pPopupMenu->CreatePopupMenu();
    
    // Define the local menu.
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_ADDRESS, "char* as &Address");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_STRING, "char* as &String");
    pPopupMenu->AppendMenu(MF_SEPARATOR);
    
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_BYTE, "&Byte");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_WORD, "&Word");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_LONG, "&Long");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_FLOAT, "&Float");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_DOUBLE, "&Double");
    pPopupMenu->AppendMenu(MF_SEPARATOR);
    
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_SIGNED, "S&igned Decimal");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_UNSIGNED, "&Unsigned Decimal");
    pPopupMenu->AppendMenu(MF_STRING, ID_VIEW_FORMAT_HEXADECIMAL, "Hexadecimal");
    
    // Create the local menu.
    CMenu* pLocalMenu = new CMenu;
    ASSERT( NULL != pLocalMenu );
    if ( !pLocalMenu ) {
        m_nErrorID = insufficientMemory;
        DisplayErrorMessage();
        return;
    }
    pLocalMenu->CreatePopupMenu();

    // Define the local menu.
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_ADD, "&Add...");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_EDIT, "&Edit...");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_DELETE, "&Delete");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_DELETEALL, "De&lete All");
    pLocalMenu->AppendMenu(MF_STRING, ID_VARIABLE_UNDELETE, "&Undelete");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_MODIFYVALUES, "&Modify Value...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);

    pLocalMenu->AppendMenu(MF_POPUP, (UINT)(pPopupMenu->GetSafeHmenu()), "&Format");

    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_TYPECAST, "Type &Cast...");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISPLAYHORIZONTALLY, "Display &Horizontally");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_DISPLAYVERTICALLY, "Display &Vertically");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SORTBYHISTORY, "Sort By H&istory");
    pLocalMenu->AppendMenu(MF_STRING, ID_VIEW_SORTBYNAME, "Sort By &Name");
    pLocalMenu->AppendMenu(MF_SEPARATOR);
    
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_SEARCH, "&Search...");
    pLocalMenu->AppendMenu(MF_STRING, ID_EDIT_SEARCHNEXT, "Search &Next");
    
    // Adjust the cursor location.
    if ( 0 == point.x && 0 == point.y ) {
        CRect rect;
        GetClientRect(&rect);
        point = CPoint(rect.left+rect.Width()/2, rect.top+rect.Height()/2);
    }

    // Display the local menu.
    ClientToScreen(&point);

    // Active the local menu.
    pLocalMenu->TrackPopupMenu(TPM_LEFTALIGN, point.x, point.y, GetParent());

    // Release the allocated buffer.
//    delete pPopupMenu;
    delete pLocalMenu;
    
    CWnd::OnRButtonDown(nFlags, point);
}
*/


BOOL CVarPane::OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
{
    // TODO: Add your message handler code here and/or call default

    // Disable parent window from pre-handling the WM_RBUTTONDOWN message.
    // MAINFRM latch WM_RBUTTONDOWN to implement local menu.
    if( message == WM_RBUTTONDOWN ) {
        return FALSE;
    }
    
    return CWnd::OnSetCursor(pWnd, nHitTest, message);
}
