/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/AOPT.CPP   1.2.1.5   17 Apr 1997 15:41:24   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/AOPT.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:41:24   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:15:10   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:27:08   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:09:10   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:14:08   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:25:26   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:44:24   ZJRD
** Initial revision.
** 
**    Rev 1.5.1.0.1.2   09 Dec 1996 10:14:30   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.5.1.0.1.0   11 Nov 1996 12:57:44   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.5.1.4   09 Sep 1996 13:14:14   ZJRD
** No change.
** 
**    Rev 1.5.1.3   05 Sep 1996 11:25:46   ZJRD
** No change.
** 
**    Rev 1.5.1.2   02 Sep 1996 09:52:54   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.5.1.0   12 Aug 1996 10:50:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   29 May 1996 09:34:02   ZJRD
** EasyPack/SLD Version 1.95
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
// aopt.cpp
//
// Roger Zhang
//                                                                           
// 5/6/1996
//
/////////////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"
#include "toolopt.h"
#include "afx.h"    
#include "ac.h"
#include "acoption.h"
#include "aa.h"
#include "aaoption.h"
#include "al.h"
#include "aloption.h"
#include "ae.h"
#include "aeoption.h"
#include "alib.h"
#include "alibopti.h"
#include "atab.h"
#include "projopt.h"
#include "aopt.h"
#include "direct.h"   

/////////////////////////////////////////////////////////////////////////////
// operations
void AOption::SetOption(CWnd *pParent)
{
    CATab dlg(&m_acTool, &m_aaTool, &m_alTool, &m_alibTool,&m_aeTool, pParent);
    dlg.DoModal();
}

BOOL AOption::SaveOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_acTool.SaveOption(fp))
        return FALSE;
    if(!m_aaTool.SaveOption(fp))
        return FALSE;
    if(!m_alTool.SaveOption(fp))
        return FALSE;
    if(!m_alibTool.SaveOption(fp))
        return FALSE;
    
    if(!m_aeTool.SaveOption(fp))
        return FALSE;
  /*  if((_stricmp(m_aeTool.m_strPath," ")!=0)&&(_stricmp(m_aeTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE;*/ 
    return TRUE;
}
                
BOOL AOption::LoadOption(FILE * fp)
{                              
    ASSERT(fp);
    
    if(!m_acTool.LoadOption(fp))
        return FALSE;
    if(!m_aaTool.LoadOption(fp))
        return FALSE;
    if(!m_alTool.LoadOption(fp))
        return FALSE;
    if(!m_alibTool.LoadOption(fp))
        return FALSE;
    if(!m_aeTool.LoadOption(fp))
        return FALSE;
  /*  if((_stricmp(m_aeTool.m_strPath," ")!=0)&&(_stricmp(m_aeTool.m_strProg,"c:\\ ")!=0))
       m_fValid=TRUE;
    else
       m_fValid=FALSE; */  
    return TRUE;
}                
    
// return 0:c file, 1:asm file, 2:other file(library)    
int AOption::GetFileType(LPCSTR lpcszFile) const
{              
    ASSERT(lpcszFile);

    char ext[_MAX_EXT];

    _splitpath(lpcszFile, NULL, NULL, NULL, ext);
    if(_stricmp(ext, ".c") == 0) {
        return 0;                
    } else if(_stricmp(ext, ".asm") == 0) {
        return 1;
    } else {
        return 2;
    }
}        

BOOL AOption::CreateLinkCmdFile(const CStringList &lst, LPCSTR lpcszProj )
{
    POSITION pos;
    CString str, str1, str2;
    FILE * fp;
    int i, flag=0, bFlag=0;
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
    char path[_MAX_PATH];

    fp = fopen(GetName(lpcszProj, ".cmd"), "wt");
    if(!fp)
        goto CMDFAIL;
             
    for(i = 0, pos = lst.GetHeadPosition(); pos != NULL; i++) {
        str2 = lst.GetNext(pos);
        
        flag = GetFileType(str2);
        if(flag != 2)
         {  
            if(flag==0) bFlag = 1;
            str1 ="";
            str = GetName(str2, ".obj");
            _splitpath(str, drive, dir, fname, ext); 
            _makepath (path, NULL, NULL, fname, ext);
            str1 += path;
         }
        else
            str1 = str2;
            
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) 
            != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
            
        if(i < lst.GetCount() - 1) {
            if(fputc(',', fp) == EOF)          
                goto CMDFAIL;
        } else {
            if(fputc(' ', fp) == EOF)          
                goto CMDFAIL;
        }
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
   
    if(bFlag){
        str1 = ",";
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
            goto CMDFAIL;
        else 
            str1.ReleaseBuffer();
            
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;           
            
        str1 = m_alibTool.GetOption();
    
        if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
            goto CMDFAIL;
        else
            str1.ReleaseBuffer();
        if(fputc(' ', fp) == EOF)          
            goto CMDFAIL;
        if(fputc('\n', fp) == EOF)          
            goto CMDFAIL;
    }
                      
    str1 = "to ";
    str1 += GetName(lpcszProj, ".out");                   
    
    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else 
        str1.ReleaseBuffer();
        
    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;
        
    str1 = m_alTool.GetOption();

    if(fwrite(str1.GetBuffer(str1.GetLength()), str1.GetLength(), 1, fp) != 1)
        goto CMDFAIL;
    else
        str1.ReleaseBuffer();

    if(fputc('\n', fp) == EOF)          
        goto CMDFAIL;

    fclose(fp);
    return TRUE;
                     
CMDFAIL:
    AfxMessageBox("Failed to create link command file!");                    
    if(fp)
        fclose(fp);
    return FALSE;
}                                              

BOOL AOption::WriteBatchFile(FILE * fp, LPCSTR lpcszText)
{
    ASSERT(fp);
    
    if(fwrite(lpcszText, lstrlen(lpcszText), 1, fp) != 1) 
        goto BATFAIL;
    if(fputc('\n', fp) == EOF)
        goto BATFAIL;
        
    return TRUE;

BATFAIL:    
    fclose(fp); 
    AfxMessageBox("Failed to create batch file!");
    return FALSE;
}


void AOption::Build(const CStringList &lst, LPCSTR lpcszProj )
{
    POSITION pos;   
    CString str;
    CString strBuild;
    CString cstr;
    CString astr;
    CString lstr;
    cstr = m_acTool.m_strPath;
    astr = m_aaTool.m_strPath; 
    lstr = m_alTool.m_strPath;
    
    if(_stricmp(m_aaTool.m_incPath,m_acTool.m_incPath)!=0)
    { 
     AfxMessageBox("Include Path of Compiler and Assemble should be same");
     return;
    }
    
//    if(cstr[cstr.GetLength()-1]!='\\')
//    cstr = cstr + "\\";
//    if(astr[astr.GetLength()-1]!='\\')
//    astr = astr + "\\";
//    if(lstr[lstr.GetLength()-1]!='\\')
//    lstr = lstr + "\\"; 
    
    if( !cstr.IsEmpty() ) {
        if(cstr[cstr.GetLength()-1]!='\\')
            cstr = cstr + "\\";
    }
    if( !astr.IsEmpty() ) {
        if(astr[astr.GetLength()-1]!='\\')
            astr = astr + "\\";
    }
    if( !lstr.IsEmpty() ) {
        if(lstr[lstr.GetLength()-1]!='\\')
            lstr = lstr + "\\"; 
    }
    
    int nType;                   
    FILE * fp; 
    fp = fopen( GetName(lpcszProj, ".bat"),"wt");
    if(!fp) {
        AfxMessageBox("Failed to create batch file!");
        return;
    }
    
    if(!WriteBatchFile(fp, "Set CC51LIB="+m_alibTool.m_strPath))
            return;
    if(!WriteBatchFile(fp, "Set CC51INC="+m_acTool.m_incPath))
            return;   

    CString strNewPath="set PATH="; 
    
    if( !cstr.IsEmpty() ) {
        strNewPath+=cstr;
        strNewPath+=";";
    }
    if( !astr.IsEmpty() && ( astr != cstr ) ) {
        strNewPath+=astr;
        strNewPath+=";";
    }    
    if( !lstr.IsEmpty() && ( lstr != cstr && lstr != astr ) ) {
        strNewPath+=lstr;
        strNewPath+=";";
    }                
    strNewPath+="%PATH%;";
    if(!WriteBatchFile(fp, strNewPath))
        return;
    
    CString strDir ;
    int     strDrive;
    
    char Directory[_MAX_PATH], cdrive[_MAX_DRIVE], cdir[_MAX_DIR];
       
    _splitpath(lpcszProj, cdrive, cdir, NULL, NULL);
    _makepath(Directory,cdrive, cdir, NULL, NULL);
    
    strDrive = cdrive[0]-'a'+1;
    _chdrive(strDrive);  
    
    //discard '\' in directory 
     
    for(int i=0;i<_MAX_DIR;i++)
     if(cdir[i]=='\\' && cdir[i+1]=='\0')
      cdir[i] = '\0';
        
    _chdir(cdir);    
    char cpath[_MAX_PATH], cfname[_MAX_FNAME],cext[_MAX_EXT];
         
    // compile or macro preprocess
    for(pos = lst.GetHeadPosition(); pos != NULL; ) {
        str = lst.GetNext(pos);
        nType = GetFileType(str);
        if(nType == 0) {    // c file
//            strBuild  = cstr + "cc51.exe ";
            strBuild  = "cc51.exe ";
            strBuild += m_acTool.GetOption();
            strBuild += str;
            _splitpath(str,NULL,NULL,cfname,cext);
            _makepath(cpath,NULL,NULL,cfname,cext);
            strBuild += " -o ";
            strBuild +=  GetName(cpath, ".src");
            
        }else if(nType == 1) {// asm file
//            strBuild = cstr + "mpp51.exe ";
            strBuild = "mpp51.exe ";
            strBuild += str;
            _splitpath(str,NULL,NULL,cfname,cext);
            _makepath(cpath,NULL,NULL,cfname,cext);
            strBuild += " ";
            strBuild += GetName(cpath, ".src");
            
        }
         else {
            continue;
        }            
                
        if(!WriteBatchFile(fp, strBuild))
            return;
        
        // assemble
//        strBuild =astr + "asm51.exe "; 
        strBuild ="asm51.exe "; 
        
        strBuild += GetName(cpath, ".src");
        strBuild += " ";
        strBuild += m_aaTool.GetOption();
        strBuild += "OJ(";
        strBuild += GetName(cpath, ".obj");
        strBuild += ")";
        if(!WriteBatchFile(fp, strBuild))
            return;
    }                                   
    
    // link
    if(!CreateLinkCmdFile(lst, lpcszProj))
        return;
//    strBuild = lstr + "link51.exe ";
    strBuild = "link51.exe ";
    strBuild += "@"; 
    strBuild += GetName(lpcszProj, ".cmd");
    if(!WriteBatchFile(fp, strBuild))
        return;

//    strBuild = lstr + "ieee51.exe ";       
    strBuild = "ieee51.exe ";       
    strBuild += GetName(lpcszProj, ".out");
    strBuild += " ";
    strBuild += GetName(lpcszProj, ".abs");
    if(!WriteBatchFile(fp, strBuild))
        return;
   
    if(!WriteBatchFile(fp, "Pause"))  
        return;
    
    fclose(fp); 
    
   FILE *model,*monitor; 
   char path[_MAX_PATH], drive[_MAX_DRIVE], dir[_MAX_DIR];
   _splitpath(lpcszProj, drive, dir, NULL, NULL);
   _makepath(path, drive, dir, NULL, NULL);
   
   char path1[_MAX_PATH];
  
   lstrcpy(path1,path);                  
   
   strcat(path,"model"); 
   _fstrcat(path1,"monitor");             
   model = fopen(path,"wt"); 
   monitor=fopen(path1,"wt");
   if(!model) {
        AfxMessageBox("Failed to create include file!");
        return;
    } 
   if(!monitor) {
        AfxMessageBox("Failed to create include file!");
        return;
    }
   CString strmodel,strmonitor;
   strmodel=" %DEFINE(MODEL)(";
   switch(m_acTool.m_nMemoryModel)
   {
    case 0:
     strmodel +="SMALL";
     break;
    case 1:
     strmodel += "LARGE";
     break;
    default:
     break;
   }                   
   strmodel += ")\n";
   if(fwrite(strmodel, strmodel.GetLength(), 1, model) != 1)
    {
     fclose(model);
     return;     
    }
   strmonitor = "%DEFINE(MON51)(NO)\n";
   if(fwrite(strmonitor, strmonitor.GetLength(), 1, monitor) != 1)
    {
     fclose(monitor);
     return;     
    }
   
   fclose(model); 
   fclose(monitor);
   WinExec(GetName(lpcszProj, ".bat"), SW_SHOW);
}
 

  static char BASED_CODE szFilter[] = 
    "Source file (*.cpp)|*.cpp|Source file (*.c)|*.c|Source file (*.asm)|*.asm|All Files (*.*)|*.*||";

 void AOption::Editor(CWnd * pParent)
  {
   CString str;
   CString str1;             
   CString filename;
    
    str1 = m_aeTool.m_strPath; 
    
    char drive[_MAX_DRIVE], dir[_MAX_DIR];
    char fname[_MAX_FNAME],  ext[_MAX_EXT];
   
    _splitpath(str1, drive, dir, fname, ext);
    if(!(_stricmp(ext,".exe")==0||_stricmp(ext,".com")==0))
    {
     AfxMessageBox("Editor command error!");
     return;
    
     }
   
   CFileDialog dlg(TRUE, NULL, "*.c", 
        OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT, szFilter, pParent);
    
   dlg.m_ofn.lpstrTitle = "Open File ";
   if(dlg.DoModal() == IDOK) {
      filename = dlg.GetPathName();
      m_aeTool.m_strProg = filename;
      
      str = m_aeTool.m_strPath + " ";
      str += filename;
      WinExec(str, SW_SHOW);
   }
} 
                