
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/COMMUNIC.CPP   1.2.1.5   17 Apr 1997 15:43:28   ZJRD  $  
**
**    $Log:   D:/ECB2S/SRC/LOG/COMMUNIC.CPP  $
** 
**    Rev 1.2.1.5   17 Apr 1997 15:43:28   ZJRD
** No change.
** 
**    Rev 1.2.1.4   16 Apr 1997 10:17:46   ZJRD
** No change.
** 
**    Rev 1.2.1.3   10 Apr 1997 15:29:16   ZJRD
** 2.09F
** 
**    Rev 1.2.1.1   03 Apr 1997 15:10:36   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:15:36   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:26:48   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:45:10   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:23:48   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:03:56   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:48:18   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:38:54   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:03:32   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:56:28   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 11:03:38   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 15:00:22   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:41:52   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:26   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:26   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:33:40   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.6   18 Apr 1996 13:06:34   Shirley
** No change.
** 
**    Rev 1.5   12 Apr 1996 10:45:42   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.3   15 Feb 1996 09:00:50   Shirley
** No change.
** 
**    Rev 1.2   12 Feb 1996 14:12:52   Shirley
** No change.
** 
**    Rev 1.1   06 Feb 1996 15:39:04   Shirley
** No change.
** 
**    Rev 1.0   06 Feb 1996 13:53:34   Shirley
** Initial revision.
** 
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  COMMUNIC.CPP
//
//  Description:The implement file of the class CCommunicationDialog
//
//  Author:     Roger Zhang
//  Date:       02/01/96
//
//  Modification:
//
//      1. 02/01/96, Ver 0.1
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "communic.h"
#include <ctype.h>

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
extern BOOL SetupCommunication(UINT pData);
extern BOOL SetCommType(int nTempCommType);
extern BOOL ReadCommInfo(void);
int OpenAbiComDlg(int fHelpComm, CWnd* pWnd = NULL);
char * PortAddr[8] = {
//add by chris
    "0x300",  //PCE
    "0x378",  //LPT1
    "0x278",  //LPT2
    "0x3BC",  //LPT3
    "0x3F8",  //COM1
    "0x2F8",  //COM2
    "0",    //COM3
    "0",     //COM4
//    "0"       //dummy
};                                  

/////////////////////////////////////////////////////////////////////////////
static char * SkipHeadWS(char * psz)
{
    while(isspace(*psz))    ++ psz;
    return psz;
}              

static void CutTailWS(char * psz)
{
    int l = strlen(psz);
    if(!l)  return;     
    psz += l - 1;
    while(isspace(*psz))    -- psz;
    *(psz+1) = '\0';
}                

static BOOL Dec2Num(char * psz, DWORD & dwVal)
{
    char * p = psz;
                   
    int l = strlen(p);
    if(l == 0)  return FALSE;
                              
    DWORD dw = 1;                              
    dwVal = 0;      
    p += l - 1;
    for(int i = 0; i < l; i ++, p --, dw *= 10) {
        if(*p < '0' || *p > '9')    return FALSE;
        dwVal += (*p - '0') * dw;
    }
    return TRUE;    
}

static BOOL Hex2Num(char * psz, DWORD & dwVal)
{
    char * p = psz;
                   
    int l = strlen(p);
    if(l == 0)  return FALSE;
                              
    DWORD dw = 1;                              
    dwVal = 0;      
    p += l - 1;
    for(int i = 0; i < l; i ++, p --, dw *= 16) {
        if(*p >= '0' && *p <= '9')  dwVal += (*p - '0') * dw;
        else if(*p >= 'a' && *p <= 'f') dwVal += (*p - 'a' + 10) * dw;
        else if(*p >= 'A' && *p <= 'F') dwVal += (*p - 'A' + 10) * dw;
        else    return FALSE;
    }
    return TRUE;    
}


/////////////////////////////////////////////////////////////////////////////

#define FNAME   "EPSLD52F.INI"     
extern int nPortType;                
extern int nPortAddr;         
BOOL SetComm(void)
{   
    BOOL bOK;
    
    // Set communication type
    if ( nPortType == 0 )     // PCE
         bOK = SetCommType(1);
    else if ( nPortType > 0 && nPortType <= 3 )     // LPT1->LPT3
         bOK = SetCommType(2);
    else if ( nPortType > 4 && nPortType <=7 )     // COM1->COM3
         bOK = SetCommType(0);
    if ( bOK == TRUE) {
        // Set port address
        bOK = SetupCommunication(nPortAddr);
    }

    return bOK;
}                    

/////////////////////////////////////////////////////////////////////////////
void CommDlg(void)
{
    CCommunicationDialog dlg;
    if(dlg.DoModal() == IDOK) {
        AfxMessageBox("Setup communication Ok");
    } else {
        AfxMessageBox("Setup communication failed");
    }
}

/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog dialog


CCommunicationDialog::CCommunicationDialog(CWnd* pParent /*=NULL*/)
    : CDialog(CCommunicationDialog::IDD, pParent)
{                       
    ::ReadCommInfo();
    //{{AFX_DATA_INIT(CCommunicationDialog)
    m_nType = ::nPortType;
    m_bChecked = FALSE;
    m_nComBaud = 3;
    //}}AFX_DATA_INIT
}

void CCommunicationDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CCommunicationDialog)
    //by chris
    //DDX_Radio(pDX, IDC_COMM_LPT1, m_nType);
    DDX_Radio(pDX, IDC_COMM_PCE, m_nType);
    DDX_Text(pDX, IDC_COMM_EDIT, m_strAddr);
    DDX_Check(pDX, IDC_CHECK_AUTO_BAUD, m_bChecked);
    DDX_Radio(pDX, IDC_COMM_BAUD1, m_nComBaud);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCommunicationDialog, CDialog)
    //{{AFX_MSG_MAP(CCommunicationDialog)
    ON_BN_CLICKED(IDC_COMM_LPT1, OnCommLpt1)
    ON_BN_CLICKED(IDC_COMM_LPT2, OnCommLpt2)
    ON_BN_CLICKED(IDC_COMM_LPT3, OnCommLpt3)
    ON_BN_CLICKED(ID_DETAIL, OnDetail)
    ON_BN_CLICKED(IDC_COMM_PCE, OnCommPce)
    ON_BN_CLICKED(IDC_COMM_COM1, OnCommCom1)
    ON_BN_CLICKED(IDC_COMM_COM2, OnCommCom2)
    ON_BN_CLICKED(IDC_COMM_COM3, OnCommCom3)
    ON_BN_CLICKED(IDC_COMM_COM4, OnCommCom4)
    ON_BN_CLICKED(IDC_CHECK_AUTO_BAUD, OnCheckAutoBaud)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CCommunicationDialog message handlers

void CCommunicationDialog::OnOK()
{
    // TODO: Add extra validation here
    CDialog::OnOK();
    //by chris
//    m_nType++;
}

void CCommunicationDialog::OnCommLpt1()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];       
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow();
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(FALSE);     
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(FALSE);         
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt2()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];                              
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow();
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(FALSE);     
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(FALSE);         
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommLpt3()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];                    
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow();
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(FALSE);
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

BOOL CCommunicationDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();                        
    //add by chris:
    //GetDlgItem(IDC_COMM_PCE)->ShowWindow(SW_HIDE);
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(!m_bChecked);                    
    if(m_nType >=0 && m_nType<=3) {
        GetDlgItem(IDC_COMM_EDIT)->EnableWindow();
        GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow(FALSE);       
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(FALSE);       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(FALSE);       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(FALSE);       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(FALSE);       
        GetDlgItem(IDC_COMM_ST2)->EnableWindow(FALSE);
    } else {                                                   
        GetDlgItem(IDC_COMM_EDIT)->EnableWindow(FALSE);
        GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow();   
        GetDlgItem(IDC_COMM_ST2)->EnableWindow();    
        
    }

    return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCommunicationDialog::OnDetail()
{
    // TODO: Add your control notification handler code here
    int nDummy;
    nDummy = ::OpenAbiComDlg(0, this);
}

void CCommunicationDialog::OnCommPce()
{
    // TODO: Add your control notification handler code here
    UpdateData(TRUE);                    
    //m_strAddr = ::PortAddr[m_nType];                      
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow();
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(FALSE);       
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(FALSE);       
    wsprintf(m_strAddr.GetBuffer(10), "0x%X", m_nPortAddr[m_nType]);
    m_strAddr.ReleaseBuffer();
    UpdateData(FALSE);   
}

void CCommunicationDialog::OnCommCom1()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow(FALSE);
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow();       
    if(!m_bChecked) {
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow();          
        GetDlgItem(IDC_COMM_ST2)->EnableWindow();       
    }
    
}

void CCommunicationDialog::OnCommCom2()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow(FALSE);
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow();       
    if(!m_bChecked) {
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow();          
        GetDlgItem(IDC_COMM_ST2)->EnableWindow();       
    }
    
}

void CCommunicationDialog::OnCommCom3()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow(FALSE);
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow();       
    if(!m_bChecked) {
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow();          
        GetDlgItem(IDC_COMM_ST2)->EnableWindow();       
    }
    
}

void CCommunicationDialog::OnCommCom4()
{
    // TODO: Add your control notification handler code here
    GetDlgItem(IDC_COMM_EDIT)->EnableWindow(FALSE);
    GetDlgItem(IDC_CHECK_AUTO_BAUD)->EnableWindow();       
    if(!m_bChecked) {
        GetDlgItem(IDC_COMM_BAUD1)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD2)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD3)->EnableWindow();       
        GetDlgItem(IDC_COMM_BAUD4)->EnableWindow();          
        GetDlgItem(IDC_COMM_ST2)->EnableWindow();       
    }
    
}

void CCommunicationDialog::OnCheckAutoBaud()
{
    // TODO: Add your control notification handler code here   
     m_bChecked = !m_bChecked;
    
    GetDlgItem(IDC_COMM_ST2)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD1)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD2)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD3)->EnableWindow(!m_bChecked);                    
    GetDlgItem(IDC_COMM_BAUD4)->EnableWindow(!m_bChecked);                    
    
}
