/***************************************************************************
**               
**    $Header:   D:/ECB2S/SRC/LOG/DIAGNO/ABIREG51.CPP   1.7   17 Apr 1997 16:36:18   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DIAGNO/ABIREG51.CPP  $
** 
**    Rev 1.7   17 Apr 1997 16:36:18   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:13:22   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:58:10   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:35:36   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:20:42   ZJRD
** No change.
** 
**    Rev 1.1   19 Mar 1997 11:48:54   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 15:01:26   ZJRD
** Initial revision.
** 
**    Rev 1.4.1.0.1.2   09 Dec 1996 10:24:46   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.4.1.0.1.0   11 Nov 1996 13:04:50   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4.1.4   09 Sep 1996 13:49:12   ZJRD
** EasyPack/SLD Version 1.9f
** 
**    Rev 1.4.1.3   05 Sep 1996 11:40:00   ZJRD
** EasyPack/SLD Version 1.9e
** 
**    Rev 1.4.1.2   02 Sep 1996 10:04:42   ZJRD
** EasyPack/SLD Version 1.9d
** 
**    Rev 1.4.1.0   12 Aug 1996 11:06:24   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.2   05 Jun 1996 15:01:06   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.1   29 May 1996 09:43:08   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.0   16 May 1996 09:12:46   ZJRD
** Initial revision.
** 
**    Rev 1.28   15 Feb 1996 08:56:16   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:07:32   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:00   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:47:54   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:19:10   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:14:22   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:14:16   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:33:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:26:54   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:13:16   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:20   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:48   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:31:36   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:18:16   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:28:28   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:30:16   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:32   Shirley
** EasyPack/SLD Version 0.23
** 
**    Rev 1.10   08 Nov 1995 12:43:14   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:05:16   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:10   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:54   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:31:18   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:12   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:36   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:04   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:22   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:16   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abireg51.cpp
**
** Description: 
** 
** 
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include <stdio.h>

#include "abireg51.h" 
#include "abitype.h"
#include "abimacro.h"
#include <time.h>
#include "meter.h"        
#include "diagnost.h"
BOOL bCanTrace = FALSE;

static UINT gRegLen = 0x7f;
STATUS SendReceiveNoRelink(UINT wLoop, int tcount);
/////////////////////////////////////////////////////////////////
// ABI rountine part
//
STATUS AbiGetRegLen(UINT *wRegLen);
STATUS AbiGetFWSupport(UINT *wCpuNum, UINT* wCpuType);
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType);


STATUS AbiGetCpuId(UINT *nCpuId);
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId);
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor);

STATUS AbiGetCpuStatus(UINT *uCpuStatus);
STATUS AbiGetFreq(UCHAR *pszBuffer);
STATUS AbiGetTimerCount(TIMER_COUNT *pTimerCount);

STATUS AbiDiagnostic2(BYTE& bResult1,BYTE& bResult2);
STATUS AbiGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff);

/////////////////////////////////////////////////////////////////
// call ABI sub rountine 
//
extern STATUS SendReceive(UINT lp, int tcount);

/****************************************************
**
** Name : AbiGetRegLen()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetRegLen(UINT *wRegLen)
{  
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_REG_LEN,lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wRegLen =*((UINT*) &inputStream[1]);
        gRegLen = *((UINT * )&inputStream[1]);
    }
    else
        *wRegLen = 0x7f;
        
    return(status);
}

/****************************************************
**
** Name : AbiGetFWSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFWSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;

    SaveId(FW_GET_FW_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = *((UINT*) &inputStream[1]);

        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}

/****************************************************
**
** Name : AbiGetTargetSupport()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTargetSupport(UINT *wCpuNum, UINT* wCpuType)
{  
    STATUS status;
    UINT lp = 0;
    UINT uint;
    UCHAR *uchPtr;
    UCHAR *uchCpuNum = (UCHAR *) wCpuType;
    
    *wCpuNum = 1;
    *wCpuType = 1;
    return ICE_OK;

    SaveId(FW_GET_TARGET_SUPPORT, lp);
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        *wCpuNum = *((UINT*) &inputStream[1]);

        uchPtr = &inputStream[3];
        for (uint = 0; uint < (*wCpuNum) * 2; uint++) {
           * uchCpuNum ++ = *uchPtr++;
        }
    }

    return(status);
}

/****************************************************
**
** Name : AbiDiagnostic()
**
** Function
**
**    Input  : uchOption
**             diagnostic option 1--7
**             1 : PIO
**             2 : MAP RAM
**             3 : EVENT ADDRESS RAM
**             4 : EVENT DATA RAM
**             5 : SPOON RAM
**             6 : EMULATION RAM
**             7 : TRACE RAM
**
**    Output : result 0 ok; !0 not ok 
**             IF uchOption  == 1
**                  result:bit 0 == 1 porta err
**                         bit 1 == 1 portb err
**                         bit 2 == 1 portb err
**             IF uchOption == 7
**                  result:bit 0 == 1 trace count low err
**                         bit 1 == 1 trace count high err
**                         bit 2 == 1 trace addrh err
**                         bit 3 == 1 trace addrl err
**                         bit 4 == 1 trace data err
**                         bit 5 == 1 trace port
**                         bit 6 == 1 trace spare and status
**
** Notes: this routine only supported in fw 12.15 or later
**        22.13 or later...
**
****************************************************/
ADDR retAddr;
STATUS AbiDiagnostic(unsigned char uchOption,unsigned char& bResult)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_DIAGNOSTIC, lp);            
    SaveVar(uchOption , lp, sizeof(unsigned char));

    status = SendReceiveNoRelink(lp, /*BASE_TIME*/0x100); 
    bResult = inputStream[1];
    if ((bResult && 0x80) == 0x80)
      memcpy(&(retAddr.addr),&inputStream[2],sizeof(WORD));
    
    return(status);
}


/****************************************************
**
** Name : AbiGetCpuId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuId(UINT *nCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;
    
    *nCpuId = 1;
    return ICE_OK;
    
    lp = 0;
    SaveId(FW_GET_CPU_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiSetCpuId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiSetCpuId(UINT nSetCpuId, UINT *nGetCpuId)
{
    STATUS status;
    UINT lp;
    UCHAR *uchPtr;
    
    *nGetCpuId = nSetCpuId;
    return ICE_OK;
    
    lp = 0;
    SaveId(FW_SET_CPU_ID, lp);
    SaveVar(nSetCpuId, lp, sizeof(UINT));

    status = SendReceive(lp, BASE_TIME);

    uchPtr = &inputStream[1];
    *nGetCpuId = *((UINT*)uchPtr);

    return(status);
}

/****************************************************
**
** Name : AbiGetFwId()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFwId(UCHAR *uchMajor,  UCHAR *uchMinor)
{
    STATUS status;
    UINT lp;
    
    lp = 0;
    SaveId(FW_GET_FW_ID, lp);
    status = SendReceive(lp, BASE_TIME);

    *uchMajor = (UCHAR) inputStream[1];
    *uchMinor = (UCHAR) inputStream[2];

    return(status);
}

/****************************************************
**
** Name : AbiGetCpuStatus()
**
** Function : to get the current CPU status, Trace status,
**            Timer status
**
**    Input  :
**
**    Output :
**            bit 2     0: trace off
**                      1: trace on
**                3     0: trigger off
**                      1: trigger on
**              4~6     0: Stopped(break)
**                      1: Stopped(user)
**                      2: Stopped(write)
**                      3: Stopped(Guard)
**                      4: EP running
**                      5: EP wait
**                      6: EP halt
**                7     0: verify off
**                      1: verify on
**                8     0: timer off
**                      1: timer on 
**
** Notes:
**
****************************************************/
STATUS AbiGetCpuStatus(UINT *uCpuStatus)
{
    STATUS status;
    UINT lp;
    bCanTrace = TRUE;      
    if ( bCanTrace ) TRACE("Bb %2.1f\n",(double)clock());         
    lp = 0;
    SaveId(FW_GET_CPU_STATUS, lp);
    status = SendReceive(lp, BASE_TIME);
    
    *uCpuStatus = *((UINT*) &inputStream[1]);  
    if ( bCanTrace ) TRACE("Be %2.1f\n",(double)clock());   
    bCanTrace = FALSE;
    return status;
}


/****************************************************
**
** Name : AbiGetFreq()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetFreq(UCHAR *pszBuffer)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_GET_FREQ, lp);
    status = SendReceive(lp, BASE_TIME);

    if (status  == ICE_OK) {
        for (int i=0; i<10; i++)
            *pszBuffer++ = (UCHAR) inputStream[1+i];
    }

    return(status);
}

/****************************************************
**
** Name : AbiGetTimerCount()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
****************************************************/
STATUS AbiGetTimerCount(TIMER_COUNT *pTimerCount)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_GET_TIMER_COUNT, lp);
    status = SendReceive(lp, BASE_TIME);

    if ( ICE_OK == status ) {
       // ASSERT ( 0 == inputStream[1] || 1 == inputStream[1] )
        if ( 0 == inputStream[1] ) {
            pTimerCount->ulLowCount = 0;
            pTimerCount->uchHighCount = 0;
        }
        else {
            pTimerCount->ulLowCount = * (ULONG * ) &inputStream[2];
            pTimerCount->uchHighCount =  (UCHAR ) inputStream[6];
        }
    }
    return status;
}

/*****************************************************
**
** Name : AbiReset()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiReset(ADDR addr)
{
    STATUS status; 
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_RESET,uintLoop);
    SaveVar(addr, uintLoop, sizeof(ADDR));

    // Added by Gates Hua
    if ( addr.addrType == 0x10 )
        status = SendReceive(uintLoop, 60);
    else 
        status = SendReceive(uintLoop, BASE_TIME);
    
    return status;
}

//added by john 96.8
/****************************************************
**
** Name : AbiDetailDgnst(char& bByte1,char& bByte2,char& bByte3,char& bByte4)
**
** Function : detail diagnostic
**
**    Input  :
**
**    Output : bByte1: bit0 TVCC
**                     bit1 EpodModel
**                     bit2 NRSTEP or NDLEPD
**                     bit3 CANEND
**                     bit4 ENDSP
**                     bit5 CPURUN
**                     bit6 CANRUN
**                     bit7 MemTest 
**             bByte2: bit0 reset 
**                     bit1 go and halt
**                     bit2 breakpoint
**                     bit3 trace
**                     bit4 qualify
**                     bit5 timer
**                     bit6 event trigger
**                     bit7 step
**             bByte3: bit0 Status AK
**             bByte4: value(uknown)              
**             
**
** Notes:
**                          
****************************************************/
STATUS AbiDetailDgnst(char& bByte1,char& bByte2,char& bByte3,char& bByte4)
{                 
    
    /*bByte1 = bByte2 = bByte3 = bByte4 = 0xff;
    return ICE_OK;*/
    
    
    STATUS status;
    UINT lp = 0;

    SaveId(FW_DETAIL_DIAGNOSTIC, lp);
    status = SendReceive(lp, 60);

    if ( ICE_OK == status ) {      
        bByte1 = inputStream[1];
        bByte2 = inputStream[2];
        bByte3 = inputStream[3];
        bByte4 = inputStream[4];
    }
    return status;
    
 }
 
/*****************************************************
**
** Name : AbiSelectBaud()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSelectBaud(BYTE bOption)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SELECT_BAUD,uintLoop);      
    SaveVar(bOption, uintLoop, sizeof(BYTE));

    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiSelectBaud()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiDiagnostic2(BYTE& bResult1,BYTE& bResult2)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_DIAGNOSTIC2,uintLoop);      

    status = SendReceive(uintLoop, BASE_TIME*10);
    bResult1 = inputStream[1];
    bResult2 = inputStream[2];
    
    return(status);
}
 
//john 97.2
/*****************************************************
**
** Name : AbiSendProgData()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_SEND_PROG_DATA,uintLoop);      
    SaveVar(wAddr, uintLoop, sizeof(WORD));
    SaveVar(bLen, uintLoop, sizeof(BYTE));
    SaveBuffer(pBuff,uintLoop,bLen);
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiPrograme()
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiProgram(BYTE bType,BYTE bUes)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_PROGRAME,uintLoop);      
    SaveVar(bType, uintLoop, sizeof(BYTE));
    SaveVar(bUes, uintLoop, sizeof(BYTE));
    
    status = SendReceive(uintLoop, BASE_TIME*10);
    
    return(status);
}

/*****************************************************
**
** Name : AbiGetUesData(BYTE bType)
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff)
{
    STATUS status;
    UINT uintLoop;

    uintLoop = 0;
    SaveId(FW_GET_UES_DATA,uintLoop);      
    SaveVar(bType, uintLoop, sizeof(BYTE));
    
    status = SendReceive(uintLoop, BASE_TIME);
    
    if (status == ICE_OK){
        bLen =inputStream[1];
        memcpy(pBuff,&inputStream[2],bLen);
    }
    return(status);
}
