/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/DIAGNO/UISERIAL.H__   1.7   17 Apr 1997 16:36:50   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/DIAGNO/UISERIAL.H__  $
** 
**    Rev 1.7   17 Apr 1997 16:36:50   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:17:42   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:58:32   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:36:16   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:21:02   ZJRD
** No change.
** 
**    Rev 1.1   19 Mar 1997 11:49:14   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 15:01:40   ZJRD
** Initial revision.
** 
**    Rev 1.6   21 Oct 1996 09:19:22   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:51:46   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:39:04   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:53:10   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:34:24   ZJRD
** PIC-SLD Version 0.50
** 
**    Rev 1.0   13 Aug 1996 09:20:14   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : UISERIAL.H 
** Author:john chow
** Description:
**    Descript the function of serial communication for PIC-SLD
**
**    Finished date: 96.7
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _UISERIAL_
#define _UISERIAL_
#include "serialcm.h"
#include "abitype.h"

//definition of class CDosSerialAgree 
class CWinSerialPICAgree : public CBaseSerialPICAgree
{
//members              
public:
    BOOL SerialInfor[COM_PORT_4+1];
    enum {
        ERR_OPEN = 500,
        ERR_BAUD,
        ERR_INIT,
        ERR_TRYINIT
    };  
//operation
public:
    virtual BOOL SetSerialOption();
    virtual BOOL SetSerialPortBaud(BYTE,BYTE);
    virtual BOOL CommInit();  
    virtual void IsUnstable();               
    
    CString GetSerialPortNum();
    CString GetSerialBaudRate();
    CString GetPICClockType();
protected:
    int m_nDeviceID;
    COMSTAT m_ComStatus;    
    DCB m_DCB;

    BOOL TryInit();
    
    virtual BOOL SendByte(BYTE);
    virtual BOOL ReceiveByte(BYTE&);
    virtual BOOL SendString(BYTE *,int);
    virtual BOOL ReceiveString(BYTE *,int);
    
    virtual BOOL IsEscape();
    virtual BOOL IsRelink();
    
    virtual void FlushBufferIn();
    virtual void FlushBufferOut();
    
//construct and destruct
public:
    CWinSerialPICAgree();
    ~CWinSerialPICAgree();
        
};

#endif //uiserial