
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EPSETUP/ABIBASE.H__   1.0.1.1.1.5   17 Apr 1997 16:21:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EPSETUP/ABIBASE.H__  $
** 
**    Rev 1.0.1.1.1.5   17 Apr 1997 16:21:46   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.4   16 Apr 1997 11:02:34   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.3   10 Apr 1997 15:53:26   ZJRD
** 2.09F
** 
**    Rev 1.0.1.1.1.1   03 Apr 1997 15:31:58   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.0   28 Mar 1997 10:35:54   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.0.1.0   19 Mar 1997 11:46:00   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:59:36   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:23:50   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:03:58   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:48:22   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:38:58   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:03:36   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:56:44   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 11:03:42   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 15:00:24   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:41:58   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:32   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:32   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:33:44   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.6   18 Apr 1996 13:06:40   Shirley
** No change.
** 
**    Rev 1.5   12 Apr 1996 10:45:48   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.3   15 Feb 1996 09:00:56   Shirley
** No change.
** 
**    Rev 1.2   12 Feb 1996 14:12:58   Shirley
** No change.
** 
**    Rev 1.1   06 Feb 1996 15:39:10   Shirley
** No change.
** 
**    Rev 1.0   06 Feb 1996 13:53:36   Shirley
** Initial revision.
** 
**    Rev 1.24   01 Feb 1996 10:19:38   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:16:30   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:16:26   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:34:20   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:48   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:13:42   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:10:32   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:09:50   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:13:12   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:32   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:23:36   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:25:58   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:38   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:04   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:45:02   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:03:34   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:46:44   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:16   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:04   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:48:46   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:19:16   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:51:44   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:58:02   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:46:28   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:55:22   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abibase.h
**
** Description: define base data types which are used in ABI 
**
** Programmer: Frank Chang
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABIBASE_
#define _ABIBASE_

typedef unsigned char UCHAR;

#ifndef UINT
typedef unsigned int  UINT;
#endif

#ifndef WORD
typedef unsigned short  WORD;
#endif                  

#ifndef DWORD
typedef unsigned long DWORD;
#endif

#ifndef ULONG
typedef unsigned long ULONG;
#endif

typedef int STATUS;

typedef unsigned char FLAG;

#ifndef BOOL
typedef int  BOOL;
#endif  

#ifndef FALSE
#define FALSE 0
#define TRUE  !FALSE
#endif  

const int BASE_TIME = 0xff;

typedef enum {
    ABI_OK      = 0,
    ABI_TIME_OVER = -1,
    ABI_ESCAPE = -2
} ABI_RET;

typedef struct {
    FLAG addrType;
    WORD  addr;
} ADDR;

/* All ABI routines Return codes */
typedef enum {
        ICE_OK              = 0x0,
        ICE_FAIL_STEP,                  //target cannot step
        ICE_FAIL_MEM_WRITE,             //memory write failure
        ICE_FAIL_MAP_INCLUDE,           //map status not included
        ICE_FAIL_MAP_BOUNDARY,          //map address boundary error
        ICE_NOT_FOUND       = 0x5,
        ICE_FOUND,
        ICE_TIME_OUT        = 0x7,
        ICE_PARA_ERROR      = 0x8,
        ICE_EP_RUNNING      = 0x10,
        ICE_TRACE_RUNNING   = 0x11,
        ICE_TRACE_READ_OVER = 0x12,
        ICE_COMMAND_INVALID = 0x13,

        ICE_FLASH_SW_ERROR  = 0x40,
        ICE_FLASH_EC_ERROR  = 0x41,
        ICE_FLASH_PRG_ERROR = 0x42,
        ICE_FLASH_REC_ERROR = 0x43,

} RET_CODE;
         
         
#endif
