 
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/EPSETUP/ABITYPE.H__   1.0.1.1.1.5   17 Apr 1997 16:21:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/EPSETUP/ABITYPE.H__  $
** 
**    Rev 1.0.1.1.1.5   17 Apr 1997 16:21:52   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.4   16 Apr 1997 11:08:08   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.3   10 Apr 1997 15:53:30   ZJRD
** 2.09F
** 
**    Rev 1.0.1.1.1.1   03 Apr 1997 15:32:02   ZJRD
** No change.
** 
**    Rev 1.0.1.1.1.0   28 Mar 1997 10:35:58   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.0.1.0   19 Mar 1997 11:46:04   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:59:38   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:23:50   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:03:58   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:48:20   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:38:56   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:03:36   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:56:42   ZJRD
** No change.
** 
**    Rev 1.7.1.0   12 Aug 1996 11:03:40   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 15:00:24   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:41:54   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:11:30   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:19:30   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:33:42   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.6   18 Apr 1996 13:06:38   Shirley
** No change.
** 
**    Rev 1.5   12 Apr 1996 10:45:44   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.3   15 Feb 1996 09:00:54   Shirley
** No change.
** 
**    Rev 1.2   12 Feb 1996 14:12:56   Shirley
** No change.
** 
**    Rev 1.1   06 Feb 1996 15:39:08   Shirley
** No change.
** 
**    Rev 1.0   06 Feb 1996 13:53:34   Shirley
** Initial revision.
** 
**    Rev 1.24   01 Feb 1996 10:14:30   Shirley
** EasyPack/SLD Version 0.35b
** 
**    Rev 1.23   26 Jan 1996 09:20:24   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:54   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:10   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:42   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:20   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:52   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:36   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:21:46   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:28:08   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:27:42   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:39:36   Shirley
** EasyPack/SLD Version 0.22
** 
**    Rev 1.9   02 Nov 1995 10:02:20   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:45:00   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:43:18   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:48   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:46:52   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:18:18   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:47:42   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:26   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:43:30   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:16   Shirley
** Initial revision.
**
****************************************************************************/

/***************************************************************************
**
** File name : abitype.h
**
** Description: 
**
**
**
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#ifndef _ABITYPE_
    #define _ABITYPE_

    #ifndef _ABIBASE_
        #include "abibase.h"
    #endif

    typedef enum {
        NORMAL_RUN = 0,FREE_RUN
    } RUN_MODE;

    //for DIAGNOSTIC commands return code
    typedef enum {
        ALL_OK              = 0x0,
        FAIL_PIO_CTC        = 0x01,
        FAIL_MAP_RAM        = 0x02,
        FAIL_EVENT_ADDR_RAM = 0x04,
        FAIL_EVENT_DATA_RAM = 0x08,
        FAIL_SPOON_RAM      = 0x10,
        FAIL_EMULATION_RAM  = 0x20,
        FAIL_TRACE_RAM      = 0x40
    } DIAG_MSG;

    typedef enum {
        MEM_UNDEFINED   =0,
        MEM_CODE,
        MEM_EXT_DATA,
        MEM_INT_DATA,
        MEM_SFR,
        MEM_BIT
    }ADDR_TYPE;

    typedef enum {
        MAP_I =0,
        MAP_IR,
        MAP_E,
        MAP_ER,
        MAP_C,
        MAP_CR,
        MAP_G
    } MAP_ATTR;

    typedef enum {
        PORT_P0 =0,
        PORT_P1,
        PORT_P2,
        PORT_P3,
    } PARA_PORT;

    typedef enum {
        CASE_SENSITIVE  = 0,
        CASE_INSENSITIVE
    }CASE_FLAG;

    /* define the F/W command ID for Xview  */
    typedef enum {
        FW_RESET                = 0x0,
        FW_GO                   = 0x1,
        FW_ABORT                = 0x2,
        FW_DIAGNOSTIC           = 0x3,
        FW_SET_CPU_ID           = 0x4,
        FW_GET_CONTROL          = 0x5,
        FW_SET_CONTROL          = 0x6,
        FW_SET_TIMER_ONOFF      = 0x7,
        FW_SET_PORT             = 0x8,
        FW_OUTPUT               = 0x9,
        FW_INPUT                = 0xa,
        FW_SET_VERIFY_ONOFF     = 0xb,
        FW_SET_TRIG_ONOFF       = 0xc,
        FW_SET_TRIG_LEVEL       = 0xd,
        FW_SET_TRIG_LOGIC       = 0xe,
        FW_GET_CPU_ID           = 0xf,
        FW_CHECKSUM             = 0x10,
        FW_COMPARE              = 0x11,
        FW_COPY                 = 0x12,
        FW_DOWNLOAD             = 0x13,
        FW_FILL                 = 0x14,
        FW_GET_MEM_N            = 0x15,
        FW_SEARCH               = 0x16,
        FW_TEST                 = 0x17,
        FW_SET_MEM_N            = 0x18,
        FW_UPLOAD               = 0x19,
        FW_GET_TRIGGER          = 0x1a,

        FW_GET_REG_LEN          = 0x1f,
        FW_GET_ALL_REG          = 0x20,
        FW_GET_ONE_REG          = 0x21,
        FW_SET_ONE_REG          = 0x22,
        FW_GET_FW_ID            = 0x23,
        FW_GET_FREQ             = 0x24,
        FW_INIT_EPROM           = 0x25,
        FW_BURN_EPROM           = 0x26,
        FW_GET_TIMER_COUNT      = 0x27,

        FW_GET_MAP              = 0x31,
        FW_SET_MAP              = 0x32,
        FW_SET_BP               = 0x33,
        FW_CLR_BP               = 0x34,
        FW_GET_BP               = 0x35,

        FW_STEP_ONE             = 0x40,
        FW_STEP_OVER            = 0x41,
        FW_CYCLE                = 0x42,
        FW_GET_CPU_STATUS       = 0x43,
        FW_STEP_RANGE           = 0x44,
        FW_STEP_OVER_RANGE      = 0x45,

        FW_GET_TARGET_SUPPORT   = 0x47,
        FW_GET_FW_SUPPORT       = 0x48,

        FW_SET_EVENT            = 0x50,
        FW_CLR_EVENT            = 0x51,
        FW_GET_EVENT            = 0x52,

        FW_SET_TRACE_ONOFF      = 0x58,
        FW_GET_TRACE_BUFFER     = 0x59,
        FW_GET_TRACE_LAST_FRAME = 0x5a,

        FW_FLASH_SWITCH         = 0x60,
        FW_FLASH_ERASE          = 0x61,
        FW_FLASH_PROG           = 0x62,
        //97.1
        FW_SELECT_BAUD			= 0X74
    } FW_COMMAND_ID;

    
    //for MAP command
    typedef struct {
        ADDR stAddr;
        ADDR endAddr;
        char mapAttr;
    } MAP_INFO;         
    
    //for SEARCH command
    typedef struct {
        FLAG caseFlag;
        char srchBufLen;
        char srchBuf[32];
    } SEARCH_INFO;         
    
    //for LIST command
    typedef struct tracerec{
        WORD frameNo;
        WORD addr;
        UCHAR data;
        UCHAR status;
        UCHAR port;
        }TRACE_INFO;

    //for CYCLE command, unreviewed
    typedef struct {
        WORD addr;
        UCHAR data;
        UCHAR status; //SPARE: 7~3
                      //XXXXX210
                      //0:S, 1:F, 2:R, 3:W, 4:AK
        UCHAR port;
    } CYCLE_INFO; 

    //for Timer command
    typedef struct {
        ULONG ulLowCount;
        UCHAR uchHighCount;
    } TIMER_COUNT;
    
    //Reserved, for ICE_FAIL_MEM_WRITE message
/*    typedef struct{
        ADDR addr;
        DATA data;
    } RET_INFO;
*/                               



    //for EVENT, QUALIFY commands
    typedef struct {
        WORD    setMode;            //only when list_trace_buffer used, it = 1;
                                    //others is 0;
        FLAG    qlfyType[12];       //[0-1] event_start_no: 0:qualify_cmd, 1:ev1, 2:ev2, 3:ev3
                                    //[2-3] event_end_no  : not used
                                    //[4-5] addr_qualify  : 0: all is wildcard;  XXXX
                                    //                      1: single addr;      1234
                                    //                      02h: bit wildcard;   123(10XX): x must be behind digital
                                    //                                           value = 1230 or 123f or 123x
                                    //                                           mask  = FFFC
                                    //                                           each bit, 1:actual 0:wildcard
                                    //                      10h: range  10h-20h;
                                    //                      20h: exclusive range; ~10h-20h
                                    //                      40h: addr group;  <10h, 20h, 30h...>
                                    //[6-7] data_qualify  : 0: all is wildcard;  XXXX
                                    //                      1: single data;      1234
                                    //                      02h: bit wildcard;   12XX, 12x3, 12
                                    //                      10h: range  10h-20h;
                                    //                      20h: exclusive range; ~10h-20h
                                    //[8] status_qualify  : 0: not setted
                                    //                      1: setted
                                    //[9] extern_qualify  : 0: not setted
                                    //                      1: setted
                                    //[10] count_qualify  : 0: not setted
                                    //                      1: setted(only for EV1)
                                    //[11] reserved        :
        ULONG   data1;              //start
        ULONG   data2;              //end
        ULONG   status;             //S:1h, F:2h, R:4h, W:8h, AK:10h
        ULONG   extrn;              //extern data  1:High, 0:Low
        ULONG   extMask;            //extern data mask flag, not used
        ULONG   count;              //event count, only for EV1
        WORD    RES[3];             //not used
        WORD    addrCount;          //setted address count
        WORD    addr[10][4];        //start address
    }BUS_EVENT, QUALIFY, *PBUSEVENT, *PQUALIFY;

    //for LEVEL command
    typedef struct {
        FLAG traceFlag;        /* 0 trace unchanged    */
                               /* 1 trace ON           */
                               /* 2 trace OFF          */
        FLAG timerFlag;        /* 0 timer unchanged    */
                               /* 1 timer ON           */
                               /* 2 timer OFF          */
        DWORD dwCond;          /* condition list       */
                            // EV1  AAAAAAAAH
                            // EV2  CCCCCCCCH
                            // EV3  F0F0F0F0H
                            // EV4  FF00FF00H
                            // EV5  FFFF0000H
                            // EV1 OR  EV2 = AAAAAAAAH OR  CCCCCCCCH = EEEEEEEEH
                            // EV2 AND EV3 = CCCCCCCCH AND F0F0F0F0H = C0C0C0C0H

    }  TRIGGER_LEVEL;

    //for TRIGGER command
    typedef struct {
        FLAG trigFlag;         /* 0 delay count    */
                               /* 1 foreward       */
                               /* 2 backward       */
                               /* 3 center         */
        FLAG runFlag;          /* 0 without run    */
                               /* 1 with run       */
        DWORD delayCount;      /* delay count(trigFlg=0 used) */
        WORD levelCount;
        WORD levelID[4];       /* level ID list*/
                               //LV1:           levelCount =1, levelID[0]=1
                               //LV2:           levelCount =1, levelID[0]=2
                               //LV1_Then_LV2:  levelCount =2, levelID[0]=1, levelID[1] =2
                               //LV2_Then_LV1:  levelCount =2, levelID[0]=2, levelID[2] =1
    } TRIGGER_LOGIC ;

    typedef struct {
        WORD wActionId;
        WORD wEpromId;
        WORD wPinOut;
        unsigned long ulStartAddr;
        unsigned long ulEndAddr;
    } BURN_EPROM;

#endif
