
/**************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/FWSETUP/ABIMEM51.CPP   1.7   17 Apr 1997 16:37:08   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/FWSETUP/ABIMEM51.CPP  $
** 
**    Rev 1.7   17 Apr 1997 16:37:08   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:17:58   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:58:54   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:36:22   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:21:10   ZJRD
** No change.
** 
**    Rev 1.1   19 Mar 1997 11:49:20   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 15:02:14   ZJRD
** Initial revision.
** 
**    Rev 1.2.1.0.1.2   09 Dec 1996 10:25:10   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.2.1.0.1.0   11 Nov 1996 13:05:12   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.2.1.4   09 Sep 1996 13:49:32   ZJRD
** No change.
** 
**    Rev 1.2.1.3   05 Sep 1996 11:40:20   ZJRD
** No change.
** 
**    Rev 1.2.1.2   02 Sep 1996 10:05:00   ZJRD
** No change.
** 
**    Rev 1.2.1.1   28 Aug 1996 15:58:06   ZJRD
** No change.
** 
**    Rev 1.2.1.0   12 Aug 1996 11:06:56   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.0   05 Jun 1996 15:01:40   ZJRD
** Initial revision.
** 
**    Rev 1.28   15 Feb 1996 08:55:18   Shirley
** EasyPack/SLD Version 1.01
** 
**    Rev 1.27   12 Feb 1996 14:09:22   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:35:46   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:50:02   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:14:32   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:20:26   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:20:18   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:08   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:27:58   Shirley
** No change.
** 
**    Rev 1.19   18 Jan 1996 10:09:54   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:16:10   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:11:44   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:22   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:34:54   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:22:36   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:27:58   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:28:04   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:41:18   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:58   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:51:22   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:12   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:25:58   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:47:32   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:23:40   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:50:24   Shirley
** EasyPack/SLD Version 0.1c
** 
**    Rev 1.2   20 Sep 1995 10:52:20   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:43:24   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:14   Shirley
** Initial revision.
**
***************************************************************************/

/***************************************************************************
**
** File name : abimem51.cpp
**
** Description: 
**
**
**
**
** Programmer: Frank Chang
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#include "stdafx.h"

#include "abitype.h"
#include "abimacro.h"

static ADDR retAddr;

/////////////////////////////////////////////////////////////////                  
// Rountines declaration
//

STATUS AbiInitEprom();
STATUS AbiBurnEprom(BURN_EPROM burnEprom, WORD *wChecksum);

//unchecked, 02/08/96
STATUS AbiSwitchFlash();
STATUS AbiEraseFlash();
STATUS AbiProgramFlash(UCHAR ,UCHAR, UCHAR* pchBuff, UINT uPatternLen);

extern STATUS SendReceive(UINT lp, int tcount);
extern STATUS SendReceiveNoRelink(UINT lp, int tcount);

/*****************************************************
**
** Name : AbiInitEprom()
**
** Function: Before programming, initialize the
**           communication with EPROM
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiInitEprom()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_INIT_EPROM,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiBurnEprom()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiBurnEprom(BURN_EPROM burnEprom, WORD *wChecksum)
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_BURN_EPROM,lp);
    SaveVar(burnEprom, lp, sizeof(BURN_EPROM));
    status = SendReceive(lp, BASE_TIME);
    
    if (status == ICE_OK) {
        if (burnEprom.wActionId != 1)
            *wChecksum = *((WORD *) &inputStream[1]);
    }
    else {
        retAddr.addr = *((WORD *) &inputStream[1]);
    }
    return(status);

}

/*****************************************************
**
** Name : AbiSwitchEprom()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiSwitchFlash()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_FLASH_SWITCH,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}
     
/*****************************************************
**
** Name : AbiEraseFlash()
**
** Function:
**
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiEraseFlash()
{
    STATUS status;
    UINT lp;

    lp = 0;
    SaveId(FW_FLASH_ERASE,lp);
    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

/*****************************************************
**
** Name : AbiProgramFlash()
**
** Function:
**
**    Input  :
**
**    Output :
**
** Notes:
**
*****************************************************/
STATUS AbiProgramFlash(UCHAR adrh,UCHAR adrl, UCHAR* pchBuff, UINT uPatternLen)
{
    STATUS status;
    UINT lp = 0;

    SaveId(FW_FLASH_PROGRAM,lp);

    SaveVar(uPatternLen, lp, 1);
    SaveVar(adrh,lp,1);
    SaveVar(adrl,lp,1);
    memcpy(&outputStream[lp], pchBuff, uPatternLen);
    lp += uPatternLen;


    status = SendReceive(lp, BASE_TIME);
    
    return(status);
}

     
