/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/FWSETUP/SERIALCM.H__   1.7   17 Apr 1997 16:38:20   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/FWSETUP/SERIALCM.H__  $
** 
**    Rev 1.7   17 Apr 1997 16:38:20   ZJRD
** No change.
** 
**    Rev 1.6   16 Apr 1997 11:18:18   ZJRD
** No change.
** 
**    Rev 1.5   10 Apr 1997 15:59:12   ZJRD
** 2.09F
** 
**    Rev 1.3   03 Apr 1997 15:37:20   ZJRD
** No change.
** 
**    Rev 1.2   27 Mar 1997 15:21:58   ZJRD
** No change.
** 
**    Rev 1.1   19 Mar 1997 11:50:00   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 15:02:24   ZJRD
** Initial revision.
** 
**    Rev 1.6   21 Oct 1996 09:19:20   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:51:44   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:38:46   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:53:06   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:34:22   ZJRD
** PIC-SLD Version 0.50
** 
**    Rev 1.0   13 Aug 1996 09:19:22   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : SERIALCM.H
** Author:john chow
** Description:
**    Descript the base function of serial communication for PIC
**
**    Finished date: 96.7
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/


#ifndef _SERIALCM_
#define _SERIALCM_

#include "stdafx.h"
#include <sys\timeb.h>
#include <string.h>
#include "abitype.h"

//const define

#define MAXERRORNUM 200              

// definition of CBaseCom
class CBaseCom 
{   
//member
public:
    int m_nError;
    int m_nDetailError;
    BOOL m_isCanBeUsed;                  
    
    enum { ERR_NO,ERR_NOT_REPARE,ERR_TIME_OUT,ERR_ESC,ERR_FATAL};
private:
    struct _timeb m_startTime,m_currentTime;
    unsigned long m_lTimer; 
   
//operation
public:  
    virtual BOOL SendByte(BYTE) = 0;
    virtual BOOL ReceiveByte(BYTE&) = 0;
    virtual BOOL SendString(BYTE *,int);
    virtual BOOL ReceiveString(BYTE *,int);
    virtual BOOL IsEscape() { return FALSE;}
    virtual void FlushBufferIn() {return ;}
    virtual void FlushBufferOut() {return ;}
    
    void SetTimer(unsigned long);
    void RestartTimer();
    
    BOOL IsTimeOut();
    
//construct
protected:
    CBaseCom() { 
        m_isCanBeUsed = FALSE; 
        m_nError = m_nDetailError = ERR_NO;}       
};

//definition of class CBaseAgree
class CBaseAgree : public CBaseCom
{
//member
public:
    BYTE *m_strInput,*m_strOutput;  
    WORD m_nInputStrLen,m_nOutputStrLen;
    enum { INPUTLEN = 2048,OUTPUTLEN = 4096 };
//operation
public:
    void SetOutputStr(BYTE*,int);   
    void GetInputStr(BYTE*,int&);
    
    virtual BOOL Do() = 0;
//construct and destruct
protected:
    CBaseAgree();
    ~CBaseAgree();  
};  

//definition of class CPICAgree
class CPICAgree : public CBaseAgree
{                                 
//member
public:
    BOOL isConnected;
    enum { 
        ERR_RELINKQUIT = 200,
        ERR_RECEIVE_WRONGCODE,
        ERR_NOT_CONNECTED,
        ERR_RECEIVE_DOLLAR,
        ERR_SEND_DOLLAR,
        ERR_SHAKE_HAND,
        ERR_SEND_HEAD,
        ERR_SEND_REC,
        ERR_SHAKE_HAND_,
        ERR_RECEIVE_HEAD,
        ERR_RECEIVE_REC
    };
    unsigned long nBackTime;//setted by every abi command to define the inter time
                    //between send string to fw and receive string from fw
                    
    
private:
    enum {       
        LEAD_CODE   = ':',
        HEAD_OK     = 0x55,
        HEAD_FAIL   = 0xaa,
        REC_OK      = 0x5a,   
        REC_FAIL    = 0xa5
    };      
    int m_nErrorTime;//counter of error
            
//operation 
public:
    virtual BOOL IsRelink() { return FALSE; }
    virtual BOOL Do();
    virtual void IsUnstable() = 0;
                      
    BOOL Init();                  
    BOOL Shakehand(BYTE bTimers = 10);
    BOOL Shakehand_();
    BOOL SendHead();
    BOOL SendRec();
    BOOL ReceiveHead();
    BOOL ReceiveRec();
    

//construct
protected:
    CPICAgree() { isConnected == FALSE; m_nErrorTime = 0; } 
    
};                   

//definition of class CBaseSerialPICAgree
class CBaseSerialPICAgree : public CPICAgree
{                                        
//members
public:
    enum {        
    	 COM_PCE = 0,
         COM_LPT1,          
         COM_LPT2,          
         COM_LPT3, 
         COM_PORT_1,
         COM_PORT_2,
         COM_PORT_3,
         COM_PORT_4
    };
    enum {
        BAUD_9600 = 0,
        BAUD_19200,
        BAUD_38400,
        BAUD_57600,
        BAUD_115200
    };  
    enum {
        CLOCK_LP = 0,
        CLOCK_XT,
        CLOCK_HS,
        CLOCK_RC
    };
        
protected:
    BYTE m_bPortNum;
    BYTE m_bBaudRate;
    BYTE m_bDefaultBaudRate;      
    WORD m_wAddr;
    BYTE m_bPICClockType;//Because we must set the clock type for pic at the
    					 //beginning.
    					 //NOT USE
    BYTE m_bPICCpuType;	//NOT USE				 

//operation
public:
    virtual BOOL SetSerialOption() = 0;
    virtual BOOL SetSerialPortBaud(BYTE,BYTE) = 0;
    virtual BOOL CommInit() = 0;
    
    
    BYTE GetSerialPortNum();
    BYTE GetSerialBaudRate();
    BYTE GetPICClockType();
    BYTE GetPICCpuType();
     
 };
 
#endif //serialcm 
 