/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/HWTIP.H__   1.2.1.4   17 Apr 1997 15:52:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/HWTIP.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:52:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:24:16   ZJRD
** 2.09F
** 
****************************************************************************/

// foxbar.h : header file
//
#ifndef _fox_bar
#define _fox_bar

#define  TWS_TIPS                0x0010
#define  TWS_NO_TIPS             0x0000

struct AFX_TBBUTTON
{
	UINT nID;        // Command ID that this button sends
	UINT nStyle;    // TBBS_ styles
	int iImage;     // index into mondo bitmap of this button's picture
						// or size of this spacer
}; 
/////////////////////////////////////////////////////////////////////////////
// CTipToolBar window

class CTipToolBar : public CToolBar
{
// Construction
public:
	CTipToolBar();
    BOOL Create( CWnd *pParent, UINT ex_Style=TWS_NO_TIPS);    
    void FilterTipMessage(MSG *pMsg);                              
    
// Attributes
public:
    void SetBackColor(COLORREF);
    void SetDelayTime(int nTimes);//nTimes * 55ms
    void SetTipFont(LOGFONT *logFont);

private:
   CWnd       *m_pTip; 
   CRect      m_wndRect;
   BOOL       m_bSetTimer; 
   UINT       m_dwStyle;  
   int        m_nDelayTime;
   int        m_nTimeCount;
   UINT       m_BtnID;
   UINT       m_OldBtnID;
   enum { m_TimerID = 1300 };
     
public:
// Operations
protected:
void TipProcess(CPoint point);

private:                  
void ShowTipCard(UINT ID,POINT point);
void DrawContent(LPCSTR lpText,POINT point);
void ReleaseTip(BOOL bOut=FALSE);
int  HitTipTest(CPoint point/*screen postion*/);
UINT OnCmdHitTest(CPoint point); 
void BorderPaint(CDC* pDC);

// Implementation
public:
	virtual ~CTipToolBar();
protected:
    virtual void DoPaint(CDC* pDC);
   inline AFX_TBBUTTON* GetButtonPtr(int nIndex) const;

protected:
	// Generated message map functions

	//{{AFX_MSG(CTipToolBar)
	afx_msg int  OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnTimer(UINT);   
    afx_msg void OnSize(UINT uType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
/////////////////////////////////////////////////////////////////////////////
// CFoxStatusBar window

class CFoxStatusBar : public CStatusBar
{

DECLARE_DYNAMIC(CFoxStatusBar)

// Construction
public:
	CFoxStatusBar();
	BOOL Create(CWnd* pParentWnd,
			DWORD dwStyle = WS_CHILD | WS_VISIBLE | CBRS_BOTTOM,
			UINT nID = AFX_IDW_STATUS_BAR);

// Attributes
public:

// Operations
public:

// Implementation
public:
	virtual ~CFoxStatusBar();

protected:
	// Generated message map functions
	//{{AFX_MSG(CFoxStatusBar)
    afx_msg LRESULT OnSetFont(WPARAM wParam, LPARAM);		
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
/////////////////////////////////////////////////////////////////////////////

