
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/LDRUBROF.CPP   1.2.1.4   17 Apr 1997 15:55:02   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/LDRUBROF.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:02   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:26:08   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:36:50   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:16:24   ZJRD
** 2.09E
** 
**    Rev 1.2.1.0   28 Mar 1997 10:21:28   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:31:40   ZJRD
** Easy Pack SLD 2.09c
** 
**    Rev 1.0   12 Mar 1997 14:47:32   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:14:58   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:58:14   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:15:24   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:26:58   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:54:04   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:47:38   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:52:18   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.5   05 Jun 1996 14:55:38   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:38:22   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:00:40   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:15:06   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:22:58   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 13:02:46   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.30   12 Apr 1996 10:36:50   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:49:50   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:02:18   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:27:32   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:43:10   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:16:04   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:12:54   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:13:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:39:20   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:28:10   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:10:06   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:17:20   Shirley
** EasyPack/SLD Version 0.34a
** 
**    Rev 1.17   04 Jan 1996 11:11:54   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:08:32   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:35:04   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:24:20   Shirley
** EasyPack/SLD Version 0.31
** 
**    Rev 1.13   13 Nov 1995 09:25:02   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:29:28   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:32:54   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:42:16   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:06:34   Shirley
** EasyPack/SLD Version 0.21
** 
**    Rev 1.8   27 Oct 1995 16:50:10   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:44:32   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:28:12   Shirley
** EasyPack/SLD Version 0.1f
** 
**    Rev 1.5   18 Oct 1995 14:52:24   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:21:52   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:52:10   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:36   Shirley
** EasyPack/SLD Version 0.1b
** 
**    Rev 1.1   15 Sep 1995 09:48:18   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:54:34   Shirley
** Initial revision.
**
****************************************************************************/

/****************************************************************************
**
**  Name:  LDRUBROF.C
**
**  Description:
**      Entry points for UBROF 8051 Loader.
**
**  Status:  CODED
**
**    Rev 1.0   1 Sept. 1995 8:30:00am   Gates Hua
** Initial revision.
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "stdafx.h"
#include <ctype.h>
#include <io.h>
#include <sys\timeb.h>
#include <time.h>
#include <fcntl.h>
#include <sys\stat.h>

#include "srccom.h"
#include "symblsvr.h"
#include "abibase.h"
#include "abitype.h"
#include "abiextfn.h"
#include "ldr.h"           
#include "ldrubrof.h"
#include "uicom.h"
#include "errcodec.h"
#include "srccom.h"

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
struct attrCC {
    unsigned int num ;
    unsigned long attr ;
    unsigned int type ;
    struct attrCC *next;
    
public :
    attrCC() {
        num = 0;
        attr = 0;
        type = 0;
        next = 0;
    }
};

typedef struct {
    SEGMENTTYPE type;
    U32 addr;
} ORG_ADDRESS;

typedef struct {
    ORG_ADDRESS start;
    ORG_ADDRESS end;
    int flag;
} STATE_ADDR;

STATE_ADDR stat_addr ;
U32 start , end;
ORG_ADDRESS curAddr;
U8 LineNumInfo[16] , SymDefInfo[51] , OldKey;
struct BlockBlock far *curBlock ;
struct StoreExtendVar *varExtHdrPtr = 0 , *varExtPtr = 0;
struct attrCC *attrExtHdrPtr = 0 , *attrExtPtr = 0;

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
extern SYM_DESCRIPTOR curModDesc;
extern U32 uLoadBytes;

extern int dw_byte;
extern ADDR g_nextAddr;
extern unsigned char *g_ptrCode;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
void UbrofSegIdToEnum(U8 ui , SEGMENTTYPE* type);
void UbrofTypeConv(U16& ui);                            
void InitVarExtendLink( void );
void MatchFuncType( char *str , TYPE_INDEX& typeIndex );
//for UBROF bank switching
struct FillAddr{
  ADDR start;
  U8   num;
  FillAddr * next;
 public: FillAddr()
 {
   next=0;
 };
};     

struct FillAddr * uCurFill, * uFillHdr=NULL;

static char szPath[_MAX_PATH];
static CString strPath;
static BOOL bListValid = FALSE;
static int nListLastLineNum = FALSE;
static U32 nCurOrg = 0;
static U32 nCurPos = 0;
static CString strSegmentName;
static BOOL bNameValid = FALSE;
static BOOL bOrgValid = FALSE;
static BOOL bMapFileOpened = FALSE;
static CStdioFile mapfile;
static BOOL bOrgStatus = FALSE;
                                                       
                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
//Added by Dragon                        
extern STATUS AbiGetMemN(ADDR addr1, ADDR addr2,char* pchBuff);
extern STATUS AbiFill(ADDR addr1, ADDR addr2,char* pchBuff,UINT uPatternLen);
extern RETCODE SymAddLoadStartAgain();

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadProcess - Ubrof Loader main process routine                 *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadProcess(void)
{       
    int err;       
    U8 key;

    if (m_lpModuleName) {
/* load module only */
/* Get the module descriptor from moduleName and moduleReference */
        err = LdrUbrofLoadModuleOnly() ;
    }
    else {
        m_startaddress = 0;                                                   
/* load UBROF file all information */
                              
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( (err = LdrUbrofLoadStarter()) == -1 ) {
            return( -1 );
        }
        if ( (err = LdrUbrofLoadTypes()) == -1 ) {
            return( -1 );
        }
         
        if ( (err = GetOneByte(&key)) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }
        while (key != t_ubrof_eof) {
            switch ( key ) {
            case t_beg_lib :
            case t_beg_pgm :
                err = LdrUbrofGetModule( key , FALSE );
                if (err == -1){
                    DelAddrList();
                    return(err);  
                }
                break;
            default :
#ifdef _DUMP_
                Message("\r\n???Unknown record at file %lx",GetFileCurPos()-1);
#endif
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                DelAddrList();
                return(-1);
                break;
            }
            if ( (err = GetOneByte(&key)) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                DelAddrList();
                return(-1);
            }
        }   
    } 
    
    // for bank switching  added by dragon
    if(!LOAD_CODE(m_ldrFlags)||!m_IsBankSwitchOn){
       DelAddrList();
       return (err);
    }
    else if(!FillCodeToBankMem()){
       return -1;
    }
    else{
       return err;
    } 
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModuleOnly - Ubrof Loader a module only                     *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModuleOnly(void)
{
    int err;                                                       
    char *lpStr;                           
    char *lpModule;                    
    U32 moduleOffset , ul;    
    U8 key;
    RETCODE retCode ;
    
    err = lstrlen(m_lpModuleName);
    lpModule = new char[err+1];
    ASSERT( lpModule );
    if ( lpModule == 0 ) {
        m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
        return(-1);
    }
        
    lstrcpy(lpModule , m_lpModuleName);
//    lpStr = strstr("." , lpModule);
    lpStr = strstr(lpModule , ".");
    if (lpStr) *lpStr = '\0';        

    retCode = SymAddLoadStart(
            m_lpFileName,
            TRUE,
            &m_time );
    if ( retCode != GOOD ) {
        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
        return( FAILURE );
    }
    err = (U16) SymAddModuleOpenByDesc( curModDesc , &moduleOffset , &ul );
    if ( err != GOOD ) {
        m_dwErrorNum = ER_LDR_LOAD_MODULE;  // 0x4021;
        return(-1);
    }
    if ( m_onDemand == FALSE ) {
        m_dwErrorNum = ER_LDR_MOD_INFO_LOADED;  // 0x4022;
        return 0;
    }
    if ( SeekLoadFile( moduleOffset , 0 )   != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    if ( (err = GetOneByte(&key)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }      
    err = LdrUbrofGetModule( key , TRUE );
    return(err);               
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModuleByDesc - Load a module local information for OnDemand *
*                   load Only loader block,symbol and linenum information  *
*  parameter :                                                             *
*       offset  --  this module in load file position .                    *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModuleByDesc( U32 offset ) 
{                    
    int err;                                                       
    U8 key;
    int nOldFlags;
    
    nOldFlags = m_ldrFlags;
    m_ldrFlags = 0x1;
    if ( SeekLoadFile( offset , 0 ) != 0 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    if ( (err = GetOneByte(&key)) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }      
    err = LdrUbrofGetModule( key , TRUE );
    m_ldrFlags = nOldFlags;
    return(err);               
}
                        
/***************************************************************************
*                                                                          *
*  LdrUbrofLoadModule - Load a module information by ldrFlags and onDemand *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadModule(void)
{           
    return 0;
}
                                            
/***************************************************************************
*                                                                          *
*  LdrUbrofLoadStarter - Load UBROF start section                          *
*  parameter :                                                             *
*       None (Information all in class LoaderServer)                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadStarter(void)
{       
    U8 ch;           
    U8 data[7];     
    RETCODE retCode;
    
    if ( GetOneByte(&ch) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(FAILURE);                        
    }
    switch ( ch ) {
    case t_beg_file :
        if ( GetBytes(data , 3) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F; 
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }
        m_time.day = data[0];
        m_time.month = data[1];                
        m_time.year = 1900 ;
        m_time.year +=  ( (U16) data[2] ) ; 
        m_time.hour = -1;
        break;
    case t_beg_file1 :
        if ( GetBytes(data , 6) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(FAILURE);
        }      
        m_time.second = data[0];
        m_time.minute = data[1];
        m_time.hour = data[2];
        m_time.day = data[3];
        m_time.month = data[4];                
        m_time.year = 1900 ;
        m_time.year +=  ( (U16) data[5] ) ; 
        m_time.hour = -1;
        break;
    default :
#ifdef _DUMP_
        Message("\r\n???Unknown record in STARTER at file %lx",
                GetFileCurPos()-1);
#endif
        m_dwErrorNum = ER_LDR_FILE_FORMAT;  // 0x4014;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(FAILURE);
        break;
    }   
    if( LOAD_SYM( m_ldrFlags )&&m_bAppSym&&m_bLoadInit){
            retCode = SymAddLoadStartAgain();
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
        }

    if (LOAD_SYM(m_ldrFlags)&&(!m_bAppSym||!m_bLoadInit)){ //for load n time
        CString filename;
        
        filename = m_lpFileName;
        retCode = SymAddLoadStart(
                        filename.GetBuffer(filename.GetLength()) ,
                        FALSE,
                        &m_time );
        if ( retCode != GOOD ) {
            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
            return( FAILURE );
        }
    }
                        
    return(GOOD);       
}

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadTypes - Load UBROF types record information                 *
*  parameter :                                                             *
*       None (Information add in symbol server)                            *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
//int LoaderServer::LdrUbrofLoadTypes(void)

/***************************************************************************
*                                                                          *
*  LdrUbrofLoadTypes - Load UBROF types record information                 *
*  parameter :                                                             *
*       nFlag   --   for attr type . generate link                         *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*  Notes : This first time call this function nFlag must be 0              *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofLoadTypes(int nFlag)
{                                           
    TYPE_HEADER_TYPE typeHdrInfo;
    int i , k , err;
    U8 ch , j;           
    U8 data[LDR_BUFSIZE];
    int flag , symFlag;           
    U16 ui , uj;
    U32 ul;              
    char *nullPtr = "\0";
    RETCODE retCode;
                    
    typeHdrInfo.typeChoice = (TYPE_CLASS) COMPLEX_TYPE_CLASS;
    
    flag = 1;
    m_absflag = 0;    
    symFlag = LOAD_SYM(m_ldrFlags);
    if ( nFlag ) symFlag = 0;      
    else {  
        long nCurPos = GetFileCurPos(); 
        if ( 0 == LdrUbrofLoadTypes(1) ) {
            if ( -1 == SeekLoadFile( nCurPos , 0 ) ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = nCurPos;
                return(-1);                        
            }
        }   
        else return -1;
    }

    while ( flag ) {
        typeHdrInfo.typeName = nullPtr;                    
        typeHdrInfo.sizeInMAUs = 0;      
        typeHdrInfo.sizeCalculated = FALSE;

        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
        
        switch ( ch ) {
        case t_end :
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }     
            flag = 0;
            break;
        case t_type : /* 0x4A */
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            ui = BinToU16(data) + 156;

            j = data[2];
            switch( j ) {
            case t_type_pointer : /* 0x0F */ 
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = 0x03L;
                    typeHdrInfo.t.complexType = TY_SMALL_PTR;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypePointerTypeIndex(ui , uj);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_array : /* 0x10 */
                if ( GetBytes(data , 8) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );

                ul = BinToU32(&data[2]);
                if ( symFlag ) {
                    TYPE_C_ARRAY_STRUCT arr;

                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_C_ARRAY;
                    arr.typeIndex = uj;
                    uj = BinToU16(&data[6]);
//  Gates Hua , 7/04/95 Array Type Size is 0 , HighBound is 0 .
//                    if ( uj == 0 ) {     
//                      m_dwErrorNum = 0x4023;
//                       return(-1);
//                    }
                    arr.highBound = uj - 1;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypeCArray(ui , &arr);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_struct : /* 0x11 */
                typeHdrInfo.typeName = (LPSTR) GetName();
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                ul = BinToU32(data);
                uj = BinToU16(&data[4]);
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_STRUCT;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                         delete typeHdrInfo.typeName; 
                         typeHdrInfo.typeName=0;
                         m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025;
                        return( FAILURE );
                    }
                }                   
                for( i=0 ; ((unsigned int)i )<uj ; i++) {
                    TYPE_S_U_STRUCT s;
                    U16 uu;
                    
                    if ( GetBytes(data , 4) == -1 ) { 
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    ul = BinToU32(data);
                    s.offset = (U16) ul;
                    s.name = (LPSTR) GetName();
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    uu = BinToU16(data);
                    UbrofMatchAttrType( uu );
                    UbrofTypeConv( uu );
                    s.typeIndex = uu;
                    
                    if ( symFlag ) {
                        retCode = SymAddTypeStructUnion(ui , &s);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( s.name ) {
                        delete s.name ;
                        s.name = 0;
                    }
                }
                if(typeHdrInfo.typeName){ 
                   delete typeHdrInfo.typeName;
                   typeHdrInfo.typeName=0;
                }
                break;
            case t_type_union : /* 0x12 */              
                typeHdrInfo.typeName = (LPSTR) GetName();
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                ul = BinToU32(data);
                uj = BinToU16(&data[4]);
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    typeHdrInfo.sizeInMAUs = ul;
                    typeHdrInfo.t.complexType = TY_UNION;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        delete typeHdrInfo.typeName;
                        typeHdrInfo.typeName=0;
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }                   
                for( i=0 ; ((unsigned int)i)<uj ; i++) {
                    TYPE_S_U_STRUCT s;           
                    U16 uu;
                    
                    s.name = (LPSTR) GetName();
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    uu = BinToU16(data);
                    UbrofMatchAttrType( uu );
                    UbrofTypeConv( uu );
                    s.typeIndex = uu;
                    s.offset = 0;
                    
                    if ( symFlag ) {
                        retCode = SymAddTypeStructUnion(ui , &s);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                    if ( s.name ) {
                        delete s.name ;
                        s.name = 0;
                    }
                }
                if(typeHdrInfo.typeName){
                   delete typeHdrInfo.typeName;
                   typeHdrInfo.typeName=0;
                }
                break;
            case t_type_bits : /* 0x13 */
                if ( GetBytes(data , 4) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                uj = BinToU16(&data[2]);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    TYPE_BITFIELD_STRUCT bit;
                    
                    typeHdrInfo.sizeCalculated = FALSE;
                    typeHdrInfo.t.complexType = TY_BITFIELD;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    bit.bitfieldSigned = 1;
                    bit.size = data[0];
                    bit.offset = data[1];
                    bit.baseTypeIndex = uj;
                    retCode = SymAddTypeBitfield(ui , &bit);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            case t_type_func : /* 0x20 */
            case t_type_func1 : /* 0x23 */
                if ( symFlag ) {
                    U8 frameType, argCount;
                    U32 attr;
                                  
                    attr = 0xFFFFFFFF;                                
                    typeHdrInfo.t.complexType = TY_FUNC_DEP;
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    if ( GetBytes(data , 3) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    }
                    uj = BinToU16(data);
                    UbrofMatchAttrType( uj );
                    UbrofTypeConv( uj );
                    frameType = data[2];
                    if ( j == t_type_func ) {
                        if ( GetOneByte(data) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        argCount = data[0];
                    }
                    else {
                        if ( GetBytes(data , 5) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        argCount = data[4];
                        attr = BinToU32(data);
                    }
                    retCode = SymAddTypeFunc(ui,attr,frameType,0L,uj,argCount,0,"");
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    for (i=0 ; i < argCount ; i++) {
                        if ( GetBytes(data , 2) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        }
                        uj = BinToU16(data);
                        UbrofMatchAttrType( uj );
                        UbrofTypeConv( uj );
                        retCode = SymAddTypeFuncParam(ui,uj);
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }                       
                }
                else {
                    if ( j == t_type_func ) {
                        if ( GetBytes(data , 4) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        } 
                        uj = data[3];
                    }
                    else {
                        if ( GetBytes(data , 8) == -1 ) {
                            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                            m_bDispOff = 1;
                            m_dwOffset = GetFileCurPos();
                            return(-1);
                        } 
                        uj = data[7];
                    }
                    if ( GetBytes(data , 2*uj) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);
                    } 
                }
                break;
            case t_type_attr : /* 0x15 */
                if ( GetBytes(data , 3) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
//                if ( symFlag ) {
                if ( nFlag || ( !nFlag && symFlag ) ) {
                    if ( attrExtHdrPtr ) {
                        attrExtPtr->next = new attrCC;
                        if ( attrExtPtr->next == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr = attrExtPtr->next;
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = ( unsigned long ) data[0];
                        uj = BinToU16(&data[1]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                    else {
                        attrExtHdrPtr = attrExtPtr = new attrCC;
                        if ( attrExtPtr == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = ( unsigned long ) data[0];
                        uj = BinToU16(&data[1]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                }
                break;
            case t_type_attr1 : /* 0x24 */
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
//                if ( symFlag ) {
                if ( nFlag || ( !nFlag && symFlag ) ) {
                    if ( attrExtHdrPtr ) {
                        attrExtPtr->next = new attrCC;
                        if ( attrExtPtr->next == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr = attrExtPtr->next;
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = BinToU32( data );
                        uj = BinToU16(&data[4]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                    else {
                        attrExtHdrPtr = attrExtPtr = new attrCC;
                        if ( attrExtPtr == 0 ) {
                            m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                            return( FAILURE );
                        }
                        attrExtPtr->num = ui - 156;
                        attrExtPtr->attr = BinToU32( data );
                        uj = BinToU16(&data[4]);
                        UbrofMatchAttrType( uj );
                        attrExtPtr->type = uj;
                    }
                }
                break;
            case t_type_dptr0 : /* 0x17 */
            case t_type_dptr1 : /* 0x18 */
            case t_type_dptr2 : /* 0x19 */
            case t_type_dptr3 : /* 0x1A */
            case t_type_dptr4 : /* 0x1B */
            case t_type_dptr5 : /* 0x1C */
            case t_type_dptr6 : /* 0x1D */
            case t_type_dptr7 : /* 0x1E */
            case t_type_cptr0 : /* 0x1F */
            case t_type_cptr1 : /* 0x20 */
            case t_type_cptr2 : /* 0x21 */
            case t_type_cptr3 : /* 0x22 */
                k = j - t_type_dptr0 ;
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);
                }
                uj = BinToU16(data);
                UbrofMatchAttrType( uj );
                UbrofTypeConv( uj );
                if ( symFlag ) {
                    typeHdrInfo.sizeCalculated = TRUE;
                    if ( j <= t_type_dptr7 ) {
                        typeHdrInfo.sizeInMAUs = j - t_type_dptr0;
                        if ( typeHdrInfo.sizeInMAUs <= 0 ) typeHdrInfo.sizeInMAUs = 1;
                        else if ( typeHdrInfo.sizeInMAUs >= 3 ) typeHdrInfo.sizeInMAUs = 3;
                    }
                    else {
                        typeHdrInfo.sizeInMAUs = j - t_type_cptr0;
                        if ( typeHdrInfo.sizeInMAUs <= 0 ) typeHdrInfo.sizeInMAUs = 1;
                        else if ( typeHdrInfo.sizeInMAUs >= 3 ) typeHdrInfo.sizeInMAUs = 3;
                    }
//                    typeHdrInfo.sizeInMAUs = 0x02L;
                    typeHdrInfo.t.complexType = TY_SMALL_PTR;// typeHdrInfo.t.complexType = (COMPLEX_TYPE) (TY_DPTR0 + k);
                    retCode = SymAddTypeHeader(ui , &typeHdrInfo);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                    retCode = SymAddTypePointerTypeIndex(ui , uj);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                break;
            default :
#ifdef _DUMP_
                Message("\r\n???Unknown type record at file %lx",GetFileCurPos()-4);
#endif
                m_dwErrorNum = ER_LDR_TYPE;     // 0x4016;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return (-1);            
            }
            break;
        case t_size_type : /* 0x4F */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            if ( symFlag ) {
                uj = data[0];
                UbrofTypeConv( uj );
                retCode = SymAddTypeOverwriteSize( (U8) uj , data[1] );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }
            break;
        default :
#ifdef _DUMP_
            Message("\r\n???Unknown type record at file %lx",GetFileCurPos()-1);
#endif
            m_dwErrorNum = ER_LDR_TYPE;     // 0x4016;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
        }
    }
    return(0);
}

/***************************************************************************
*                                                                          *
*  LdrUbrofGetModule - Load UBROF one module information                   *
*  parameter :                                                             *
*       keyword  --  module first record keyword                           *
*       onDemandFlag -- on demand load flag                                *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::LdrUbrofGetModule(U8 keyword , BOOL onDemandFlag) 
{
    SYM_DESCRIPTOR moduleDesc;
    int flag , symFlag , codeFlag ;
    int i , err;
    U8 ch , j;           
    U8 data[LDR_BUFSIZE];
    U16 ui , uj;
    U32 ul; 
    char *tmpFileName;           
    RETCODE retCode;
                  
    ClearUpModuleBlock();
    curBlock = 0;
    symFlag = LOAD_SYM(m_ldrFlags);
    codeFlag = LOAD_CODE(m_ldrFlags);
    start = DEFAULT_START_ADDR;
    end = DEFAULT_END_ADDR;
    flag = 1;       
    ModuleNodeInit();
    
    ch = keyword;   
    m_modNode.offset = m_uBufInFilePos + m_uBufPos - 1 ;
    if ( GetBytes(data , 3) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);                        
    }                            
    m_version = data[0];
//    m_absflag = data[2] & 0x01;
    m_absflag = data[1] & 0x01;
    
   // get whether is banked or not //added by dragon
    if(m_version==4||m_version==5){
       data[2] = U8(data[2]>>2);
       if(int(data[2]&1)&&!m_IsBankSwitchOn){
          m_IsBankSwitchOn = 1;
       }
    } 
    else if(m_version==3){
       data[2] = U8(data[2]&0x0f);
       if(data[2]==2&&!m_IsBankSwitchOn){
          m_IsBankSwitchOn = 1;
       }
    }   
       
    if ( GetBytes(data , 3) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x400F;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);
    }
    m_modNode.time.day = data[0];
    m_modNode.time.month = data[1];                
    m_modNode.time.year = 1900 ;
    m_modNode.time.year +=  ( (U16) data[2] ) ; 
    m_modNode.time.hour = -1;
    if(m_modNode.name) delete m_modNode.name;
    m_modNode.name = (LPSTR) GetName();
    stat_addr.flag = 0;           

    symFlag = LOAD_SYM(m_ldrFlags);
    codeFlag = LOAD_CODE(m_ldrFlags);

    if ( m_modNode.name ) {
        // Added by Dragon
        if ( m_modNode.name[0] == '?' && !m_bSpecSymbol ) symFlag = 0;
    }
    
    curAddr.type = SEG_CODE;
    curAddr.addr = 0;        
    //for load n time  added bu dragon 2/25/1997
    if(IsModuleExist(m_modNode.name)){
       symFlag = 0;
    }
    
    if ( symFlag ) {   
        if ( onDemandFlag == TRUE ) {
            moduleDesc = curModDesc;
        }
        else {
            retCode = SymAddModuleCreate(
                m_modNode.name ,
                &m_modNode.time ,
                &m_modNode.codeaddr ,
                m_modNode.offset ,
                (BOOLEAN) m_onDemand ,
                0,
                &moduleDesc );
            if ( retCode != GOOD ) {
                m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                return( FAILURE );
            }
            curModDesc = moduleDesc;
        }
    }

    if ( GetOneByte(&ch) == -1 ) {
        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
        m_bDispOff = 1;
        m_dwOffset = GetFileCurPos();
        return(-1);                        
    }                            
    
    while ( flag ) {
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
            m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
            return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }
        switch( ch ) {
        case t_end : /* 0x3F */
        case t_end_abs : /* 0x3D */
            if ( ch == t_end_abs ) {
                if ( GetBytes(data , 6) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                            
                ui = BinToU16(data);
                ul = BinToU32(&data[2]);
                m_nStartBank = BYTE(ul>>16);
                m_startaddress = ul;
#ifdef _DUMP_
                Message("   Starting Address: %lx",m_startaddress);
#endif
            }
            if ( m_modNode.scope != 0 ) {
                m_dwErrorNum = ER_LDR_MODULE_FORMAT;    // 0x401A;
                return (-1);
            }
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            flag = 0;            

            if ( stat_addr.flag == 1 ) {  
                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                //to speified bank
                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                   if ( addrState.startAddr != DEFAULT_START_ADDR &&
                        addrState.endAddr != DEFAULT_END_ADDR ) {
                        ConvertAddrToBank(addrState.startAddr);
                        ConvertAddrToBank(addrState.endAddr);
                   }
                }
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }         

// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }                
            
// Added By Gates Hua , for optimize download code speed            
            if ( codeFlag ) {
                err = DownloadCode();
                if(err==-1){
                    DelAddrList();
                    m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
                    return(-1);
                }
            }

            if ( symFlag ) {   
                QUAL_ADDR_RANGE_TYPE qaddr;
                m_modNode.codeaddr.segType = (SEGMENTTYPE) SEG_CODE;
                m_modNode.codeaddr.startAddr = start;
                m_modNode.codeaddr.endAddr = end;
                qaddr.startAddr = start;
                qaddr.endAddr = end;
                qaddr.startValid = TRUE;
                qaddr.endValid = TRUE;                      
                if ( start > end ) {
                    qaddr.startValid = FALSE;
                    qaddr.endValid = FALSE;
                }
                    
                if ( m_modNode.linecnt > 0 ) {
                    retCode = SymAddLinenumEnd();
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }                              
                else if ( start != DEFAULT_START_ADDR && end != DEFAULT_END_ADDR && 
                    (symFlag && (onDemandFlag || !m_onDemand)) ) {
                    LdrUbrofGetLstFileInfo(moduleDesc);
                    if ( m_modNode.linecnt > 0 ) {
                        retCode = SymAddLinenumEnd();
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }                              
                } 
                
                ClearUpModuleBlock();
                if ( onDemandFlag == FALSE ) {
                    retCode = SymAddModuleClose( 
                        (BOOLEAN) (!m_onDemand) );
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
                        return( FAILURE );
                    }
                }
                else {
                    retCode = SymAddModuleClose( TRUE );
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025 ;
                        return( FAILURE );
                    }
                }            
                if ( qaddr.startValid || qaddr.endValid ) {
                    if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                       if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                           qaddr.endAddr != DEFAULT_END_ADDR ) {
                           ConvertAddrToBank(qaddr.startAddr);
                           ConvertAddrToBank(qaddr.endAddr);
                       }
                    }
                       
                    retCode = SymAddSymbolSetAddr( &qaddr );
                    if ( retCode != GOOD ) {
                         m_dwErrorNum = ER_LDR_SYM_SERVER;  // 0x4025 ;
                         return( FAILURE );
                    }
                }
            }              
            return 0;
        case t_debug : /* 0x52 */
            if ( GetOneByte(data) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            break;
        case t_aux : /* 0x53 */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            } 
            break;
        case t_aux_1 : /* 0x54 */
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            break;
        case t_file : /* 0x46 */
            m_modNode.tfileoffset = m_uBufInFilePos + m_uBufPos - 1;
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            ui = BinToU16(data);
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            for( i=0;((unsigned int)i)<ui;i++ ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                            
                uj = BinToU16( data );
                if ( GetBytes(data , uj) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                            
            }
            if ( symFlag && !onDemandFlag) {    
                retCode = SymAddModuleSourceFilePosition( moduleDesc ,
                                    m_modNode.tfileoffset );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }
            break;
        // next case added by Jamoon 4/18/96
        case t_file_ref     : // 0xB9   
            if ( GetBytes(data, 5) == FAILURE ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }
            ui = BinToU16(data+3);                            
            if ( GetBytes(data, ui+6) == FAILURE ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }
            break;
        case t_symbol_def : /* 0x4C */
        case t_symbol_def1 : /* 0xA6 */
            if ( GetBytes(data , 7) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            tmpFileName = (LPSTR) GetName();
            
            //for bank switching
            GetBankCallRetAddr(data, tmpFileName);
                //for load n time
            if(m_bLoadToBank&&m_IsBankSwitchOn){
               m_dwErrorNum = ER_LDR_FILE_BANK;
               return -1;
             }

            if ( strlen(tmpFileName) > 40 ) tmpFileName[40] = '\0';
            lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
            if ( tmpFileName ) delete tmpFileName;
            tmpFileName = 0;
            memcpy( (LPSTR) SymDefInfo , (LPSTR) data , 7);
            if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }
            if ( ch == t_symbol_def1 ) {
                if ( GetBytes(data , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                     
                ui = BinToU16(data);       
                if ( GetBytes(data , ui*13) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }       
                SymDefInfo[7] = 1;                     
            }                   
            else SymDefInfo[7] = 0;     
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( symFlag && !onDemandFlag) {    
                j = SymDefInfo[0];
//              if ( j==2 || j==4 || j==9 ) {
                if ( j==2 || j==4 ) {
                    m_modNode.symno++;
                    if ( UbrofProcessModSym() != GOOD )
                        return( FAILURE );
                }
            }                   
            break;
        case t_macro : /* 4E */
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            uj = BinToU16(data);
            if ( GetBytes(data , uj) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            break;
        case t_func_begin : /* 0x50 */
        case t_func_begin1 : /* 0xA7 */     
            if ( m_modNode.scope != 0 ) {
                m_dwErrorNum = ER_LDR_SCOPE;    // 0x4019;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            m_modNode.scope++;
            if ( symFlag && (onDemandFlag || !m_onDemand) ) {
                curBlock = new BlockBlock;
                
                if ( curBlock == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return(FAILURE);
                }
                curBlock->scope = m_modNode.scope;
                curBlock->codeaddr.segType=(SEGMENTTYPE)SEG_CODE;
                curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;
            }
            tmpFileName = (LPSTR) GetName();
            if ( GetBytes(data , 10) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                curBlock->funcName = tmpFileName;
                tmpFileName = 0;
                curBlock->srcRange.lineNumStart = BinToU16(data);
                curBlock->srcRange.columnStart = BinToU16(&data[2]);
                curBlock->srcRange.lineNumEnd = BinToU16(&data[4]);
                curBlock->srcRange.columnEnd = BinToU16(&data[6]);

                FUNC_CLASS funcClass;
                if ( curBlock->scope != 1 ) funcClass = FUNC_LOCAL ;
                else funcClass = FUNC_GLOBAL;
                UbrofMatchFuncType( curBlock->funcName , curBlock->typeIndex );
                retCode = SymAddFuncCreate(     
                                    curBlock->funcName ,
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    curBlock->typeIndex );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }
            ui = BinToU16(&data[8]);
            for( i = 0; ((unsigned int)i) < ui; i++ ) {
                if ( GetBytes(SymDefInfo , 7) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                            
                tmpFileName = (LPSTR) GetName();
                if ( strlen(tmpFileName) > 40 ) tmpFileName[40] = '\0';
                lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
                if ( tmpFileName ) delete tmpFileName;
                tmpFileName = 0;
                if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }
                if ( ch == t_func_begin1 ) {
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }
                    uj = BinToU16(data);
                    if ( GetBytes(data , uj*13) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }
                }
                if ( symFlag && (!m_onDemand || onDemandFlag) ) {    
                    j = SymDefInfo[0];
//                  if ( j==7 || j==4 || j==8 || j==9 ) {
                    if ( j==7 || j==4 || j==8 ) {
                        curBlock->localsymno++;
                        if ( GOOD != UbrofProcessBlockSym() )
                            return( FAILURE );
                    }
                }                   
            }
            break;
        case t_block_begin : /* 0x48 */
        case t_block_begin1 : /* 0xA8 */
            if ( m_modNode.scope < 1 ) { 
                m_dwErrorNum = ER_LDR_SCOPE;    // 0x4019;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);
            }
            else if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                curBlock->son = new BlockBlock;
                ASSERT( curBlock->son );                        
                if ( curBlock->son == 0 ) {
                    m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                    return (FAILURE);
                }
                curBlock->son->father = curBlock ;
                curBlock = curBlock->son;

                m_modNode.scope++;
                curBlock->scope = m_modNode.scope;
                curBlock->codeaddr.segType = (SEGMENTTYPE) SEG_CODE;
                curBlock->codeaddr.startAddr = DEFAULT_START_ADDR ;
                curBlock->codeaddr.endAddr = DEFAULT_END_ADDR ;

                FUNC_CLASS funcClass;
                if ( curBlock->scope != 1 ) funcClass = FUNC_LOCAL ;
                else funcClass = FUNC_GLOBAL;
                retCode = SymAddFuncCreate(     
                                    "",
                                    funcClass ,
                                    curBlock->stacksize ,
                                    &curBlock->codeaddr ,
                                    curBlock->typeIndex );
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }
            }               
            else m_modNode.scope++;
            if ( GetBytes(data , 2) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            ui = BinToU16(data);
            for(i=0;((unsigned int)i)<ui;i++) {
                if ( GetBytes(SymDefInfo , 7) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }                            
                tmpFileName = (LPSTR) GetName();
                if ( strlen(tmpFileName) > 40 ) tmpFileName[40] = '\0';
                lstrcpy( (LPSTR) &SymDefInfo[10] , (LPSTR) tmpFileName);
                if ( tmpFileName ) delete tmpFileName;
                tmpFileName = 0;
                if ( GetBytes(&SymDefInfo[8] , 2) == -1 ) {
                    m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                    m_bDispOff = 1;
                    m_dwOffset = GetFileCurPos();
                    return(-1);                        
                }
                if ( ch == t_block_begin1 ) {
                    if ( GetBytes(data , 2) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }
                    uj = BinToU16(data);
                    if ( GetBytes(data , uj*13) == -1 ) {
                        m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                        m_bDispOff = 1;
                        m_dwOffset = GetFileCurPos();
                        return(-1);                        
                    }
                }
                if ( symFlag && (!m_onDemand || onDemandFlag) ) {    
                    j = SymDefInfo[0];
//                  if ( j==7 || j==4 || j==8 || j==9 ) {
                    if ( j==7 || j==4 || j==8 ) {
                        curBlock->localsymno++;
                        if ( GOOD != UbrofProcessBlockSym() )
                            return( FAILURE );
                    }
                }                   
            }
            break;
        case t_src_stat : /* 0x47 */
            if ( stat_addr.flag == 1 ) {
                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                //to specified bank
                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                    if ( addrState.startAddr != DEFAULT_START_ADDR &&
                        addrState.endAddr != DEFAULT_END_ADDR ) {
                        ConvertAddrToBank(addrState.startAddr);
                        ConvertAddrToBank(addrState.endAddr);
                    }
                }
                   
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }                           
// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }
            if ( GetBytes(data , 9) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                memcpy((LPSTR) LineNumInfo , (LPSTR) data , 8);
                stat_addr.flag = 1;
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
            }
            break;
        // next case added by Jamoon 4/18/96
        case t_new_file     :   // 0xBA
            if ( GetBytes(data , 3) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            break;
        case t_block_end : /* 0x49 */
            if ( m_modNode.scope == 0 ) {
                m_dwErrorNum = ER_LDR_SCOPE;    // 0x4019;
                m_bDispOff = 1;
                return(-1);
            }
            if ( stat_addr.flag == 1 ) {  

                if ( m_modNode.linecnt == 0 ) {
                    retCode = SymAddLinenumStart(moduleDesc);
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=BinToU16(LineNumInfo);
                srcState.columnStart=BinToU16(&LineNumInfo[2]);
                srcState.lineNumEnd=BinToU16(&LineNumInfo[4]);
                srcState.columnEnd=BinToU16(&LineNumInfo[6]);
                addrState.startAddr=stat_addr.start.addr;
                addrState.endAddr=stat_addr.end.addr;
                //to specified bank
                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                    if ( addrState.startAddr != DEFAULT_START_ADDR &&
                        addrState.endAddr != DEFAULT_END_ADDR ) {
                        ConvertAddrToBank(addrState.startAddr);
                        ConvertAddrToBank(addrState.endAddr);
                    }
                }
                addrState.segType=SEG_CODE;
                retCode = SymAddSourceState(&srcState , &addrState);
                if ( retCode != GOOD ) {
                    m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                    return( FAILURE );
                }

                m_modNode.linecnt++;
                if ( curBlock ) {
                    if (curBlock->codeaddr.startAddr > 
                        stat_addr.start.addr ) 
                        curBlock->codeaddr.startAddr = 
                        stat_addr.start.addr;
                    if (curBlock->codeaddr.endAddr < 
                        stat_addr.end.addr ) 
                        curBlock->codeaddr.endAddr = 
                        stat_addr.end.addr;
                }                           
// Add by Gates Hua 1/10/96                                  
                if ( start > stat_addr.start.addr ) 
                    start = stat_addr.start.addr;
                if ( end < stat_addr.end.addr ) 
                    end = stat_addr.end.addr;
//                    
                stat_addr.start.addr = DEFAULT_START_ADDR;
                stat_addr.end.addr = DEFAULT_END_ADDR;
                stat_addr.flag = 0;
            }
            if ( symFlag && (!m_onDemand || onDemandFlag) ) {
                if ( curBlock ) {

                    QUAL_ADDR_RANGE_TYPE qaddr;
                    
                    if ( curBlock->father ) {
                        if (curBlock->father->codeaddr.startAddr
                            > curBlock->codeaddr.startAddr) {
                            curBlock->father->codeaddr.startAddr =
                                curBlock->codeaddr.startAddr;
                        }
                        if (curBlock->father->codeaddr.endAddr
                            < curBlock->codeaddr.endAddr) {
                            curBlock->father->codeaddr.endAddr =
                                curBlock->codeaddr.endAddr;
                        }                   
                    }
// Add by Gates Hua , 1/10/96
                    else {
                        if ( start > curBlock->codeaddr.startAddr )
                            start = curBlock->codeaddr.startAddr;
                        if ( end < curBlock->codeaddr.endAddr) {
                            end = curBlock->codeaddr.endAddr;
                        }                   
                    }
                            
                    qaddr.startAddr = curBlock->codeaddr.startAddr;
                    qaddr.endAddr = curBlock->codeaddr.endAddr;
                    qaddr.startValid = TRUE;
                    qaddr.endValid = TRUE;                      
                    if ( qaddr.startAddr > qaddr.endAddr ) {
                        qaddr.startValid = FALSE;
                        qaddr.endValid = FALSE;
                    }
                        
                    retCode = SymAddFuncClose();
                    if ( retCode != GOOD ) {
                        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                        return( FAILURE );
                    }      
                    if ( qaddr.startValid || qaddr.endAddr ) {
                        //to specified bank
                        if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                            if ( qaddr.startAddr != DEFAULT_START_ADDR &&
                                qaddr.endAddr != DEFAULT_END_ADDR ) {
                                ConvertAddrToBank(qaddr.startAddr);
                                ConvertAddrToBank(qaddr.endAddr);
                            }
                        }
                        retCode = SymAddSymbolSetAddr( &qaddr );
                        if ( retCode != GOOD ) {
                            m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
                            return( FAILURE );
                        }
                    }
                        
                    if ( curBlock->father ) {
                        curBlock = curBlock->father;
                        ClearUpBlockBlock(curBlock->son);
                        delete curBlock->son;
                        curBlock->son = 0;
                    }
                    else {
                        ClearUpBlockBlock(curBlock);
                        delete curBlock ;
                        curBlock = 0;
                    }
                }
                else {    
                    m_dwErrorNum = ER_LDR_BLOCK_INFO;       // 0x401C;
                    return(-1);
                }
            }
            m_modNode.scope--;
            break;
        case t_abs_var : /* 0x39 */
            if ( GetOneByte(&j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( GetBytes(data , j) == -1 ) {
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            if ( codeFlag ) {
                ADDR stAddr , endAddr;
                int BankNum;
                
                //for load to x area                    
                if ( LOAD_TODATA( m_ldrFlags ) ){
                    // m_dwErrorNum = ER_LDR_X_AREA;
                     return -1;
                }
/* Modified by Gates Hua , for optimize download code speed                 
                if(curAddr.type == SEG_CODE ||
                   curAddr.type == SEG_UNTYPED ) {
                    
                   //Added by Dragon;for bank-switching
                   BankNum = int(curAddr.addr >> 16);
                   stAddr.addr = (unsigned short) curAddr.addr;
                   
                   if(BankNum){
                      if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                         m_dwErrorNum = ER_LDR_FILE_BANK;
                         return -1;
                      }
                      if(BankNum>=g_nBankNum){
                         m_dwErrorNum = ER_LDR_OUTOF_BANKNUM; 
                         m_bDispOff = 1;
                         m_dwOffset = g_nBankNum;
                         return -1;
                       } 
                      AddBankInfoToArray(BankNum,stAddr.addr);
                    }   
                       
                   endAddr.addr = (unsigned short) (curAddr.addr + j - 1);

                   if(g_nBankNum){
                        stAddr.addrType = endAddr.addrType = U8(BankNum + 6);
                        if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                           stAddr.addrType = endAddr.addrType = U8(m_bLoadToBank);
                        }
                    }
                   else{
                        stAddr.addrType = endAddr.addrType = 1;
                    }
#ifdef _ZLR_        
                   err=AbiFill(stAddr , endAddr , (char *)data , j);
                   
                   if(err==ICE_OK){
                      if(stAddr.addrType==6)
                          AddToAddrList(stAddr,j);
                    }
                   else  {
                      if(stAddr.addrType==6&&m_IsBankSwitchOn)
                          DelAddrList();
                       m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
                       return(-1);
                   }
#endif                  
                   uLoadBytes += (U32)j;
                }                  
                else {
//                    Warning("Download code not in code segment!");
                    Warning( ER_CODE_NOT_IN_CODESEG );
                    return(-1);
                }
*/                         
// Modified by Gates Hua at 9/10/97 , for meeting a record download tp seg_xdata
                if(curAddr.type == SEG_CODE ||
                   curAddr.type == SEG_UNTYPED ) {
                    
                   //Added by Dragon;for bank-switching
                   BankNum = int(curAddr.addr >> 16);
                   stAddr.addr = (unsigned short) curAddr.addr;
                   
                   if(BankNum){
                      if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                         m_dwErrorNum = ER_LDR_FILE_BANK;
                         return -1;
                      }
                      if(BankNum>=g_nBankNum){
                         m_dwErrorNum = ER_LDR_OUTOF_BANKNUM; 
                         m_bDispOff = 1;
                         m_dwOffset = g_nBankNum;
                         return -1;
                       } 
                      AddBankInfoToArray(BankNum,stAddr.addr);
                    }   
                       
                   endAddr.addr = (unsigned short) (curAddr.addr + j - 1);

                   if(g_nBankNum){
                        stAddr.addrType = endAddr.addrType = U8(BankNum + 6);
                        if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                           stAddr.addrType = endAddr.addrType = U8(m_bLoadToBank);
                        }
                    }
                   else{
                        stAddr.addrType = endAddr.addrType = 1;
                    }                                                
                }
                else {
                    switch( curAddr.type ) {
                    case SEG_CODE :
                        stAddr.addrType = endAddr.addrType = 1;
                        break;
                    case SEG_DATA :
                        stAddr.addrType = endAddr.addrType = 3;
                        break;
                    case SEG_XDATA :
                        stAddr.addrType = endAddr.addrType = 2;
                        break;
                    case SEG_BIT :
                        stAddr.addrType = endAddr.addrType = 5;
                        break;
                    case SEG_REGISTER :
                        stAddr.addrType = endAddr.addrType = 4;
                        break;
                    default :
                        stAddr.addrType = endAddr.addrType = 0;
                        break;
                    }   
                    stAddr.addr = (unsigned short) curAddr.addr;
                    endAddr.addr = (unsigned short) (curAddr.addr + j - 1);
                }
                    
               err = 0; 
               if ( dw_byte && ( stAddr.addrType != g_nextAddr.addrType || stAddr.addr != g_nextAddr.addr ) ) {
                   err = DownloadCode();
                   if(err==-1){
                      if(stAddr.addrType==6&&m_IsBankSwitchOn)
                          DelAddrList();
                       m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
                       return(-1);
                   }
               }
                   
              if(stAddr.addrType==6)
                  AddToAddrList(stAddr,j);
                      
               g_nextAddr.addrType = stAddr.addrType;
               g_nextAddr.addr = endAddr.addr+1;
                   
               memcpy( g_ptrCode , data , j );
               g_ptrCode += j;
                   
               dw_byte += j;
                   
               if ( dw_byte >= 255 ) {
                   err = DownloadCode();
                   if(err==-1){
                      if(stAddr.addrType==6&&m_IsBankSwitchOn)
                          DelAddrList();
                       m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;    // 0x4020;
                       return(-1);
                   }
               }

/*                   
                }                  
                else {
//                    Warning("Download code not in code segment!");
                    Warning( ER_CODE_NOT_IN_CODESEG );
                    return(-1);
                }
*/                
            }
            if ( symFlag ) {
//                if ( curAddr.type == SEG_CODE ) {
                if ( curAddr.type == SEG_CODE ||
                    curAddr.type == SEG_UNTYPED ) {
// Modify by Gates Hua , 1\10\96
//                    if ( start > curAddr.addr ) start = curAddr.addr;
//                    if ( end < (curAddr.addr+j-1) ) end = curAddr.addr+j-1;
// Restore by Gates Hua , 9\10\97 for support assemble source level debug from list file
                    if ( start > curAddr.addr ) start = curAddr.addr;
                    if ( end < (curAddr.addr+j-1) ) end = curAddr.addr+j-1;
                    
                    if ( stat_addr.flag ) {
                        U32 address;
                        address = curAddr.addr;
                        if (stat_addr.start.addr>address)
                            stat_addr.start.addr = address; 
                        address += j - 1;
                        if (stat_addr.end.addr<address)
                            stat_addr.end.addr = address;
                    }
                }
// Modified by Gates Hua at 9/10/97 , for meeting a record download tp seg_xdata
/*                
                else {
//                    Warning("Download code not in code segment!");
                    Warning( ER_CODE_NOT_IN_CODESEG );
                    return(-1);
                }
*/                
            }
            curAddr.addr += j;                  
            break;
        case t_org : /* 0x51 */
            if ( GetBytes(data , 5) == -1 ) {  
                m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
                m_bDispOff = 1;
                m_dwOffset = GetFileCurPos();
                return(-1);                        
            }                            
            UbrofSegIdToEnum( data[0] , &curAddr.type );
            curAddr.addr = BinToU32(&data[1]);

            if(curAddr.type == SEG_CODE ||
               curAddr.type == SEG_UNTYPED ) {
                    
               int BankNum = int(curAddr.addr >> 16);
                   
               if(BankNum){
                  if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                     m_dwErrorNum = ER_LDR_FILE_BANK;
                     return -1;
                  }
                  if(BankNum>=g_nBankNum){
                     m_dwErrorNum = ER_LDR_OUTOF_BANKNUM; 
                     m_bDispOff = 1;
                     m_dwOffset = g_nBankNum;
                     return -1;
                   } 
//                  AddBankInfoToArray(BankNum,stAddr.addr);
                }   
            }  
            break;
        default :
#ifdef _DUMP_
            Message("\r\n???Unknown MOD record at file %lx",
                    GetFileCurPos()-1);
#endif
            m_dwErrorNum = ER_LDR_UBROF_FORMAT;     // 0x4024;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);
            break;
        }        
        if ( GetOneByte(&ch) == -1 ) {
            m_dwErrorNum = ER_LDR_READ_FILE;    // 0x4014;
            m_bDispOff = 1;
            m_dwOffset = GetFileCurPos();
            return(-1);                        
        }                            
    }
    
    return 0;
}   

/***************************************************************************
*                                                                          *
*  UbrofProcessModSym - Load UBROF module symbol information               *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::UbrofProcessModSym(void)
{
    U32 address;     
    U16 ui;
    
    VAR_STORAGE_CLASS varStorage;
    VAR_REGISTER_CLASS registerClass;
//    BOOL isConst , isValid ;
    BOOLEAN isConst , isValid ;
    ADD_VAR_ADDR_UNION addr;
    SYM_DESCRIPTOR symDesc;
    
    varStorage = GLOBAL_VAR_CLASS;                     
    registerClass = NOT_REG;
    ui = BinToU16(&SymDefInfo[1]);
    address = BinToU32(&SymDefInfo[3]);
    //to specified bank
    if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
       ConvertAddrToBank(address);
    }
    if ( ui == 6 ) isValid = FALSE ;
    else isValid = TRUE;
    if ( ui == 7 ) isConst = TRUE;
    else isConst = FALSE;
    if ( isValid ) {
        UbrofSegIdToEnum( (U8) ui , &addr.addr.segType );
        addr.addr.addr = address;
    }
    else {
        registerClass = LIVING_REG;
        addr.registerIndex = (U16) address;
    }
    ui = BinToU16(&SymDefInfo[8]);
    UbrofMatchAttrType( ui );
    UbrofTypeConv( ui );                     
    if ( SymDefInfo[10] == '?' && !m_bSpecSymbol ) return GOOD;
                
    if ( GOOD != SymAddVar((LPSTR)&SymDefInfo[10],ui,
        varStorage,registerClass,&addr,isConst,
        isValid,&symDesc) ) {
        if ( varExtHdrPtr ) {
            varExtPtr->next = new StoreExtendVar;
            if ( varExtPtr->next == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                return( FAILURE );
            }
            varExtPtr = varExtPtr->next;
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
        else {          
            varExtHdrPtr = varExtPtr = new StoreExtendVar;
            if ( varExtPtr == 0 ) {
                m_dwErrorNum = ER_LDR_MEMORY_ALLOC;     // 0x4000;
                return( FAILURE );
            }
            memcpy( varExtPtr->SymDefInfo , SymDefInfo , 51 );
        }
    }   
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  UbrofProcessBlockSym - Load UBROF local symbol information              *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
int LoaderServer::UbrofProcessBlockSym(void)
{
    U32 address;     
    U16 ui;
    
    VAR_STORAGE_CLASS varStorage;
    VAR_REGISTER_CLASS registerClass;
//    BOOL isConst , isValid ;
    BOOLEAN isConst , isValid ;
    ADD_VAR_ADDR_UNION addr;
    SYM_DESCRIPTOR symDesc;
    
    registerClass = NOT_REG;
    if ( SymDefInfo[0] == 7 ) varStorage = AUTO_VAR_CLASS ;
    else if ( SymDefInfo[0] == 4 ) varStorage = STATIC_VAR_CLASS ;
    else if ( SymDefInfo[0] == 8 ) {
        varStorage = AUTO_VAR_CLASS ;
        registerClass = LIVING_REG;
    }
    else {
        varStorage = UNKNOWN_VAR_CLASS ;
        return GOOD;
    }
    ui = BinToU16(&SymDefInfo[1]);
    address = BinToU32(&SymDefInfo[3]);
    //to specified bank
    if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
       ConvertAddrToBank(address);
    }
    if ( ui == 6 ) isValid = FALSE ;
    else isValid = TRUE;
    if ( ui == 7 ) isConst = TRUE;
    else isConst = FALSE;
    if ( isValid ) {
        UbrofSegIdToEnum( (U8) ui , &addr.addr.segType );
        addr.addr.addr = address;
    }
    else {
        registerClass = LIVING_REG;
        addr.registerIndex = (U16) address;
    }
    ui = BinToU16(&SymDefInfo[8]);
    UbrofMatchAttrType( ui );
    UbrofTypeConv( ui );
    if ( SymDefInfo[10] == '?' && !m_bSpecSymbol ) return GOOD;
    if ( GOOD != SymAddVar((LPSTR)&SymDefInfo[10],ui,varStorage,
        registerClass,&addr,isConst,isValid,&symDesc) ) {
        m_dwErrorNum = ER_LDR_SYM_SERVER;   // 0x4025;
        return ( FAILURE );
    }
    return GOOD;
}

/***************************************************************************
*                                                                          *
*  UbrofSegIdToEnum - convert ubrof segment ID to symbol server enum       *
*  parameter :                                                             *
*       ui     ---     ubrof segment ID                                    *
*       type   ---     symbol server segment enum                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void UbrofSegIdToEnum(U8 ui , SEGMENTTYPE* type)
{
    switch (ui) {
    case 0:
        *type = SEG_UNTYPED ;
        break;
    case 1:         
        *type = SEG_CODE ;
        break;
    case 2:
    case 4:
        *type = SEG_DATA ;
        break;
    case 3:
        *type = SEG_XDATA ;
        break;
    case 5:
        *type = SEG_BIT ;
        break;
    case 6:
        *type = SEG_REGISTER ;
        break;
    case 7:
        *type = SEG_CONST ;
        break;
    default :
        *type = SEG_UNTYPED ;
        break;
    }
}

/***************************************************************************
*                                                                          *
*  UbrofTypeConv - convert ubrof symbol type to symbol server type         *
*  parameter :                                                             *
*       ui     ---     ubrof type                                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void UbrofTypeConv(U16& ui)
{
    if ( ui >= 0x64 ) {
        ui += 156;
    }
    else {
        switch( ui ) {
        case 0 :
            ui = BI_UNKNOWN;
            break;
        case 1 :
            ui = BI_U8_UCHAR;
            break;
        case 2 :    /* signed char */
            ui = BI_S8_CHAR;            
            break;             
        case 3 :
            ui = BI_S16_USHORT;
            break;
        case 4 :
            ui = BI_S16_SHORT;
            break;
        case 5 :
            ui = BI_U16_UINT;
            break;
        case 6 :             
            ui = BI_S16_SINT;
            break;
        case 8 :
            ui = BI_S32_LONG;
            break;
        case 7 :             
            ui = BI_U32_ULONG;
            break;
        case 9 :
            ui = BI_F32;
            break;
        case 10 :
        case 0x0B :
            ui = BI_F64;
            break;
        case 0x0C :
            ui = BI_VOID;
            break;
        default :
            ui = BI_UNKNOWN;
            break;
        }
    }
}           

/***************************************************************************
*                                                                          *
*  InitVarExtendLink - initialize StoreExtendVar Link                      *
*  parameter :                                                             *
*       None                                                               *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void InitVarExtendLink( void )
{
struct StoreExtendVar *ttt;
struct attrCC *tttt;

    varExtPtr = varExtHdrPtr ;
    while ( varExtPtr ) {
        ttt = varExtPtr->next ;
        delete varExtPtr ;
        varExtPtr = ttt;
    }
    varExtPtr = varExtHdrPtr = 0;

    attrExtPtr = attrExtHdrPtr ;
    while ( attrExtPtr ) {
        tttt = attrExtPtr->next ;
        delete attrExtPtr ;
        attrExtPtr = tttt;
    }
    attrExtPtr = attrExtHdrPtr = 0;
}

/***************************************************************************
*                                                                          *
*  UbrofMatchFuncType - match function type in StoreExtendVar Link         *
*  parameter :                                                             *
*       str  --  function name                                             *
*       typeIndex  --  function type                                       *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void LoaderServer::UbrofMatchFuncType(char *str , TYPE_INDEX& typeIndex)
{
struct StoreExtendVar *ttt;

    ttt = varExtHdrPtr ;
    while ( ttt ) {
        if ( 0 == strcmp( (LPSTR)(&ttt->SymDefInfo[10]) , str ) ) {
            break;
        }
        ttt = ttt->next;
    }
    if ( ttt ) {
        U16 ui ;
        
        ui = BinToU16(&ttt->SymDefInfo[8]);
        UbrofMatchAttrType( ui );
        UbrofTypeConv( ui );
        typeIndex = (U32) ui;
    }
    else typeIndex = 0;
}

/***************************************************************************
*                                                                          *
*  UbrofMatchAttrType - match attribute type in attrCC Link                *
*  parameter :                                                             *
*       uType  --  attribute type                                          *
*  return value :                                                          *
*       0  ---  OK                 -1  ---  failure                        *
*                                                                          *
***************************************************************************/
void LoaderServer::UbrofMatchAttrType(U16& uType)
{
struct attrCC *ttt;

    ttt = attrExtHdrPtr ;
    while ( ttt ) {
        if ( uType == ttt->num ) {
            break;
        }
        ttt = ttt->next;
    }
    if ( ttt ) {
        uType = (U16) ttt->type;                 
        UbrofMatchAttrType(uType);
    }
}              

/***************************************************************************
*  Added by Dragon for Bank-Switching 12/30/1996                           *
*                                                                          *
*  AddBankInfoToList                                                       *                                                               
*                                                                          *
*  no return value :                                                          *
*                                                                          *
***************************************************************************/
            
void LoaderServer::AddBankInfoToArray(int bank, U16 addr)
{
 ASSERT(bank!=0);
  
 int i=0;
 
 if(addr < m_BankStartAddr){
    m_BankStartAddr = addr;
 }

 while(i<3){
   if(bank==m_nBankInfo[i]){
      return;
   }
   else if(m_nBankInfo[i]==0){
      m_nBankInfo[i] = bank;
      return;
    }
   i++;
 }
}
     
/***************************************************************************
*  Added by Dragon for Bank-Switching 12/30/1996                           *
*                                                                          *
*  FillCodeToBankMem -                                                     *                                                               
*                                                                          *
*   return value :                                                          *
*                                                                          *
***************************************************************************/

BOOL LoaderServer::FillCodeToBankMem()
{                        
  int i=0,err,banknum;
  BOOL FillFlag=0;
  BOOL CodeFlag;
  
  CodeFlag = LOAD_CODE(m_ldrFlags);
 
  if(!CodeFlag||!m_IsBankSwitchOn){
     return 1;
  }

  while(i<3){
     if(m_nBankInfo[i] !=0){ 
        FillFlag = 1;
        break;
     }
     i++;
  }
  if(!FillFlag) return 1;
  if(g_nBankNum==4) banknum=4;
  else if(g_nBankNum==2) banknum=2;
  
  ADDR start, end, DestAddr;
 
  start.addr = 0;
  start.addrType = 6;
  end.addr = m_BankStartAddr-1;
  end.addrType = 6;
  
  DestAddr.addr = 0;
                             
  uCurFill = uFillHdr;
  
  while(uCurFill){
        if ( (err = TestKey(VK_ESCAPE)) == 1 ) {
              m_dwErrorNum = ER_LDR_ABORT;  // 0x4010;
              return( -1 );
        } 
        if ( (m_window == LOAD_FROM_DIALOG)&&(m_ldrFlags & LDR_STATUS) ) {
            if ( IsLoadCanceled() ) {
                m_dwErrorNum = ER_LDR_ABORT;    // 0x4010;
                return( -1 );
            }                  
            TestMessage();
        }

        i=1;
        start.addr = (uCurFill->start).addr;
        end.addr = start.addr + (uCurFill->num) -1;
        if(start.addr < m_BankStartAddr){
            while(i<banknum){
                 DestAddr.addr=start.addr;
                 DestAddr.addrType=U8(6+i);
                 ASSERT(start.addrType==end.addrType);
                 if(AbiCopy(start, end, DestAddr)!=ICE_OK){
                    DelAddrList();
                    m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;
                    return 0; 
                  }
                 i++;
           }
       }//end of if
       uCurFill = uCurFill->next;
    } //end of while
  DelAddrList();
  m_bBankReady = TRUE;
  return 1;
} //end of function
 

/***************************************************************************
*  Added by Dragon for Bank-Switching 12/30/1996                           *
*                                                                          *
*  AbiMyCopy                                                               *                                                               
*                                                                          *
*   return value : 0  1                                                    *
*                                                                          *
***************************************************************************/

BOOL LoaderServer::AbiMyCopy(ADDR start, ADDR end, ADDR DestAddr)
{
  char buf[255];
  U32  num;
  ADDR sAddr, eAddr ;
  
  ASSERT(start.addrType == end.addrType);
  
  sAddr.addr = start.addr;
  sAddr.addrType = start.addrType;
  eAddr.addr = end.addr;
  eAddr.addrType = end.addrType;
  
  num = end.addr - start.addr;        
  while( num > 0x00ff ){
     eAddr.addr = sAddr.addr + 0xfe;
     if(AbiGetMemN(sAddr, eAddr, buf)!=ICE_OK){
        ASSERT( 0 );
        return 0;
     }   
     
     sAddr.addrType = eAddr.addrType = DestAddr.addrType;
     if(AbiFill(sAddr, eAddr, buf, 0xfe)!=ICE_OK){
        m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE;
        m_bDispOff = 0; 
        return 0;
     }
     sAddr.addr = eAddr.addr + 1;
     sAddr.addrType = eAddr.addrType = 6;
     num -= 0x00ff;
  }//end of while
   
   eAddr.addr = sAddr.addr + (U16)num;
   ASSERT(eAddr.addr==end.addr);      

   if(AbiGetMemN(sAddr, eAddr, buf)!=ICE_OK){
      return 0;
   }   
     
   sAddr.addrType = eAddr.addrType = DestAddr.addrType;
   if(AbiFill(sAddr, eAddr, buf,(U16)num)!=ICE_OK){
      m_dwErrorNum = ER_ICE_FAIL_MEM_WRITE; 
      m_bDispOff = 0; 
      return 0;
   }   
   
   return 1;
}//end of function

void LoaderServer::GetBankCallRetAddr(U8 * data, char * Name)
{
 char call[12]="?X_CALL_L18";
 char ret[11]="?X_RET_L18";
 
 if(m_bCallBank && m_bRetBank ){
    return;
 }
 
 if(!m_bCallBank && strcmp(Name,call)==0){
    m_uBankCallAddr = BinToU32(&data[3]);
    m_bCallBank = 1;
 }
 
 if(m_bCallBank && strcmp(Name,ret)==0){
    m_uBankRetAddr = BinToU32(&data[3]);
    m_bRetBank = 1;
 } 
 if(m_bCallBank && m_bRetBank ){
    m_IsBankSwitchOn = 1;
    m_bBankReady = FALSE;
 }
}                 
    
 void LoaderServer::AddToAddrList(ADDR start,U8 num)
  { 
    if(uFillHdr==NULL){
       uFillHdr= new FillAddr();
       ASSERT(uFillHdr);
       uFillHdr->start.addr=start.addr;
       uFillHdr->start.addrType=start.addrType;
       uFillHdr->num=num;
       return;
    }
    
    struct FillAddr * temp;
    
    uCurFill = uFillHdr;
    while(uCurFill){
     temp = uCurFill;
     uCurFill=uCurFill->next;
    } 
    uCurFill = new FillAddr();
    ASSERT(uCurFill);
    temp->next = uCurFill;
    uCurFill->start.addr=start.addr;
    uCurFill->start.addrType=start.addrType;
    uCurFill->num=num;
    return;
  }      

 void LoaderServer::DelAddrList()
 { 
   struct FillAddr * temp;
   while(uFillHdr){
     temp = uFillHdr->next;
     delete uFillHdr;
     uFillHdr = temp;
   }
   uFillHdr = NULL;
 }
   

int LoaderServer::LdrIsNumber(char c)
{
    if ( (c>='0'&&c<='9')||(c>='A'&&c<='F')||(c>='a'&&c<='f') ) {
        return 1;
    }               
    return 0;
}                

//   0  ---  line end
//   1  ---  number
//   2  ---  symbol
int LoaderServer::LdrGetOneToken(char *pLine, int nLen, int& nStart, int& nEnd)
{                   
    int nMode = 1;
    BOOL bSpec=FALSE;
    while( nStart < nLen ) {
        if ( pLine[nStart] == ' ' ) nStart++;
        else break;
    }

    if ( nStart >= nLen ) return 0;    
    nEnd = nStart; 
    while( nEnd < nLen ) {
        if ( (pLine[nEnd] == ' ') ) break;
        if ( (pLine[nEnd] == '\n') ) {
            if ( nEnd == nStart ) return 0;
            break;
        }
        if ( !LdrIsNumber(pLine[nEnd]) ) {
            if ( nStart!=nEnd && nMode==1 && !bSpec && (pLine[nEnd] == 'H' || pLine[nEnd] == 'h') ) {
                bSpec = TRUE;
            }
            else 
                nMode = 2;
        }                                              
        else if ( bSpec ) nMode = 2;
        nEnd++;
    }
    return nMode;
}

int LoaderServer::LdrGetOneHexNumber(char *pLine, int nLen, int nStart, int nEnd)
{                        
    long lResult = 0;
    while( nStart < nLen ) {
        if ( pLine[nStart] == ' ' ) nStart++;
        else break;
    }

    if ( nStart >= nLen || nStart >= nEnd || nEnd > nLen ) return 0;    
    while( nStart < nEnd ) {
        if ( pLine[nStart] == ' ' ) break;
        if ( LdrIsNumber(pLine[nStart]) ) {
            lResult = lResult << 4;
            if ( pLine[nStart] >= 'A' ) {
                if ( pLine[nStart] >= 'a' ) 
                    lResult += pLine[nStart] - 'a' + 10;
                else 
                    lResult += pLine[nStart] - 'A' + 10;
            }
            else 
                lResult += pLine[nStart] - '0';
        }
        else break;
        nStart++;
    }
    return (int)lResult;
}

U32 LoaderServer::LdrGetMapSegmentAddress(char *pLine, int nLen, int nStart, int nEnd)
{                        
    U32 lResult = 0;
    BOOL bLong = FALSE;
    while( nStart < nLen ) {
        if ( pLine[nStart] == ' ' ) nStart++;
        else break;
    }

    if ( nStart >= nLen || nStart >= nEnd || nEnd > nLen ) return 0L;    
    while( nStart < nEnd ) {
        if ( pLine[nStart] == ' ' ) break;
        if ( LdrIsNumber(pLine[nStart]) ) {
            lResult = lResult << 4;
            if ( pLine[nStart] >= 'A' ) {
                if ( pLine[nStart] >= 'a' ) 
                    lResult += pLine[nStart] - 'a' + 10;
                else 
                    lResult += pLine[nStart] - 'A' + 10;
            }
            else 
                lResult += pLine[nStart] - '0';
        }
        else if ( bLong ) break;
        else if ( pLine[nStart] == ':' ) {
//            lResult = lResult << 16;
            bLong = TRUE;
        }                                
        else break;
        nStart++;
    }
    return lResult;
}

int LoaderServer::GetSegmentAddressFromMap(char* pLine, int nStart, int nEnd)
{
    int nMapLine = 0;
    int nLen , nToken , nNum;
    BOOL bModStart = FALSE; 
    BOOL bInfo = FALSE , bInfo1 = FALSE; 
    char *pName = NULL; 
    if ( !bMapFileOpened ) return -1;
    strSegmentName = &pLine[nStart];
    strSegmentName.GetBufferSetLength(nEnd-nStart); 
    
    mapfile.SeekToBegin();
    
    while( mapfile.ReadString(pLine,512) ) {
        nMapLine++;
        if ( pLine[0] == 0x0c || pLine[0] == 0x0a ) continue;       
        if ( pLine[0] == '#' ) {
            if ( nMapLine == 3 && ((pName=strstr(pLine , "IAR Universal Linker"))==NULL) ) {
                return -1;
            }    
            continue;
        }

//        if ( nMapLine > 3 && (pName=strstr(pLine , "PROGRAM MODULE, NAME : ")) ) {
        if ( nMapLine > 3 && (pName=strstr(pLine , "MODULE, NAME : ")) ) {
            pName += 15;                                    
            nStart = 0;
            if ( (nToken=LdrGetOneToken(pName, strlen(pName), nStart, nEnd)) == 2 ) {
                if ( (strlen(m_modNode.name) == nEnd-nStart) &&  !strnicmp( m_modNode.name, &pName[nStart], nEnd-nStart ) ) {
                    bModStart = TRUE;
                    bInfo = FALSE; 
                }                    
            }
        }                       
        else if ( bModStart ) {
            if ( bInfo ) {  // Relative -- 28 , Banked -- 26 , Address -- 10 
                if ( !bInfo1 ) {
                    int nKey = -1;
                    if ( (pName=strstr(pLine,"Relative segment, address : ")) ) 
                        nKey = 1;
                    else if ( (pName=strstr(pLine,"Banked segment, address : ")) ) 
                        nKey = 2;
                    else if ( (pName=strstr(pLine,"address : ")) )               
                        nKey = 3;
                    else if ( (pName=strstr(pLine,"SEGMENTS IN DUMP ORDER")) )
                        nKey = 4;
                        
                    switch ( nKey ) {
                    case 1:                                                     
                        pName += 28;
                        if ( (nToken=LdrGetOneToken(pName, strlen(pName), nStart, nEnd)) != 0 ) {
                            nCurOrg = nCurPos = LdrGetMapSegmentAddress(pName, strlen(pName), nStart, nEnd);
                            bNameValid = TRUE;
                            bOrgValid = TRUE;
                        }
    //                    break;
                        return 1;
                    case 2:   
                        pName += 26;
                        if ( (nToken=LdrGetOneToken(pName, strlen(pName), nStart, nEnd)) != 0 ) {
                            nCurOrg = nCurPos = LdrGetMapSegmentAddress(pName, strlen(pName), nStart, nEnd);
                            bNameValid = TRUE;
                            bOrgValid = TRUE;
                        }
    //                    break;
                        return 1;
                    case 3:   
                        pName += 10;
                        if ( (nToken=LdrGetOneToken(pName, strlen(pName), nStart, nEnd)) != 0 ) {
                            nCurOrg = nCurPos = LdrGetMapSegmentAddress(pName, strlen(pName), nStart, nEnd);
                            bNameValid = TRUE;
                            bOrgValid = TRUE;
                        }
    //                    break;
                        return 1;
                    case 4:
                        bInfo1 = TRUE;
                        break;
                    default:
                        break;
                    }   
                }
            }
            else {
                nStart = 0;
                if ( (nToken=LdrGetOneToken(pLine, strlen(pLine), nStart, nEnd)) == 2 ) {
                    if ( nStart == 0 ) {
                        if ( nEnd-nStart == strSegmentName.GetLength() ) {
                            if ( !strnicmp(pLine, strSegmentName.GetBuffer(strSegmentName.GetLength()), nEnd-nStart) ) {
                                bInfo = TRUE;
                            }
                        }
                    }
                }
            }
        }    
        
        if ( !bInfo1 ) {
            if ( (pName=strstr(pLine,"SEGMENTS IN DUMP ORDER")) ) {
                bInfo1 = TRUE;
            }                        
        }
        else {
            nStart = 0;
            if ( (nToken=LdrGetOneToken(pLine, strlen(pLine), nStart, nEnd)) == 2 ) {
                if ( nStart == 0 ) {
                    if ( nEnd-nStart == strSegmentName.GetLength() ) {
                        if ( !strnicmp(pLine, strSegmentName.GetBuffer(strSegmentName.GetLength()), nEnd-nStart) ) {
                            nStart = nEnd;
                            if ( (nToken=LdrGetOneToken(pLine, strlen(pLine), nStart, nEnd)) == 1 ) {
                                nCurOrg = nCurPos = LdrGetMapSegmentAddress(pLine, strlen(pLine), nStart, nEnd);
                                bNameValid = TRUE;
                                bOrgValid = TRUE;
                                return 1;
                            }
                        }
                    }
                }
            }
        }
        
    }           
    return 0;   
}

//  0  --  no use or empty line
//  1  --  useful line
// -1  --  error
int LoaderServer::LdrUbrofSwitchLine(SYM_DESCRIPTOR moduleDesc, CStdioFile& listFile, char *pLine, 
    int& nNum, int& nSrcLine)
{    
    int nLen, nStart, nEnd , nToken;
    int nOffset , nListLine;
    OFSTRUCT of;         
    CString strTemp;
    BOOL bFound;                                            
    int nPos1;   
        
    nLen = strlen( pLine );
    nStart = 0;
    
    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) != 1 ) {
        if ( nToken == 2 && nStart+1 == nEnd && pLine[nStart] == '/' ) {
            if ( !bListValid ) return 0;
        }
        else return 0;
    }                 
    else  if ( !(nToken == 1 && nEnd <= 5) ) {
        return 0;
    }           
    else {    
        int nPos1 = nStart;
        while(nPos1<nEnd) {
            if ( pLine[nPos1]<'0'||pLine[nPos1]>'9') return 0;
            nPos1++;
        }
    }

    if ( nToken == 1 ) {
        nSrcLine++;
    //    nNum++;
        nListLine = atoi(pLine);
        bListValid = TRUE;
        nListLastLineNum = nListLine;
    }
    else {
//        bListValid = FALSE;
        nListLine = nListLastLineNum;
//        nListLastLineNum = 0;
    }

    nStart = nEnd;
    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 0 ) {
        return 0;
    }                 
 
    if ( nToken == 1 ) {
        if ( nEnd <= 11 ) {
//            nOffset = atoi(&pLine[nStart]);
            nOffset = LdrGetOneHexNumber(pLine, nLen, nStart, nEnd);
            
            nStart = nEnd;
            if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) != 1 ) {
                // deal with org and RSEG
                int nKey = -1;
                
                if ( (nStart+3 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "org" , 3)) )
                    nKey = 1;
                else if ( (nStart+4 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "ASEG" , 4)) )
                    nKey = 2;
                else if ( (nStart+4 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "RSEG" , 4)) )
                    nKey = 3;            
                else {  
                    nStart = nEnd;
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 2 ) 
                        nKey = -1;
                    if ( (nStart+3 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "org" , 3)) )
                        nKey = 1;
                    else if ( (nStart+4 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "ASEG" , 4)) )
                        nKey = 2;
                    else if ( (nStart+4 == nEnd) && (0 == strnicmp((const char *)&pLine[nStart], "RSEG" , 4)) )
                        nKey = 3;            
                    else {  
                        return 0;
                    }
                }
                nStart = nEnd;
                switch ( nKey ) {
                case 1:     // ORG
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 1 ) {
                        nCurOrg = LdrGetOneHexNumber(pLine, nLen, nStart, nEnd);
                        if ( !bNameValid ) {
                            nCurPos = nCurOrg;
//                          bOrgValid = FALSE;
                            bOrgValid = TRUE;
                            bOrgStatus = TRUE;
                        }
                    }   
                    break;            
                case 2:     // ASEG
                    bOrgStatus = FALSE;
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 2 ) {
                        bOrgValid = FALSE;
                    }               
                    break;
                case 3:     // RSEG    
                    bOrgStatus = FALSE;
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 2 ) {
//                        if ( !GetSegmentAddressFromMap(pLine, nStart, nEnd) ) {
                        if ( GetSegmentAddressFromMap(pLine, nStart, nEnd)<=0 ) {
                            if ( bOrgValid ) {
                                nCurPos = nCurOrg;
                                bOrgValid = TRUE;    
                                bNameValid = TRUE;
                            }
                        }   
                    }               
                    break;
                default:
                    break;
                }
                return 0;
            }                 
            
            if ( nStart == 12 ) {                                                    
                BOOL bToken = FALSE;
                nStart = nEnd;
                if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) != 0 ) {
                    if ( nToken == 1 ) 
                        bToken = TRUE;
                // for jump db , dw generate information
                    if ( (nStart+2 == nEnd) && ( (0 == strnicmp((const char *)&pLine[nStart], "DB" , 2))||
                        (0 == strnicmp((const char *)&pLine[nStart], "DW" , 2)) ) ) {
                        return 0;
                    }
                    nStart = nEnd;
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) != 0 ) {
                        if ( (nStart+1 == nEnd) && (pLine[nStart] == ':') ) {
                            nStart = nEnd;
                            nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd);
                        }                           
                        if ( (nStart+2 == nEnd) && ( (0 == strnicmp((const char *)&pLine[nStart], "DB" , 2))||
                            (0 == strnicmp((const char *)&pLine[nStart], "DW" , 2)) ) ) {
                            return 0;
                        }
                    }                
                    else if ( bToken ) return 0;
                }
            
                if ( m_modNode.linecnt == 0 ) {
                    SymAddLinenumStart(moduleDesc);
                }
                
                SOURCE_RANGE_TYPE srcState;
                ADDR_RANGE_TYPE addrState;
                srcState.lineNumStart=nSrcLine;
                srcState.columnStart=1;
                srcState.lineNumEnd=nSrcLine;
//                if ( nLen > 22 && pLine[21] == ' ' )
//                    srcState.columnEnd=nLen - 22 + 1;
//                else 
//                    srcState.columnEnd=nLen+1;
                srcState.columnEnd=0xFFFF;

                if ( !(bOrgValid&&bNameValid) ) {
                    if ( bOrgStatus ) {
                        addrState.startAddr=start+nOffset-nCurPos;
                        addrState.endAddr=addrState.startAddr;
                    }
                    else {
                        addrState.startAddr=start+nOffset;
                        addrState.endAddr=addrState.startAddr;
                    }
                }
                else {    
                    addrState.startAddr=nCurPos+nOffset;
                    addrState.endAddr=addrState.startAddr;
                }
                //to speified bank
                if(m_bLoadToBank&&m_window==LOAD_FROM_SHELL){
                    addrState.startAddr &= 0xFFFF;
                    ConvertAddrToBank(addrState.startAddr);
                }
                addrState.segType=SEG_CODE;
                SymAddSourceState(&srcState , &addrState);
                m_modNode.linecnt++;

                bListValid = FALSE;
                //nListLine = nListLastLineNum;
                nListLastLineNum = 0;
                return 1;
            }
        }                
    }
    else {
        if ( pLine[nStart] == '$' ) {
            pLine[nEnd] = '\0';
            strTemp = &pLine[nStart+1];
            bFound = FALSE;  
            nPos1 = strTemp.ReverseFind('\\');
            if ( strTemp.ReverseFind(':') > nPos1 ) {
                nPos1 = strTemp.ReverseFind(':');
            }
            if ( nPos1 < 0 ) nPos1 = 0;
            else nPos1++;
            
            strPath = &pLine[nStart+1];
            if ( OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                strPath = szPath;       
                if ( pLine[nStart+1] == '\\' ) 
                    strPath += &pLine[nStart+1+nPos1];
                else 
                    strPath += &pLine[nStart+1];                    
                if ( OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                    POSITION posPath;
                    posPath = SrcPathList.GetHeadPosition();
                    while( posPath && OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                        strPath = SrcPathList.GetNext(posPath);
                        if( strPath.GetLength()>0 && strPath.Right(1) != "\\")    strPath += "\\";
                        strPath += &pLine[nStart+1+nPos1];
                        if( OpenFile(strPath, &of , OF_EXIST ) != HFILE_ERROR ) {
                            bFound = TRUE;
                            break;
                        }
                    }                
                }
                else bFound = TRUE;
            }
            else bFound = TRUE;
            
            if ( bFound ) {                        
                LdrUbrofJmpInclude(listFile, pLine , strPath, nNum);
            }
        }
    }
    return 0;
}

int LoaderServer::LdrUbrofJmpInclude(CStdioFile& listFile, char* pLine , const char* strName, int& nNum)
{                                                                                                 
    CStdioFile incFile( strName , CFile::modeRead | CFile::typeText );
    int nLen, nStart, nEnd , nToken;
    OFSTRUCT of;         
    CString strTemp;
    BOOL bFound;                                            
    int nPos1;
    
    while( incFile.ReadString(pLine,512) ) {
        while ( 1 ) {        
            if ( listFile.ReadString(pLine,512) ) {
                nNum++;
                nLen = strlen( pLine );
                nStart = 0;
                if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 1 && nEnd <= 5 ) {
                    nStart = nEnd;
                    if ( (nToken=LdrGetOneToken(pLine, nLen, nStart, nEnd)) == 2 ) {
                        if ( pLine[nStart] == '$' ) {
                            pLine[nEnd] = '\0';
                            strTemp = &pLine[nStart+1];
                            bFound = FALSE;  
                            nPos1 = strTemp.ReverseFind('\\');
                            if ( strTemp.ReverseFind(':') > nPos1 ) {
                                nPos1 = strTemp.ReverseFind(':');
                            }
                            if ( nPos1 < 0 ) nPos1 = 0;
                            else nPos1++;
                            
                            strPath = &pLine[nStart+1];
                            if ( OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                                strPath = szPath;       
                                if ( pLine[nStart+1] == '\\' ) 
                                    strPath += &pLine[nStart+1+nPos1];
                                else 
                                    strPath += &pLine[nStart+1];                    
                                if ( OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                                    POSITION posPath;
                                    posPath = SrcPathList.GetHeadPosition();
                                    while( posPath && OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
                                        strPath = SrcPathList.GetNext(posPath);
                                        if( strPath.GetLength()>0 && strPath.Right(1) != "\\")    strPath += "\\";
                                        strPath += &pLine[nStart+1+nPos1];
                                        if( OpenFile(strPath, &of , OF_EXIST ) != HFILE_ERROR ) {
                                            bFound = TRUE;
                                            break;
                                        }
                                    }                
                                }
                                else bFound = TRUE;
                            }
                            else bFound = TRUE;
                            
                            if ( bFound ) {                        
                                LdrUbrofJmpInclude(listFile, pLine , strPath, nNum);
                            }
                        }
    
    //                    if ( pLine[nStart] == '$' ) {
    //                        pLine[nEnd] = '\0';
    //                        strPath = szPath;
    //                        strPath += &pLine[nStart+1];                    
    //                        if ( OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
    //                            POSITION posPath;
    //                            posPath = SrcPathList.GetHeadPosition();
    //                            while( posPath && OpenFile(strPath, &of , OF_EXIST ) == HFILE_ERROR ) {
    //                                strPath = SrcPathList.GetNext(posPath);
    //                                if( strPath.GetLength()>0 && strPath.Right(1) != "\\")    strPath += "\\";
    //                                strPath += &pLine[nStart+1];
    //                                if( OpenFile(strPath, &of , OF_EXIST ) != HFILE_ERROR ) break;
    //                            }                
    //                        }
    //                        LdrUbrofJmpInclude(listFile, pLine , strPath, nNum);
    //                    }
                    }
                }                 
                else {
                    continue;
                }
            }
            else {
                incFile.Close();
                return 0;
            }
            break;
        }        
    }                 
    incFile.Close();
    return 1;    
}
                
BOOL LoaderServer::LdrUbrofGetLstFileInfo(SYM_DESCRIPTOR moduleDesc)
{
//    char szPath[_MAX_PATH];
    lstrcpy(szPath,m_lpFileRef);
    int nLen = lstrlen(szPath);
    int i ;
    for (i = nLen-1; i >= 0 ; i--) {
        if (  szPath[i] == '\\' || szPath[i] == '/' 
            || szPath[i]  == ':' ) break;
    }
    if ( i > 0 ) szPath[i+1] = '\0';

//    struct _find_t fileinfo;
    CString strFileName = szPath;
    strFileName += m_modNode.name;
    strFileName += ".lst";
    
//    CString strPath = strFileName;
    strPath = strFileName;
    int nPos = strPath.ReverseFind('.');
    if ( i < nPos )
        strPath.GetBufferSetLength(nPos);

    CString strSrcName = strPath;
    strSrcName += ".ASM";
    OFSTRUCT of;         
    BOOL bOk = FALSE;
    
    if ( !( OpenFile(strFileName, &of , OF_EXIST )  == HFILE_ERROR ||
            OpenFile(strSrcName, &of , OF_EXIST )   == HFILE_ERROR) ) 
        bOk = TRUE;    
    if ( !bOk ) {
        strSrcName = strPath;
        strSrcName += ".S03";
        if ( !( OpenFile(strFileName, &of , OF_EXIST )  == HFILE_ERROR ||
            OpenFile(strSrcName, &of , OF_EXIST )   == HFILE_ERROR) ) 
            bOk = TRUE;    
    }                        
    
    if ( !bOk ) return FALSE;
    
    CStdioFile listFile(strFileName,CFile::modeRead | CFile::typeText );
    
    char szLine[513],*p;
    char ch;
    BOOL bModBegin = FALSE;
    int nNum , nSrcLine;
    int nStart , nEnd;
    
    nNum = 0;  
    nSrcLine = 0;

    bListValid = FALSE;
    nListLastLineNum = 0;

    nCurOrg = 0;
    nCurPos = 0;
    strSegmentName = "";
    bNameValid = FALSE;
    bOrgValid = FALSE;
    bMapFileOpened = FALSE; 
    bOrgStatus = FALSE;

    CString strMap = m_lpFileRef;   
    nPos = strMap.ReverseFind('.');
    if ( i < nPos )
        strMap.GetBufferSetLength(nPos);
    strMap += ".MAP";
    if ( !( OpenFile(strMap, &of , OF_EXIST )  == HFILE_ERROR ) ) {
        if ( mapfile.Open(strMap,CFile::modeRead | CFile::typeText ) ) {
            bMapFileOpened = TRUE;    
        }
        else bMapFileOpened = FALSE;    
    }
        
    while ( listFile.ReadString(szLine,512) ) {
        nNum++;
        if ( szLine[0] == 0x0c || szLine[0] == 0x0a ) continue;       
        if ( szLine[0] == '#' ) {
            if ( nNum == 3 && strstr(szLine , "IAR 8051 Assembler")==NULL ) {
                listFile.Close();
                if ( bMapFileOpened ) mapfile.Close();
                return FALSE;
            }    
            continue;
        }

        LdrUbrofSwitchLine(moduleDesc, listFile, (char *)szLine, nNum, nSrcLine);
    }
    
LST_FAIL :
    if ( bMapFileOpened ) mapfile.Close();
    listFile.Close();
    if ( m_lstFileInfo ) {
        delete m_lstFileInfo;
        m_lstFileInfo = NULL;
    }
    return FALSE;
}

/******************************** E O F ***********************************/
