/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/LOGO.CPP   1.2.1.4   17 Apr 1997 15:55:20   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/LOGO.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:55:20   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:26:20   ZJRD
** 2.09F
** 
****************************************************************************/

// firewnd.cpp : implementation file
//
// This is a part of the Microsoft Foundation Classes C++ library.
// Copyright (C) 1992-1995 Microsoft Corporation
// All rights reserved.
//
// This source code is only intended as a supplement to the
// Microsoft Foundation Classes Reference and related
// electronic documentation provided with the library.
// See these sources for detailed information regarding the
// Microsoft Foundation Classes product.

#include "stdafx.h"
#include "logo.h"
//#include "utils.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif                                      

#define BASEDELAY 100
#define IMAGELEN  600

static BOOL g_bClose=0;
static HPALETTE g_hDefPal;
static char *szIndex[]={"FLAME1","FLAME2","FLAME3","FLAME4",
						"FLAME5","FLAME6","FLAME7","FLAME8","FLAME9"};
						
/////////////////////////////////////////////////////////////////////
//CLogoWnd()
CLogoWnd::CLogoWnd(DWORD dwDelay, DWORD *dwSafePoint)
{                   
	m_pdwSafePoint=dwSafePoint;
//safe init
	m_bQuitNow=0;
	m_bCanClose=0;
	m_hViewDC=NULL;
    m_hStarCDC=NULL;
    m_hMemDC=NULL; 
    m_hStarMDC=NULL;
    m_hFlameDC=NULL;
    m_hBackDC=NULL;
    m_hStarCBit=NULL; 
    m_hStarMBit=NULL;
    m_hMemBit=NULL;
    m_hBackBit=NULL;
    m_dwExitDelay=dwDelay+GetTickCount();
    m_hTitleFont=NULL;
    m_hVerFont=NULL;
}

CLogoWnd::~CLogoWnd()
{          
}     

/////////////////////////////////////////////////////////////////////
//IntiBitmap
BOOL CLogoWnd::InitGDI()
{
	ASSERT(m_hWnd!=NULL);

//InitDC	
	m_hViewDC = ::GetDC(m_hWnd);
	m_hStarCDC  = ::CreateCompatibleDC(m_hViewDC);
	m_hStarMDC  = ::CreateCompatibleDC(m_hViewDC);
	m_hMemDC	= ::CreateCompatibleDC(m_hViewDC);
	m_hBackDC	= ::CreateCompatibleDC(m_hViewDC);
	m_hFlameDC	= ::CreateCompatibleDC(m_hViewDC);
	
	SaveDC(m_hViewDC);
	SaveDC(m_hStarCDC);
	SaveDC(m_hStarMDC);
	SaveDC(m_hMemDC);
	SaveDC(m_hBackDC);
	SaveDC(m_hFlameDC);
	
    m_hMemBit  = ::CreateCompatibleBitmap(m_hViewDC,
                                          m_BackBitmapInfo.bmWidth,
                                          m_BackBitmapInfo.bmHeight); 		

	::SelectObject(m_hStarCDC, m_hStarCBit); 
	::SelectObject(m_hStarMDC, m_hStarMBit);
	::SelectObject(m_hMemDC, m_hMemBit);
	::SelectObject(m_hBackDC, m_hBackBit);
	
	return 1;
}

BOOL CLogoWnd::InitBitmap()
{
    m_hStarCBit= ::LoadBitmap(AfxGetApp()->m_hInstance, "cstar");
    m_hStarMBit= ::LoadBitmap(AfxGetApp()->m_hInstance, "mstar");
    m_hBackBit = ::LoadBitmap(AfxGetApp()->m_hInstance, "background");
    GetObject(m_hBackBit,sizeof(BITMAP),&m_BackBitmapInfo);
    return 1;
}

BOOL CLogoWnd::FreeGDI()
{ 
///////////////////////////////////////
//FreeDC	
	if(m_hViewDC!=NULL)
	{
	   ::RestoreDC(m_hViewDC,-1);
	   ::ReleaseDC(m_hWnd,m_hViewDC);
	   m_hViewDC=NULL;
	}   
    
    if(m_hStarCDC!=NULL)
    {
	   ::RestoreDC(m_hStarCDC,-1);
	   ::DeleteDC(m_hStarCDC);
	   m_hStarCDC=NULL;
    
    }

    if(m_hFlameDC!=NULL)
    {
	   ::RestoreDC(m_hFlameDC,-1);
	   ::DeleteDC(m_hFlameDC);
	   m_hFlameDC=NULL;
    
    }            
    
    if(m_hStarMDC!=NULL)
    {
	   ::RestoreDC(m_hStarMDC,-1);
	   ::DeleteDC(m_hStarMDC);
	   m_hStarMDC=NULL;
    
    }

    if(m_hMemDC!=NULL)
    {
	   ::RestoreDC(m_hMemDC,-1);
	   ::DeleteDC(m_hMemDC);
	   m_hMemDC=NULL;
    
    }

    if(m_hBackDC!=NULL)
    {
	   ::RestoreDC(m_hBackDC,-1);
	   ::DeleteDC(m_hBackDC);
	   m_hBackDC=NULL;
    
    }     
    
    if(m_hTitleFont)
      DeleteObject(m_hTitleFont);
    if(m_hVerFont)
      DeleteObject(m_hVerFont);
      
//FreeBitmap	        
	if(m_hMemBit!=NULL)
	   DeleteObject(m_hMemBit);
	if(m_hStarCBit!=NULL)
	   DeleteObject(m_hStarCBit);
	if(m_hStarMBit!=NULL)
	   DeleteObject(m_hStarMBit);
	if(m_hBackBit!=NULL)
	   DeleteObject(m_hBackBit);

	return 1;
}      

///////////////////////////////////////
//CreateWnd
BOOL CLogoWnd::CreateWnd(LPSTR lpszTitle, LPSTR lpszVer,int nTitleHeight, int nVerHeight)          
{                
    m_strTitle=lpszTitle;
    m_strVer=lpszVer;
  	LOGFONT logFont;

	memset(&logFont, 0, sizeof(LOGFONT));
	logFont.lfHeight=nTitleHeight;
	logFont.lfWeight=1600;
	logFont.lfItalic=1;
	lstrcpy(logFont.lfFaceName,"Times New Roman");
	m_hTitleFont=::CreateFontIndirect(&logFont);
	
	memset(&logFont, 0, sizeof(LOGFONT));
	logFont.lfHeight=nVerHeight;
	logFont.lfWeight=800;
	logFont.lfItalic=1;
	lstrcpy(logFont.lfFaceName,"Times New Roman");
	m_hVerFont=CreateFontIndirect(&logFont);

	InitBitmap();
	                                  
    BOOL bCreate=
           CreateEx(WS_EX_TOPMOST,
                    AfxRegisterWndClass(CS_HREDRAW|CS_VREDRAW|CS_OWNDC,
                                        0,
                                        (HBRUSH)GetStockObject(BLACK_BRUSH),
                                        (HCURSOR)::LoadCursor(NULL,IDC_ARROW)),//0),
                    NULL,
                    WS_POPUP|WS_VISIBLE|WS_OVERLAPPED|WS_THICKFRAME,//WS_BORDER,//WS_THICKFRAME|,
                    0,0,m_BackBitmapInfo.bmWidth+7,m_BackBitmapInfo.bmHeight+4,
                    NULL,
                    NULL,
                    NULL
                   );              
    delay(100);               
   	return bCreate;
}

///////////////////////////////////////
//ProcessMsg
BOOL CLogoWnd::ProcessMsg(MSG *pMsg)
{         
       MSG msg;            
       switch(pMsg->message)
       {               
		  case WM_LBUTTONDOWN:
		  case WM_RBUTTONDOWN:
		  case WM_MBUTTONDOWN:
		  case WM_LBUTTONDBLCLK:
		  case WM_RBUTTONDBLCLK:
		  case WM_MBUTTONDBLCLK:
		  case WM_LBUTTONUP:
		  case WM_RBUTTONUP:
		  case WM_MBUTTONUP:
          case WM_KEYDOWN:
          case WM_KEYUP:{         
               while(::PeekMessage(&msg, NULL, WM_KEYFIRST, WM_KEYLAST, PM_REMOVE) ||
               ::PeekMessage(&msg, NULL, WM_MOUSEFIRST, WM_MOUSELAST, PM_REMOVE));
               return TRUE;
               }
               
          default: break;     
               
       }   

    return FALSE;
}
                                                                          
///////////////////////////////////////
//AutoClose
void CLogoWnd::AutoClose(CPoint point)
{   
	if(m_bQuitNow==0)
	{
	    CRect rect;                              
		GetClientRect(&rect);
		if(rect.PtInRect(point)==0 && m_bCanClose)
		{        
	       m_bQuitNow=1;
		   PostMessage(WM_CLOSE);
		}   
		else  
		{
		   ReleaseCapture();
		   SetCapture();
		}   
    } 
}              

///////////////////////////////////////
//PaintBitmap
void CLogoWnd::PaintBitmap()
{   
   static UINT index=0;
   index++;               
   int 		x,y,nSLine;        
//   int		nIdx=SaveDC(m_hMemDC);
   DWORD	dwExtent;
   
   ::BitBlt(m_hMemDC,0,0,m_BackBitmapInfo.bmWidth, m_BackBitmapInfo.bmHeight,
            m_hBackDC,0,0,SRCCOPY);   

   if(index<=15){      
   x=(387*index)/30;
   y=( (x*124)/258 );

   ::BitBlt(m_hMemDC,x,y,85,52,m_hStarMDC,0,0,SRCAND);   
   ::BitBlt(m_hMemDC,x,y,85,52,m_hStarCDC,0,0,SRCPAINT);    
//   ::SetTextColor(m_hMemDC,RGB(128,128,0));
   }
   else if(index>15&&index<25)
   {     
  

 	// Bug 98: 04/16/98
//	HBITMAP hBitmap = ::LoadBitmap(AfxGetApp()->m_hInstance, szIndex[index-16]);
    HBITMAP hBitmap = ::LoadBitmap(AfxGetApp()->m_hInstance, "background");



     ASSERT(hBitmap);
     if(hBitmap){         
     ::SelectObject(m_hFlameDC, hBitmap);
 	 ::BitBlt(m_hMemDC,0,0,m_BackBitmapInfo.bmWidth, m_BackBitmapInfo.bmHeight,
              m_hFlameDC,0,0,SRCCOPY);   
     DeleteObject(hBitmap);
     }
    } 
    else if(index==(25)&&m_hBackBit)
    {                       
	   ::SetTextColor(m_hMemDC,RGB(192,192,0));	
	   ::SetBkMode(m_hMemDC, TRANSPARENT);
	   ::SelectObject(m_hMemDC, m_hTitleFont);
	   dwExtent=::GetTextExtent(m_hMemDC, (LPCSTR)m_strTitle,m_strTitle.GetLength());
	   ::TextOut(m_hMemDC, m_BackBitmapInfo.bmWidth-LOWORD(dwExtent)-18,
	   			 18,m_strTitle, m_strTitle.GetLength());
	   ::SelectObject(m_hMemDC, m_hVerFont);			 
	   nSLine=int(HIWORD(dwExtent));
	   dwExtent=::GetTextExtent(m_hMemDC, (LPCSTR)m_strVer,m_strVer.GetLength());
	   ::TextOut(m_hMemDC, m_BackBitmapInfo.bmWidth-LOWORD(dwExtent)-18,
	   			 20+HIWORD(dwExtent)+nSLine,m_strVer, m_strVer.GetLength());

      ::BitBlt(m_hViewDC,0, 0, m_BackBitmapInfo.bmWidth, m_BackBitmapInfo.bmHeight,
               m_hMemDC,0,0,SRCCOPY);   

       DeleteObject(m_hBackBit);
	   m_hBackBit = ::LoadBitmap(AfxGetApp()->m_hInstance, "ebackground");
       ASSERT(m_hBackBit);
 	   ::SelectObject(m_hBackDC, m_hBackBit);

	   ::SetTextColor(m_hBackDC,RGB(192,192,0));	
	   ::SetBkMode(m_hBackDC, TRANSPARENT);
	   ::SelectObject(m_hBackDC, m_hTitleFont);
	   dwExtent=::GetTextExtent(m_hBackDC, (LPCSTR)m_strTitle,m_strTitle.GetLength());
	   ::TextOut(m_hBackDC, m_BackBitmapInfo.bmWidth-LOWORD(dwExtent)-18,
	   			 18,m_strTitle, m_strTitle.GetLength());

	   ::SelectObject(m_hBackDC, m_hVerFont);			 
	   nSLine=int(HIWORD(dwExtent));
	   dwExtent=::GetTextExtent(m_hBackDC, (LPCSTR)m_strVer,m_strVer.GetLength());
	   ::TextOut(m_hBackDC, m_BackBitmapInfo.bmWidth-LOWORD(dwExtent)-18,
	   			 20+HIWORD(dwExtent)+nSLine,m_strVer, m_strVer.GetLength());
	   return;			 
   } else{
   
   if(m_uTimerID)
   {			           
   	  KillTimer(m_uTimerID);			 
   	  m_uTimerID=0;           
   	  int xOrg=68+76-8;
   	  int yOrg=47+99-10;               

      for(int i=0; i<10; i++)
      {          
        ::BitBlt(m_hViewDC,xOrg-i*7,yOrg-i*10, (i+1)*15,(i+1)*20,//m_BackBitmapInfo.bmWidth, m_BackBitmapInfo.bmHeight,
                 m_hMemDC,xOrg-i*7,yOrg-i*10,SRCCOPY);   
      	delay(55);         
      }            
      delay(2000);
      m_bCanClose=1;
//      if(g_bClose==1)
         CloseLogoWnd();
   }	  
   
   } 
   
   ::BitBlt(m_hViewDC,0, 0, m_BackBitmapInfo.bmWidth, m_BackBitmapInfo.bmHeight,
            m_hMemDC,0,0,SRCCOPY);   
            
//   RestoreDC(m_hMemDC,nIdx);         
}

///////////////////////////////////////
//delay
void CLogoWnd::delay(int nCount)
{
    DWORD dwClick=dwClick=GetTickCount();   
    MSG   msg;
    while(GetTickCount()<dwClick+nCount)
	{
	  if( ::PeekMessage(&msg,NULL,0,0,PM_REMOVE) )
	     DispatchMessage(&msg);
	}             
		              
}
BEGIN_MESSAGE_MAP(CLogoWnd, CWnd)
	//{{AFX_MSG_MAP(CFireWnd)
	ON_WM_CREATE()
	ON_WM_TIMER()
	ON_WM_PAINT()
	ON_WM_NCPAINT()
	ON_WM_DESTROY()
//	ON_WM_PALETTECHANGED()
//	ON_WM_QUERYNEWPALETTE()
	ON_WM_RBUTTONDOWN()
	ON_WM_LBUTTONDOWN()
	ON_WM_CLOSE()
	ON_WM_NCLBUTTONDOWN()
	ON_WM_NCRBUTTONDOWN()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
                 
///////////////////////////////////////
//OnCreate	        
int CLogoWnd::OnCreate(LPCREATESTRUCT pcs)
{
	int nResult=CWnd::OnCreate(pcs);
	m_bOpen=1;
	CenterWindow();
	InitGDI();
	
	SetCapture();
	m_uTimerID=SetTimer(0x451, BASEDELAY, NULL); 
	return nResult;
}                  
  
///////////////////////////////////////
//OnTimer	        
void CLogoWnd::OnTimer(UINT nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	CWnd::OnTimer(nIDEvent);

	if(nIDEvent==m_uTimerID && m_bOpen)
	{  
	   if(!m_bQuitNow&&m_dwExitDelay<=GetTickCount())
	   {             
	        m_bQuitNow=1;       
	        MessageBeep(-1);
	        //KillTimer(m_uTimerID);
	        //AfxMessageBox("ok");
	        m_bCanClose=1;
			PostMessage(WM_CLOSE);
			return;
	   }
	         
	   PaintBitmap();
	}
	
}
                 
///////////////////////////////////////
//OnNcPaint	        
void CLogoWnd::OnNcPaint() 
{                          
//    CWnd::OnNcPaint();
    CWindowDC dc(this);
    dc.SaveDC();                            
    CSize size;
    CRect rectWin, rectClient;
    GetWindowRect(&rectWin);
    GetClientRect(&rectClient);
    size.cx=rectWin.Width()-rectClient.Width();
    size.cy=rectWin.Height()-rectClient.Height();
    int nWidth=size.cx>size.cy?size.cx:size.cy;
    
    CPen penWhite(PS_SOLID, 1, RGB(255,255,255));
    CPen penGray(PS_SOLID, nWidth, GetSysColor(COLOR_INACTIVEBORDER));
    size=rectWin.Size();
    dc.SelectObject(CBrush::FromHandle((HBRUSH)GetStockObject(NULL_BRUSH)));
    dc.SelectObject(&penGray);
    dc.Rectangle(0,0,size.cx,size.cy);
    dc.SelectObject(&penWhite);
    dc.Rectangle(1,1,size.cx-1,size.cy-1);
    dc.RestoreDC(-1);
}     

///////////////////////////////////////
//OnPaint	        
void CLogoWnd::OnPaint() 
{   
    CWnd::OnPaint();               
	PaintBitmap();
}
                 
///////////////////////////////////////
//OnRButtonDown	        
void CLogoWnd::OnRButtonDown(UINT nFlags, CPoint point)
{
	if(m_bQuitNow==0)
	{
		CWnd::OnRButtonDown(nFlags, point);
		AutoClose(point);
	}	
}

///////////////////////////////////////
//OnLButtonDown	        
void CLogoWnd::OnLButtonDown(UINT nFlags, CPoint point)
{
	if(m_bQuitNow == 0)
	{
	    CWnd::OnLButtonDown(nFlags, point);
		AutoClose(point);
	}	
}
                 
///////////////////////////////////////
//OnNcLButtonDown	        
void CLogoWnd::OnNcLButtonDown(UINT nHitTest, CPoint point)
{
}

///////////////////////////////////////
//OnNcRButtonDown	        
void CLogoWnd::OnNcRButtonDown(UINT nHitTest, CPoint point)
{
}
///////////////////////////////////////
//PostNcDestroy	        
void CLogoWnd::PostNcDestroy()
{   
     if(AfxGetApp()->m_pMainWnd)
        AfxGetApp()->m_pMainWnd->BringWindowToTop();
     
     if(m_pdwSafePoint!=NULL)
     {                
        *m_pdwSafePoint=NULL;
        delete this;
     }   
}

///////////////////////////////////////
//OnDestroy	        
void CLogoWnd::OnDestroy() 
{            
    if(m_uTimerID>0)
    {
	   KillTimer(m_uTimerID);
	   m_uTimerID=0;
	}               
	
    ReleaseCapture();
    FreeGDI();
    m_bOpen=0;

extern CLogoWnd *g_pLogoWnd;
	g_pLogoWnd=NULL;

	CWnd::OnDestroy();
}
                 
///////////////////////////////////////
//OnClose()
void CLogoWnd::OnClose()                 
{
	if(m_bCanClose==0){
	   g_bClose=1;     
	   return;
	}        
	
	CWnd::OnClose();
}
