
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SHLHIST.CPP   1.2.1.4   17 Apr 1997 15:58:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SHLHIST.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:58:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:30:38   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:40:50   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:19:34   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:24:18   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:34:20   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:14   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.2   09 Dec 1996 10:17:46   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 13:01:00   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:22:26   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:33:52   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 10:00:56   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:44:14   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:49:34   ZJRD
** No change.
** 
**    Rev 1.7   11 Jun 1996 10:25:10   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:52:56   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:34:12   ZJRD
** No change.
** 
**    Rev 1.3   16 May 1996 09:02:46   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:14:20   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:29:12   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.31   18 Apr 1996 12:58:26   Shirley
** No change.
** 
**    Rev 1.30   12 Apr 1996 10:42:06   Shirley
** EasyPack/SLD Version 1.90
** 
**    Rev 1.28   15 Feb 1996 08:57:08   Shirley
** No change.
** 
**    Rev 1.27   12 Feb 1996 14:08:30   Shirley
** No change.
** 
**    Rev 1.26   06 Feb 1996 15:34:56   Shirley
** No change.
** 
**    Rev 1.25   06 Feb 1996 13:49:14   Shirley
** No change.
** 
**    Rev 1.24   01 Feb 1996 10:15:16   Shirley
** No change.
** 
**    Rev 1.23   26 Jan 1996 09:18:40   Shirley
** No change.
** 
**    Rev 1.22   25 Jan 1996 13:18:34   Shirley
** No change.
** 
**    Rev 1.21   24 Jan 1996 10:36:10   Shirley
** No change.
** 
**    Rev 1.20   23 Jan 1996 11:24:34   Shirley
** EasypPack/SLD Version 0.34c
** 
**    Rev 1.19   18 Jan 1996 10:11:18   Shirley
** No change.
** 
**    Rev 1.18   15 Jan 1996 16:12:54   Shirley
** No change.
** 
**    Rev 1.17   04 Jan 1996 11:10:56   Shirley
** No change.
** 
**    Rev 1.16   30 Nov 1995 09:14:46   Shirley
** No change.
** 
**    Rev 1.15   28 Nov 1995 15:29:18   Shirley
** No change.
** 
**    Rev 1.14   21 Nov 1995 11:21:32   Shirley
** No change.
** 
**    Rev 1.13   13 Nov 1995 09:27:16   Shirley
** No change.
** 
**    Rev 1.12   12 Nov 1995 11:31:52   Shirley
** No change.
** 
**    Rev 1.11   08 Nov 1995 16:33:56   Shirley
** No change.
** 
**    Rev 1.10   08 Nov 1995 12:44:42   Shirley
** No change.
** 
**    Rev 1.9   02 Nov 1995 10:04:28   Shirley
** No change.
** 
**    Rev 1.8   27 Oct 1995 16:47:24   Shirley
** No change.
** 
**    Rev 1.7   27 Oct 1995 13:45:14   Shirley
** No change.
** 
**    Rev 1.6   25 Oct 1995 14:26:34   Shirley
** No change.
** 
**    Rev 1.5   18 Oct 1995 14:49:30   Shirley
** No change.
** 
**    Rev 1.4   13 Oct 1995 13:24:26   Shirley
** No change.
** 
**    Rev 1.3   29 Sep 1995 09:48:20   Shirley
** No change.
** 
**    Rev 1.2   20 Sep 1995 10:53:06   Shirley
** No change.
** 
**    Rev 1.1   15 Sep 1995 09:48:48   Shirley
** No change.
** 
**    Rev 1.0   07 Sep 1995 09:53:58   Shirley
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLHIST.CPP
//
//  Description:The implement file for the class: HistoryList
//
//  Author:     Roger Zhang
//
//  Date:       03/16/95
//
//  Modification:
//
//      1. 03/16/95, Initial version 
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "shlcom.h"
#include "shlhist.h"
    
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: HistoryElement                     //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement::HistoryElement(char * pch, int nLen)
 : m_isOK(TRUE)
{                    
    ASSERT(pch && nLen > 0);
    
    if((m_nLength = nLen) == 0)   return;
    if((m_pchElem = new char [nLen]) == 0)    m_isOK = FALSE;
    else {
        m_nLength = nLen;
        strncpy(m_pchElem, pch, m_nLength);
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement::~HistoryElement()
{
    if(m_isOK && m_nLength)    delete [] m_pchElem;
}                                          
                                          
/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//              Implement of the class: HistoryList                        //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryList::HistoryList(void)
: m_nMaxSize(nShellHistSize), m_isOK(TRUE), m_nElem(0), m_nPos(0),
  m_isRecall(FALSE)
{  
    if(m_nMaxSize && (m_Elem = new PHistoryElement[m_nMaxSize]) == 0) 
        m_isOK = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryList::~HistoryList()
{
    if(!m_isOK) return;
    if(!m_nMaxSize)   return;
    for(int i = 0; i < m_nElem; i ++) {
        delete m_Elem[i];
    }                  
    delete [] m_Elem;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
void HistoryList::DelHead(void)
{
    if(IsEmpty())   return;
    delete m_Elem[0];
    for(int i = 0; i < m_nElem - 1; i ++)
        m_Elem[i] = m_Elem[i + 1];
    -- m_nElem;
    m_nPos = IsEmpty() ? 0 : m_nElem - 1;
    m_isRecall = FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL HistoryList::AddTail(char * pch, int nLen)
{                                                   
    ASSERT(nLen >= 0 && pch);
                         
	if (nLen == 254) nLen++;                                                                                  
    
    HistoryElement * pElem = new HistoryElement(pch, nLen);
    if(!pElem || !(*pElem)) return FALSE;        
    if(IsFull())  DelHead();
    m_Elem[m_nElem++] = pElem;
    m_nPos = m_nElem - 1;            
    m_isRecall = FALSE;
    return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL HistoryList::SetMaxSize(int nMax)
{       
    ASSERT(nMax >= 0);
    
    if(nMax == m_nMaxSize)    return TRUE;
    
    PHistoryElement * p;
    int i;
    
    if(nMax && (p = new PHistoryElement[nMax]) == 0) return FALSE;
    if(nMax >= m_nElem) {
        for(i = 0; i < m_nElem; i ++) p[i] = m_Elem[i];
    }
    else {
        for(i = 0; i < nMax; i ++)  p[nMax - i - 1] = m_Elem[m_nElem - i - 1];
        for(i = 0; i < m_nElem - nMax; i ++)  delete m_Elem[i];
        m_nElem = nMax;        
    }                
    if(m_nMaxSize)   delete [] m_Elem;
    m_Elem = p;
    m_nMaxSize = nMax;
    m_nPos = m_nElem - 1;        
    m_isRecall = FALSE;
    return TRUE;
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: can't be empty 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement * HistoryList::GetPrev(void)
{
    ASSERT(!IsEmpty() && m_nMaxSize > 0);
    
    if(!m_isRecall) {
        m_isRecall = TRUE;
        return m_Elem[m_nPos];
    } else if(IsHead()) return m_Elem[m_nPos];
    else return m_Elem[--m_nPos];           
}                            

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: can't be empty
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
HistoryElement * HistoryList::GetNext(void)
{
    ASSERT(!IsEmpty() && m_nMaxSize > 0);

    if(IsTail()) {
        m_isRecall = FALSE;   return 0;
    } else return m_Elem[++m_nPos];
}

/////////////////////////////////////(EOF)///////////////////////////////////
                                   
