
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SHLSYNCO.CPP   1.2.1.4   17 Apr 1997 15:59:14   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SHLSYNCO.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:59:14   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:31:10   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:41:20   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:19:52   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:24:34   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:34:36   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:24   ZJRD
** Initial revision.
** 
**    Rev 1.0.1.2   09 Dec 1996 10:15:08   ZJRD
** EasyPack/SLD Version 2.0P
** 
**    Rev 1.0.1.0   11 Nov 1996 12:58:24   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.4   09 Sep 1996 13:15:44   ZJRD
** EasyPack/SLD Version 1.9f
** 
**    Rev 1.3   05 Sep 1996 11:27:16   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 09:54:24   ZJRD
** No change.
** 
**    Rev 1.1   28 Aug 1996 15:48:36   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.0   12 Aug 1996 10:53:02   ZJRD
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  SHLSYNCO.CPP
//
//  Description:The implement file of the class ShellSyntaxColor
//
//  Author:     Annie Yi
//
//  Date:       06/17/96
//
//  Modification:
//
//      1. 06/17/96, Initial version 
//
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
                                           
/////////////////////////////////////////////////////////////////////////////
// Include files.
#include "stdafx.h"
#include <ctype.h>
#include <direct.h>

#include "colors.h" 
#include "shlsynco.h"
#include "address.h"
#include "addrapi.h"
#include "aliaspub.h"
#include "hosterrs.h"
  
/////////////////////////////////////////////////////////////////////////////
// Debug flags.
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
  

/////////////////////////////////////////////////////////////////////////////
// Type definitions.


/////////////////////////////////////////////////////////////////////////////
// Macro definitions.


/////////////////////////////////////////////////////////////////////////////
// Global variables.     
int nMaxCmdNo = 62;
HintsList* pHintsList;
BOOL bFile = FALSE;

/////////////////////////////////////////////////////////////////////////////
// Static variables.


/////////////////////////////////////////////////////////////////////////////
// External variables.
extern char szAppPath[_MAX_PATH+1];

/////////////////////////////////////////////////////////////////////////////
// Global function prototypes.
void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[]) ;                        
void SplitCommand(CString strLine, CString& strCommand, int& nCount,
     CStringList* listHints);


/////////////////////////////////////////////////////////////////////////////
// Local function prototypes.

/////////////////////////////////////////////////////////////////////////////
// External function prototypes.
 

/////////////////////////////////////////////////////////////////////////////
// Executable codes.

/////////////////////////////////////////////////////////////////////////////
// Public functions.

void GetSyntaxColor(char* pszText, int nLength, int& nArgc, SynColor syncolor[])
{                             
    int nPos; 
    BOOL isOk = FALSE;
    CSyntaxCheckSub* pSyntax = new CSyntaxCheckSub;     
    isOk = pSyntax->CheckCommandSyntaxSub(pszText, nLength, nPos);    
    pSyntax->SetSyntaxColor(nPos, nArgc, syncolor);
    delete pSyntax;          
    
}

void MakeHints(void)
{   
    CString strPath, strFile;
    
    strPath = ::szAppPath;
    mkdir(strPath);                 
    strFile = strPath + "hints.dat";
    // Assign the open flag.
    CFileStatus status;
    if ( !CFile::GetStatus(strFile, status) ) {
        //AfxMessageBox("Error: Cannot find the file:hints.dat");
        char pchText[256];
        ErrGetErrorText(ER_NOT_FIND_FILE, pchText);
        AfxMessageBox(pchText);

        return;
    }                                       
    
    pHintsList = new HintsList[nMaxCmdNo];      
    // Open the record file.
    UINT nOpenFlag = CFile::modeRead | CFile::typeText;
    CStdioFile* fp = new CStdioFile(strFile, nOpenFlag);
    
        // Read from the record file.
    int nMax = 300;
    char* pszLine = new char[nMax];
    CString strCommand("");
    int nCount = 0;
        
    int i=0;
    while ( fp->ReadString(pszLine, nMax) ) {
        // Split string.                                          
        pHintsList[i].plistHints = new CStringList;
        
        SplitCommand(CString(pszLine), strCommand, nCount, pHintsList[i].plistHints);
        pHintsList[i].strCommand = strCommand;
        pHintsList[i].nCount = nCount;
        i++;
        if (i > nMaxCmdNo) break;                           
    }
    while (i<nMaxCmdNo) {
        pHintsList[i].strCommand = "";
        pHintsList[i].nCount = 0;
        pHintsList[i].plistHints = 0;   
        i++;    
    }
    delete []pszLine;
    
    // Close the record file.
    fp->Close();
    delete fp;      
    
    bFile = TRUE;   
}                                                                       


void SplitCommand(CString strLine, CString& strCommand, int& nCount,
     CStringList* plistHints)
{
    // Get Command token.        
    enum { delimiter = ';', space = ' ' };
    CString strTemp(strLine);
    int nFind = strLine.Find(delimiter);
    if ( -1 == nFind ) {
        return;
    }
    strCommand = strLine.Left(nFind);
    strTemp = strLine.Right(strLine.GetLength()-nFind-1);
    nFind = strTemp.Find(delimiter);             
    plistHints->RemoveAll();                                
    plistHints->AddTail(strCommand);         
    while ( -1 != nFind ) {
        plistHints->AddTail(strTemp.Left(nFind));         
        strTemp = strTemp.Right(strTemp.GetLength()-nFind-1);   
        nFind = strTemp.Find(delimiter);
    }
    nCount = plistHints->GetCount();
}   


void FreeHints(void)
{                        
    if ( !bFile ) return;
    if ( pHintsList == 0 ) return;
         
    for (int i = 0; i < nMaxCmdNo; i++) {
        if (pHintsList[i].plistHints) {
            POSITION posHead  = pHintsList[i].plistHints->GetHeadPosition();
            while (posHead) {
                (pHintsList[i].plistHints->GetNext(posHead)).Empty();    
            }               
            pHintsList[i].plistHints->RemoveAll();
            delete pHintsList[i].plistHints;
            pHintsList[i].plistHints = 0;
        }                                                
        
    }
    
    delete []pHintsList;
    pHintsList = 0; 
}

/////////////////////////////////////////////////////////////////////////////
// Implementation codes of class: CSyntaxCheckSub.

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::CSyntaxCheckSub().
//
//  Description: The construction of the class: CSyntaxCheckSub.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheckSub::CSyntaxCheckSub()
{
    
    m_nEvent = 0;
    
}   // End of CSyntaxCheckSub::CSyntaxCheckSub().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::~CSyntaxCheckSub().
//
//  Description: The destruction of the class: CSyntaxCheckSub.
//
//  Input:  None.
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CSyntaxCheckSub::~CSyntaxCheckSub()
{

}   // End of CSyntaxCheckSub::~CSyntaxCheckSub().


/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CSyntaxCheckSub::CheckCommandSyntaxSub().
//
//  Description: Main control routine of the class: CSyntaxCheckSub.
//
//  Input:  pchEditBuf - The line editor buffer.
//          nLen - The number of the characters in the line editor buffer.
//
//  Output: None.
//
//  Return: FALSE - syntax error; TRUE - syntax OK.
//
/////////////////////////////////////////////////////////////////////////////
BOOL CSyntaxCheckSub::CheckCommandSyntaxSub(const char* pchEditBuf, const int nLen, int& nPos)
{                           
    BOOL isTrue = FALSE;
    
    // Make a copy from the editor buffer.
    CopyCommandLine(pchEditBuf, nLen);

    // Parse the command's parameters.


    if ( !CommandParseSub() ) {
        ASSERT( FALSE );
        return (FALSE);
    }
 
    // Check command keyword.
    if ( !CheckCommandKeywordSub() ) {
        return FALSE;
    }
     
    // Call the syntax core.
    isTrue = SyntaxDispatchSub(m_nCommandID);

    nPos = m_nPos;
    
    return isTrue;
}    
                  
BOOL CSyntaxCheckSub::CommandParseSub(void)
{
    // Assertion of the input parameters.
    ASSERT( m_nLen > 0 && m_nLen <= MAX_CMDLINE+1 );
    for ( int i = 0; i < m_nLen; i++ ) {
        ASSERT( m_pchLineBuf[i] >= MIN_KEY && m_pchLineBuf[i] <= MAX_KEY );
    }

    char* pszTemp = new char[m_nLen+4];
    memset(pszTemp, 0, m_nLen+4);
    strcpy(pszTemp, m_pchLineBuf);
    CString str(pszTemp);
    int nPos = str.ReverseFind(';');
    if (nPos != -1) {
        str = str.Right(str.GetLength()-nPos-1);
        m_nLen = str.GetLength();
        strcpy(m_pchLineBuf, str);
    }                       
    
    delete []pszTemp;
    
    //For macro variable
    char* p = m_pchLineBuf;
    while (*p) {
        if ( isspace(*p) )
            p++;
        else
            break;  
    }           
    if ( '$' == *p ) {
        m_nArgc = 1;
        NewMem(m_pszArgv[0], m_nLen);

        strcpy(m_pszArgv[0], p);            
        return(TRUE);
    }                        
    
    // Get the token of the commands.
    char pszToken[MAX_CMDLINE+1];
    int nTokenLen = 0;
    BOOL isToken = FALSE;
    
    for ( i = 0; i < m_nLen; i++ ) {
        // Only for: "xxxx".
        if ( KEY_DQ == m_pchLineBuf[i] && TOKEN_KEY == m_pchLineBuf[i-1] ) {
            NewMem(m_pszArgv[m_nArgc], m_nLen-i+1);            
            if ( !m_pszArgv[m_nArgc] ) {
                ASSERT( FALSE );
                return (FALSE);
            }
            else {
                memcpy(m_pszArgv[m_nArgc], m_pchLineBuf+i, m_nLen-i);
                //m_pszArgv[m_nArgc++][m_nLen-i] = 0;
                int nPos = m_nLen-i-1;
                while (m_pszArgv[m_nArgc][nPos] == ' ') {
                    nPos--;                 
                }          
                m_pszArgv[m_nArgc++][nPos+1] = 0;                
                m_nToken = m_nArgc;
                return (TRUE);
            }    
        }

        // Normal case.
        if ( TOKEN_KEY == m_pchLineBuf[i] ) {
            if ( TRUE == isToken ) {
                pszToken[nTokenLen] = 0;
                NewMem(m_pszArgv[m_nArgc], nTokenLen*sizeof(char)+1);
                if ( !m_pszArgv[m_nArgc] ) {
                    ASSERT( FALSE );
                    return (FALSE);
                }
                else {
                    isToken = FALSE;
                    strcpy(m_pszArgv[m_nArgc++], pszToken);
                    nTokenLen = 0;
                }    
            }
        }
        else {
            if ( FALSE == isToken ) {
                isToken = TRUE;
            }
            pszToken[nTokenLen++] = m_pchLineBuf[i];
        }
    }
                         
    if ( m_pchLineBuf[m_nLen-2] != ' ') {
        m_nToken = (m_nArgc == 1) ? 1 : (m_nArgc - 1);      
    }                       
    else {
        m_nToken = m_nArgc;
    }   

    // Return back.
    return (TRUE);

}   // End of CSyntaxCheckSub::CommandParseSub(). 

                  
BOOL CSyntaxCheckSub::CheckCommandKeywordSub(void)
{
    // Assertion of the input parameters.
    ASSERT( 0 == m_nCommandID );
    if ( 0 == m_nArgc ) {
        m_nErrorID = NO_COMMAND;
        return (FALSE);
    }
    ASSERT( m_nArgc > 0 );
    ASSERT( m_pszArgv[0] );
    
    if ('@' == m_pszArgv[0][0]) {
        m_nCommandID = CMDID_RUNMACRO;
        return (TRUE);          
    }
    
    if ('$' == m_pszArgv[0][0]) {
        m_nCommandID = CMDID_VARDEFINE;
        return (TRUE);          
    }

    char* pszExpand = new char[21];
    char* pszHints = new char[400];
                                             
    int nRet = ::ExpandCommand(m_pszArgv[0], pszExpand, pszHints);
    
    if ( nRet != CCommandSet::NO_COMMAND) {
        NewMem(m_pszArgv[0], strlen(pszExpand) + 1);
        strcpy(m_pszArgv[0] , pszExpand); 
    }                                    
    delete []pszExpand;
    pszExpand = 0;
    
    delete []pszHints;
    pszHints = 0;
    
    // Detect the command ID.
    nRet = GetTotalCommandId(m_pszArgv[0]);
    
    if (nRet == CCommandSet::NO_COMMAND) {
        m_nErrorID = NO_SUCH_COMMAND;    
        return FALSE;
    }   
    else {
        m_nCommandID = nRet;
        return TRUE;
    }      
    return (FALSE);

}   // End of CSyntaxCheckSub::CheckCommandKeywordSub().
                                                                                                              

BOOL CSyntaxCheckSub::SyntaxDispatchSub(const int nCommandID)
{
    // Assertion of the input parameters.
    ASSERT( nCommandID >= MIN_CMDID && nCommandID <= MAX_CMDID );

    BOOL isTrue = FALSE;
    // Reset the error ID.
    m_nErrorID = 0;
    
    // Dispatch the syntax checking routine.
    switch ( nCommandID ) {    
    
        case CMDID_RUNMACRO:
            isTrue = SyntaxCheckRunMacroSub();
            break;
        case CMDID_VARDEFINE:
            isTrue = SyntaxCheckVarDefineSub();
            break;          
        case CMDID_ALIAS:
            isTrue = SyntaxCheckAliasSub();
            break;  
        case CMDID_ASSEMBLE:
            isTrue = SyntaxCheckAssembleSub();
            break;                             
        case CMDID_BIT:
            isTrue = SyntaxCheckBitSub();
            break;                             
        case CMDID_BREAKPOINT:
            isTrue = SyntaxCheckBreakpointSub();
            break;                     
        case CMDID_BYTE:
            isTrue = SyntaxCheckByteSub();
            break;                             
        case CMDID_CHECKSUM:
            isTrue = SyntaxCheckChecksumSub();
            break;
        case CMDID_CLEAR:
            isTrue = SyntaxCheckClearSub();
            break;             
        case CMDID_COMPARE:
            isTrue = SyntaxCheckCompareSub();
            break;
        case CMDID_CONTROL:
            isTrue = SyntaxCheckControlSub();
            break;
        case CMDID_COPY:                  
            isTrue = SyntaxCheckCopySub();
            break;
        case CMDID_CYCLE:                  
            isTrue = SyntaxCheckCycleSub();
            break;
        case CMDID_DISASSEMBLE:
            isTrue = SyntaxCheckChecksumSub();
            break;          
        case CMDID_DIAGNOSIS:
            //isTrue = SyntaxCheckDiagnosisSub();
            break;
        case CMDID_EVENT:
            isTrue = SyntaxCheckEventSub();
            break;
        case CMDID_EV1:  
            isTrue = SyntaxCheckEv1Sub();
            break;
        case CMDID_EV2:
            isTrue = SyntaxCheckEv2Sub();
            break;
        case CMDID_EV3:
            isTrue = SyntaxCheckEv3Sub();
            break;
        case CMDID_FILL:
            isTrue = SyntaxCheckFillSub();
            break;
        case CMDID_GO:
            isTrue = SyntaxCheckGoSub();
            break;
        case CMDID_HALT:
            isTrue = SyntaxCheckHaltSub();
            break;
        case CMDID_HELP:
            isTrue = SyntaxCheckHelpSub();
            break;
        case CMDID_IDENTIFY:
            isTrue = SyntaxCheckIdentifySub();
            break;
        case CMDID_INCLUDE:
            isTrue = SyntaxCheckIncludeSub();                      
            break;
        case CMDID_INPORT:
            isTrue = SyntaxCheckInportSub();
            break;
        case CMDID_JUMP:
            isTrue = SyntaxCheckJumpSub();
            break;
        case CMDID_LEVEL:
            isTrue = SyntaxCheckLevelSub();
            break;
        case CMDID_LIST:
            isTrue = SyntaxCheckListSub();
            break;
        case CMDID_LOG:
            isTrue = SyntaxCheckLogSub();
            break;
        case CMDID_LONG:
            isTrue = SyntaxCheckLongSub();
            break;
        case CMDID_LV1:
            isTrue = SyntaxCheckLv1Sub();
            break;
        case CMDID_LV2:
            isTrue = SyntaxCheckLv1Sub();
            break;
        case CMDID_MACRO:
            isTrue = SyntaxCheckMacroSub(); 
            break;    
        case CMDID_MAP:
            isTrue = SyntaxCheckMapSub(); 
            break;
        case CMDID_MDEL:
            isTrue = SyntaxCheckMdelSub(); 
            break;
        case CMDID_MEMORY:
            isTrue = SyntaxCheckMemorySub();
            break;
        case CMDID_MEND:
            isTrue = SyntaxCheckMendSub(); 
            break;
        case CMDID_MLIST:
            isTrue = SyntaxCheckMlistSub(); 
            break;
        case CMDID_OUTPORT:
            isTrue = SyntaxCheckOutportSub();
            break;           
        case CMDID_PORT:
            isTrue = SyntaxCheckPortSub();
            break;           
        case CMDID_QUALIFY:
            isTrue = SyntaxCheckEv2Sub();
            break;
        case CMDID_REGISTER:
            isTrue = SyntaxCheckRegisterSub();
            break;
        case CMDID_RESET:
            isTrue = SyntaxCheckResetSub();
            break;
        case CMDID_RESTART:
            isTrue = SyntaxCheckRestartSub();
            break;
        case CMDID_SAVEDISASM:
            isTrue = SyntaxCheckSavedisasmSub();
            break;          
        case CMDID_SEARCH:
            isTrue = SyntaxCheckSearchSub();
            break;       
        case CMDID_STEP:
            isTrue = SyntaxCheckStepSub();
            break;
        case CMDID_TEST:
            isTrue = SyntaxCheckTestSub();
            break;                 
        case CMDID_TIMER:
            isTrue = SyntaxCheckTimerSub();
            break;                 
        case CMDID_TRACE:
            isTrue = SyntaxCheckTraceSub();
            break;
        case CMDID_TRIGGER:
            isTrue = SyntaxCheckTriggerSub();
            break;
        case CMDID_UPLOAD:
            isTrue = SyntaxCheckUploadSub();
            break;
        case CMDID_VERIFY:
            isTrue = SyntaxCheckVerifySub();
            break;
        case CMDID_WORD:
            isTrue = SyntaxCheckWordSub();
            break;
        case CMDID_CREATE:
            isTrue = SyntaxCheckCreateSub();
            break;
        case CMDID_DELETE:
            isTrue = SyntaxCheckDeleteSub();
            break;
        case CMDID_LOAD:
            isTrue = SyntaxCheckLoadSub();
            break;
        case CMDID_QUERY:
            isTrue = SyntaxCheckQuerySub();
            break;
        case CMDID_SSAVE:
            isTrue = SyntaxCheckSsaveSub();
            break;
        case CMDID_SRECALL:
            isTrue = SyntaxCheckSrecallSub();
            break;
        case CMDID_SYMBOL:
            isTrue = SyntaxCheckSymbolSub();
            break;
        case CMDID_WATCH:
            isTrue = SyntaxCheckWatchSub();
            break;
            
        default:
            ASSERT( FALSE );
            break;
    }              

    return isTrue;
    
}   // End of CSyntaxCheckSub::SyntaxDispatchSub().

                                                    
BOOL CSyntaxCheckSub::SyntaxCheckRunMacroSub(void)
{                
    BOOL isTrue = FALSE;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            break;
        case 2:
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
        case 10:
        case 11:
            m_nPos = 1;
            break;
        default:           
            m_nPos = 100;
            break;
    }   
        
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckRunMacroSub(). 

BOOL CSyntaxCheckSub::SyntaxCheckVarDefineSub(void)
{                
    BOOL isTrue = FALSE;
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckVarDefineSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckAliasSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsCommandName(m_pszArgv[1]) ) {
                m_nPos = 1;
            }              
            else {
                m_nPos = 2;
                isTrue = TRUE;
            }
            break;                    
        case 3:               
            if ( !IsCommandName(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }    
            if ( !IsCommandName(m_pszArgv[2]) ) {
                m_nPos = 2;
                break;
            }        
            m_nPos = 100;      
            //isTrue = TRUE;            
            break;        
        default:
            if ( !IsCommandName(m_pszArgv[1]) ) {
                m_nPos = 2;
                break;
            }    
            if ( !IsCommandName(m_pszArgv[2]) ) {
                m_nPos = 100;
                break;
            }        
            break;
    }        
    
    return isTrue;    
    
}   //End of CSyntaxCheckSub::SyntaxCheckAliasSub().                                                    
                                              
                                              
BOOL CSyntaxCheckSub::SyntaxCheckAssembleSub(void)
{                
    BOOL isTrue = FALSE;    

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2: 
            if ( IsAddrPX(m_pszArgv[1]) ){
                m_nPos = 100;  
                isTrue = TRUE;
            }              
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsAddrPX(m_pszArgv[1]) ){
                m_nPos = 100;  
            }              
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckAssembleSub().                                                    
                                                 

BOOL CSyntaxCheckSub::SyntaxCheckBitSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:                  
            if ( IsBAddrDefault(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }
            break;                 
        case 3:            
            if ( IsBAddrDefault(m_pszArgv[1]) ) {
                if ( IsDataBit(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;        
        default:
            if ( IsBAddrDefault(m_pszArgv[1]) ) {
                if ( IsDataBit(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckBitSub().                                                    

                                                 
BOOL CSyntaxCheckSub::SyntaxCheckBreakpointSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;       
            isTrue = TRUE;
            break;
        case 2: 
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
                isTrue = TRUE;
            }              
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
            }              
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckBreakpointSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckByteSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:                  
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }
            break;                 
        case 3:            
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsData(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;        
        default:
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsData(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckByteSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckChecksumSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        
        case 3:
            if ( !IsAddrXPI(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 100;     
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 100;
                    isTrue = TRUE;
                }   
            }
            break;
        default:         
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 100;
                }   
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckChecksumSub().


BOOL CSyntaxCheckSub::SyntaxCheckClearSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:                
            m_nPos = 1; 
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordAll(m_pszArgv[1]) || IsPAddrDefault(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }             
            else {
                m_nPos = 1;
            }   
            break;
        default:
            if ( IsKeywordAll(m_pszArgv[1]) || IsPAddrDefault(m_pszArgv[1]) ) {
                m_nPos = 100;
            }             
            else {
                m_nPos = 1;
            }   
            break;
    }        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckClearSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckCompareSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        case 3:
            if ( !IsAddrXP(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXP(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4; 
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXP(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4;
                    isTrue = TRUE;
                }                    
                break;
            }         
            if ( !IsAddrXP(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;
                isTrue = TRUE;
            } 
            break;           
        case 5:
            if ( !IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXP(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsAddrXP(m_pszArgv[4]) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 100;   
                        isTrue = TRUE;
                    }   
                }                 
                break;
            }         
            if ( !IsAddrXP(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;
            }           
            break;           
        default:
            if ( !IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXP(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsAddrXP(m_pszArgv[4]) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 100;   
                    }   
                }   
                break;
            }                        
            if ( !IsAddrXP(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;
            }           
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckCompareSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckControlSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:           
            if ( IsKeywordControlOption(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }              
            else {
                m_nPos = 1;             
            }
            break;                 
        case 3:
            if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }         
            if ( !IsKeywordEnable(m_pszArgv[2]) && 
                 !IsKeywordDisable(m_pszArgv[2]) ) {
                m_nPos = 2;   
                break;       
            }                           
            else {
                m_nPos = 100;
                isTrue = TRUE;              
                break;
            }
            break;      
        default:
            if ( !IsKeywordControlOption(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }              
            if ( !IsKeywordEnable(m_pszArgv[2]) && 
                 !IsKeywordDisable(m_pszArgv[2]) ) {
                m_nPos = 2;          
            }                           
            else {
                m_nPos = 100;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckControlSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckCopySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        case 3:
            if ( !IsAddrXPI(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4; 
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4;
                    isTrue = TRUE;
                }                    
                break;
            }         
            if ( !IsAddrXPI(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;   
                isTrue = TRUE;
            } 
            break;           
        case 5:
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsAddrXPI(m_pszArgv[4]) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 100;   
                        isTrue = TRUE;
                    }   
                }                 
                break;
            }         
            if ( !IsAddrXPI(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;
            }           
            break;           
        default:
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsAddrXPI(m_pszArgv[4]) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 100;   
                    }   
                }   
                break;
            }                        
            if ( !IsAddrXPI(m_pszArgv[3]) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 100;
            }           
            break;
    }        
    
    return isTrue;
    
}   //End of CSyntaxCheckSub::SyntaxCheckCopySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckCycleSub(void)
{                
    BOOL isTrue = FALSE;     
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE;          
            break;
        default:
            break;
    }        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckCycleSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckDisassembleSub(void)
{                
    BOOL isTrue = TRUE;
        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckDisassembleSub().                                                    


/*
BOOL CSyntaxCheckSub::SyntaxCheckDiagnosisSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            break;
        case 2:           
            break;
        
        case 3:
            break;        
        case 4:          
            break;                              
        default:
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckDiagnosisSub().                                                    
*/

BOOL CSyntaxCheckSub::SyntaxCheckEventSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;      
            //SetSyntaxColorEvent();
            m_nEvent = 0; 
            isTrue = TRUE;          
            break;
        default:
            if ( IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            }                 
            if ( IsEventOption(m_pszArgv[1]) ) {
                if ( 0 == stricmp(m_pszArgv[1], "1") ) {
                    for ( int i = 0 ; i < (m_nToken-1); i++) {
                        NewMem(m_pszArgv[i], 300);
                        strcpy(m_pszArgv[i], m_pszArgv[i+1]);                   
                    }                                        
                    m_nPos--;
                    m_nToken--;
                    m_nCommandID = CMDID_EV1;
                    isTrue = SyntaxCheckEv1Sub();
                    m_nEvent = 1;
                    break;
                }
                if ( 0 == stricmp(m_pszArgv[1], "2") ) {
                    for ( int i = 0 ; i < (m_nToken-1); i++) {
                        NewMem(m_pszArgv[i], 300);
                        strcpy(m_pszArgv[i], m_pszArgv[i+1]);                   
                    }                                        
                    m_nPos--;
                    m_nToken--;
                    m_nCommandID = CMDID_EV2;
                    isTrue = SyntaxCheckEv2Sub();
                    m_nEvent = 2;
                    break;
                }
                if ( 0 == stricmp(m_pszArgv[1], "3") ) {
                    for ( int i = 0 ; i < (m_nToken-1); i++) {
                        NewMem(m_pszArgv[i], 300);
                        strcpy(m_pszArgv[i], m_pszArgv[i+1]);                   
                    }        
                    m_nPos--;  
                    m_nToken--;             
                    m_nCommandID = CMDID_EV3;                 
                    isTrue = SyntaxCheckEv3Sub();
                    m_nEvent = 3;
                    break;
                }
            }               
            m_nPos = 1;
            break;
        
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckEventSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv1Sub(void)
{                
    BOOL isTrue = FALSE;
    int nClear = 0; 
    BOOL nDup = FALSE;
    
    // Check command syntax.
    
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordAddress(m_pszArgv[1]) ) {
                m_nPos = 2;   
                isTrue = TRUE;
                break;
            }              
            if ( IsKeywordDatum(m_pszArgv[1]) ) {
                m_nPos = 3;   
                isTrue = TRUE;
                break;    
            }             
            if ( IsKeywordCount(m_pszArgv[1]) ) {
                m_nPos = 4;   
                isTrue = TRUE;
                break;
            }                      
            if ( IsKeywordStatus(m_pszArgv[1]) ) {
                m_nPos = 22;   
                isTrue = TRUE;
                break;
            }                      
            if ( IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;     
                isTrue = TRUE;
                break;
            }              
            m_nPos = 1;  
            break;             
        default:    
            if ( IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;     
                break;
            }              
            int nAddr = 0;
            int nDatum = 0; 
            int nStatus = 0;
            int nCount = 0;
            int nIndex = 0;
            for (int i = 1; i < m_nToken; i++) {
                if ( IsKeywordAddress(m_pszArgv[i]) ) {
                    if ( nAddr == 0 ) {
                        nAddr = i;  
                    }
                    else nDup = TRUE;   
                }           
                if ( IsKeywordDatum(m_pszArgv[i]) ) {
                    if ( nDatum == 0 ) 
                        nDatum = i;     
                    else nDup = TRUE;       
                }           
                if ( IsKeywordCount(m_pszArgv[i]) ) {
                    if ( nCount == 0 )
                        nCount = i; 
                    else nDup = TRUE;       
                }           
                if ( IsKeywordStatus(m_pszArgv[i]) ) {
                    if ( nStatus == 0 )
                        nStatus = i;    
                    else nDup = TRUE;       
                }                                                              
                if ( IsKeywordClear(m_pszArgv[i]) ) {
                    nClear = i;                                                     
                }
            }           
            nIndex = (nAddr > nDatum) ? nAddr : nDatum;
            nIndex = (nIndex > nCount) ? nIndex : nCount;
            nIndex = (nIndex > nStatus) ? nIndex : nStatus;
            if (nIndex == 0) {
                m_nPos = 1;
                break;
            }   
            if (nIndex == nAddr) {
                nIndex++;
                if (nIndex < m_nToken) {
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsPAddrDefault(m_pszArgv[nIndex]) &&
                                 IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                if ( (nDatum == 0) && (nCount == 0) && 
                                     (nStatus == 0) ) {
                                    m_nPos = 7;
                                    isTrue = TRUE;
                                    break;                               
                                }
                                if ( nDatum == 0 && nStatus == 0 ) {
                                    m_nPos = 15;       
                                    isTrue = TRUE;
                                    break;
                                }                               
                                if ( nStatus == 0 && nCount == 0 ) {
                                    m_nPos = 14;  
                                    isTrue = TRUE;
                                    break;
                                }    
                                if ( nDatum == 0 && nCount == 0 ) { 
                                    m_nPos = 23;  
                                    isTrue = TRUE;
                                    break;
                                }              
                                if ( nDatum == 0 ){
                                    m_nPos = 24;  
                                    isTrue = TRUE;
                                    break;
                                }    
                                if ( nStatus == 0 ){
                                    m_nPos = 25;  
                                    isTrue = TRUE;
                                    break;
                                }    
                                if ( nCount == 0 ){
                                    m_nPos = 26;  
                                    isTrue = TRUE;
                                    break;
                                }    
                                m_nPos = 100;
                                isTrue = TRUE;
                                break;
                            }         
                            if ( !IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 12;  
                                break;
                            }               
                            if ( !IsPAddrDefault(m_pszArgv[nIndex] ) ) {
                                m_nPos = 5;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nPos = 5;
                                break;
                            }
                            else {
                                isTrue = TRUE;
                                m_nPos = 12;
                                break;
                            }                                               
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos = 5;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }        
                    if ( !IsPAddrDefault(m_pszArgv[nIndex]) &&
                         !IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        m_nPos = 2;
                        break;                      
                    }
                    if ( IsPAddrDefault(m_pszArgv[nIndex]) ) {         
                        if ( (nDatum == 0) && (nCount == 0) && 
                             (nStatus == 0) ) {
                            m_nPos = 19;                       
                            isTrue = TRUE;
                            break;                               
                        }
                        if ( nDatum == 0 && nStatus == 0) {
                            m_nPos = 21;  
                            isTrue = TRUE;
                            break;
                        }              
                        if ( nStatus == 0 && nCount == 0 ){
                            m_nPos = 20;  
                            isTrue = TRUE;
                            break;
                        }             
                        if ( nCount == 0 && nDatum == 0 ){
                            m_nPos = 27;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nDatum == 0 ) {
                            m_nPos = 28;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nStatus == 0 ) {
                            m_nPos = 29;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nCount == 0 ) {
                            m_nPos = 30;  
                            isTrue = TRUE;
                            break;
                        }                               
                        m_nPos = 31;  
                        isTrue = TRUE;
                        break;                          
                    }
                    else {
                        if ( (nDatum == 0) && 
                             (nCount == 0) &&
                             (nStatus == 0 ) ) {
                            m_nPos = 7;                        
                            isTrue = TRUE;
                            break;                               
                        }
                        if ( nDatum == 0 && nStatus == 0 ) {
                            m_nPos = 15;  
                            isTrue = TRUE;
                            break;
                        }                         
                        if ( nCount == 0 && nStatus == 0 ){
                            m_nPos = 14;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nCount == 0 && nDatum == 0 ){
                            m_nPos = 23;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nDatum == 0 ) {
                            m_nPos = 24;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nStatus == 0 ) {
                            m_nPos = 25;  
                            isTrue = TRUE;
                            break;
                        }                                 
                        if ( nCount == 0 ) {
                            m_nPos = 26;  
                            isTrue = TRUE;
                            break;
                        }   
                        m_nPos = 100;
                        isTrue = TRUE;
                        break;                              
                    }       
                }
                m_nPos = 2;             
                isTrue = TRUE;
                break;
            }         
            if (nIndex == nDatum) {
                nIndex++;
                if (nIndex < m_nToken) {
                    //Datum Range data1 data2
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsEventData(m_pszArgv[nIndex]) &&
                                 IsEventData(m_pszArgv[nIndex+1] ) ) {
                                if ( (nAddr == 0) && (nCount == 0) &&
                                     (nStatus == 0) ) {
                                    m_nPos = 17;
                                    isTrue = TRUE;
                                    break;                               
                                }
                                if ( nAddr == 0 && nStatus == 0) {
                                    m_nPos = 16;  
                                    isTrue = TRUE;
                                    break;
                                }              
                                if ( nCount == 0 && nStatus == 0) {
                                    m_nPos = 14;  
                                    isTrue = TRUE;
                                    break;
                                }    
                                if ( nAddr == 0 && nCount == 0) {
                                    m_nPos = 32;  
                                    isTrue = TRUE;
                                    break;
                                }              
                                if ( nAddr == 0 ) {
                                    m_nPos = 33;  
                                    isTrue = TRUE;
                                    break;
                                }                                 
                                if ( nStatus == 0 ) {
                                    m_nPos = 25;  
                                    isTrue = TRUE;
                                    break;
                                }                                 
                                if ( nCount == 0 ) {
                                    m_nPos = 26;  
                                    isTrue = TRUE;
                                    break;
                                }   
                                m_nPos = 100;  
                                isTrue = TRUE;
                                break;                                      
                            }         
                            if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 13;
                                break;
                            }               
                            if ( !IsEventData(m_pszArgv[nIndex] ) ) {
                                m_nPos = 8;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nPos = 8;
                                break;
                            }             
                            else {
                                m_nPos = 13;      
                                isTrue = TRUE;
                                break;
                            }                           
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos = 8;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }    
                    //Datum xadr or badrs
                    if ( !IsEventData(m_pszArgv[nIndex]) &&
                         !IsWildcardData(m_pszArgv[nIndex]) ) {
                        m_nPos = 3;
                        break;                      
                    }             
                    if ( (nAddr == 0) && (nCount == 0) &&
                         (nStatus == 0) ) {
                        m_nPos = 17;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 && nStatus == 0) {
                        m_nPos = 16;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nCount == 0 && nStatus == 0) {
                        m_nPos = 14;  
                        isTrue = TRUE;
                        break;
                    }    
                    if ( nAddr == 0 && nCount == 0) {
                        m_nPos = 32;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nAddr == 0 ) {
                        m_nPos = 33;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nStatus == 0 ) {
                        m_nPos = 25;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nCount == 0 ) {
                        m_nPos = 26;  
                        isTrue = TRUE;
                        break;
                    }   
                    m_nPos = 100;  
                    isTrue = TRUE;
                    break;                                      
                }
                m_nPos = 3; 
                isTrue = TRUE;          
                break;
            }         
            if (nIndex == nCount) {
                nIndex++;
                if (nIndex < m_nToken) {
                    if ( !IsAddrData(m_pszArgv[nIndex]) ) {
                        m_nPos = 11;
                        break;
                    }       
                    if ( (nAddr == 0) && (nDatum == 0) &&
                         (nStatus == 0) ) {
                        m_nPos = 34;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 && nStatus == 0) {
                        m_nPos = 16;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nDatum == 0 && nStatus == 0) {
                        m_nPos = 15;  
                        isTrue = TRUE;
                        break;
                    }    
                    if ( nAddr == 0 && nDatum == 0) {
                        m_nPos = 34;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nAddr == 0 ) {
                        m_nPos = 33;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nStatus == 0 ) {
                        m_nPos = 25;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nDatum == 0 ) {
                        m_nPos = 24;  
                        isTrue = TRUE;
                        break;
                    }   
                    m_nPos = 100;  
                    isTrue = TRUE;
                    break;                                      
                }                
                m_nPos = 11;  
                isTrue = TRUE;
            }                        
            if (nIndex == nStatus) {
                nIndex++;
                if (nIndex < m_nToken) {             
                    while (nIndex < m_nToken ) {                    
                        if ( !IsStatusOption(m_pszArgv[nIndex]) ) {
                            m_nPos = 23;
                            //break;
                            goto AA;
                        }           
                        nIndex++;
                    }   
                    if ( (nAddr == 0) && (nDatum == 0) &&
                         (nCount == 0) ) {
                        m_nPos = 35;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 && nCount == 0) {
                        m_nPos = 32;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nDatum == 0 && nCount == 0) {
                        m_nPos = 23;  
                        isTrue = TRUE;
                        break;
                    }    
                    if ( nAddr == 0 && nDatum == 0) {
                        m_nPos = 34;  
                        isTrue = TRUE;
                        break;
                    }              
                    if ( nAddr == 0 ) {
                        m_nPos = 33;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nCount == 0 ) {
                        m_nPos = 26;  
                        isTrue = TRUE;
                        break;
                    }                                 
                    if ( nDatum == 0 ) {
                        m_nPos = 24;  
                        isTrue = TRUE;
                        break;
                    }   
                    m_nPos = 100;  
                    isTrue = TRUE;
                    break;                      
                }
                m_nPos = 22;  
                isTrue = TRUE;            
            }
            break;
    }        
                                 
AA:                                 
    if ( nClear != 0 || nDup == TRUE ) {
        isTrue = FALSE;
    }
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckEv1Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv2Sub(void)
{                
    BOOL isTrue = FALSE;
    int nClear = 0;                  
    BOOL nDup = FALSE;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordAddress(m_pszArgv[1]) ) {
                m_nPos = 2;   
                isTrue = TRUE;
                break;
            }              
            if ( IsKeywordDatum(m_pszArgv[1]) ) {
                m_nPos = 3;   
                isTrue = TRUE;
                break;    
            }             
            if ( IsKeywordStatus(m_pszArgv[1]) ) {
                m_nPos = 12;   
                isTrue = TRUE;
                break;
            }                      
            if ( IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;     
                isTrue = TRUE;
                break;
            }              
            m_nPos = 1;  
            break;             
        default:                    
            if ( IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;     
                break;
            }                   
            int nAddr = 0;
            int nDatum = 0;
            int nStatus = 0;
            int nIndex = 0;          
            for (int i = 1; i < m_nToken; i++) {
                if ( IsKeywordAddress(m_pszArgv[i]) ) {
                    if ( nAddr == 0 )
                        nAddr = i;  
                    else nDup = TRUE;       
                }           
                if ( IsKeywordDatum(m_pszArgv[i]) ) {
                    if ( nDatum == 0 )
                        nDatum = i; 
                    else nDup = TRUE;       
                }           
                if ( IsKeywordStatus(m_pszArgv[i]) ) {
                    if ( nStatus == 0 )
                        nStatus = i;    
                    else nDup = TRUE;       
                }                                                              
                if ( IsKeywordClear(m_pszArgv[i]) ) {
                    nClear = i;                                                     
                }
            }           
            nIndex = (nAddr > nDatum) ? nAddr : nDatum;
            nIndex = (nIndex > nStatus) ? nIndex : nStatus;
            if (nIndex == 0) {
                m_nPos = 1;
                break;
            }   
            if (nIndex == nAddr) {
                nIndex++;
                if (nIndex < m_nToken) {
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsPAddrDefault(m_pszArgv[nIndex]) &&
                                 IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                if ( nDatum == 0 && nStatus == 0 ) {                                
                                    m_nPos = 7;
                                    isTrue = TRUE;                                  
                                    break;       
                                }
                                if ( nDatum == 0 ) {
                                    m_nPos = 14;
                                    isTrue = TRUE;                                  
                                    break;       
                                }
                                if ( nStatus == 0 ) {                               
                                    m_nPos = 15; 
                                    isTrue = TRUE;                                  
                                    break;       
                                }                                                           
                                m_nPos = 100; 
                                isTrue = TRUE;                                  
                                break;      
                            }         
                            if ( !IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 5; 
                                break;
                            }               
                            if ( !IsPAddrDefault(m_pszArgv[nIndex] ) ) {
                                m_nPos = 4;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nPos = 4;
                                break;
                            }
                            else {
                                m_nPos = 5;       
                                isTrue = TRUE;
                                break;
                            }                                               
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos = 4;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }        
                    if ( !IsPAddrDefault(m_pszArgv[nIndex]) &&
                         !IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        m_nPos = 2;
                        break;                      
                    }
                    if ( IsPAddrDefault(m_pszArgv[nIndex]) ) {         
                        if ( nDatum == 0 && nStatus == 0 ) {                                
                            m_nPos = 8;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nDatum == 0 ) {
                            m_nPos = 17;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nStatus == 0 ) {                               
                            m_nPos = 18; 
                            isTrue = TRUE;                                  
                            break;       
                        }                                                           
                        m_nPos = 6;   
                        isTrue = TRUE;
                        break;                               
                    }
                    else {                     
                        if ( nDatum == 0 && nStatus == 0 ) {                                
                            m_nPos = 7;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nDatum == 0 ) {
                            m_nPos = 14;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nStatus == 0 ) {                               
                            m_nPos = 15; 
                            isTrue = TRUE;                                  
                            break;       
                        }                                                           
                        m_nPos = 100; 
                        isTrue = TRUE;
                        break;                                                                                                
                    }
                }
                m_nPos = 2;             
                isTrue = TRUE;
                break;
            }         
            if (nIndex == nDatum) {
                nIndex++;
                if (nIndex < m_nToken) {
                    //Datum Range adr1 adr2
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsEventData(m_pszArgv[nIndex]) &&
                                 IsEventData(m_pszArgv[nIndex+1] ) ) {
                                if ( nAddr == 0 && nStatus == 0) {
                                    m_nPos = 11;
                                    isTrue = TRUE;
                                    break;                               
                                }
                                if ( nAddr == 0 ) {
                                    m_nPos = 16;  
                                    isTrue = TRUE;
                                    break;                               
                                }            
                                if ( nStatus == 0 ) {
                                    m_nPos = 15;  
                                    isTrue = TRUE;
                                    break;                               
                                }                                           
                                m_nPos = 100;     
                                isTrue = TRUE;
                                break;                               
                                    
                                isTrue = TRUE;                                  
                            }         
                            if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 10;
                                break;
                            }               
                            if ( !IsEventData(m_pszArgv[nIndex] ) ) {
                                m_nPos = 9;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nPos = 9;
                                break;
                            }             
                            else {
                                m_nPos = 10;  
                                isTrue = TRUE;
                                break;
                            }                           
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos = 9;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }    
                    //Datum xadr or badrs..
                    if ( !IsEventData(m_pszArgv[nIndex]) &&
                         !IsWildcardData(m_pszArgv[nIndex]) ) {
                        m_nPos = 3;
                        break;                      
                    }             
                    if ( nAddr == 0 && nStatus == 0) {
                        m_nPos = 11;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 ) {
                        m_nPos = 16;  
                        isTrue = TRUE;
                        break;                               
                    }            
                    if ( nStatus == 0 ) {
                        m_nPos = 15;  
                        isTrue = TRUE;
                        break;                               
                    }                                           
                    m_nPos = 100; 
                    isTrue = TRUE;
                    break;                               
                }
                m_nPos = 3;             
                isTrue = TRUE;
                break;
            }         
            if (nIndex == nStatus ) {
                nIndex++;
                if (nIndex < m_nToken) {
                    while (nIndex < m_nToken ) {                    
                        if ( !IsStatusOption(m_pszArgv[nIndex]) ) {
                            m_nPos = 23;
                            //break;
                            goto AA;
                        }                       
                        nIndex++;
                    }   
                    if ( (nAddr == 0) && (nDatum == 0) ) {
                        m_nPos = 13;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 ) {
                        m_nPos = 16;  
                        isTrue = TRUE;
                        break;                               
                    }            
                    if ( nDatum == 0 ) {
                        m_nPos = 14;  
                        isTrue = TRUE;
                        break;                               
                    }              
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;                        
                }                             
                m_nPos = 12;  
                isTrue = TRUE;            
                
            break;
        }    
    }        
AA:
    if ( nClear != 0 || nDup == TRUE ) {
        isTrue = FALSE;
    }
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckEv2Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckEv3Sub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsEvent3Option(m_pszArgv[1]) ) {
                m_nPos = 100;   
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;            
            }                       
            break;                
        default:
            if ( !IsEvent3Option(m_pszArgv[1]) ) {
                m_nPos = 1;
            }
            else {
                m_nPos = 100;            
            }                       
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckEv3Sub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckFillSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        case 3:
            if ( !IsAddrAllX(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4;  
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddr(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4;
                    isTrue = TRUE;
                }                    
                break;
            }         
            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5;          
                isTrue = TRUE;
            } 
            break;           
        case 5:
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 5; 
                        isTrue = TRUE;
                    }   
                }                 
                break;
            }         
            if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5; 
                isTrue = TRUE;
            }           
            break;           
        default:
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsData(m_pszArgv[4]) && !IsString(m_pszArgv[4])) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 5; 
                    }   
                }   
                break;
            }                        
            if ( !IsData(m_pszArgv[3]) && !IsString(m_pszArgv[3])) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5;
            }           
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckFillSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckGoSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:           
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }             
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
                m_nPos = 3;
                isTrue = TRUE;
                break;
            }                 
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                m_nPos = 4;
                isTrue = TRUE;
                break;
            }                 
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
                m_nPos = 5;
                isTrue = TRUE;
                break;
            }                 
            m_nPos = 1;  
            break;                   
        case 3:              
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordFrom(m_pszArgv[2]) ) {
                    m_nPos = 6;
                    isTrue = TRUE;                      
                }   
                else {
                    m_nPos = 2;
                }              
                break;
            }         
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 7;
                    isTrue = TRUE;                      
                }   
                else {
                    m_nPos = 3;
                }              
                break;
            }                   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;                      
                }   
                else {
                    m_nPos = 4;
                }              
                break;
            }                               
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
                if ( IsGoMonitorTimer(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;                      
                }   
                else {
                    m_nPos = 5;
                }              
                break;
            }         
            m_nPos = 1;
            break;        
        case 4:             
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordFrom(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;                      
                    }   
                    else {
                        m_nPos = 6;
                    }
                }                               
                else {
                    m_nPos = 2;
                }              
                break;
            }   
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsKeywordTill(m_pszArgv[3]) ) {
                        m_nPos = 8;
                        isTrue = TRUE;                      
                    }   
                    else {
                        m_nPos = 7;
                    }
                }                               
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }   
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
                if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
                    m_nPos = 5;                     
                }                               
                else {
                    m_nPos = 100;
                }              
                break;
            }   
            m_nPos = 1;        
            break;                              
        case 5:             
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordFrom(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }   
                    else {
                        m_nPos = 6;
                    }
                }                               
                else {
                    m_nPos = 2;
                }              
                break;
            }   
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsKeywordTill(m_pszArgv[3]) ) {     
                        if ( IsPAddrDefault(m_pszArgv[4]) ) {                           
                            m_nPos = 100;
                            isTrue = TRUE;                      
                        }            
                        else {
                            m_nPos = 8;
                        }
                    }   
                    else {
                        m_nPos = 7;
                    }
                }                               
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }   
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
                if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
                    m_nPos = 5;                     
                }                               
                else {
                    m_nPos = 100;
                }              
                break;
            }   
            m_nPos = 1;        
            break;                              
        default:
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordFrom(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }   
                    else {
                        m_nPos = 6;
                    }
                }                               
                else {
                    m_nPos = 2;
                }              
                break;
            }   
            if ( IsKeywordFrom(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsKeywordTill(m_pszArgv[3]) ) {
                        if ( IsPAddrDefault(m_pszArgv[4]) ) {
                            m_nPos = 100;
                        }
                        else {  
                            m_nPos = 8;
                        }   
                    }   
                    else {
                        m_nPos = 7;
                    }
                }                               
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }   
                else {
                    m_nPos = 3;
                }              
                break;
            }   
            if ( IsKeywordMonitor(m_pszArgv[1]) ) {
                if ( !IsGoMonitorTimer(m_pszArgv[2]) ) {
                    m_nPos = 5;                     
                }                               
                else {
                    m_nPos = 100;
                }              
                break;
            }   
            m_nPos = 1;        
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckGoSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckHaltSub(void)
{                
    BOOL isTrue = FALSE;             
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;               
            isTrue = TRUE;          
            break;
        default:
            break;
    }        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckHaltSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckHelpSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:           
            if ( IsCommand(m_pszArgv[1]) ) {
                m_nPos = 100;  
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsCommand(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckHelpSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckIdentifySub(void)
{                
    BOOL isTrue = TRUE;

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckIdentifySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckIncludeSub(void)
{                

    BOOL isTrue = FALSE;
    int nRet = 0;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;
            isTrue = TRUE;  
            break;
        case 2:           
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                m_nPos = 100;  
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                m_nPos = 100;  
            }
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckIncludeSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckInportSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:        
            if ( IsPort(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }      
            m_nPos = 1;
            break;                    
        case 3:
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;        
        case 4:          
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) { 
                    if ( IsBitNo(m_pszArgv[3]) ) { 
                        m_nPos = 100;
                        isTrue = TRUE;
                    }
                    else {  
                        m_nPos = 3;
                    }   
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;                              
        default:
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) { 
                    if ( IsBitNo(m_pszArgv[3]) ) { 
                        m_nPos = 100;
                    }
                    else {  
                        m_nPos = 3;
                    }   
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckInportSub().                                                    

BOOL CSyntaxCheckSub::SyntaxCheckJumpSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2: 
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
                isTrue = TRUE;
            }              
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
            }              
            else {
                m_nPos = 1;
            }     
            break;
    }        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckJumpSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckLevelSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:       
            if ( 0 == stricmp(m_pszArgv[1], "1") ||
                 0 == stricmp(m_pszArgv[1], "2") ) {
                m_nPos = 2;
                isTrue = TRUE;                          
            }
            else {
                m_nPos = 1;
            }             
            break;
        default:
            // m_nArgc >= 3.
            char pszEventSeq[255];
            int nIndex = 2;
            memset(pszEventSeq, 0, sizeof(pszEventSeq));
            for ( int i = 2; i < m_nToken; i++ ) {
                if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                     0 != stricmp(m_pszArgv[i], "TIMER") ) {
                    strcat(pszEventSeq, m_pszArgv[i]);
                    strcat(pszEventSeq, " ");
                    nIndex++;
                }
                else {
                    break;
                }
            }
            if ( 2 == nIndex ) {
                m_nPos = 2;
                return isTrue;
            }
            
            // Check Event Sequence.
            if ( !IsEventSequence(pszEventSeq) ) {
                m_nPos = 2;
                return isTrue;
            }
            
            // Check Trace or Timer.
            switch ( m_nArgc - nIndex ) {
                case 0:
                    m_nPos = 3;
                    isTrue = TRUE;
                    break;
                case 1:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        m_nPos = 4;
                        isTrue = TRUE;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        m_nPos = 5;
                        isTrue = TRUE;
                        break;
                    }
                    m_nPos = 3;
                    break;    
                case 2:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 6;
                            isTrue = TRUE;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;
                            break;
                        }     
                        m_nPos = 5;
                        break;
                    }
                    m_nPos = 3;
                    break;
                case 3:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                                m_nPos = 5;
                                isTrue = TRUE;
                                break;                                  
                            }
                            m_nPos = 6;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 5;
                        break;
                    }
                    m_nPos = 3;
                    break;
                case 4:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {  
                                if ( IsKeywordOn(m_pszArgv[nIndex+3]) ||
                                     IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                                    m_nPos = 100;                   
                                    isTrue = TRUE;
                                    break;
                                }     
                                m_nPos = 5;
                                break;                                  
                            }
                            m_nPos = 6;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 5;
                        break;
                    }
                    m_nPos = 3;
                    break;
                default:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {  
                                if ( IsKeywordOn(m_pszArgv[nIndex+3]) ||
                                     IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                                    m_nPos = 100;                   
                                    break;
                                }     
                                m_nPos = 5;
                                break;                                  
                            }
                            m_nPos = 6;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 5;
                        break;
                    }
                    m_nPos = 3;                 
                    break;
            }                  
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckLevelSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckListSub(void)
{                
    BOOL isTrue = FALSE;
    BOOL nDup = FALSE;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:                              
            if ( IsKeywordNumber(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            } 
            if ( IsListOptionSub(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }             
            if ( IsListFrameSub(m_pszArgv[1]) ) {
                m_nPos = 3;
                isTrue = TRUE;
                break;
            }             
            if ( IsKeywordAddress(m_pszArgv[1]) ) {
                m_nPos = 4;
                isTrue = TRUE;
                break;
            }                                
            if ( IsKeywordDatum(m_pszArgv[1]) ) {
                m_nPos = 5;
                isTrue = TRUE;
                break;
            }           
            if ( IsKeywordStatus(m_pszArgv[1]) ) {
                m_nPos = 12;
                isTrue = TRUE;
                break;
            }                       
            m_nPos = 1;
            break;             
        case 3:        
            if ( IsKeywordNumber(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            } 
            if ( IsListOptionSub(m_pszArgv[1]) ) {
                if ( IsListFrameSub(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                    break;
                }   
                if ( IsKeywordAddress(m_pszArgv[2]) ) {
                    m_nPos = 4;
                    isTrue = TRUE;
                    break;
                }                                
                if ( IsKeywordDatum(m_pszArgv[2]) ) {
                    m_nPos = 5;
                    isTrue = TRUE;
                    break;
                }                                                   
                if ( IsKeywordStatus(m_pszArgv[2]) ) {
                    m_nPos = 12;
                    isTrue = TRUE;
                    break;
                }                       
                m_nPos = 2;
                break;
            }             
            if ( IsListFrameSub(m_pszArgv[1]) ) {
                if ( IsKeywordAddress(m_pszArgv[2]) ) {
                    m_nPos = 4;
                    isTrue = TRUE;
                    break;
                }                                
                if ( IsKeywordDatum(m_pszArgv[2]) ) {
                    m_nPos = 5;
                    isTrue = TRUE;
                    break;
                }                       
                if ( IsKeywordStatus(m_pszArgv[2]) ) {
                    m_nPos = 12;
                    isTrue = TRUE;
                    break;
                }                       
                m_nPos = 3;
                break;
            }             
            if ( IsKeywordAddress(m_pszArgv[1]) ) {
                if ( IsKeywordRange(m_pszArgv[2]) ) {
                    m_nPos = 6;
                    isTrue = TRUE;
                    break;
                }
                if ( IsWildcardAddr(m_pszArgv[2]) ) {
                    m_nPos = 7;
                    isTrue = TRUE;
                    break;
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 8;   
                    isTrue = TRUE;
                    break;
                }                           
                m_nPos = 4;
                break;
            }                                
            if ( IsKeywordDatum(m_pszArgv[1]) ) {
                if ( IsKeywordRange(m_pszArgv[2]) ) {
                    m_nPos = 9;
                    isTrue = TRUE;
                    break;
                }        
                if ( IsEventData(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }     
                if ( IsWildcardData(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }           
                m_nPos = 5;
                break;
            }                                    
            if ( IsKeywordStatus(m_pszArgv[1]) ) {
                if ( IsStatusOption(m_pszArgv[2]) ) {
                    m_nPos = 20;
                    isTrue = TRUE;
                    break;
                }           
                m_nPos = 12;
                break;
            }           
            m_nPos = 1;
            break;        
        default:
            if ( IsKeywordNumber(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                   
            int nIndex = 0;
            int nAddr = 0;
            int nDatum = 0;
            int nStatus = 0;
            for (int i = 1; i < m_nToken; i++) {
                if ( IsKeywordAddress(m_pszArgv[i]) ) {
                    if ( nAddr == 0 )
                        nAddr = i;  
                    else nDup = TRUE;       
                }           
                if ( IsKeywordDatum(m_pszArgv[i]) ) {
                    if ( nDatum == 0 )
                        nDatum = i; 
                    else nDup = TRUE;       
                }           
                if ( IsKeywordStatus(m_pszArgv[i]) ) {
                    if ( nStatus == 0 )
                        nStatus = i;    
                    else nDup = TRUE;       
                }                                                              
            }           

            nIndex = (nAddr > nDatum) ? nAddr : nDatum;
            nIndex = (nIndex > nStatus) ? nIndex : nStatus;
            if (nIndex == 0) {
                m_nPos = 3;
                break;
            }   
            if (nIndex == nAddr) {
                nIndex++;
                if (nIndex < m_nToken) {
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsPAddrDefault(m_pszArgv[nIndex]) &&
                                 IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                if ( nDatum == 0 && nStatus == 0 ) {                                
                                    m_nPos = 7;
                                    isTrue = TRUE;                                  
                                    break;       
                                }
                                if ( nDatum == 0 ) {
                                    m_nPos = 13;
                                    isTrue = TRUE;                                  
                                    break;       
                                }
                                if ( nStatus == 0 ) {                               
                                    m_nPos = 14; 
                                    isTrue = TRUE;                                  
                                    break;       
                                }                                                           
                                m_nPos = 100; 
                                isTrue = TRUE;                                  
                                break;      
                            }         
                            if ( !IsPAddrDefault(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 10; 
                                break;
                            }               
                            if ( !IsPAddrDefault(m_pszArgv[nIndex] ) ) {
                                m_nPos = 6;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsPAddrDefault(m_pszArgv[nIndex]) ) {
                                m_nPos = 6;
                                break;
                            }
                            else {
                                m_nPos = 10;       
                                isTrue = TRUE;
                                break;
                            }                                               
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos =6;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }        
                    if ( !IsPAddrDefault(m_pszArgv[nIndex]) &&
                         !IsWildcardAddr(m_pszArgv[nIndex]) ) {
                        m_nPos = 4;
                        break;                      
                    }
                    if ( IsPAddrDefault(m_pszArgv[nIndex]) ) {         
                        if ( nDatum == 0 && nStatus == 0 ) {                                
                            m_nPos = 8;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nDatum == 0 ) {
                            m_nPos = 15;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nStatus == 0 ) {                               
                            m_nPos = 16; 
                            isTrue = TRUE;                                  
                            break;       
                        }                                                           
                        m_nPos = 17;   
                        isTrue = TRUE;
                        break;                               
                    }
                    else {                     
                        if ( nDatum == 0 && nStatus == 0 ) {                                
                            m_nPos = 7;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nDatum == 0 ) {
                            m_nPos = 13;
                            isTrue = TRUE;                                  
                            break;       
                        }
                        if ( nStatus == 0 ) {                               
                            m_nPos = 14; 
                            isTrue = TRUE;                                  
                            break;       
                        }                                                           
                        m_nPos = 100; 
                        isTrue = TRUE;
                        break;                                                                                                
                    }
                }
                m_nPos = 4;             
                isTrue = TRUE;
                break;
            }         
            if (nIndex == nDatum) {
                nIndex++;
                if (nIndex < m_nToken) {
                    //Datum Range adr1 adr2
                    if ( IsKeywordRange(m_pszArgv[nIndex]) ) {
                        nIndex++;
                        if ( (nIndex+2) <= m_nToken ) {
                            if ( IsEventData(m_pszArgv[nIndex]) &&
                                 IsEventData(m_pszArgv[nIndex+1] ) ) {
                                if ( nAddr == 0 && nStatus == 0) {
                                    m_nPos = 18;
                                    isTrue = TRUE;
                                    break;                               
                                }
                                if ( nAddr == 0 ) {
                                    m_nPos = 19;  
                                    isTrue = TRUE;
                                    break;                               
                                }            
                                if ( nStatus == 0 ) {
                                    m_nPos = 14;  
                                    isTrue = TRUE;
                                    break;                               
                                }                                           
                                m_nPos = 100;     
                                isTrue = TRUE;
                                break;                               
                            }         
                            if ( !IsEventData(m_pszArgv[nIndex+1] ) ) {
                                m_nPos = 11;
                                break;
                            }               
                            if ( !IsEventData(m_pszArgv[nIndex] ) ) {
                                m_nPos = 9;
                                break;
                            }                           
                        }
                        if ( (nIndex+1) == m_nToken ) {
                            if ( !IsEventData(m_pszArgv[nIndex]) ) {
                                m_nPos = 9;
                                break;
                            }             
                            else {
                                m_nPos = 11;  
                                isTrue = TRUE;
                                break;
                            }                           
                        }    
                        if ( nIndex == m_nToken ) {
                            m_nPos = 9;       
                            isTrue = TRUE;
                            break;
                        }
                        break;
                    }    
                    //Datum xadr or badrs..
                    if ( !IsEventData(m_pszArgv[nIndex]) &&
                         !IsWildcardData(m_pszArgv[nIndex]) ) {
                        m_nPos = 5;
                        break;                      
                    }             
                    if ( nAddr == 0 && nStatus == 0) {
                        m_nPos = 18;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 ) {
                        m_nPos = 19;  
                        isTrue = TRUE;
                        break;                               
                    }            
                    if ( nStatus == 0 ) {
                        m_nPos = 14;  
                        isTrue = TRUE;
                        break;                               
                    }                                           
                    m_nPos = 100; 
                    isTrue = TRUE;
                    break;                               
                }
                m_nPos = 4;             
                isTrue = TRUE;
                break;
            }         
            if (nIndex == nStatus ) {
                nIndex++;
                if (nIndex < m_nToken) {
                    while (nIndex < m_nToken ) {                    
                        if ( !IsStatusOption(m_pszArgv[nIndex]) ) {
                            m_nPos = 12;
                            //break;
                            goto AA;
                        }                       
                        nIndex++;
                    }   
                    if ( (nAddr == 0) && (nDatum == 0) ) {
                        m_nPos = 20;
                        isTrue = TRUE;
                        break;                               
                    }
                    if ( nAddr == 0 ) {
                        m_nPos = 19;  
                        isTrue = TRUE;
                        break;                               
                    }            
                    if ( nDatum == 0 ) {
                        m_nPos = 13;  
                        isTrue = TRUE;
                        break;                               
                    }              
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;                        
                }                             
                m_nPos = 12;  
                isTrue = TRUE;                            
                break;
        }    

    }        
AA:
    if ( nDup == TRUE ) {
        isTrue = FALSE;
    }
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckListSub().                                                    
                    
                    
BOOL CSyntaxCheckSub::SyntaxCheckLogSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;                                                
                                                        
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            }
            if ( IsFilename(m_pszArgv[1], nRet) ) { 
                if ( !IsKeywordCommand(m_pszArgv[1]) && 
                     !IsKeywordAppend(m_pszArgv[1] )) {                    
                    m_nPos = 2;
                    isTrue = TRUE;
                    break;
                }
                else {
                    m_nPos = 2;
                    isTrue = FALSE;
                    break;
                }   
            }
            m_nPos = 1;
            break;              
        case 3:         
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                if (IsKeywordCommand(m_pszArgv[2]) ) {                    
                    m_nPos = 3;
                    isTrue = TRUE;
                    break;
                }   
                if (IsKeywordAppend(m_pszArgv[2]) ) { 
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }   
                m_nPos = 2;
                break;
            }             
            m_nPos = 1;         
            break;        
        case 4:         
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;   
                    }
                    else {
                        m_nPos = 3;
                    }                    
                    break;
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 2;
                }     
                break;
            }             
            m_nPos = 1;         
            break;               
        default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClose(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                if (IsKeywordCommand(m_pszArgv[2]) ) {
                    if (IsKeywordAppend(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }
                    else {
                        m_nPos = 3;
                    }
                    break;                    
                }            
                if (IsKeywordAppend(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 2;
                }     
                break;
            }             
            m_nPos = 1;         
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckLogSub().                                                    

BOOL CSyntaxCheckSub::SyntaxCheckLongSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:                  
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }
            break;                 
        case 3:            
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsDataLong(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;        
        default:
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsDataLong(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckLongSub().                                                    

                                             
BOOL CSyntaxCheckSub::SyntaxCheckLv1Sub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        default:
            // m_nArgc >= 3.
            char pszEventSeq[255];
            int nIndex = 1;
            memset(pszEventSeq, 0, sizeof(pszEventSeq));
            for ( int i = 1; i < m_nToken; i++ ) {
                if ( 0 != stricmp(m_pszArgv[i], "TRACE") &&
                     0 != stricmp(m_pszArgv[i], "TIMER") ) {
                    strcat(pszEventSeq, m_pszArgv[i]);
                    strcat(pszEventSeq, " ");
                    nIndex++;
                }
                else {
                    break;
                }
            }
            if ( 1 == nIndex ) {
                m_nPos = 1;
                return isTrue;
            }
            
            // Check Event Sequence.
            if ( !IsEventSequence(pszEventSeq) ) {
                m_nPos = 1;
                return isTrue;
            }
            
            // Check Trace or Timer.
            switch ( m_nArgc - nIndex ) {
                case 0:
                    m_nPos = 2;
                    isTrue = TRUE;
                    break;
                case 1:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        m_nPos = 3;
                        isTrue = TRUE;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        m_nPos = 4;
                        isTrue = TRUE;
                        break;
                    }
                    m_nPos = 2;
                    break;    
                case 2:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 5;
                            isTrue = TRUE;
                            break;
                        }     
                        m_nPos = 3;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 2;
                    break;
                case 3:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {
                                m_nPos = 4;
                                isTrue = TRUE;
                                break;                                  
                            }
                            m_nPos = 5;
                            break;
                        }     
                        m_nPos = 3;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 2;
                    break;
                case 4:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {  
                                if ( IsKeywordOn(m_pszArgv[nIndex+3]) ||
                                     IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                                    m_nPos = 100;                   
                                    isTrue = TRUE;
                                    break;
                                }     
                                m_nPos = 4;
                                break;                                  
                            }
                            m_nPos = 5;
                            break;
                        }     
                        m_nPos = 3;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 3;
                    break;
                default:
                    if ( IsKeywordTrace(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            if ( IsKeywordTimer(m_pszArgv[nIndex+2]) ) {  
                                if ( IsKeywordOn(m_pszArgv[nIndex+3]) ||
                                     IsKeywordOff(m_pszArgv[nIndex+3]) ) {
                                    m_nPos = 100;                   
                                    break;
                                }     
                                m_nPos = 4;
                                break;                                  
                            }
                            m_nPos = 5;
                            break;
                        }     
                        m_nPos = 3;
                        break;
                    }
                    if ( IsKeywordTimer(m_pszArgv[nIndex]) ) {
                        if ( IsKeywordOn(m_pszArgv[nIndex+1]) ||
                             IsKeywordOff(m_pszArgv[nIndex+1]) ) {
                            m_nPos = 100;
                            break;
                        }     
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 2;                 
                    break;
            }                  
            break;
    }        
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckLv1Sub().                                                    
                                            
/*                                            
BOOL CSyntaxCheckSub::SyntaxCheckLv2Sub(void)
{                
    
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            break;
        case 2: 
            break;
        default:
            break;
    }        
    
    return isTrue;    

}   //End of CSyntaxCheckSub::SyntaxCheckLv2Sub().                                                    
*/                                             
                                             
BOOL CSyntaxCheckSub::SyntaxCheckMacroSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;  
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMacroSub().                                                    
                                    
                                    
BOOL CSyntaxCheckSub::SyntaxCheckMapSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2: 
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                m_nPos = 2;  
                isTrue = TRUE;
                break;
            }             
            if ( IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 3;  
                isTrue = TRUE;
                break;
            }             
            m_nPos = 1;  
            break;       
        case 3: 
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( IsMapMemType(m_pszArgv[2]) ) {
                    m_nPos = 4;  
                    isTrue = TRUE;
                    break;              
                }
                m_nPos = 2;  
                break;
            }             
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    m_nPos = 5;  
                    isTrue = TRUE;
                    break;                  
                }                                     
                if ( IsAddrXP(m_pszArgv[2]) ) {
                    m_nPos = 4;  
                    isTrue = TRUE;
                    break;                      
                }
                m_nPos = 3;  
                break;
            }             
            m_nPos = 1;  
            break;       
        case 4:             
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( IsMapMemType(m_pszArgv[2]) ) {
                    if ( IsMapAttr(m_pszArgv[2][0],m_pszArgv[3]) ) {
                        m_nPos = 100;  
                        isTrue = TRUE;
                        break;                                          
                    }
                    m_nPos = 4;  
                    break;              
                }
                m_nPos = 2;  
                break;
            }             
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        m_nPos = 4;  
                        isTrue = TRUE;
                        break;                                          
                    }
                    m_nPos = 5;  
                    break;                  
                }                                     
                if ( IsAddrXP(m_pszArgv[2]) ) {
                    if ( IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( IsMapAttr('X',m_pszArgv[3]) ) {
                        m_nPos = 100;  
                        isTrue = TRUE;
                        break;                          
                        }                 
                    }   
                    else {                  
                        if ( IsMapAttr('P',m_pszArgv[3]) ) {
                        m_nPos = 100;  
                        isTrue = TRUE;
                        break;                          
                        }                 
                    }
                    m_nPos = 4;  
                    break;                      
                }
                m_nPos = 3;  
                break;
            }             
            m_nPos = 1;  
            break;                  
        case 5:             
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( IsMapMemType(m_pszArgv[2]) ) {
                    if ( IsMapAttr(m_pszArgv[2][0],m_pszArgv[3]) ) {
                        m_nPos = 100;  
                        break;                                          
                    }
                    m_nPos = 4;  
                    break;              
                }
                m_nPos = 2;  
                break;
            }             
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        if ( IsXAddrDefault(m_pszArgv[1]) ) {
                            if (IsMapAttr('X',m_pszArgv[4]) ) {
                                m_nPos = 100;  
                                isTrue = TRUE;
                                break;                                          
                            }                       
                        }   
                        else {                      
                            if (IsMapAttr('P',m_pszArgv[4]) ) {
                                m_nPos = 100;  
                                isTrue = TRUE;
                                break;                                          
                            }                       
                        }   
                        m_nPos = 4;  
                        break;                                          
                    }
                    m_nPos = 5;  
                    break;                  
                }                                     
                if ( IsAddrXP(m_pszArgv[2]) ) {              
                    if ( IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( IsMapAttr('X',m_pszArgv[3]) ) {
                            m_nPos = 100;  
                            break;                          
                        }   
                    }   
                    else {
                        if ( IsMapAttr('P',m_pszArgv[3]) ) {
                            m_nPos = 100;  
                            break;                          
                        }
                    }                       
                    m_nPos = 4;  
                    break;                      
                }
                m_nPos = 3;  
                break;
            }             
            m_nPos = 1;  
            break;       
        default:
            if ( IsKeywordAll(m_pszArgv[1]) ) {
                if ( IsMapMemType(m_pszArgv[2]) ) {
                    if ( IsMapAttr(m_pszArgv[2][0],m_pszArgv[3]) ) {
                        m_nPos = 100;  
                        break;                                          
                    }
                    m_nPos = 4;  
                    break;              
                }
                m_nPos = 2;  
                break;
            }             
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        if ( IsXAddrDefault(m_pszArgv[1]) ) {
                            if (IsMapAttr('X',m_pszArgv[4]) ) {
                                m_nPos = 100;  
                                break;                                          
                            }                       
                        }   
                        else {
                            if (IsMapAttr('P',m_pszArgv[4]) ) {
                                m_nPos = 100;  
                                break;                                          
                            }                       
                        }                               
                        m_nPos = 4;  
                        break;                                          
                    }
                    m_nPos = 5;  
                    break;                  
                }                                     
                if ( IsAddrXP(m_pszArgv[2]) ) {              
                    if ( IsXAddrDefault(m_pszArgv[1]) ) {
                        if ( IsMapAttr('X',m_pszArgv[3]) ) {
                            m_nPos = 100;  
                            break;                          
                        }
                    }
                    else {
                        if ( IsMapAttr('X',m_pszArgv[3]) ) {
                            m_nPos = 100;  
                            break;                          
                        }
                    }   
                    m_nPos = 4;  
                    break;                      
                }
                m_nPos = 3;  
                break;
            }             
            m_nPos = 1;  
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMapSub().                                                    



BOOL CSyntaxCheckSub::SyntaxCheckMdelSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:                
            m_nPos = 1; 
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }             
            else {
                m_nPos = 1;
            }   
            break;
        default:
            if ( IsKeywordAll(m_pszArgv[1]) || IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;
            }             
            else {
                m_nPos = 1;
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMdelSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMemorySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        
        case 3:
            if ( !IsAddrAllX(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
        
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 100;          
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 100;
                    isTrue = TRUE;
                }   
            }
            break;
        default:         
            if ( !IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrAllX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 100;
                }   
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMemorySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMendSub(void)
{                
    BOOL isTrue = TRUE;

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMendSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckMlistSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;
            isTrue = TRUE;  
            break;
        case 2:           
            if ( IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;  
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsMacroName(m_pszArgv[1]) ) {
                m_nPos = 100;  
            }
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckMlistSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckOutportSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsPort(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }            
            m_nPos = 1;  
            break;
        case 3:
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    m_nPos = 5;
                    isTrue = TRUE;
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;        
        case 4:          
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) { 
                    if ( IsBitNo(m_pszArgv[3]) ) { 
                        m_nPos = 4;
                        isTrue = TRUE;
                    }
                    else {  
                        m_nPos = 3;
                    }   
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    if ( IsByteData(m_pszArgv[3]) ) {
                        m_nPos = 100; 
                        isTrue = TRUE;
                    }
                    else {
                        m_nPos = 5;
                    }       
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;   
        case 5:                            
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) { 
                    if ( IsBitNo(m_pszArgv[3]) ) { 
                        if ( IsBitData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;
                            break;
                        }
                        else {  
                            m_nPos = 4;
                        }   
                    }
                    else {  
                        m_nPos = 3;
                    }   
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    if ( IsByteData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }
                    else {
                        m_nPos = 5;
                    }       
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;
        default:
            if ( IsPort(m_pszArgv[1]) ) {
                if ( IsKeywordBit(m_pszArgv[2]) ) { 
                    if ( IsBitNo(m_pszArgv[3]) ) { 
                        if ( IsBitData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;
                        }
                        else {  
                            m_nPos = 4;
                            break;
                        }   
                    }
                    else {  
                        m_nPos = 3;
                    }   
                    break; 
                }   
                if ( IsKeywordByte(m_pszArgv[2]) ) {
                    if ( IsByteData(m_pszArgv[3]) ) {
                        m_nPos = 100;                       
                    }
                    else {
                        m_nPos = 5;
                    }       
                    break;
                }                       
                m_nPos = 2;
                break;              
            }         
            m_nPos = 1;         
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckOutportSub().                                                    

BOOL CSyntaxCheckSub::SyntaxCheckPortSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsPort(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            }            
            m_nPos = 1;  
            break;          
        default:           
            if ( IsPort(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }            
            m_nPos = 1;  
            break;          
    }           
    return isTrue;        
    
}   //End of CSyntaxCheckSub::SyntaxCheckPortSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckRegisterSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:                          
            if ( IsRegName(m_pszArgv[1]) ) {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }   
            break;                 
        case 3:            
            if ( IsRegName(m_pszArgv[1]) ) {
                if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                }
                else {  
                    m_nPos = 2;
                }
            }
            else {
                m_nPos = 1;
            }   
            break;        
        default:
            if ( IsRegName(m_pszArgv[1]) ) {
                if ( IsRegData(m_pszArgv[1], m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {  
                    m_nPos = 2;
                }
            }
            else {
                m_nPos = 1;
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckRegisterSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckResetSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2: 
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
                isTrue = TRUE;
            }              
            else {
                m_nPos = 1;
            }     
            break;
        default:
            if ( IsPAddrDefault(m_pszArgv[1]) ){
                m_nPos = 100;  
            }              
            else {
                m_nPos = 1;
            }     
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckResetSub().                                                    
                                              
BOOL CSyntaxCheckSub::SyntaxCheckRestartSub(void)
{                
    BOOL isTrue = FALSE;             
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;               
            isTrue = TRUE;          
            break;
        default:
            break;
    }        

    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckRestartSub().                                                    
                                              
// Added by Gates Hua , 3/6/98 for dome and ZJ FAE
BOOL CSyntaxCheckSub::SyntaxCheckSavedisasmSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        
        case 3:
            if ( !IsAddrXPI(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4;     
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
//                    m_nPos = 100;
                    m_nPos = 4;
                    isTrue = TRUE;
                }   
            }
            else {
                m_nPos = 100;
                isTrue = TRUE;
            } 
            break;
        case 5:          
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 100;
                    isTrue = TRUE;
                }   
            }
            else {
                m_nPos = 5;
                isTrue = TRUE;
            }
            break;                              
        default:         
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 5;
                    isTrue = TRUE;
                }   
            }
            else {
                m_nPos = 4;
                isTrue = TRUE;
            }
            break;                              
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckSavedisasmSub().

BOOL CSyntaxCheckSub::SyntaxCheckSearchSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXP(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        case 3:
            if ( !IsAddrXP(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXP(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4;         
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsAddrXP(m_pszArgv[2]) ) {
                    if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
                        m_nPos = 5;
                        isTrue = TRUE;                      
                        break;
                    }                 
                    if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
                        m_nPos = 100;
                        isTrue = TRUE;
                        break;
                    }                
                    m_nPos = 4;
                    break;
                }         
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        m_nPos = 4;
                        isTrue = TRUE;                      
                        break;
                    }
                    m_nPos = 3;
                    break;
                }
                m_nPos = 2;
                break;
            }           
            m_nPos = 1;
            break;           
        case 5:
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsAddrXP(m_pszArgv[2]) ) {
                    if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
                        if ( IsString(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;
                        }
                        else {  
                            m_nPos = 5;
                        }
                        break;
                    }                 
                    if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
                        m_nPos = 100;
                        break;
                    }                
                    m_nPos = 4;
                    break;
                }         
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
                            m_nPos = 5;
                            isTrue = TRUE;                      
                            break;
                        }
                        if ( IsData(m_pszArgv[4]) || IsString(m_pszArgv[4])) {
                            m_nPos = 100; 
                            isTrue = TRUE;
                            break;
                        }                
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 3;
                    break;
                }
                m_nPos = 2;
                break;
            }           
            m_nPos = 1;
            break;           
        default:                  
            if ( IsAddrXP(m_pszArgv[1]) ) {
                if ( IsAddrXP(m_pszArgv[2]) ) {
                    if ( IsKeywordInsensitive(m_pszArgv[3]) ) {
                        if ( IsString(m_pszArgv[4]) ) {
                            m_nPos = 100;
                        }
                        else {  
                            m_nPos = 5;
                        }
                        break;
                    }                 
                    if ( IsData(m_pszArgv[3]) || IsString(m_pszArgv[3])) {
                        m_nPos = 100;
                        break;
                    }                
                    m_nPos = 4;
                    break;
                }         
                if ( IsKeywordLength(m_pszArgv[2]) ) {
                    if ( IsAddrLen(m_pszArgv[3]) ) {
                        if ( IsKeywordInsensitive(m_pszArgv[4]) ) {
                            if ( IsString(m_pszArgv[5]) ) {
                                m_nPos = 100;
                            }
                            else {  
                                m_nPos = 5;
                            }   
                            break;
                        }
                        if ( IsData(m_pszArgv[4]) || IsString(m_pszArgv[4])) {
                            m_nPos = 100;
                            break;
                        }                
                        m_nPos = 4;
                        break;
                    }
                    m_nPos = 3;
                    break;
                }
                m_nPos = 2;
                break;
            }           
            m_nPos = 1;
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckSearchSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckStepSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:              
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            }         
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                m_nPos = 3;
                isTrue = TRUE;
                break;
            }   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                m_nPos = 4;
                isTrue = TRUE;
                break;
            }                
            m_nPos = 1;         
            break;             
        case 3:
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( IsStepCount(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }                   
                if ( IsKeywordForever(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }                
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 5;
                    isTrue = TRUE;
                    break;
                }   
                if ( IsKeywordTill(m_pszArgv[2]) ) {
                    m_nPos = 6;
                    isTrue = TRUE;
                    break;
                }                
                m_nPos = 2;
                break;
            }   
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                }
                else {
                    m_nPos = 3;
                }           
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }         
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsKeywordRet(m_pszArgv[2]) ||
                     IsKeywordCall(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                    break;
                }                                
                if ( '@' == m_pszArgv[2][0] ) {
                    if ( IsRegName(m_pszArgv[2]+1) ) {
                        m_nPos = 7;
                        isTrue = TRUE;
                        break;
                    }             
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {                   
                    m_nPos = 7;
                    isTrue = TRUE;
                    break;              
                }                       
                m_nPos = 4;             
                break;
            }                
            m_nPos = 1;         
            break;        
        case 4:             
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( IsKeywordForever(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;
                    }
                    else {
                        m_nPos = 5;
                    }
                    break;  
                }   
                if ( IsStepCount(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                   
                if ( IsKeywordTill(m_pszArgv[2]) ) {
                    if ( IsKeywordRet(m_pszArgv[3]) ||
                         IsKeywordCall(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;   
                        break;
                    }                             
                    if ( '@' == m_pszArgv[3][0] ) {
                        if ( IsRegName(m_pszArgv[3]+1) ) {   
                            m_nPos = 7;       
                            isTrue = TRUE;                          
                            break;
                        }             
                    }
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {                   
                        m_nPos = 7;       
                        isTrue = TRUE;
                        break;              
                    }                       
                    m_nPos = 4;             
                    break;
                }                
                m_nPos = 2;
                break;
            }   
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 3;
                }           
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }         
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsKeywordRet(m_pszArgv[2]) ||
                     IsKeywordCall(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }                                
                if ( '@' == m_pszArgv[2][0] ) {
                    if ( IsRegName(m_pszArgv[2]+1) ) {
                        if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                            m_nPos = 8;
                            isTrue = TRUE;
                            break;                          
                        }   
                        m_nPos = 7;
                        break;
                    }             
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {                   
                    if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                        m_nPos = 8;
                        isTrue = TRUE;
                        break;                          
                    }   
                    m_nPos = 7;
                    break;              
                }                       
                m_nPos = 4;             
                break;
            }                
            m_nPos = 1;         
            break;                              
        case 5:             
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( IsKeywordForever(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }
                    else {
                        m_nPos = 5;
                    }
                    break;  
                }   
                if ( IsStepCount(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                   
                if ( IsKeywordTill(m_pszArgv[2]) ) {
                    if ( IsKeywordRet(m_pszArgv[3]) ||
                         IsKeywordCall(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;
                    }                             
                    if ( '@' == m_pszArgv[3][0] ) {
                        if ( IsRegName(m_pszArgv[3]+1) ) {   
                            if (0 == stricmp(m_pszArgv[4], "IS") ) {
                                m_nPos = 8;       
                                isTrue = TRUE;                          
                                break;                          
                            }
                            m_nPos = 7;       
                            break;
                        }             
                    }
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {                   
                        if (0 == stricmp(m_pszArgv[4], "IS") ) {
                            m_nPos = 8;       
                            isTrue = TRUE;                          
                            break;                          
                        }
                        m_nPos = 7;       
                        break;              
                    }                       
                    m_nPos = 4;             
                    break;
                }                
                m_nPos = 2;
                break;
            }   
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 3;
                }           
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }         
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsKeywordRet(m_pszArgv[2]) ||
                     IsKeywordCall(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                                
                if ( '@' == m_pszArgv[2][0] ) {
                    if ( IsRegName(m_pszArgv[2]+1) ) {
                        if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                            if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
                                m_nPos = 100;
                                isTrue = TRUE;
                                break;                                  
                            }
                            m_nPos = 8;
                            break;                          
                        }   
                        m_nPos = 7;
                        break;
                    }             
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {                   
                    if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                        if ( IsRegData(m_pszArgv[2], m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;
                            break;                                  
                        }
                        m_nPos = 8;
                        break;                          
                    }   
                    m_nPos = 7;
                    break;              
                }                       
                m_nPos = 4;             
                break;
            }                
            m_nPos = 1;         
            break;
        case 6:             
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( IsKeywordForever(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }
                    else {
                        m_nPos = 5;
                    }
                    break;  
                }   
                if ( IsStepCount(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                   
                if ( IsKeywordTill(m_pszArgv[2]) ) {
                    if ( IsKeywordRet(m_pszArgv[3]) ||
                         IsKeywordCall(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;
                    }                             
                    if ( '@' == m_pszArgv[3][0] ) {
                        if ( IsRegName(m_pszArgv[3]+1) ) {   
                            if (0 == stricmp(m_pszArgv[4], "IS") ) {
                                if ( IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
                                    m_nPos = 100;
                                    isTrue = TRUE;
                                    break;                                  
                                }                           
                                m_nPos = 8;       
                                break;                          
                            }
                            m_nPos = 7;       
                            break;
                        }             
                    }
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {                   
                        if (0 == stricmp(m_pszArgv[4], "IS") ) {
                            if ( IsRegData(m_pszArgv[3], m_pszArgv[5]) ) {
                                m_nPos = 100;
                                isTrue = TRUE;
                                break;                                  
                            }                           
                            m_nPos = 8;       
                            break;                          
                        }
                        m_nPos = 7;       
                        break;              
                    }                       
                    m_nPos = 4;             
                    break;
                }                
                m_nPos = 2;
                break;
            }   
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 3;
                }           
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }         
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsKeywordRet(m_pszArgv[2]) ||
                     IsKeywordCall(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                                
                if ( '@' == m_pszArgv[2][0] ) {
                    if ( IsRegName(m_pszArgv[2]+1) ) {
                        if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                            if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
                                m_nPos = 100;
                                break;                                  
                            }
                            m_nPos = 8;
                            break;                          
                        }   
                        m_nPos = 7;
                        break;
                    }             
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {                   
                    if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                        if ( IsRegData(m_pszArgv[2], m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                  
                        }
                        m_nPos = 8;
                        break;                          
                    }   
                    m_nPos = 7;
                    break;              
                }                       
                m_nPos = 4;             
                break;
            }                
            m_nPos = 1;         
            break;                              
        default:
            if ( IsKeywordOver(m_pszArgv[1]) ) {
                if ( IsStepCount(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                   
                if ( IsKeywordForever(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {
                        m_nPos = 100;
                    }
                    else {
                        m_nPos = 5;
                    }
                    break;  
                }   
                if ( IsKeywordTill(m_pszArgv[2]) ) {
                    if ( IsKeywordRet(m_pszArgv[3]) ||
                         IsKeywordCall(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;
                    }                             
                    if ( '@' == m_pszArgv[3][0] ) {
                        if ( IsRegName(m_pszArgv[3]+1) ) {   
                            if (0 == stricmp(m_pszArgv[4], "IS") ) {
                                if ( IsRegData(m_pszArgv[3]+1, m_pszArgv[5]) ) {
                                    m_nPos = 100;
                                    isTrue = TRUE;
                                    break;                                  
                                }                           
                                m_nPos = 8;       
                                break;                          
                            }
                            m_nPos = 7;       
                            break;
                        }             
                    }
                    if ( IsPAddrDefault(m_pszArgv[3]) ) {                   
                        if (0 == stricmp(m_pszArgv[4], "IS") ) {
                            if ( IsRegData(m_pszArgv[3], m_pszArgv[5]) ) {
                                m_nPos = 100;
                                break;                                  
                            }                           
                            m_nPos = 8;       
                            break;                          
                        }
                        m_nPos = 7;       
                        break;              
                    }                       
                    m_nPos = 4;             
                    break;
                }                
                m_nPos = 2;
                break;
            }   
            if ( IsStepCount(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }         
            if ( IsKeywordForever(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;
            }                
            if ( IsPAddrDefault(m_pszArgv[1]) ) {
                if ( IsPAddrDefault(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 3;
                }           
                break;
            }   
            if ( IsKeywordTill(m_pszArgv[1]) ) {
                if ( IsKeywordRet(m_pszArgv[2]) ||
                     IsKeywordCall(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;
                }                                
                if ( '@' == m_pszArgv[2][0] ) {
                    if ( IsRegName(m_pszArgv[2]+1) ) {
                        if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                            if ( IsRegData(m_pszArgv[2]+1, m_pszArgv[4]) ) {
                                m_nPos = 100;
                                break;                                  
                            }
                            m_nPos = 8;
                            break;                          
                        }   
                        m_nPos = 7;
                        break;
                    }             
                }
                if ( IsPAddrDefault(m_pszArgv[2]) ) {                   
                    if ( 0 == stricmp(m_pszArgv[3], "IS") ) {
                        if ( IsRegData(m_pszArgv[2], m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                  
                        }
                        m_nPos = 8;
                        break;                          
                    }   
                    m_nPos = 7;
                    break;              
                }                       
                m_nPos = 4;             
                break;
            }                
            m_nPos = 1;         
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckStepSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTestSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        
        case 3:
            if ( !IsAddrXPI(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
        
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4;             
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4; 
                    isTrue = TRUE;
                }   
            }
            break;
        default:         
            if ( !IsAddrXPI(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrXPI(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4;
                }   
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckTestSub().                                                    

BOOL CSyntaxCheckSub::SyntaxCheckTimerSub(void)
{                
    BOOL isTrue = FALSE;     

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2: 
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;                 
                isTrue = TRUE;                 
            }                 
            else {
                m_nPos = 1;
            }   
            break;
        default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;                 
            }                 
            else {
                m_nPos = 1;
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckTimerSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTraceSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;                 
                isTrue = TRUE;                 
            }                 
            else {
                m_nPos = 1;
            }   
            break;
        default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ||
                 IsKeywordClear(m_pszArgv[1]) ) {
                m_nPos = 100;                 
            }                 
            else {
                m_nPos = 1;
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckTraceSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckTriggerSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
                 m_nPos = 100;
                 isTrue = TRUE;              
                 break;              
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                 m_nPos = 2;
                 isTrue = TRUE;              
                 break;              
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                 m_nPos = 3;
                 isTrue = TRUE;              
                 break;              
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                 m_nPos = 4;
                 isTrue = TRUE;              
                 break;              
            }          
            m_nPos = 1;  
            break;
        case 3:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                     m_nPos = 3;
                     isTrue = TRUE;              
                     break;              
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                     m_nPos = 4;
                     isTrue = TRUE;              
                     break;              
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    m_nPos = 5;
                    isTrue = TRUE;               
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;               
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    m_nPos = 6;
                    isTrue = TRUE;               
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;               
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    m_nPos = 6;
                    isTrue = TRUE;               
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
        case 4:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                    if ( IsKeywordThen(m_pszArgv[3]) ) {
                        m_nPos = 5;
                        isTrue = TRUE;               
                        break;                              
                    }                                
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;               
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        m_nPos = 6;
                        isTrue = TRUE;               
                        break;                                              
                    }                       
                    m_nPos = 3;
                    break;               
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;               
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        m_nPos = 6;
                        isTrue = TRUE;               
                        break;                                              
                    }     
                    m_nPos = 4;
                    break;               
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    if ( IsKeywordLv2(m_pszArgv[3]) ) {                 
                        m_nPos = 4;
                        isTrue = TRUE;               
                        break;                              
                    }             
                    m_nPos = 5;
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;               
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        isTrue = TRUE;               
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
        case 5:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                    if ( IsKeywordThen(m_pszArgv[3]) ) {
                        if ( IsKeywordLv2(m_pszArgv[4]) ) {                 
                            m_nPos = 4;
                            isTrue = TRUE;               
                            break;                              
                        }             
                        m_nPos = 5;
                        break;                              
                    }               
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;               
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }                       
                    m_nPos = 3;
                    break;               
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;               
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }     
                    m_nPos = 4;
                    break;               
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    if ( IsKeywordLv2(m_pszArgv[3]) ) {                 
                        if ( IsKeywordForward(m_pszArgv[4]) ||
                             IsKeywordBackward(m_pszArgv[4]) ||
                             IsKeywordCenter(m_pszArgv[4]) ) {
                            m_nPos = 100;               
                            isTrue = TRUE;                                          
                            break;                                              
                        }                                
                        if ( IsKeywordDelay(m_pszArgv[4]) ) {
                            m_nPos = 6;                                             
                            isTrue = TRUE;                                                                      
                            break;                                              
                        }     
                        m_nPos = 4;
                        break;                              
                    }             
                    m_nPos = 5;
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
        case 6:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                    if ( IsKeywordThen(m_pszArgv[3]) ) {
                        if ( IsKeywordLv2(m_pszArgv[4]) ) {                 
                            if ( IsKeywordForward(m_pszArgv[5]) ||
                                 IsKeywordBackward(m_pszArgv[5]) ||
                                 IsKeywordCenter(m_pszArgv[5]) ) {
                                m_nPos = 100;
                                isTrue = TRUE;               
                                break;                                                                          
                            }                                
                            if ( IsKeywordDelay(m_pszArgv[5]) ) {
                                m_nPos = 6;                  
                                isTrue = TRUE;               
                                break;                                              
                            }     
                            m_nPos = 4;
                            break;                              
                        }             
                        m_nPos = 5;
                        break;                              
                    }               
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }                       
                    m_nPos = 3;
                    break;               
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }     
                    m_nPos = 4;
                    break;               
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    if ( IsKeywordLv2(m_pszArgv[3]) ) {                 
                        if ( IsKeywordForward(m_pszArgv[4]) ||
                             IsKeywordBackward(m_pszArgv[4]) ||
                             IsKeywordCenter(m_pszArgv[4]) ) {
                            m_nPos = 100;               
                            break;                                              
                        }                                
                        if ( IsKeywordDelay(m_pszArgv[4]) ) {
                            if ( IsAddrData(m_pszArgv[5]) ) {
                                m_nPos = 100;          
                                isTrue = TRUE;                                                                      
                                break;                                                                          
                            }   
                            m_nPos = 6;                                                                         
                            break;                                              
                        }     
                        m_nPos = 4;
                        break;                              
                    }             
                    m_nPos = 5;
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
        case 7:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                    if ( IsKeywordThen(m_pszArgv[3]) ) {
                        if ( IsKeywordLv2(m_pszArgv[4]) ) {                 
                            if ( IsKeywordForward(m_pszArgv[5]) ||
                                 IsKeywordBackward(m_pszArgv[5]) ||
                                 IsKeywordCenter(m_pszArgv[5]) ) {
                                m_nPos = 100;
                                break;                                                                          
                            }                                
                            if ( IsKeywordDelay(m_pszArgv[5]) ) {
                                if ( IsAddrData(m_pszArgv[6]) ) {
                                    m_nPos = 100;           
                                    isTrue = TRUE;              
                                    break;                                                                          
                                }   
                                m_nPos = 6;                  
                                break;                                              
                            }     
                            m_nPos = 4;
                            break;                              
                        }             
                        m_nPos = 5;
                        break;                              
                    }               
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            isTrue = TRUE;               
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }                       
                    m_nPos = 3;
                    break;               
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }     
                    m_nPos = 4;
                    break;               
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    if ( IsKeywordLv2(m_pszArgv[3]) ) {                 
                        if ( IsKeywordForward(m_pszArgv[4]) ||
                             IsKeywordBackward(m_pszArgv[4]) ||
                             IsKeywordCenter(m_pszArgv[4]) ) {
                            m_nPos = 100;               
                            break;                                              
                        }                                
                        if ( IsKeywordDelay(m_pszArgv[4]) ) {
                            if ( IsAddrData(m_pszArgv[5]) ) {
                                m_nPos = 100;          
                                break;                                                                          
                            }   
                            m_nPos = 6;                                                                         
                            break;                                              
                        }     
                        m_nPos = 4;
                        break;                              
                    }             
                    m_nPos = 5;
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
        default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                break;               
            }          
            if ( IsKeywordRun(m_pszArgv[1]) ) {
                if ( IsKeywordLv1(m_pszArgv[2]) ) {
                    if ( IsKeywordThen(m_pszArgv[3]) ) {
                        if ( IsKeywordLv2(m_pszArgv[4]) ) {                 
                            if ( IsKeywordForward(m_pszArgv[5]) ||
                                 IsKeywordBackward(m_pszArgv[5]) ||
                                 IsKeywordCenter(m_pszArgv[5]) ) {
                                m_nPos = 100;
                                break;                                                                          
                            }                                
                            if ( IsKeywordDelay(m_pszArgv[5]) ) {
                                if ( IsAddrData(m_pszArgv[6]) ) {
                                    m_nPos = 100;           
                                    break;                                                                          
                                }   
                                m_nPos = 6;                  
                                break;                                              
                            }     
                            m_nPos = 4;
                            break;                              
                        }             
                        m_nPos = 5;
                        break;                              
                    }               
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }                       
                    m_nPos = 3;
                    break;               
                }          
                if ( IsKeywordLv2(m_pszArgv[2]) ) {
                    if ( IsKeywordForward(m_pszArgv[3]) ||
                         IsKeywordBackward(m_pszArgv[3]) ||
                         IsKeywordCenter(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                              
                    }                                
                    if ( IsKeywordDelay(m_pszArgv[3]) ) {
                        if ( IsAddrData(m_pszArgv[4]) ) {
                            m_nPos = 100;
                            break;                                                                          
                        }   
                        m_nPos = 6;
                        break;                                              
                    }     
                    m_nPos = 4;
                    break;               
                }          
                m_nPos = 2;
                break;               
            }          
            if ( IsKeywordLv1(m_pszArgv[1]) ) {
                if ( IsKeywordThen(m_pszArgv[2]) ) {
                    if ( IsKeywordLv2(m_pszArgv[3]) ) {                 
                        if ( IsKeywordForward(m_pszArgv[4]) ||
                             IsKeywordBackward(m_pszArgv[4]) ||
                             IsKeywordCenter(m_pszArgv[4]) ) {
                            m_nPos = 100;               
                            break;                                              
                        }                                
                        if ( IsKeywordDelay(m_pszArgv[4]) ) {
                            if ( IsAddrData(m_pszArgv[5]) ) {
                                m_nPos = 100;          
                                break;                                                                          
                            }   
                            m_nPos = 6;                                                                         
                            break;                                              
                        }     
                        m_nPos = 4;
                        break;                              
                    }             
                    m_nPos = 5;
                    break;                              
                }               
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 3;
                break;               
            }          
            if ( IsKeywordLv2(m_pszArgv[1]) ) {
                if ( IsKeywordForward(m_pszArgv[2]) ||
                     IsKeywordBackward(m_pszArgv[2]) ||
                     IsKeywordCenter(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    break;                                              
                }                                
                if ( IsKeywordDelay(m_pszArgv[2]) ) {
                    if ( IsAddrData(m_pszArgv[3]) ) {
                        m_nPos = 100;
                        break;                                                                          
                    }   
                    m_nPos = 6;
                    break;                                              
                }     
                m_nPos = 4;
                break;               
            }          
            m_nPos = 1;  
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckTriggerSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckUploadSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet;
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1; 
            isTrue = TRUE; 
            break;
        case 2:           
            if ( !IsAddrPX(m_pszArgv[1]) ) {
                m_nPos = 1;
            }               
            else {
                m_nPos = 2; 
                isTrue = TRUE;
            }
            break;
        case 3:
            if ( !IsAddrPX(m_pszArgv[1]) ) { 
                m_nPos = 1;
                break;
            }               
            if ( !IsKeywordLength(m_pszArgv[2]) && 
                 !IsAddrPX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }         
            if ( IsKeywordLength(m_pszArgv[2])) {
                m_nPos = 3;
                isTrue = TRUE;
            }
            else {
                m_nPos = 4;     
                isTrue = TRUE;
            }   
            break;        
        case 4:          
            if ( !IsAddrPX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    m_nPos = 4;
                    isTrue = TRUE;
                }                    
                break;
            }         
            if ( !IsFilename(m_pszArgv[3], nRet) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5; 
                isTrue = TRUE;
            } 
            break;           
        case 5:
            if ( !IsAddrPX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsFilename(m_pszArgv[4], nRet) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 5; 
                        isTrue = TRUE;
                    }   
                }                 
                break;
            }         
            if ( !IsFilename(m_pszArgv[3], nRet) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5;
            }           
            break;           
        default:
            if ( !IsAddrPX(m_pszArgv[1]) ) {
                m_nPos = 1;
                break;
            }           
            if ( !IsKeywordLength(m_pszArgv[2]) && !IsAddrPX(m_pszArgv[2])) {
                m_nPos = 2;
                break;
            }             
            if ( IsKeywordLength(m_pszArgv[2]) ) {
                if ( !IsAddrLen(m_pszArgv[3]) ) {
                    m_nPos = 3;
                }
                else {
                    if ( !IsFilename(m_pszArgv[4], nRet) ) {
                        m_nPos = 4;
                    }
                    else {
                        m_nPos = 5; 
                    }   
                }   
                break;
            }                        
            if ( !IsFilename(m_pszArgv[3], nRet) ) {
                m_nPos = 4;         
            }              
            else {
                m_nPos = 5;
            }           
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckUploadSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckVerifySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;
            isTrue = TRUE;  
            break;
        case 2:           
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }                       
            break;
        default:
            if ( IsKeywordOn(m_pszArgv[1]) ||
                 IsKeywordOff(m_pszArgv[1]) ) {
                m_nPos = 100;
            }                 
            else {
                m_nPos = 1;
            }                       
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckVerifySub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckWordSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:                  
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }
            break;                 
        case 3:            
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsData(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;        
        default:
            if ( IsAddrAllX(m_pszArgv[1]) ) {
                if ( IsData(m_pszArgv[2]) ) {
                    m_nPos = 3;
                    isTrue = TRUE;
                }   
                else {
                    m_nPos = 2;
                }                 
            }   
            else {
                m_nPos = 1;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckWordSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckCreateSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsVariableName(m_pszArgv[1]) ) {
                m_nPos = 2;
                isTrue = TRUE;
            }                 
            else {
                m_nPos = 1;
            }
            break;                 
        case 3:            
            if ( IsVariableName(m_pszArgv[1]) ) {
                if ( IsAddrAllP(m_pszArgv[2]) ) {
                    m_nPos = 100;
                    isTrue = TRUE;
                }
                else {
                    m_nPos = 2;
                }   
            }                 
            else {
                m_nPos = 1;
            }
            break;        
        default:
            if ( IsVariableName(m_pszArgv[1]) ) {
                if ( IsAddrAllP(m_pszArgv[2]) ) {
                    m_nPos = 100;
                }
                else {
                    m_nPos = 2;
                }   
            }                 
            else {
                m_nPos = 1;
            }
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckCreateSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckDeleteSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsVariableName(m_pszArgv[1]) || 
                 IsMacroVarName(m_pszArgv[1]) ||    
                 IsKeywordAll(m_pszArgv[1]) ) { 
                m_nPos = 2;
                isTrue = TRUE;
            }     
            else {
                m_nPos = 1;
            }   
            break;        
        default:
            if ( IsVariableName(m_pszArgv[1]) || 
                 IsMacroVarName(m_pszArgv[1]) ||    
                 IsKeywordAll(m_pszArgv[1]) ) { 
                m_nPos = 2;
            }     
            else {
                m_nPos = 1;
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckDeleteSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckLoadSub(void)
{                
    BOOL isTrue = FALSE;                               
    BOOL isError = TRUE;
    int nRet = 0;
    int nOption = 0; //bit0 - symbols=1 , nosymbols=0;
                     //bit1 - Code 
                     //bit2 - Append
                     //bit3 - Warn
                     //bit4 - Module
                     //bit5 - P: = 1, X: = 0                        
    
    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsFilename(m_pszArgv[1], nRet) ) {
                m_nPos = 2;
                isTrue = TRUE;
                break;
            }
            m_nPos = 1;                                 
            break;                                      
        default:  
            if ( IsFilename(m_pszArgv[1], nRet) ) {      
                //if ( IsLoadOptionSub(m_nToken, m_pszArgv) ) {
                    for ( int i = 2; i < m_nToken; i++) {
                        if ( IsKeywordSymbols(m_pszArgv[i]) ||
                             IsKeywordNosymbols(m_pszArgv[i]) ) {   
                            if ( (nOption & 1) == 1 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 1;
                            }   
                        }         
                        if ( IsKeywordCode(m_pszArgv[i]) ||
                             IsKeywordNocode(m_pszArgv[i]) ) {
                            if ( (nOption & 2) == 2 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 2;
                            }                      
                        }         
                        if ( IsKeywordWarn(m_pszArgv[i]) ||
                             IsKeywordNowarn(m_pszArgv[i]) ) {
                            if ( (nOption & 8) == 8 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 8;
                            }                      
                        }               
                        if ( IsKeywordAppend(m_pszArgv[i]) ||
                             IsKeywordNoappend(m_pszArgv[i]) ) {
                            if ( (nOption & 4) == 4 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 4;
                            }               
                        }         
                        if ( IsKeywordP(m_pszArgv[i]) ||
                             IsKeywordX(m_pszArgv[i]) ) {
                            if ( (nOption & 16) == 16 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 16;
                            }                
                        }       
                        if ( IsKeywordModule(m_pszArgv[i]) ||
                             IsKeywordModule(m_pszArgv[i]) ) {
                            if ( (nOption & 32) == 32 ) {
                                isError = FALSE;
                            }                   
                            else {
                                nOption |= 32;
                            }                
                        }       
                                                                                
                    }        
                    if ( IsKeywordModule(m_pszArgv[m_nToken-1]) ) {
                        m_nPos = 65;     
                        isTrue = TRUE;
                        break;
                    }                   
                    if ( isError && (nOption & 32) == 0 ) {
                        isTrue = TRUE;
                        m_nPos = nOption + 2;   
                        break;
                    }                       
                    if ( isError && (nOption & 32) == 32 ) {
                        isTrue = TRUE;
                        m_nPos = nOption + 1;   
                        break;
                    }                       
                //} 
                //m_nPos = 2;
                break;
            }                                   
            m_nPos = 1;                                                                                   
            break;                              
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckLoadSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckQuerySub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;  
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsSymbolName(m_pszArgv[1]) ||   
                 IsHexAddr(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }           
            break;                 
        default:
            if ( IsSymbolName(m_pszArgv[1]) ||   
                 IsHexAddr(m_pszArgv[1]) ) {
                m_nPos = 100;
            }
            else {
                m_nPos = 1;
            }           
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckQuerySub().                                                    
                    

BOOL CSyntaxCheckSub::SyntaxCheckSsaveSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:   
            if ( IsFilename(m_pszArgv[1], nRet )) {                
                m_nPos = 100;
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }       
            break;
        default:
            if ( IsFilename(m_pszArgv[1], nRet )) {                
                m_nPos = 100;
            }
            else {
                m_nPos = 1;
            }       
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckSsaveSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckSrecallSub(void)
{                
    BOOL isTrue = FALSE;
    int nRet = 0;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:   
            if ( IsFilename(m_pszArgv[1], nRet )) {                
                m_nPos = 100;
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }       
            break;
        default:
            if ( IsFilename(m_pszArgv[1], nRet )) {                
                m_nPos = 100;
            }
            else {
                m_nPos = 1;
            }       
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckSrecallSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckSymbolSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:           
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;
            }               
            break;
        default:
            if ( IsKeywordGlobal(m_pszArgv[1]) ||
                 IsKeywordModule(m_pszArgv[1]) ||
                 IsKeywordLines(m_pszArgv[1]) ||
                 IsVariableName(m_pszArgv[1]) ) {
                m_nPos = 100;
            }
            else {
                m_nPos = 1;
            }               
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckSymbolSub().                                                    


BOOL CSyntaxCheckSub::SyntaxCheckWatchSub(void)
{                
    BOOL isTrue = FALSE;

    // Check command syntax.
    switch ( m_nToken ) {
        case 1:
            m_nPos = 1;   
            isTrue = TRUE;
            break;
        case 2:                       
            if (IsString(m_pszArgv[1]) ) {
                m_nPos = 100;
                isTrue = TRUE;
            }
            else {
                m_nPos = 1;         
            }   
            break;
        default:
            if (IsString(m_pszArgv[1]) ) {
                m_nPos = 100;
            }
            else {
                m_nPos = 1;         
            }   
            break;
    }        
    
    return isTrue;    
}   //End of CSyntaxCheckSub::SyntaxCheckWatchSub().                                                    


//////////////////////////////// End of File ////////////////////////////////
