/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SPAGRP.CPP   1.2.1.4   17 Apr 1997 15:59:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SPAGRP.CPP  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:59:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:32:32   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:42:08   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:20:52   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:25:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:35:10   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:44   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:38   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:48   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:18   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:22   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:38   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:56:06   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:27:40   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:56:18   ZJRD
** No change.
** 
**    Rev 1.4   29 May 1996 09:36:24   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:09:04   ZJRD
** EasyPack/SLD Version 1.94
** 
**    Rev 1.2   10 May 1996 09:08:42   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:26:18   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:54:08   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:36:14   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAGRP.CPP
//
//  Description: The implementation file fore class: CSpaGroupSheet.
//
//  Author: Chen Jun
//
//  Date: 03/20/96
//
//  Modification:
//      1. 03/20/96, Initial version of the class: CSpaGroupSheet with VBX.
//      2. 03/29/96, CSpaGroupSheet without VBX.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"

#include "xview.h"
#include "spagrp.h"
#include "hosterrs.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// External variables.

int GetPCBank(void);
STATUS SetPCBank(int nBank);
STATUS AbiGetOneReg(int iRegId, UINT* uRegValue);
STATUS AbiSetReg(int iRegId, UINT uRegValue);


/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet dialog

IMPLEMENT_DYNAMIC(CSpaGroupSheet, CPropertySheet)

CSpaGroupSheet::CSpaGroupSheet(CWnd* pParent /*=NULL*/)
    : CPropertySheet(IDS_SPA_GROUP, pParent),
    m_nErrorID(errOK)
{
    // Add pages to the property sheet.
    AddPage(&m_pageEntry);
    AddPage(&m_pageTime);
    AddPage(&m_pageCode);
}

BEGIN_MESSAGE_MAP(CSpaGroupSheet, CPropertySheet)
	//{{AFX_MSG_MAP(CSpaGroupSheet)
    ON_WM_SYSCOMMAND()
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_ACTIVATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet common routines

void CSpaGroupSheet::DisplayErrorMessage()
{
	// Get the error string from the Error handling server.
	CString strError;
	::ErrGetErrorText(ER_SPA_BASE + m_nErrorID, strError);
	AfxMessageBox(strError);
	
	m_nErrorID = errOK;
}

BOOL CSpaGroupSheet::IsValidAddr(const CString& strAddr)
{
	// Check C-conversion.
	::ADDRESS Addr;
	if ( ::ADR_OK != ::AdrShellToAddr(strAddr, Addr, ::SPACE_PROGRAME) ) {
		return FALSE;
	}
	
	// Check space.
	if ( ::SPACE_PROGRAME != Addr.adrSpace && ::SPACE_UNDEFINE != Addr.adrSpace &&
		 Addr.adrSpace < ::SPACE_BANK1 && Addr.adrSpace > ::SPACE_BANK4 ) {
		return FALSE;
	}
	
	// Check range.
	return (::AdrCheckAddrRange(Addr));
}

void CSpaGroupSheet::SplitRecord(const CString& strLine)
{
	// Get DEFINE token.
	int nFirst = strLine.Find(';');
	if ( -1 == nFirst ) {
		return;
	}
	m_strDefine = strLine.Left(nFirst);

	// Get END token.
	int nLen = strLine.GetLength();
	int nNext = strLine.ReverseFind(';');
	if ( -1 == nNext ) {
		return;
	}
	else if ( nFirst == nNext ) {
		m_strStart = strLine.Right(nLen-nNext-1);
		return;
	}
	else {
		m_strEnd = strLine.Right(nLen-nNext-1);
	}
	
	// Get START token.
	m_strStart = (strLine.Left(nNext)).Right(nNext-nFirst-1);
}

void CSpaGroupSheet::BindRecord(const CString& strLine)
{
	// Get DEFINE token.
	int nFirst = strLine.Find(' ');
	if ( -1 == nFirst ) {
		return;
	}
	m_strDefine = strLine.Left(nFirst);
	
	// Get END token.
	int nLen = strLine.GetLength();
	int nNext = strLine.ReverseFind(' ');
	if ( -1 == nNext ) {
		return;
	}
	else if ( nFirst == nNext ) {
		m_strStart = strLine.Right(nLen-nNext-1);
		m_strEnd = "";
		return;
	}
	else {
		m_strEnd = strLine.Right(nLen-nNext-1);
	}
	
	// Get START token.
	m_strStart = (strLine.Left(nNext)).Right(nNext-nFirst-1);
}

void CSpaGroupSheet::EmptyBuffer(void)
{
	// Empty defined buffer.
	m_strDefine.Empty();
	m_strStart.Empty();
	m_strEnd.Empty();
}


/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet message handlers

void CSpaGroupSheet::OnSysCommand(UINT nID, LPARAM lParam)
{
    // TODO: Add your message handler code here and/or call default

    // Disable to move or restore main frame window.
    switch ( nID & 0x0FFF0 ) {
        case SC_MOVE:
            return;
        default:
            break;
    }
        
    CPropertySheet::OnSysCommand(nID,lParam);
}

int CSpaGroupSheet::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
    if (CPropertySheet::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
    // Centering dialog box.
    CenterWindow();
    
    // Disable 4 standard buttons.
	GetDlgItem(ID_APPLY_NOW)->DestroyWindow();
	GetDlgItem(IDOK)->DestroyWindow();
	GetDlgItem(IDCANCEL)->DestroyWindow();
	GetDlgItem(ID_HELP)->DestroyWindow();
	
	// Resize the sheet.
	m_sizeButton = CSize(0, 0);
	RecalcLayout();

	// Get the current PC 
	if ( ::ICE_OK != ::AbiGetOneReg(0, &m_uPC) ) {
		m_nErrorID = errAbi;
		DisplayErrorMessage();
		return -1;
	}
	m_nBank = ::GetPCBank();

	return 0;
}

void CSpaGroupSheet::OnClose() 
{
	// TODO: Add your message handler code here and/or call default

	// Restore to the old PC.
	SetModeless(FALSE);
	if ( ::ICE_OK != ::AbiSetReg(0, m_uPC) ) {
		m_nErrorID = errAbi;
		DisplayErrorMessage();
	}
	::SetPCBank(m_nBank);

	CPropertySheet::OnClose();
}

void CSpaGroupSheet::OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized) 
{
	CPropertySheet::OnActivate(nState, pWndOther, bMinimized);
	
	// TODO: Add your message handler code here
	
	// Update the graph bar
	if ( WA_ACTIVE == nState || WA_CLICKACTIVE == nState ) {
		CPropertyPage* pPage = GetActivePage();
		if ( pPage == &m_pageEntry ) {
			m_pageEntry.RedrawBar();
		}
		else if ( pPage == &m_pageTime ) {
			m_pageTime.RedrawBar();
		}
		else if ( pPage == &m_pageCode ) {
			m_pageCode.RedrawBar();
		}
	}
}
