/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SPAGRP.H__   1.2.1.4   17 Apr 1997 15:59:54   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SPAGRP.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 15:59:54   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:32:34   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:42:10   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:20:54   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:25:14   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:35:12   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:49:46   ZJRD
** Initial revision.
** 
**    Rev 1.7.1.0.1.0   11 Nov 1996 12:59:42   ZJRD
** EasyPack/SLD Version 2.01
** 
**    Rev 1.7.1.4   09 Sep 1996 13:18:54   ZJRD
** No change.
** 
**    Rev 1.7.1.3   05 Sep 1996 11:30:26   ZJRD
** No change.
** 
**    Rev 1.7.1.2   02 Sep 1996 09:57:30   ZJRD
** No change.
** 
**    Rev 1.7.1.1   28 Aug 1996 15:52:46   ZJRD
** EasyPack/SLD Version 1.9b
** 
**    Rev 1.7.1.0   12 Aug 1996 10:56:08   ZJRD
** EasyPack/SLD Version 1.98
** 
**    Rev 1.7   11 Jun 1996 10:24:04   ZJRD
** EasyPack/SLD Version 1.97
** 
**    Rev 1.5   05 Jun 1996 14:51:46   ZJRD
** EasyPack/SLD Version 1.96
** 
**    Rev 1.4   29 May 1996 09:33:16   ZJRD
** EasyPack/SLD Version 1.95
** 
**    Rev 1.3   16 May 1996 09:05:22   ZJRD
** No change.
** 
**    Rev 1.2   10 May 1996 09:11:24   ZJRD
** No change.
** 
**    Rev 1.1   02 May 1996 10:23:16   ZJRD
** EasyPack/SLD Version 1.92
** 
**    Rev 1.1   18 Apr 1996 12:56:58   Shirley
** EasyPack/SLD Version 1.91
** 
**    Rev 1.0   12 Apr 1996 10:42:22   Shirley
** Initial revision.
** 
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name: SPAGRP.H
//
//  Description: The header file for the class: CSpaGroupSheet.
//
//  Author: Chen Jun
//
//  Date: 03/20/96
//
//  Modification:
//      1. 03/20/96, Initial version of the class: CSpaGroupDlg with VBX.
//      2. 03/29/96, CSpaGroupSheet without VBX.
//
//  Copyright (C) 1996 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////
#ifndef _SPAGRP_H_
#define _SPAGRP_H_

#include "abitype.h"
#include "abispa.h"
#include "address.h"
#include "addrapi.h"

#include "spaentry.h"
#include "spatime.h"
#include "spaline.h"
#include "spalist.h"
#include "spacode.h"

/////////////////////////////////////////////////////////////////////////////
// CSpaGroupSheet dialog

class CSpaGroupSheet : public CPropertySheet
{
// Construction
public:
    DECLARE_DYNAMIC(CSpaGroupSheet)
	CSpaGroupSheet(CWnd* pParent = NULL);	// standard constructor

// Attributes
public:
	CSpaModuleEntryPage m_pageEntry;
	CSpaExecutionTimePage m_pageTime;
	CSpaCodeCoveragePage m_pageCode;

public:
	enum { 
		errOK = 0,		// SPA command is OK.
		errDebug,		// SPA is in debug mode.
		errEmpty,		// Empty input.
		errNoDelimit,	// The module range setting is invalid.
		errInput,		// Invalid input.
		errExist,		// The same module range setting exists.
		errFile,		// Cannot open the data file.
		errMemory,		// Insufficient memory.
		errRange,		// Module range is invalid.
		errTimer,       // System timer setting is invalid.
		errAbi,			// Wait a moment, please.
		errNoCoverage	// No coverage information about the current setting.
	};
	int m_nErrorID;

    CString m_strStart, m_strEnd, m_strDefine;

	UINT m_uPC;
	int m_nBank;

	COVERAGEGETINFO m_CodeGetData;

// Implementation
public:
	BOOL IsValidAddr(const CString& strAddr);
	void DisplayErrorMessage(void);

	void SplitRecord(const CString& strLine);
	void BindRecord(const CString& strLine);
	void EmptyBuffer(void);
	
	void SetModeless(BOOL bModeless) { m_bModeless = bModeless; };

protected:
	// Generated message map functions
	//{{AFX_MSG(CSpaGroupSheet)
    afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnClose();
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif
