
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMBYADR.H__   1.2.1.4   17 Apr 1997 16:03:06   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMBYADR.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:06   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:35:56   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:04   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:16   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:27:34   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:16   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:08   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: byadrtbl.h
**
** Title: By-address Sorted Table
**
** Purpose:
**  Class and methods for managing the by-address sorted table.  Each base
**  structure points to one by-address sorted table.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMBYADR.H__   1.2.1.4   17 Apr 1997 16:03:06   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _BYADRTBL_

                       /****************************
                        *                          *
                        *        INCLUDE FILES     *
                        *                          *
                        ****************************/
#include "sympool.h"
#include "symmgr.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef struct {
   TABLE_OFFSET symbolOffset;
   U32          delta;      // requested addr minus start addr of matching sym
} SYMBOL_INFO_TYPE;

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/

#ifdef __cplusplus

class ByAddressTable : public MemPool {

public:
//---------------------------------------------------------------------------
// ByAddressTable()  constructor
//
// Purpose:
//    Initialize by-address table variables for memory management.
//---------------------------------------------------------------------------
   ByAddressTable();    // constructor


//-----------------------------------------------------------------------
// GetOffset
//
// Purpose: returns the offset to the symbol stored in the by-address table
//-----------------------------------------------------------------------
TABLE_OFFSET ByAddressTable::GetOffset(U32 index) {
   return *(HP_TABLE_OFFSET)GetHugeDataPtr(index * sizeof(TABLE_OFFSET));
   } 


//-----------------------------------------------------------------------
// GetSymbolCount
// 
// Purpose: returns the number of symbol offsets placed into table
//-----------------------------------------------------------------------
   U32 GetSymbolCount(VOID) { return (GetAvailMemOffset()
                              / sizeof(TABLE_OFFSET)); };


//-----------------------------------------------------------------------
// SearchForAddr
//
// Purpose:
//    Searches for a symbol which has a range that contains the requested
//    address and has the smallest end address that still contains addr.
//-----------------------------------------------------------------------
   RETCODE
   ByAddressTable::SearchForAddr(OFFSET_ADDR_TYPE requestedAddr,
                                 BOOLEAN          NoPublics,
                                 SYMBOL_INFO_TYPE& symbolInfo);


//-----------------------------------------------------------------------
// SortTable
//
// Purpose: Sorts the offsets to symbols by the start address of each symbol
//
// Input parameter: NONE
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE SortTable(VOID);

//-----------------------------------------------------------------------
// CreateAddrRanges
//
// Purpose: Create address range of the specified label type.
//
// Input parameter: label type
//
// Return value: NONE
//
// Errors:
//    returns ER_BYADDRTABLE_EMPTY if no items in the table; this should
//    never occur since the call to SortTable should never be made if the
//    the dirty flag is not set - i.e. no symbols are put into table.
//------------------------------------------------------------------------
   RETCODE CreateAddrRanges(SYM_TYPE_TYPE labelType);

   
};  // end of class ByAddressTable

#endif


#ifdef __cplusplus
extern "C" {
#endif

//------------------------------------------------------------------------
// AddressCompare
//
// Purpose:
//    Provides the compare function for the QSort sort
//------------------------------------------------------------------------
int AddressCompare(const VOID FAR * first,
                   const VOID FAR * second);



//------------------------------------------------------------------------
// SortAllByAddressTables
//
// Purpose:
//    Sorts all by-address tables with addrTableDirty TRUE
//------------------------------------------------------------------------
RETCODE EXPORT
SortAllByAddressTables(VOID);


//-----------------------------------------------------------------------
// ByAddressTableGetNext
//
// Purpose:
//   Iterator to walk the bases and return the name and symbol count
//
// Input parameters:
//    startLoop: TRUE ==> starts the interation
//              FALSE ==> must be set after first access
//
// Output parameters:
//    loopPtr: call by reference; must be returned when startLoop FALSE
//    baseName: string of base name
//    entryCount: reference var returning number of symbols in this base
//    tableSize: allocated size of by-address table
//-----------------------------------------------------------------------
RETCODE
ByAddressTableGetNext(BOOLEAN       startLoop,
                      TABLE_OFFSET& loopPtr,
                      LPSTR         baseName,
                      U32&          entryCount,
                      U32&          tableSize);

//------------------------------------------------------------------------
// CreateAllAddrRanges
//
// Purpose:
//    Create address range for all public labels.
//
//------------------------------------------------------------------------
RETCODE CreateAllAddrRanges(SYM_TYPE_TYPE type);

#ifdef __cplusplus
}
#endif

#define _BYADRTBL_
#endif
/******************************** E O F *************************************/
