
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMGET.H__   1.2.1.4   17 Apr 1997 16:03:46   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMGET.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:46   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:36:52   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:40   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:48   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:06   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:42   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:30   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  symget.h
**
**  Description:
**     Prototype info for the routines that get entries from the symbol table.
**
**  Status:  PRELIMINARY
**
**  $Log$
** 
**  $Header:   D:/ECB2S/SRC/LOG/SYMGET.H__   1.2.1.4   17 Apr 1997 16:03:46   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _SYMGET_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#include "symwind.h"
#include "symmanag.h"
#include "symblsvr.h"
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
#ifdef __cplusplus

/***************************************************************************
** SymGetVarLifetimeInfo
**
** Description: Gets the alive/dead status of a register variable
**
** Input Parameters:
**    inputSymbol:   the descriptor to a register var
** Output Parameters:
**    lifetimeState: returns LIVE or DEAD
** Errors:
**    ER_SYMBOL_NOT_A_REG: the descriptor does not point to a register
**                         variable.
***************************************************************************/
RETCODE SymGetVarLifetimeInfo(SYM_DESCRIPTOR inputSymbol,
                              VAR_LIFETIME_STATE &lifetimeState);


//--------------------------------------------------------------------------
// SymGetSymbolBasicType
//
// Input parameter:
//    inputSymbol: symbol descriptor of symbol's basic type desired
//
// Output parameter:
//    basicType: code, data, or unknown.  Unknown types are:
//       SYM_PUBLIC_UNKNOWN:
//       SYM_MISCELLANEOUS:
//       SYM_CONSTANT:
//       SYM_TYPE:
//       SYM_UNDEFINED:
//--------------------------------------------------------------------------
RETCODE SymGetSymbolBasicType(SYM_DESCRIPTOR      inputSymbol, 
                              BASIC_SYM_ADDR_TYPE *basicType);


//--------------------------------------------------------------------------
// SymGetParentModule
//
// Description:
//    given and input symbol descriptor, this function checks that the
//    symbol is a module and returns that descriptor.
//    If not, it gets the parent symbol descriptor and loops.
//    If the symbol type is SYM_ROOT, the function terminates and sets
//    the output descriptor to NULL_SYMBOL.
//
// Input parameter:
//    inputSymbol: starting point for check for module type
//
// Output parameter:
//    moduleSymbol: return symbol descriptor pointing to module symbol
//                  or NULL_SYMBOL if not found
//--------------------------------------------------------------------------
RETCODE SymGetParentModule(SYM_DESCRIPTOR inputSymbol, 
                           SYM_DESCRIPTOR *moduleSymbol);


#endif

#define _SYMGET_
#endif
/******************************** E O F ***********************************/
