
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMHEAP.H__   1.2.1.4   17 Apr 1997 16:03:52   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMHEAP.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:03:52   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:37:04   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:46   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:24:54   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:12   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:48   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:34   ZJRD
** Initial revision.
** 
****************************************************************************/

/****************************************************************************
**
**  Name:  heap.h
**
**  Description:
**     prototypes for Malloc() and Free() routines.
**
**  Status:  CODED
**
**  $Log$
** 
**  $Header:   D:/ECB2S/SRC/LOG/SYMHEAP.H__   1.2.1.4   17 Apr 1997 16:03:52   ZJRD  $
**
**  Copyright (C) 1995 Microtek International.  All rights reserved.
**
*****************************************************************************/

#ifndef _HEAP_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symwind.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#ifdef __cplusplus
extern "C" {
#endif

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  TFree
**
**  Description:
**     Memory deallocator.  Frees memory associated with a pointer
**     allocated via Malloc() {see below}.
**
**     NOTA BENE:  Freeing an already Free()'ed pointer may corrupt the 
**     heap!!
**
**  Parameters:
**     input:
**        randomPointer: A pointer returned by Malloc().
**     output:
**        SUCCESS or an error (see below)
**
**  Errors:
**     ER_NOT_FOUND       -- could not find pointer info.  Is it ours?
**     ER_HEAP_CORRUPT    -- someone wrote outside of their allocation,
**                           and all over our internal data structures.
**                           This is FATAL for us!!
**
*****************************************************************************/
RETCODE EXPORT TFree( LPSTR randomPointer ) ;



/****************************************************************************
**
**  TMalloc
**
**  Description:
**     Memory ALLOCator.  Given numBytes less than 64K (current limit
**     is 65508), returns a long pointer to the allocated memory. 
**     Zero is returned on failure.  The memory is "locked" in the
**     Window's sense.  This routine should be used for allocating
**     small amounts of memory (incremental overhead is just over 
**     8 bytes per alloc).  It uses very few Window's handles.  There
**     will *never* be a handle associated with the returned pointer
**     {i.e. don't use GlobalHandle() on a pointer returned by this
**     routine}.
**
**     NOTA BENE:  Writing to memory outside the pointer+numBytes range 
**     will corrupt the heap!!
**
**  Parameters:
**     input:
**        numBytes: the number of bytes to allocate (< 64KB)
**     output:
**        return value is zero (0) or a long pointer to alloc'ed memory.
**
*****************************************************************************/
LPSTR EXPORT TMalloc( U32 numBytes ) ;   /* numBytes < 64 KB */


#ifdef __cplusplus
}
#endif

#define _HEAP_
#endif
/******************************** E O F ***********************************/
