
/***************************************************************************
**
**    $Header:   D:/ECB2S/SRC/LOG/SYMMANAG.H__   1.2.1.4   17 Apr 1997 16:04:02   ZJRD  $
**
**    $Log:   D:/ECB2S/SRC/LOG/SYMMANAG.H__  $
** 
**    Rev 1.2.1.4   17 Apr 1997 16:04:02   ZJRD
** No change.
** 
**    Rev 1.2.1.3   16 Apr 1997 10:37:36   ZJRD
** No change.
** 
**    Rev 1.2.1.2   10 Apr 1997 15:45:56   ZJRD
** No change.
** 
**    Rev 1.2.1.1   03 Apr 1997 15:25:04   ZJRD
** No change.
** 
**    Rev 1.2.1.0   28 Mar 1997 10:28:22   ZJRD
** easy pack sld 2.09d
** 
**    Rev 1.1   19 Mar 1997 11:37:56   ZJRD
** No change.
** 
**    Rev 1.0   12 Mar 1997 14:51:40   ZJRD
** Initial revision.
** 
****************************************************************************/

/*----------------------------------------------------------------------------
** Name: memmanag.h
**
** Title: Memory Manager header
**
** Purpose:
**  Define the interface for the memory manager routines.
**
** Status: PRELIMINARY
**
** $Log$
** 
** $Header:   D:/ECB2S/SRC/LOG/SYMMANAG.H__   1.2.1.4   17 Apr 1997 16:04:02   ZJRD  $
**
** Copyright (C) 1995 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#ifndef _MEMMANAG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include "symwind.h"
#include "symerrs.h"

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define INITIAL_TABLE_SIZE (1024L * 8L)
#define MIN_EXPAND_SIZE    (1024L * 8L)

#define NULL_DESCRIPTOR 0L


typedef U32 TABLE_OFFSET;
typedef U8 huge * HPU8;                        // huge pointer to U8
typedef TABLE_OFFSET huge * HP_TABLE_OFFSET;   // huge pointer to TABLE_OFFSET

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/
#ifdef __cplusplus
class Table
   {
protected:
   HANDLE tableHandle;        //Windows handle to table memory
   HPU8 hpTableObject;        //huge pointer to top of table memory
   TABLE_OFFSET tableSize;    //how big the table is
   U32 initialSize;           //size of initial GlobalAlloc
   U32 expandSize;            //size of incremental expansion


public:

//---------------------------------------------------------------------------
// Table    // constructor
// Purpose:
//    Table constructor.  Initializes private and protected variables.
//---------------------------------------------------------------------------
Table() {   // constructor
   tableHandle = 0;
   tableSize = 0L;
   initialSize = INITIAL_TABLE_SIZE;
   expandSize = MIN_EXPAND_SIZE;
}; // end of Table constructor


//---------------------------------------------------------------------------
// GetExpandSize
//
// Purpose:
//    Return the value of the variable that holds the amount of bytes to
//    expand the table with a ReAlloc
// 
//---------------------------------------------------------------------------
U32 GetExpandSize() { return expandSize; };


//---------------------------------------------------------------------------
// GetHugeDataPtr
//
// Purpose:
//    Returns a huge pointer to the item in the table referenced from the
//    tableDataOffset offset.  Does the pointer arithmetic.
//---------------------------------------------------------------------------
HPU8 GetHugeDataPtr(TABLE_OFFSET tableDataOffset)  {
   return (hpTableObject + tableDataOffset);
}; // end of GetHugeDataPtr


//---------------------------------------------------------------------------
// GetInitialSize
//
// Purpose:
//    Return the value of the variable that holds the initial size of table
//    allocation
//---------------------------------------------------------------------------
U32 GetInitialSize() { return initialSize; };


//---------------------------------------------------------------------------
// GetTableSize
//
// Purpose:
//    Return the size of the table that has been alloc'ed to date
//---------------------------------------------------------------------------
TABLE_OFFSET GetTableSize() { return tableSize; };

   
//------------------------------------------------------------------------
// InitOrExtendTable
//
// Purpose:
//    Initialize table if tableSize = 0 else
//    extend the table by <expandSize>.
//
// Input parameters:
//    allocFlag:
//       0 if memory does not need to be zeroed upon initialization
//       GMEM_ZEROINIT if memory needs to be zeroed upon initialization
//
// Output parameters: None
//
// Error:
//    Reports ER_SYM_OUT_OF_MEMORY if memory cannot be Alloc'ed or ReAlloc'ed
//------------------------------------------------------------------------
RETCODE InitOrExtendTable(WORD zeroInitFlag);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetExpandSize
//
// Purpose:
//    Sets the amount of size increase of a ReAlloc when the table is full
//---------------------------------------------------------------------------
VOID SetExpandSize(U32 size) { expandSize = size; };


//---------------------------------------------------------------------------
// SetInitialSize
//
// Purpose:
//    Set initial table size
//---------------------------------------------------------------------------
VOID SetInitialSize(U32 size) { initialSize = size; };

};  // end of class Table
#endif

#define _MEMMANAG_
#endif
/******************************** E O F *************************************/
